; compilation via dasm : dasm rom_ALICE32_V0.70_CLEAN_ALL.asm -f3 -ores -v2
; powershell : Get-FileHash nom_du_fichier
; comparaison de deux fichiers binaires sous powershell : comp
;
; +-------------------------------------------------------------------- +
;  V0.10 2020/01/04 : Premire version                                  +
;  V0.20 2020/03/01 : Version compilable avec DASM                      +
;                     Corrections des explications,                     +
;                     poursuites normalisation des labels et variables  +
;  V0.30 2020/03/03 : Poursuites normalisation des labels et variables  +
;                     Correction diverses                               +
;                     Transformation des constantes numriques en       +
;                     constantes symboliques prfixe cXXX_YYY_ZZZZ      +
;  V0.40 2020/03/30 : Poursuite transformation des constantes numriques+
;                     en constantes symboliques prfixe cXXX_YYY_ZZZZ   +
;                     Correction des erreurs d'interprtations          +
;  V0.50 2020/04/22 : Poursuite des amliorations des commentaires      +
;                     Version dfinitive avant modification pour        +
;                     amlioration                                      +
;  V0.60 2020/05/01 : Modification des commentaires                     +
;                     Correction fautes d'orthographe                   +
;  V0.70 2020/05/14 : MAJ suite remarques aprs mise  disposition sur  +
;                     le site system-cfg.com                            +
;                     Corrections diverses de commentaires ou de codes  +
; +-------------------------------------------------------------------- +
; +-------------------------------------------------------------------- +
;  Origine de la ROM : MICROSOFT 8ko + modifications MATRA              +
;  La version BASIC n'est pas encore dtermine par rapport aux versions+
;  des processeurs 6502 ou Z80.                                         +
;                                                                       +
;  Remarques : il est clair que ce n'est pas une rom                    +
;  de production (ou qui a donn son GO pour l'envoyer aux franais ?). +
;  En effet, il y a des zones de code non utilises,                    +
;  des HOOK  profusion, des manques flagrants                          +
;  d'optimisation (jsr+rts  remplacer par jmp).                        +
;                                                                       +
;  Note du 21/04/2020 : je rvise mon jugement sur les HOOK qui sont    +
;  une spcificit du BASIC MICROSOFT 6800. En effet, le basic du TRS80 +
;  COLOR contient les mme HOOK servant  tendre les capacits du BASIC+
;                                                                       +
;  Il y a plusieurs styles de programmation donc plusieurs dveloppeurs.+
;  Des partis pris dans certains commandes BASIC (par exemple CLS xx ou +
;  SET*) sont un signe d'un manque de cohrence dans la mise            +
;  au point de cette rom.                                               +
;  Quelques commandes  dvelopper seront utiles :                      +
;   HIRES              : remplace CLS 80 ou CLS 81                      +
;   TEXT               : remplace CLS 32 ou 40                          +
;   COLOR C0,C1,C2     : remplace SET* C0,C1,C2                         +
;   LINE X1,Y1,X2,Y2,C : pour tracer ... une ligne                      +
;   SETG CH,$xxyyzzww  : pour stocker une redfinition de caractre     +
;   REPEAT ... UNTIL   : nouvel ajout                                   +
;   PRINT AT X,Y       : remplace avantageusement PRINT @XX             +
;   ASS                : pour lancer l'assembleur au lieu de taper &    +
;   WORD               : pour lister les commandes basic connues        +
;   DEF FN T(X)=X+2    : pour dfinir une fonction T                    +
;   ! MYPROC           : pour appeler une procdure dfinie par ]MYPROC +
;   ] MYPROC           : pour dfinir une procdure MYPROC              +
;                                                                       +
;  De plus, il faudra supprimer les routines graphiques redondantes.    +
;  Il faudra aussi utiliser les instructions spcifique du mc6803 (mul) +
;  Un premier recensement des zones mmoires non utilises dans la ROM  +
;  et dans la RAM est en cours pour dterminer la mmoire disponible    +
;  Il faudra aussi envisager de sacrifier la partie ASSEMBLEUR pour     +
;  le dveloppement de ces fonctionnalits.                             +
;                                                                       +
;  La norme dans les labels des procdures dans le listing est la       +
;  suivante : prfixe origine +  '_' + verbe + complement               +
;  exemple : GR_getPixel :                                              +
;  Les prfixes  sont :                                                 +
;  GR  : routine graphique                                              +
;  K7  : routine magntophone                                           +
;  OS  : routine spcifique type BIOS                                   +
;  ASS : routine assembleur                                             +
;  rom : routine commande basic                                         +
;  ==> La conversion des noms des procdures n'est pas encore termine  +
;      au 04/05/2020                                                    +
; + ------------------------------------------------------------------- +
; Zone mmoire :
;
;  $0000-$007F : 128 octets   : reserved MC6803 : gestion clavier, timer, K7, RS232
;  $0080-$00FF : 128 octets   : variables basic
;  $0100-$2FFF : 12031 octets : ram optionnelle
;  $3000-$4FFF : 8Ko          : variable basic, assembleur, i/o + graphisme + programme + tableaux programmes et variables programmes
;    $3043-$3093 : sert de tampon d'dition d'une ligne assemleur mais aussi d'une zone temporaire pour :
;                  -- stockage temporaire pour les variables locales lors de la sauvegarde K7 de la partie assembleur
;                  -- stockage temporaire pour la conversion word -> ASCII
;
;    $3346 : dbut du programme basic
;    $4F94 : dbut pile systme
;  $5000-$B000 : 24576 octets : ram optionelle
;  $B000-$BFFF :  4096 octets : I/O : EF9345, SON, clavier
;     $BF20-$BF2F   : EF9345
;     $BFFF         : clavier
;  $C000-$FFFF : 16 Ko        : rom
;   $C000-$D268 : assembleur
;   $D269-$D26F : libre
;   $D270-$DFFF : routine graphique, K7, diteur mode ligne
;       $D27C-$D3FC : libre : 385 octets
;       $D432-$D43F : libre :  14 octets
;       $D691-$D69F : libre :  15 octets
;       $DACB-$DADF : libre :   5 octets
;       $DD93-$DF8F : libre : 509 octets
;       $DF90-$DFF2 : routine lecture/criture K7 non utilise
;       $DFF3-$DFFF : libre :  13 octets
;   $E000-$FFD1 : BASIC MICROSOFT : environ 8ko
;       $E000-$E02F : Table des commandes BASIC
;       $E030-$E044 : Table des sauts des oprateurs mathmatiques + prdcence associe
;       $E045-$E0E0 : Table des commandes BASIC suite
;       $E0E1-$E0ED : Table des oprateurs mathmatiques
;       $E0EE-$E147 : Table des fonctions BASIC
;       $E048-$E189 : Table des sauts des commandes et fonctions BASIC
;       $E18A-$EAAF : Table des messages d'erreurs
;       $F9BE-$F9C5 : libre :  8 octets
;       $F724-$F72D : Easter EGG : 9 octets : Microsoft
;   $FFD2-$FFDB : ANOTHER EASTER EGG nilrebmahC Chamberlin : co-auteur de la rom chez M$
;   $FFDC-$FFFF : Table de sauts systmes :  quoi a sert ?
;   $FFF0-$FFFF : table des vecteurs : SCI,TIMER,IRQ,SWI,NMI et RESET
;
; ==> Quel gachis ! Tant de mmoire perdue ...
; ===========================================================================
; TODO
;  OS_printCR
;  OS_printSPACE
; ===========================================================================
                PROCESSOR 6803

;--------------- MACRO
            MAC SKIP1
			        dc.b $21
			ENDM
            MAC SKIP2
                    dc.b $8C
            ENDM
            MAC SKIP2_ASM
                    dc.b $BC
            ENDM
            MAC SKIP_BYTE
			        dc.b $86
			ENDM


;--------------- CONSTANTES PARTIE ASSEMBLEUR
cASS_INP_ON                      EQU $01
cASS_LG_MAX_INP                  EQU $50
cASS_POSYX_STATELINE             EQU $1800
cASS_POSY_MAX_SRC                EQU $17
cASS_POSY_STATELINE              EQU $18
cASS_LG_MAX_FILENAME             EQU $08
cASS_LG_AREA_SYMB                EQU $07
cASS_LG_NAME_SYMB                EQU $05
cASS_TAB                         EQU $06
cASS_SEP_COMMENT                 EQU $3B ; ';' ; -- $3B
cASS_SEP_TEXT                    EQU $27 ; ''' ; -- $27
;--
cASS_K7_SAV_BIN                  EQU $0200
cASS_K7_SAV_SRC                  EQU $0500
cASS_K7_MODE_CONTIGU             EQU $01
;--
cASS_KB_E                        EQU $45
cASS_KB_I                        EQU $49

; -- CODE ERREUR DU COMPILATEUR DE L'ASSEMBLEUR
cASS_ERR_NOMEM                   EQU $41 ; 'A'
cASS_ERR_SYMB_EXIST              EQU $42 ; 'B'
cASS_ERR_VAL_OVERFLOW            EQU $43 ; 'C'
cASS_ERR_EXPR_MISSING            EQU $44 ; 'D'
cASS_ERR_EXPR_UNDEF              EQU $45 ; 'E'
cASS_ERR_EXPR_BAD                EQU $46 ; 'F'
cASS_ERR_SYMB_UNKNOWN            EQU $47 ; 'G'
cASS_ERR_INST_UNKNOWN            EQU $48 ; 'H'
cASS_ERR_REG_UNKNOWN             EQU $49 ; 'I'
cASS_ERR_ADR_IND_BAD             EQU $4A ; 'J'
cASS_ERR_ADR_REL_OVR             EQU $4B ; 'K'
cASS_ERR_ORG_ALREADY             EQU $4C ; 'L'
cASS_ERR_OBJ_OUTOFMEM            EQU $4D ; 'M'
cASS_ERR_ORG_UNKNOWN             EQU $4E ; 'N'
cASS_ERR_INST_MISSING            EQU $4F ; 'O'
cASS_ERR_INST_UNDEF              EQU $50 ; 'P'

; -- CODE ERREUR DE L'EDITEUR DE L'ASSEMBLEUR
cASS_ERR_BAD_TYPE_FILE           EQU $00
cASS_ERR_OVERFLOW_MEM            EQU $04
cASS_ERR_INPROGRESS              EQU $05
cASS_ERR_STR_UNKNOWN             EQU $06
cASS_ERR_BAD_NUMBER              EQU $07
cASS_ERR_EMPTY_00                EQU $08
cASS_ERR_EMPTY_01                EQU $09

;---
cASS_MINUS                       EQU $2D
cASS_SEP_ARG                     EQU $2C
cASS_TYPE_HEXA                   EQU $24 ; Pour les nombres hexa pour la partie assembleur
cASS_comma                       EQU $2C
cASS_ADR_IMM                     EQU $23
cASS_ADR_DIRECT                  EQU $3C

;--------------- CONSTANTES PARTIE BASIC
cBAS_NUMLEV                      EQU 21                                   ; Nombre de niveau d'imbrication
cBAS_ADDPRC                      EQU 01                                   ; Prcision d'un type float
cBAS_BYTES_PER_VARIABLE          EQU $05                                  ; Nombre d'octets pour stocker une variable
cBAS_LG_VAR                      EQU $02                                  ; Longueur maximle du nom d'une variable
cBAS_AREA_STR_DEFAULT            EQU $64                                  ; Nb octets par dfaut pour la zone des chaines de caractre
cBAS_BYTES_PER_FOR               EQU $12                                  ; Nb octets pour coder un for dans la pile
cBAS_LG_FILENAME                 EQU $08                                  ; Longueur maximale d'un nom de fichier
cBAS_LEN_VAR_FLOAT               EQU cBAS_BYTES_PER_VARIABLE+cBAS_LG_VAR  ; $07
cBAS_ARY_DIM_DEFAULT             EQU $0A                                  ; Taille d'un tableau par dfaut.
cBAS_OFS_STK                     EQU ((2*cBAS_NUMLEV)+(3*cBAS_ADDPRC)+13) ; $5A

;-- Dfinition des token de type commande, fonction et oprateur mathmatique

cBAS_OFS_CMD                     EQU $80

;-- Dfinition des token BASIC de type commande
cBAS_TOKEN_FOR                   EQU cBAS_OFS_CMD                         ; $80 : OPCODE DE LA COMMANDE BASIC FOR
cBAS_TOKEN_GOTO                  EQU cBAS_TOKEN_FOR     + 1               ; $81 : OPCODE DE LA COMMANDE BASIC GOTO
cBAS_TOKEN_GOSUB                 EQU cBAS_TOKEN_GOTO    + 1               ; $82 : OPCODE DE LA COMMANDE BASIC GOSUB
cBAS_TOKEN_REM                   EQU cBAS_TOKEN_GOSUB   + 1               ; $83 : OPCODE DE LA COMMANDE BASIC REM
cBAS_TOKEN_IF                    EQU cBAS_TOKEN_REM     + 1               ; $84 : OPCODE DE LA COMMANDE BASIC IF
cBAS_TOKEN_DATA                  EQU cBAS_TOKEN_IF      + 1               ; $85 : OPCODE DE LA COMMANDE BASIC DATA
cBAS_TOKEN_PRINT                 EQU cBAS_TOKEN_DATA    + 1               ; $86 ; OPCODE DE LA COMMANDE BASIC PRINT
cBAS_TOKEN_ON                    EQU cBAS_TOKEN_PRINT   + 1               ; $87 ; OPCODE DE LA COMMANDE BASIC ON
cBAS_TOKEN_INPUT                 EQU cBAS_TOKEN_ON      + 1               ; $88 : OPCODE DE LA COMMANDE BASIC INPUT
cBAS_TOKEN_END                   EQU cBAS_TOKEN_INPUT   + 1               ; $89 ; OPCODE DE LA COMMANDE BASIC END
cBAS_TOKEN_NEXT                  EQU cBAS_TOKEN_END     + 1               ; $8A : OPCODE DE LA COMMANDE BASIC NEXT
cBAS_TOKEN_DIM                   EQU cBAS_TOKEN_NEXT    + 1               ; $8B : OPCODE DE LA COMMANDE BASIC DIM
cBAS_TOKEN_READ                  EQU cBAS_TOKEN_DIM     + 1               ; $8C : OPCODE DE LA COMMANDE BASIC READ
cBAS_TOKEN_LET                   EQU cBAS_TOKEN_READ    + 1               ; $8D : OPCODE DE LA COMMANDE BASIC LET
cBAS_TOKEN_RUN                   EQU cBAS_TOKEN_LET     + 1               ; $8E : OPCODE DE LA COMMANDE BASIC RUN
cBAS_TOKEN_RESTORE               EQU cBAS_TOKEN_RUN     + 1               ; $8F : OPCODE DE LA COMMANDE BASIC RESTORE
cBAS_TOKEN_RETURN                EQU cBAS_TOKEN_RESTORE + 1               ; $90 : OPCODE DE LA COMMANDE BASIC RETURN
cBAS_TOKEN_STOP                  EQU cBAS_TOKEN_RETURN  + 1               ; $91 ; OPCODE DE LA COMMANDE BASIC STOP
cBAS_TOKEN_POKE                  EQU cBAS_TOKEN_STOP    + 1               ; $92 ; OPCODE DE LA COMMANDE BASIC POKE
cBAS_TOKEN_CONT                  EQU cBAS_TOKEN_POKE    + 1               ; $93 : OPCODE DE LA COMMANDE BASIC CONT
cBAS_TOKEN_LIST                  EQU cBAS_TOKEN_CONT    + 1               ; $94 ; OPCODE DE LA COMMANDE BASIC LIST
cBAS_TOKEN_CLEAR                 EQU cBAS_TOKEN_LIST    + 1               ; $95 ; OPCODE DE LA COMMANDE BASIC CLEAR
cBAS_TOKEN_NEW                   EQU cBAS_TOKEN_CLEAR   + 1               ; $96 ; OPCODE DE LA COMMANDE BASIC NEW
cBAS_TOKEN_CLOAD                 EQU cBAS_TOKEN_NEW     + 1               ; $97 ; OPCODE DE LA COMMANDE BASIC CLOAD
cBAS_TOKEN_CSAVE                 EQU cBAS_TOKEN_CLOAD   + 1               ; $98 ; OPCODE DE LA COMMANDE BASIC CSAVE
cBAS_TOKEN_LLIST                 EQU cBAS_TOKEN_CSAVE   + 1               ; $99 ; OPCODE DE LA COMMANDE BASIC LLIST
cBAS_TOKEN_LPRINT                EQU cBAS_TOKEN_LLIST   + 1               ; $9A ; OPCODE DE LA COMMANDE BASIC LPRINT
cBAS_TOKEN_SET                   EQU cBAS_TOKEN_LPRINT  + 1               ; $9B : OPCODE DE LA COMMANDE BASIC SET
cBAS_TOKEN_RESET                 EQU cBAS_TOKEN_SET     + 1               ; $9C : OPCODE DE LA COMMANDE BASIC RESET
cBAS_TOKEN_CLS                   EQU cBAS_TOKEN_RESET   + 1               ; $9D ; OPCODE DE LA COMMANDE BASIC CLS
cBAS_TOKEN_SOUND                 EQU cBAS_TOKEN_CLS     + 1               ; $9E : OPCODE DE LA COMMANDE BASIC SOUND
cBAS_TOKEN_EXEC                  EQU cBAS_TOKEN_SOUND   + 1               ; $9F : OPCODE DE LA COMMANDE BASIC EXEC
cBAS_TOKEN_SKIPF                 EQU cBAS_TOKEN_EXEC    + 1               ; $A0 ; OPCODE DE LA COMMANDE BASIC SKIPF

; -- Dfinition des fonctions spcifiques, oprateurs mathmatiques, fonctions  1 seul paramtre, fonction  n paramtres, fonction  aucun paramtre (MEM)

; -- fonctions ou commandes spcifiques
cBAS_TOKEN_TAB                   EQU cBAS_TOKEN_CMD_MAX     + 1           ; $A1 : Opcode DE LA FONCTION BASIC TAB
cBAS_TOKEN_TO                    EQU cBAS_TOKEN_TAB         + 1           ; $A2 : Opcode DE LA FONCTION BASIC TO
cBAS_TOKEN_THEN                  EQU cBAS_TOKEN_TO          + 1           ; $A3 : Opcode DE LA FONCTION BASIC THEN
cBAS_TOKEN_NOT                   EQU cBAS_TOKEN_THEN        + 1           ; $A4 : Opcode DE LA FONCTION BASIC NOT
cBAS_TOKEN_STEP                  EQU cBAS_TOKEN_NOT         + 1           ; $A5 : Opcode DE LA FONCTION BASIC STEP
cBAS_TOKEN_OFF                   EQU cBAS_TOKEN_STEP        + 1           ; $A6 : Opcode DE LA FONCTION BASIC OFF

;-- oprateur mathmatique
cBAS_TOKEN_PLUS                  EQU cBAS_TOKEN_OFF         + 1           ; $A7 : Opcode DE LA FONCTION BASIC +
cBAS_TOKEN_MINUS                 EQU cBAS_TOKEN_PLUS        + 1           ; $A8 : Opcode DE LA FONCTION BASIC -
cBAS_TOKEN_mult:                 EQU cBAS_TOKEN_MINUS       + 1           ; $A9 : Opcode DE LA FONCTION BASIC *
cBAS_TOKEN_div:                  EQU cBAS_TOKEN_mult        + 1           ; $AA : Opcode DE LA FONCTION BASIC /
cBAS_TOKEN_power:                EQU cBAS_TOKEN_div         + 1           ; $AB : Opcode DE LA FONCTION BASIC ^
cBAS_TOKEN_AND:                  EQU cBAS_TOKEN_power       + 1           ; $AC : Opcode DE LA FONCTION BASIC AND
cBAS_TOKEN_OR:                   EQU cBAS_TOKEN_AND         + 1           ; $AD : Opcode DE LA FONCTION BASIC OR

; -- Oprateur de comparaison
cBAS_TOKEN_sup                   EQU cBAS_TOKEN_OR          + 1           ; $AE : OPCODE DE L'OPERATEUR BASIC >
cBAS_TOKEN_egal                  EQU cBAS_TOKEN_sup         + 1           ; $AF : OPCODE DE L'OPERATEUR BASIC =
cBAS_TOKEN_inf                   EQU cBAS_TOKEN_egal        + 1           ; $B0 : OPCODE DE L'OPERATEUR BASIC <

;-- Dfinition des token BASIC de type FONCTION  1 seul paramtre, fonction n paramtres et fonction  aucun paramtre
cBAS_TOKEN_SGN                   EQU cBAS_TOKEN_inf         + 1           ; $B1 : OPCODE DE LA FONCTION BASIC SGN
cBAS_TOKEN_INT                   EQU cBAS_TOKEN_SGN         + 1           ; $B2 : OPCODE DE LA FONCTION BASIC INT
cBAS_TOKEN_ABS                   EQU cBAS_TOKEN_INT         + 1           ; $B3 : OPCODE DE LA FONCTION BASIC ABS
cBAS_TOKEN_USR                   EQU cBAS_TOKEN_ABS         + 1           ; $B4 : OPCODE DE LA FONCTION BASIC USR
cBAS_TOKEN_RND                   EQU cBAS_TOKEN_USR         + 1           ; $B5 : OPCODE DE LA FONCTION BASIC RND
cBAS_TOKEN_SQR                   EQU cBAS_TOKEN_RND         + 1           ; $B6 : OPCODE DE LA FONCTION BASIC SQR
cBAS_TOKEN_LOG                   EQU cBAS_TOKEN_SQR         + 1           ; $B7 : OPCODE DE LA FONCTION BASIC LOG
cBAS_TOKEN_EXP                   EQU cBAS_TOKEN_LOG         + 1           ; $B8 : OPCODE DE LA FONCTION BASIC EXP
cBAS_TOKEN_SIN                   EQU cBAS_TOKEN_EXP         + 1           ; $B9 : OPCODE DE LA FONCTION BASIC SIN
cBAS_TOKEN_COS                   EQU cBAS_TOKEN_SIN         + 1           ; $BA : OPCODE DE LA FONCTION BASIC COS
cBAS_TOKEN_TAN                   EQU cBAS_TOKEN_COS         + 1           ; $BB : OPCODE DE LA FONCTION BASIC TAN
cBAS_TOKEN_PEEK                  EQU cBAS_TOKEN_TAN         + 1           ; $BC : OPCODE DE LA FONCTION BASIC PEEK
cBAS_TOKEN_LEN                   EQU cBAS_TOKEN_PEEK        + 1           ; $BD : OPCODE DE LA FONCTION BASIC LEN
cBAS_TOKEN_STRdollar             EQU cBAS_TOKEN_LEN         + 1           ; $BE : OPCODE DE LA FONCTION BASIC STR$
cBAS_TOKEN_VAL                   EQU cBAS_TOKEN_STRdollar   + 1           ; $BF : OPCODE DE LA FONCTION BASIC VAL
cBAS_TOKEN_ASC                   EQU cBAS_TOKEN_VAL         + 1           ; $C0 : OPCODE DE LA FONCTION BASIC ASC
cBAS_TOKEN_CHRdollar             EQU cBAS_TOKEN_ASC         + 1           ; $C1 : OPCODE DE LA FONCTION BASIC CHR$
cBAS_TOKEN_LEFTdollar            EQU cBAS_TOKEN_CHRdollar   + 1           ; $C2 : OPCODE DE LA FONCTION BASIC LEFT$
cBAS_TOKEN_RIGHTdollar           EQU cBAS_TOKEN_LEFTdollar  + 1           ; $C3 : OPCODE DE LA FONCTION BASIC RIGHT$
cBAS_TOKEN_MIDdollar             EQU cBAS_TOKEN_RIGHTdollar + 1           ; $C4 : OPCODE DE LA FONCTION BASIC MID$
cBAS_TOKEN_POINT                 EQU cBAS_TOKEN_MIDdollar   + 1           ; $C5 : OPCODE DE LA FONCTION BASIC POINT
cBAS_TOKEN_VARPTR                EQU cBAS_TOKEN_POINT       + 1           ; $C6 : OPCODE DE LA FONCTION BASIC VARPTR
cBAS_TOKEN_INKEYdollar           EQU cBAS_TOKEN_VARPTR      + 1           ; $C7 : OPCODE DE LA FONCTION BASIC INKEY$
cBAS_TOKEN_MEM                   EQU cBAS_TOKEN_INKEYdollar + 1           ; $C8 : OPCODE DE LA FONCTION BASIC MEM

;--
cBAS_TOKEN_CMD_MAX               EQU cBAS_TOKEN_SKIPF                     ; Numro maximal des commandes BASIC                     : $A0
cBAS_OFS_FCT                     EQU cBAS_TOKEN_SGN                       ; Dbut de token de type fonction avec ou sans paramtre : $B1
cBAS_TOKEN_ALL_MAX               EQU cBAS_TOKEN_MEM                       ; Numro maximal de tous les opcodes BASIC               : $C8
cBAS_NB_OP                       EQU (cBAS_TOKEN_inf-cBAS_TOKEN_sup) + 1  ; Nombre d'oprateur de comparaison                      : $03

;--
sBAS_ERR_NOFOR                   EQU "NF" ; $00 (00) : NF Next without For
sBAS_ERR_SYNTAX                  EQU "SN" ; $02 (02) : SN SyNtax error
sBAS_ERR_NOGOSUB                 EQU "RG" ; $04 (04) : RG Return without Gosub
sBAS_ERR_NODATA                  EQU "OD" ; $06 (06) : OD Overflow Data
sBAS_ERR_ILLQTY                  EQU "FC" ; $08 (08) : FC function incorrecte
sBAS_ERR_OVERFLOW                EQU "OV" ; $0A (10) : OV OVerflow capcity
sBAS_ERR_MEMFULL                 EQU "OM" ; $0C (12) : OM Out of Memory
sBAS_ERR_UNDEFSTAT               EQU "US" ; $0E (14) : TM Type Mismatch
sBAS_ERR_BADSUBS                 EQU "BS" ; $10 (16) : BS Bad Subscript
sBAS_ERR_REDIMD                  EQU "DD" ; $12 (18) : DD Erreur avec un tableau
sBAS_ERR_ZERODIV                 EQU "/0" ; $14 (20) : /0 divide by 0
sBAS_ERR_ILLDIR                  EQU "ID" ; $16 (22) : ID Illegal Direct
sBAS_ERR_BADTYPE                 EQU "TM" ; $18 (24) : TM Type Mismatch
sBAS_ERR_STRFULL                 EQU "OS" ; $1A (26) : OS Out of String
sBAS_ERR_STRLONG                 EQU "LS" ; $1C (28) : LS Lenght String
sBAS_ERR_FRMCPX                  EQU "ST" ; $1E (30) : ST STatement
sBAS_ERR_CANTCONT                EQU "CN" ; $20 (32) : CN CaN't continue
sBAS_ERR_IO                      EQU "IO" ; $22 (34) : IO Error Input/output
sBAS_ERR_K7                      EQU "FM" ; $24 (38) : FM File Mismatch

cBAS_ERR_NOFOR                   EQU $00  ; (00) : NF Next without For
cBAS_ERR_SYNTAX                  EQU $02  ; (02) : SN SyNtax error
cBAS_ERR_NOGOSUB                 EQU $04  ; (04) : RG Return without Gosub
cBAS_ERR_NODATA                  EQU $06  ; (06) : OD Overflow Data
cBAS_ERR_ILLQTY                  EQU $08  ; (08) : FC function incorrecte
cBAS_ERR_OVERFLOW                EQU $0A  ; (10) : OV OVerflow capcity
cBAS_ERR_MEMFULL                 EQU $0C  ; (12) : OM Out of Memory
cBAS_ERR_UNDEFSTAT               EQU $0E  ; (14) : TM Type Mismatch
cBAS_ERR_BADSUBS                 EQU $10  ; (16) : BS Bad Subscript
cBAS_ERR_REDIMD                  EQU $12  ; (18) : DD Erreur avec un tableau
cBAS_ERR_ZERODIV                 EQU $14  ; (20) : /0 divide by 0
cBAS_ERR_ILLDIR                  EQU $16  ; (22) : ID Illegal Direct
cBAS_ERR_BADTYPE                 EQU $18  ; (24) : TM Type Mismatch
cBAS_ERR_STRFULL                 EQU $1A  ; (26) : OS Out of String
cBAS_ERR_STRLONG                 EQU $1C  ; (28) : LS Lenght String
cBAS_ERR_FRMCPX                  EQU $1E  ; (30) : ST STatement
cBAS_ERR_CANTCONT                EQU $20  ; (32) : CN CaN't continue
cBAS_ERR_IO                      EQU $22  ; (34) : IO Error Input/output
cBAS_ERR_K7                      EQU $24  ; (38) : FM File Mismatch
; -- BASIC
cBAS_CMD_GO_LINEEDIT             EQU $2A ; '*' ; -- $2A
cBAS_CMD_RETURN_ASS              EQU $26 ; '&' ; -- $26
cBAS_CMD_GO_ASS                  EQU $25 ; '%' ; -- $25
; --
cBAS_SEP_STR                     EQU $22 ; '"' ; -- $22
cBAS_ID_STR                      EQU $24 ; '$'
cBAS_FCT_OPEN                    EQU $28 ; '('
cBAS_FCT_CLOSE                   EQU $29 ; ')'
cBAS_SEP_ARG                     EQU $2C ; ','
cBAS_SEP                         EQU $3A ; ':' ; -- $3A
cBAS_SEP_VAR                     EQU $3B ; ';' ; -- $3B
cBAS_EQUAL                       EQU $3D

; -- BASIC partie mathmatique
cMATH_PLUS                       EQU $2B ; '-'
cMATH_MINUS                      EQU $2D ; '+'
cMATH_SEP_FLT                    EQU $2E ; '.'

;---------------- KEYBOARD
cKB_NULL                         EQU $00
cKB_BREAK                        EQU $03
cKB_ENTER                        EQU $0D
cKB_ESPACE                       EQU $20
cKB_CTRL                         EQU $00 ; ''
cKB_SHIFT                        EQU $00 ; ''
;---
cKB_LEFT                         EQU $08
cKB_RIGHT                        EQU $09
cKB_DOWN                         EQU $0A
cKB_UP                           EQU $0B
; -- clavier normal

cKB_AROBASE                      EQU $40 ; '@'
cKB_Q                            EQU $51 ; 'Q'
cKB_B                            EQU $42 ; 'B'
cKB_C                            EQU $43 ; 'C'
cKB_D                            EQU $44 ; 'D'
cKB_E                            EQU $45 ; 'E'
cKB_F                            EQU $46 ; 'F'

cKB_G                            EQU $47 ; 'G'
cKB_H                            EQU $48 ; 'H'
cKB_I                            EQU $49 ; 'I'
cKB_J                            EQU $4A ; 'J'
cKB_K                            EQU $4B ; 'K'
cKB_L                            EQU $4C ; 'L'
cKB_DIVIDE                       EQU $2F ; '/'
cKB_N                            EQU $4E ; 'N'

cKB_O                            EQU $4F ; 'O'
cKB_P                            EQU $50 ; 'P'
cKB_A                            EQU $41 ; 'A'
cKB_R                            EQU $52 ; 'R'
cKB_S                            EQU $53 ; 'S'
cKB_T                            EQU $54 ; 'T'
cKB_U                            EQU $55 ; 'U'
cKB_V                            EQU $56 ; 'V'

cKB_Z                            EQU $5A ; 'Z'
cKB_X                            EQU $58 ; 'X'
cKB_Y                            EQU $59 ; 'Y'
cKB_W                            EQU $57 ; 'W'

cKB_0                            EQU $30 ; '0'
cKB_1                            EQU $31 ; '1'
cKB_2                            EQU $32 ; '2'
cKB_3                            EQU $33 ; '3'
cKB_4                            EQU $34 ; '4'
cKB_5                            EQU $35 ; '5'
cKB_6                            EQU $36 ; '6'

cKB_7                            EQU $37 ; '7'
cKB_8                            EQU $38 ; '8'
cKB_9                            EQU $39 ; '9'
cKB_2POINT                       EQU $3A ; ':'
cKB_M                            EQU $4D ; 'M'
cKB_comma                        EQU $2C ; ','
cKB_minus                        EQU $2D ; '-'
cKB_dot                          EQU $2E ; '.'

cKB_SEMICOLON                    EQU $3B ; ';'

; -- CTRL
cKB_CTRL_ARROBASE                EQU cBAS_TOKEN_INPUT       ; $88 ; OPCODE DE LA COMMANDE BASIC INPUT
cKB_CTRL_Q                       EQU cKB_LEFT               ; $08 ; Fleche gauche
cKB_CTRL_B                       EQU cBAS_TOKEN_ABS         ; $B3 ; OPCODE DE LA COMMANDE BASIC ABS
cKB_CTRL_C                       EQU cBAS_TOKEN_INT         ; $B2 ; OPCODE DE LA COMMANDE BASIC INT
cKB_CTRL_D                       EQU cBAS_TOKEN_GOSUB       ; $82 ; OPCODE DE LA COMMANDE BASIC GOSUB
cKB_CTRL_E                       EQU cBAS_TOKEN_SET         ; $9B ; OPCODE DE LA COMMANDE BASIC SET
cKB_CTRL_F                       EQU cBAS_TOKEN_RETURN      ; $90 ; OPCODE DE LA COMMANDE BASIC RETURN

cKB_CTRL_G                       EQU cBAS_TOKEN_IF          ; $84 ; OPCODE DE LA COMMANDE BASIC IF
cKB_CTRL_H                       EQU cBAS_TOKEN_THEN        ; $A3 ; OPCODE DE LA COMMANDE BASIC THEN (n'existe pas !)
cKB_CTRL_I                       EQU cBAS_TOKEN_NEXT        ; $8A ; OPCODE DE LA COMMANDE BASIC NEXT
cKB_CTRL_J                       EQU cBAS_TOKEN_GOTO        ; $81 ; OPCODE DE LA COMMANDE BASIC GOTO
cKB_CTRL_K                       EQU cBAS_TOKEN_SOUND       ; $9E ; OPCODE DE LA COMMANDE BASIC SOUND
cKB_CTRL_L                       EQU cBAS_TOKEN_PEEK        ; $BC ; OPCODE DE LA COMMANDE BASIC PEEK
cKB_CTRL_DIVIDE                  EQU cBAS_TOKEN_COS         ; $BA ; OPCODE DE LA COMMANDE BASIC COS
cKB_CTRL_N                       EQU cBAS_TOKEN_SIN         ; $B9 ; OPCODE DE LA COMMANDE BASIC SIN

cKB_CTRL_O                       EQU cBAS_TOKEN_STEP        ; $A5 ; OPCODE DE LA COMMANDE BASIC STEP
cKB_CTRL_P                       EQU cBAS_TOKEN_INKEYdollar ; $C7 ; OPCODE DE LA COMMANDE BASIC INKEY$
cKB_CTRL_A                       EQU $15                    ; $15 ; CLEAR LINE
cKB_CTRL_R                       EQU cBAS_TOKEN_RESET       ; $9C ; OPCODE DE LA COMMANDE BASIC RESET
cKB_CTRL_S                       EQU cKB_RIGHT
cKB_CTRL_T                       EQU cBAS_TOKEN_READ        ; $8C ; OPCODE DE LA COMMANDE BASIC READ
cKB_CTRL_U                       EQU cBAS_TOKEN_FOR         ; $80 ; OPCODE DE LA COMMANDE BASIC FOR
cKB_CTRL_V                       EQU cBAS_TOKEN_RND         ; $B5 ; OPCODE DE LA COMMANDE BASIC RND

cKB_CTRL_Z                       EQU $5E                    ; 'Z'
cKB_CTRL_X                       EQU cBAS_TOKEN_SGN         ; $B1 ; OPCODE DE LA COMMANDE BASIC SGN
cKB_CTRL_Y                       EQU cBAS_TOKEN_RESTORE     ; $8F ; OPCODE DE LA COMMANDE BASIC RESTORE
cKB_CTRL_W                       EQU cKB_DOWN               ; $0A ; fleche bas
cKB_CTRL_ENTER                   EQU cKB_ENTER              ; $0D ; enter
cKB_CTRL_ESPACE                  EQU $07

cKB_CTRL_0                       EQU $30                    ; '0'
cKB_CTRL_1                       EQU cBAS_TOKEN_RUN         ;     ; OPCODE DE LA COMMANDE BASIC RUN
cKB_CTRL_2                       EQU cBAS_TOKEN_CONT        ;     ; OPCODE DE LA COMMANDE BASIC CONT
cKB_CTRL_3                       EQU cBAS_TOKEN_CSAVE       ; $98 ; OPCODE DE LA COMMANDE BASIC CSAVE
cKB_CTRL_4                       EQU cBAS_TOKEN_CLOAD       ; $97 ; OPCODE DE LA COMMANDE BASIC CLOAD
cKB_CTRL_5                       EQU cBAS_TOKEN_NEW         ; $96 ; OPCODE DE LA COMMANDE BASIC NEW
cKB_CTRL_6                       EQU cBAS_TOKEN_LIST        ; $94 ; OPCODE DE LA COMMANDE BASIC LIST

cKB_CTRL_7                       EQU cBAS_TOKEN_CLEAR       ; $95 ; OPCODE DE LA COMMANDE BASIC CLEAR
cKB_CTRL_8                       EQU cBAS_TOKEN_CLS         ; $9D ; OPCODE DE LA COMMANDE BASIC CLS
cKB_CTRL_9                       EQU cBAS_TOKEN_PRINT       ; $86 ; OPCODE DE LA COMMANDE BASIC PRINT
cKB_CTRL_2POINT                  EQU cBAS_TOKEN_END         ; $89 ; OPCODE DE LA COMMANDE BASIC END
cKB_CTRL_M                       EQU cBAS_TOKEN_POKE        ; $92 ; OPCODE DE LA COMMANDE BASIC POKE
cKB_CTRL_comma                   EQU cBAS_TOKEN_TAN         ; $BB ; OPCODE DE LA COMMANDE TAN
cKB_CTRL_minus                   EQU cBAS_TOKEN_STOP        ; $91 ; OPCODE DE LA COMMANDE BASIC STOP
cKB_CTRL_dot                     EQU cBAS_TOKEN_LOG         ; $B7 ; OPCODE DE LA COMMANDE LOG

cKB_CTRL_SEMICOLON               EQU cBAS_TOKEN_SQR         ; $B6 ; OPCODE DE LA COMMANDE SQR
cKB_CTRL_BREAK                   EQU cKB_BREAK
cKB_CTRL_LEFT                    EQU cKB_LEFT
cKB_CTRL_RIGHT                   EQU cKB_RIGHT
cKB_CTRL_DOWN                    EQU cKB_DOWN
cKB_CTRL_UP                      EQU cKB_UP

;-- SHIFT
cKB_SHIFT_ARROBASE               EQU $13       ;
cKB_SHIFT_Q                      EQU $8F       ; CARACTERE PLEIN
cKB_SHIFT_B                      EQU $80       ; CARACTERE VIDE
cKB_SHIFT_C                      EQU $82       ; CARACTERE No 2
cKB_SHIFT_D                      EQU $87       ; CARACTERE No 7
cKB_SHIFT_E                      EQU $8D       ; CARACTERE No 13
cKB_SHIFT_F                      EQU $86       ; CARACTERE No 6

cKB_SHIFT_G                      EQU $85       ; CARACTERE No 5
cKB_SHIFT_H                      EQU $48       ; 'H'
cKB_SHIFT_I                      EQU $49       ; 'I'
cKB_SHIFT_J                      EQU $4A       ; 'J'
cKB_SHIFT_K                      EQU $4B       ; 'K'
cKB_SHIFT_L                      EQU $4C       ; 'L'
cKB_SHIFT_DIVIDE                 EQU $3F       ; '?'
cKB_SHIFT_N                      EQU $4E       ; 'N'

cKB_SHIFT_O                      EQU $4F       ; 'O'
cKB_SHIFT_P                      EQU $50       ; 'P'
cKB_SHIFT_A                      EQU $89       ; CARACTERE No 9
cKB_SHIFT_R                      EQU $8C       ; CARACTERE No 12
cKB_SHIFT_S                      EQU $88       ; CARACTERE No 8
cKB_SHIFT_T                      EQU $8B       ; CARACTERE No 11
cKB_SHIFT_U                      EQU $8F       ; CARACTERE No 15
cKB_SHIFT_V                      EQU $81       ; CARACTERE No 1

cKB_SHIFT_Z                      EQU $84       ; CARACTERE No 4
cKB_SHIFT_X                      EQU $83       ; CARACTERE No 3
cKB_SHIFT_Y                      EQU $8A       ; CARACTERE No 10
cKB_SHIFT_W                      EQU $8E       ; CARACTERE No 14
cKB_SHIFT_ENTER                  EQU cKB_ENTER ;

cKB_SHIFT_ESPACE                 EQU $06       ;
cKB_SHIFT_0                      EQU $30       ; '0'
cKB_SHIFT_1                      EQU $21       ; '!'
cKB_SHIFT_2                      EQU $22       ; '"'
cKB_SHIFT_3                      EQU $23       ; '#'
cKB_SHIFT_4                      EQU $24       ; '$'
cKB_SHIFT_5                      EQU $25       ; '%'
cKB_SHIFT_6                      EQU $26       ; '&'

cKB_SHIFT_7                      EQU $27       ; '''
cKB_SHIFT_8                      EQU $28       ; '('
cKB_SHIFT_9                      EQU $29       ; ')'
cKB_SHIFT_2POINT                 EQU $2A       ; '*'
cKB_SHIFT_M                      EQU $4D       ; 'M'
cKB_SHIFT_inf                    EQU $3C       ; '<'
cKB_SHIFT_egal                   EQU $3D       ; '='
cKB_SHIFT_sup                    EQU $3E       ; '>'

cKB_SHIFT_SEMICOLON              EQU $2B       ; '+'
cKB_SHIFT_BREAK                  EQU cKB_BREAK ; BREAK
cKB_SHIFT_LEFT                   EQU cKB_LEFT  ; Fleche gauche
cKB_SHIFT_DOWN                   EQU cKB_DOWN  ; Fleche droite
cKB_SHIFT_RIGHT                  EQU cKB_RIGHT ; Fleche bas
cKB_SHIFT_UP                     EQU cKB_UP    ; Fleche haut

;---------------- K7
cK7_TYP_PRG_BASIC                EQU $00
cK7_TYP_PRG_0x01                 EQU $01
cK7_TYP_PRG_ASS                  EQU $02
cK7_TYP_PRG_ARRAY                EQU $04
cK7_TYP_PRG_ASS_SRC              EQU $05
;--
cK7_TYP_BLK_FILENAME             EQU $00
cK7_TYP_BLK_DATA                 EQU $01
cK7_TYP_BLK_END                  EQU $FF
cK7_DURATE_BIT_LOW               EQU $23
cK7_DURATE_BIT_HIGH              EQU $46
;--
cK7_SYNCHRO                      EQU $55
cK7_SYNCHRO_02                   EQU $3C

;---------------- OS
cOS_NULL                         EQU $00
cOS_DEV_SCREEN                   EQU $00
cOS_DEV_PRINTER                  EQU $01
cOS_DEV_BUFFER                   EQU $02
cOS_DEV_PRINTER_0xFE             EQU $FE
; --
cOS_CLS_MODE_LORES               EQU $20 ; Mode 32 colonnes
cOS_CLS_MODE_TEXTE               EQU $28 ; Mode 40 colonnes
cOS_CLS_MODE_HIRES               EQU $50 ; Mode 80 colonnes
cOS_CLS_MODE_HIRES_INV           EQU $51 ; Mode 80 colonnes invers
;--
cOS_WARN                         EQU $55
cOS_SPACE                        EQU $20
cOS_BS                           EQU $08 ; Back Space
cOS_CR                           EQU $0D ; Carriage Return
cOS_PLEIN_INVERSE                EQU $80 ; Caractre plein inverse
cOS_PLEIN                        EQU $7F ; Code du caractre plein dans le charset de EF9345 pour le mode 80 colonnes

;---------------- EDITEUR MODE LIGNE
cEDT_UNKNOWN                     EQU $21 ; '!'

;---------------- CPU
cCPU_BEGIN_RAM                   EQU $80

;---------------- VDP
cVDP_MODE_80x25                  EQU $00
cVDP_MODE_40x25                  EQU $01
cVDP_MODE_32x16                  EQU $02
;--
cVDP_PLEIN_LO                    EQU $0F            ; Caractre plein en basse rsolution
;--
cVDP_CMD_IND                     EQU $80
cVDP_CMD_KRF                     EQU $00
cVDP_CMD_KRG                     EQU $02
cVDP_CMD_KRC                     EQU $40
cVDP_CMD_KRL                     EQU $50
cVDP_CMD_EXP                     EQU 96
cVDP_CMD_CMP                     EQU 64+32+16
cVDP_CMD_KRE                     EQU 16
cVDP_CMD_OCT                     EQU 32+16
cVDP_CMD_MVB                     EQU 128+64+16
cVDP_CMD_MVD                     EQU 128+64+32
cVDP_CMD_MVT                     EQU 128+64+32+16
cVDP_CMD_CLF                     EQU $05
cVDP_CMD_CLG                     EQU $07
cVDP_CMD_VSM                     EQU 128+16+8+1
cVDP_CMD_VRM                     EQU 128+16+4+1
cVDP_CMD_INY                     EQU 128+32+16
cVDP_CMD_NOP                     EQU 128+16+1
cVDP_RD                          EQU $08
cVDP_WR                          EQU $00
cVDP_NO_INC                      EQU $00
cVDP_INC                         EQU $01
cVDP_COPY_MVP_TO_AP              EQU $04
cVDP_COPY_AP_TO_MVP              EQU $08
cVDP_STOP_EOB                    EQU $01
cVDP_STOP_NO                     EQU $02
cVDP_USE_AUX                     EQU $04
cVDP_USE_MAIN                    EQU $00
cVDP_REG_ROM                     EQU $00
cVDP_REG_TGS                     EQU $01
cVDP_REG_MAT                     EQU $02
cVDP_REG_PAT                     EQU $03
cVDP_REG_DOR                     EQU $04
cVDP_REG_ROR                     EQU $07
; -- VARIABLE POUR LE REGISTRE TGS
cVDP_TGS_625                     EQU $00    ; Rsolution 625 lignes
cVDP_TGS_525                     EQU $01    ; Rsolution 525 lignes
cVDP_TGS_NO_INTERLACE            EQU $00    ; Mode non entrelac
cVDP_TGS_INTERLACE               EQU $02    ; Mode entrelac
cVDP_TGS_NO_HOR_RESYNC           EQU $00
cVDP_TGS_HOR_RESYNC              EQU $04
cVDP_TGS_NO_VER_RESYNC           EQU $00
cVDP_TGS_VER_RESYNC              EQU $08
cVDP_TGS_SYNC_OUT_COMP           EQU $10
cVDP_TGS_SYNC_OUT_V_H            EQU $00
cVDP_TGS_SERVICE_ROW             EQU $20
cVDP_TGS_NO_SERVICE_ROW          EQU $00
cVDP_TGS_MODE_40_LONG            EQU $00
cVDP_TGS_MODE_40_VAR             EQU $40
cVDP_TGS_MODE_40_SHORT           EQU $00
cVDP_TGS_MODE_80_LONG            EQU $C0
cVDP_TGS_MODE_80_SHORT           EQU $80
; -- VARIABLE POUR LE REGISTRE MAT
cVDP_MAT_DBL_HEIGHT              EQU $80
cVDP_MAT_NO_DBL_HEIGHT           EQU $00
cVDP_MAT_CURSOR_DISP             EQU $40
cVDP_MAT_NO_CURSOR_DISP          EQU $00
cVDP_MAT_MD_CURS_FIX_CPL         EQU $00
cVDP_MAT_MD_CURS_FLS_CPL         EQU $20
cVDP_MAT_MD_CURS_FIX_UND         EQU $10
cVDP_MAT_MD_CURS_FLS_UND         EQU $30
cVDP_MAT_MARG_INS                EQU $08
cVDP_MAT_NO_MARG_INS             EQU $00
; -- VARIABLE POUR LE REGISTRE PAT
cVDP_PAT_SERVICE_ROW_EN          EQU $01
cVDP_PAT_NO_SERVICE_ROW_EN       EQU $00
cVDP_PAT_UP_BULK_EN              EQU $02
cVDP_PAT_NO_DW_BULK_EN           EQU $00
cVDP_PAT_DW_BULK_EN              EQU $04
cVDP_PAT_NO_UP_BULK_EN           EQU $00
cVDP_PAT_CONCEAL_EN              EQU $08
cVDP_PAT_NO_CONCEAL_EN           EQU $00
cVDP_PAT_INS_MODE_INLAY          EQU $00
cVDP_PAT_INS_MODE_BOXING         EQU $10
cVDP_PAT_INS_MODE_CHAR_MARK      EQU $20
cVDP_PAT_INS_MODE_ACT_AREA_MARK  EQU $30
cVDP_PAT_FLASH_EN                EQU $40
cVDP_PAT_NO_FLASH_EN             EQU $00
cVDP_PAT_NO_FLASH_EN             EQU $00
cVDP_PAT_MODE_40_LONG            EQU $00
cVDP_PAT_MODE_40_VAR             EQU $00
cVDP_PAT_MODE_40_SHORT           EQU $80
cVDP_PAT_MODE_80_LONG            EQU $00
cVDP_PAT_MODE_80_SHORT           EQU $00
; -- COULEUR
cVDP_BLACK                       EQU $00
cVDP_RED                         EQU $01
cVDP_GREEN                       EQU $02
cVDP_YELLOW                      EQU $03
cVDP_BLUE                        EQU $04
cVDP_MAGENTA                     EQU $05
cVDP_CYAN                        EQU $06
cVDP_WHITE                       EQU $07
; --- Couleur obtenue par le bit d'inscrustation
cVDP_ORANGE                      EQU $00
; -- ATTRIBUTS
cVDP_NO_INSERT                   EQU $00
cVDP_INSERT                      EQU $01
cVDP_NO_DBL_HEIGHT               EQU $00
cVDP_DBL_HEIGHT                  EQU $02
cVDP_NO_CONCEAL                  EQU $00
cVDP_CONCEAL                     EQU $04
cVDP_NO_DBL_WIDTH                EQU $00
cVDP_WIDTH                       EQU $08
;--
cVDP_DOR_HI_INS_HI               EQU $80
cVDP_DOR_HI_INS_LO               EQU $08
; -- ATTRIBUTS MODE 80 colonnes
cVDP_80_AT_D                     EQU $01 ; ATTRIBUT COLOR SET
cVDP_80_AT_NO_D                  EQU $00 ; ATTRIBUT NO_COLOR SET
cVDP_80_AT_U                     EQU $02 ; ATTRIBUT UNDERLINE
cVDP_80_AT_NO_U                  EQU $00 ; ATTRIBUT NO_UNDERLINE
cVDP_80_AT_F                     EQU $04 ; ATTRIBUT FLASH
cVDP_80_AT_NO_F                  EQU $00 ; ATTRIBUT NO FLASH
cVDP_80_AT_N                     EQU $08 ; ATTRIBUT NEGATIVE
cVDP_80_AT_NO_N                  EQU $00 ; ATTRIBUT NO NEGATIVE

            seg.u data
            org $00

;----------------
;--- ORG $0000 - Partie CPU
;----------------
DDR1:               ds 1
DDR2:               ds 1
PORT1:              ds 1
PORT2:              ds 1            ; Port I/O soit pour RS232 soit pour K7
                    ds 1
                    ds 1
                    ds 1
                    ds 1
CPTHOR_STATUS:      ds 1
CPTHOR:             ds 2            ; Compteur d'horloge
CPTHOR_CMP:         ds 1            ; Comparateur pour le compteur d'horloge
                    ds 1
CPTHOR_CAPT:        ds 2
                    ds 1
;----------------
RCMDSERIAL:         ds 1
RETATSERIAL:        ds 1
RRECEPTIONSERIAL:   ds 1
RTRANSMISERIAL:     ds 1
RCTRLRAM:           ds 1
;----------------
RESERVED:           ds $B           ; 0
                    ds $1E          ; 0
                    ds $30          ; 0
                    ds $12          ; 0
;----------------
;--- ORG $0080 - RAM
;----------------
CHARAC:             ds 1            ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
ENDCHR:             ds 1            ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
EOLPNTR:            ds 1            ; cela sert  beaucoup de choses : op. binaires, etc.
DIMFLG:             ds 1            ; ARRAY flag : 0=EVALUATE, 1=DIMENSIONNING
VALTYP:             ds 1            ; type de la variable en cours : 00:num, $FF:alpha
DATAFLG:            ds 1
SUBFLG:             ds 1            ; Disable ARRAY search : =$00: ALLOW SEARCH,=$80:DISABLE SEARCH
INPUTFLG:           ds 1            ; =$00:INPUT,=$4F:READ
CPRMASK:            ds 1            ; Masque de comparaison
INDEX:              ds 2
TMPPTR:             ds 2
TMPFLT:             ds 4
SAVREGS:            ds 2
TXTAB:              ds 2            ; dbut du programme basic
VARTAB:             ds 2            ; Fin du programme BASIC / dbut des variables
ARYTAB:             ds 2
STREND:             ds 2
botSTACK:           ds 2
FRETOP:             ds 2
FREESPC:            ds 2
MEMSIZ:             ds 2            ; Adresse - 1 de la fin de la RAM DISPONIBLE
OLDLIN:             ds 2
LINUM:              ds 2
OLDTXT:             ds 2
TMPTXT:             ds 2
DATTXT:             ds 2            ; DATA STATEMENT LINE NUMBER POINTER
DATPTR:             ds 2            ; DATA STATEMENT ADDRESS POINTER
INPTR:              ds 2
VARNAM:             ds 2            ; Temporary storage for a variable name
VARPNT:             ds 2            ; Pointer used in array building
FORPNT:             ds 2
LASTOP:             ds 2
OPMASK:             ds 1
PTRTMP1:            ds 1
HIGHDS:             ds 2            ; Cible lors d'une copie de zone mmoire
HIGHTR:             ds 2            ; Source lors d'une copie de zone mmoire
PTRTMP2:            ds 2
LOWTR:              ds 2
                    ds 1
PTRTMP3:            ds 1
PTRTMP4:            ds 2
DSCPTR:             ds 2
ACC1:               ds 6
NBLOOP:             ds 1
ACC3:               ds 6
ACC2:               ds 6
PRODSIGN:           ds 1
ACC1EXT:            ds 1
STRNG2:             ds 2
                    ds 1
                    ds 1
CURLIN:             ds 2
;----------------
; PARAMETRAGE SPECIFIQUE POUR LE DEVICE EN COURS
;----------------
DEVXMARGIN:         ds 2                    ; Marge GAUCHE/DROITE pour les tabulations
                                            ; CLS 81 : $10,$40
                                            ; CLS 40 : $10,$10
                                            ; CLS 32 : $10,$10
DEVXCURR:           ds 1
                                            ; vaut $00  l'init
DEVXMAX:            ds 1                    ; vaut 32,40 ou 80
DEVNU:              ds 1                    ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
;----------------
fDONTCARE:          ds 1                    ; flag qui ne sert  rien actuellement toujours gal  0
fCOLDWARN:          ds 1
;--------------------------------------
; Routine de lecture entre utilisateur : $EB
;--------------------------------------
CHRGET:             ds 1
                    ds 1
                    ds 1
                    ds 1
                    ds 1
                    ds 1
                    ds 1
                    ds 1
CHRGOT:             ds 1
TXTPTR:             ds 1
byte_F5:            ds 1
                    ds 1
                    ds 1
                    ds 1
;----------------
Attribute_HIRES:    ds 1                    ; contient l'attribut du caractre en mode haute rsolution
                                            ; Par dfaut contient $00 (mode inversion) sinon $88.
                                            ; C'est un nibble donc l'attribut doit tre rpt 2
                                            ; fois dans l'octet (car colonne paire/impaire !)
                                            ; Sinon cela fait des effets sympas
ColorBG_SCR_LINE:   ds 1                    ; Couleur du fond de la ligne insre suite au scrolling de l'cran
ColorFGBG_CAR:      ds 1                    ; Couleur de fond et d'criture du caractre !
ColorCLS:           ds 1                    ; couleur  utiliser lors d'un CLS
                                            ; + motif ( experimenter) si le code couleur
                                            ; ne correspond pas  un codage prvu de la couleur
                    ds 1
                    ds 1
                    ds 1
; end of 'RAMPROC'

; ===========================================================================

; Segment type: Regular
;           code ; RAM
            org $3000
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
fAUTOREPEAT:                   ds 1         ; =0:no autorepat;<>0:AUTOREPAT ON et est dcremente
                                            ; d'1 unit  chaque rptition
TABAD:                         ds 2         ; pointeur sur les tableaux de conversion KEYB -> ASCII
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
;---------------
SCR_LGY:                       ds 1
SCR_LGX:                       ds 1         ; taille max sur X en mode 32, 40 ou 80 colonnes
SCR_MARGEXY:                   ds 2
SCROFSY:                       ds 1         ; OFFSET A AJOUTER POUR ALLER A LA LIGNE SUIVANTE POUR UN MEME X
XMAX_SCR:                      ds 1         ; longueur d'un cran
SCRPIX_YMAX:                   ds 1         ; Taille max en pixel pour Y
SCRPIX_XMAX:                   ds 1         ; Taille max en pixel pour X
MARGIN_SCR:                    ds 2         ; marge gauche: dfaut pour 32x16:$10=16:80x25:$10=16
                                            ; marge droite: dfaut pour 32x16:$10=16;80x25:$40=64
;----------------
TECRAN:                        ds 1         ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
HOME_YX:                       ds 2         ; dfinit (YX) la position du dbut de l'cran
POINT_YX_HIRES:                ds 2
dataR4_EF9345:                 ds 1
cmdR4_EF9345:                  ds 1
RDPIX_EF9345:                  ds 2         ; Octet lu dans la mmoire  une position X,Y en mode HIRES
                                            ; le format est sm0000A2A1/A0C6C5C4C3C2C1C0 avec :
											; s : =1 : mode HIRES (semi-graphique) : accs type "pixel" 
											; m : couleur du pixel : 0 : couleur de l'encre , 1 : couleur de la marge 
											; [A2->C0] le pixel  lire  crire
MSKPIX_EF9345:                 ds 2         ; Position du pixel en mode HIRES (semi-graphique)
dataR1_EF9345:                 ds 1
cmdR1_EF9345:                  ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
POS_BUFFERKEYB:                ds 1
fFLASHCAR:                     ds 1         ; dtermine si c'est le caractre en dessous du curseur qui doit tre "flash" (clignotement)
fFLASHCUR:                     ds 1         ; dtermine si c'est le curseur qui doit tre "flash" (clignotement)
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
                               ds 1
;----------------
ASS_SAVEREGS_PERCENT:          ds 2
ASS_LEN_INP_USR:               ds 1         ; Longueur de la saisie utilisateur
ASS_BUF_CURINP_BOT:            ds 1         ; Position du curseur d'dition
ASS_TAMPONTMP:                 ds 7
;----------------
; sauvegarde spcifique de l'header K7 pour l'assembleur
;----------------
ASS_SAVE_HEADER_K7_LM_BINAIRE: ds 2         ; Peut prendre la valeur $0200, $0500
                                            ; si $0200 alors ($02=langage machine) et ($00=binaire)
                                            ; si $0500 alors ($05=fichier texte de l'diteur) et ($00=binaire)
ASS_SAVE_HEADER_K7_CONTIGU:    ds 1         ; peut prendre la valeur 1 : contigu (code assembleur)
ASS_SAVE_HEADER_K7_EXEC:       ds 2         ; Adresse d'excution
ASS_SAVE_HEADER_K7_LOAD:       ds 2         ; Adresse de chargement
;----------------
ASS_TAMPONLIGNE:               ds $41
ASS_BUF_TOP:                   ds 2         ; A quel moment cette variable est initialise ? Sert de borne ?
                                            ; Contient $0000 en fin d'dition
;----------------
ASS_UNKNOWN                    ds 1         ; Variable dont l'utilit n'a pas t trouve
;----------------
ASS_MEMMAX:                    ds 2
ASS_OBJ_BEGIN:                 ds 2         ; dbut du programme objet
ASS_CURY:                      ds 1
ASS_CURX:                      ds 1
ASS_ERR:                       ds 1
ASS_CHAR:                      ds 1
ASS_INP_INPROGRESS:            ds 1
ASS_FCOPYSRC:                  ds 1         ; donne le sens de la copie du source peut prendre la valeur 1
ASS_MODE_INS:                  ds 1         ; Mode insertion ou pas (CTRL+J)
ASS_MODE_KBD_AUTO:             ds 1
ASS_SAV_NUMLINE:               ds 1
                               ds 1
ASS_NUMLINE:                   ds 1         ; sert par exemple  stocker le numro de ligne  chercher
                               ds 1
ASS_PTRSOURCE:                 ds 1
                               ds 1
ASS_PTRTMP:                    ds 2
ASS_VARTMP:                    ds 2
ASS_SAV_CURADXY:               ds 2
;---------------
ASS_COMP_LOAD:                 ds 2
ASS_COMP_EXC:                  ds 2         ; Pointeur sur le dbut du code  excuter
ASS_COMP_CURLINE:              ds 2
ASS_OBJ_END:                   ds 2         ; Fin du programme objet
ASS_BOT_SYMB:                  ds 2
ASS_PTRCUROP:                  ds 2         ; Pointeur sur l'opcode en cours de dcodage
ASS_PTR_TMP_SYMB:              ds 2         ; Pointeur sur la liste des symboles compils (tiquettes, etc.)
ASS_CURADRCMP:                 ds 2         ; Adresse du rsultat de la compilation
ASS_CURNUMLINE:                ds 2         ; numro de ligne courante traite durant la compilation
ASS_LGSRC:                     ds 1         ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
ASS_LENCUROP:                  ds 1         ; Longueur de l'opcode courante
ASS_CURDIRECTIVE:              ds 1         ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante
ASS_TMP_CONV:                  ds 2         ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
ASS_CONV_EN_COURS:             ds 1
ASS_CONV_POS_OR_NEG:           ds 1
ASS_COMP_EN_COURS:             ds 1         ; COMPILATION EN COURS - numro de passe - 1
ASS_FLGSHOWPARSE:              ds 1         ; Flag indiquant qu'il y a eu un demande de compilation
ASS_FLGLI:                     ds 1         ; Flag indiquant que les lignes compiles + source sont  montrer lors de la compilation
ASS_DEVNU:                     ds 1         ; Indique la port de sortie du listing (0 : ECRAN; 1 : IMPRIMANTE)
ASS_NUMERR:                    ds 1         ; numro de l'erreur
ASS_ERR_PASSE_1:               ds 1
ASS_ERR_PASSE_2:               ds 1
ASS_ORG:                       ds 1         ; flag directive ORG dfinie : =0 non sinon  oui
ASS_FLGPAG:                    ds 1
;-----------------
memFREE_01                     ds $20
;-----------------
NBNAM_K7:                      ds 1         ; lg du nom du fichier
FILNA_K7:                      ds 8         ; nom du fichier
FILTY_K7:                      ds 1         ; Type du FICHIER
ASCFL_K7:                      ds 1         ; Fichier en ASCII
GAPFL_K7:                      ds 1         ; Fichier contigu
ADSTR_K7:                      ds 2         ; contient l'adresse d'excution d'un programme binaire
ADLOA_K7:                      ds 2         ; contient l'adresse de chargement lors de la lecture
ADDEB_K7:                      ds 2         ; Adresse dbut de la zone  sauvegarder
ADFIN_K7:                      ds 2         ; Adresse fin de la zone  sauvegarder
;----------------
memFREE:                       ds $F9
;----------------
vectTODO:                      ds 3
;----------------
vectSCI:                       ds 3
vectTOF:                       ds 3
vectOCF:                       ds 3
vectICF:                       ds 3
doIRQ1:                        ds 3
doSWI:                         ds 3
doNMI:                         ds 3
;----------------
doUSER:                        ds 3
;----------------
ENTROPY:                       ds 4
;----------------
KEYB_INVVIDEO:                 ds 1         ; Indicateur pour INVERSE VIDEO pour l'cran et
                                            ; majuscule/minuscule pour imprimante (toggle entre $00 et $FF)
;----------------
memFREE_02                     ds 2
;----------------
pEXEC:                         ds 2
pCOLD:                         ds 2
;----------------
PR_BAUDRATE:                   ds 2
;----------------
CRT_TEMPO:                     ds 2
;----------------
MARGIN_PRT:                    ds 1         ; CLS 81 : DEFAUT : MARGE GAUCHE : $10 MARGE DROITE :$40
activePRT:                     ds 1
CurXPRT:                       ds 1         ; WORD :
                                            ; Position X for cursor on PRINTER
                                            ; Max X for cursor on PRINTER
XMaxPRT:                       ds 1
;----------------
CURWAITCLIGNOTEMENT:           ds 1
;----------------
CMPMID_K7:                     ds 1         ; $18 par dfaut ;  valeur de comparaison pour dterminer si c'est un bit  1 ou  0
CMP0_K7:                       ds 1         ; $1A par dfaut ;  Limite haute pour un signal  1200 hz
CMP1_K7:                       ds 1         ; $0B par dfaut ;  limite haute pour une frquence  2400 Hz
NBBYTSYNCHRO_K7:               ds 2         ; dfaut : $0080  : nombre d'octets  $55  envoyer sur K7 pour la synchronisation
;----------------
;- KEYBOARD
;----------------
ROLTB:                         ds 8         ; Mmorisation de la dernire touche entre
NUMRGKBD:                      ds 1         ; numro de ligne en cas de scanning : 0->7
TMPKBD:                        ds 1
;----------------
                               ds 1
;----------------
adrMEM_XY:                     ds 1
TMPPT:                         ds 2
LASTPT:                        ds 2
DESC_STK:                      ds 15
ADRENDMEM:                     ds 2         ; Adresse de la fin de mmoire
TMPFLT1:                       ds 4
;----------------
; PARTIE VARIABLE POUR K7
;----------------
sTMPBUFK7:                     ds 9         ; stocke :
                                            ;  - la longueur du nom du fichier (maxi 8 caractres)
                                            ;  - le nom du fichier
zTMPFICNM_K7:                  ds 8
fFICTYP_K7:                    ds 1         ; Type du fichier k7 : $00:BASIC,$01 ou $04 selon la rom ?:ARRAY,$02:LANGAGE MACHINE,$05:FICHIER TEXTE DE L'EDITEUR
UNKNOWN_1_K7:                  ds 1
UNKNOWN_2_K7:                  ds 1
wOFSLOAD_K7:                   ds 2         ; offset de chargement du programme, $0000 par dfaut
wSAVEorLOAD_K7:                ds 2         ; Nombre d'octets  sauvegarder ou  lire
CURDVC:                        ds 1         ; CURRENT DEVICE : $00 : SCREEN, $FF : K7
pMEMBEGIN_K7:                  ds 2
pMEMEND_K7:                    ds 2
fSAVEDATA_K7:                  ds 1         ; =$00:sauve les donnes K7 en mmoire sinon ne les sauve pas
DUMMY_K7:                      ds 1         ; 0 par dfaut : rle inconnu
BLKTY_K7:                      ds 1         ; type de bloc : $00 nom du fichier,$01 bloc de donnes,$FF bloc de fin
bK7_LG_BLK:                    ds 1         ; Longueur du bloc lu ou crit
                               ds 1
pTMP_K7:                       ds 2         ; pointeur servant  tout ... FILENAME,CLOAD,CSAVE...
bREALL_K7:                     ds 1         ; doit tre gal  0 pour effectuer la lecture
bNB_READ_K7:                   ds 1         ; compteur du nombre de donnes  lire : est dcrement de 1  chaque lecture d'octet de la K7
bNbBitsToRDWR_K7:              ds 1
CPERTM_K7:                     ds 1         ; longueur (quivalent  un temps) d'un bit lu en provenance du port K7
CBTPHA_K7:                     ds 1         ; flag indiquant la phase de lecture du port K7 (quelle transition HI-LO or LO-HI)
;----------------
charKEYB:                      ds 1
CURAD_YX:                      ds 2
COLOR_CARGRA:                  ds 1         ; Code couleur cyclique pour les caractres graphiques via CTRL+0
ENDSTT:                        ds 1         ; Indique si la fin du programme a t rencontr
fEDITLINE_SEP:                 ds 1         ; en mode dition ligne ou LIST, l'opcode lu est un ", un :, un DATA, un REM
;----------------
; Zone contenant les hooks du basic : cela sent une rom de debugging
;----------------
vHOOK1_KBD:                    ds 3
vHOOK2_PRINTCHAR:              ds 3
vHOOK3_INITPRMSCCR:            ds 3
vHOOK4_CLEAR:                  ds 3
vHOOK5_KBD:                    ds 3
vHOOK6_EVAL:                   ds 3
vHOOK7_ERROR_1:                ds 3
vHOOK8_ERROR_2:                ds 3
vHOOK9_PARSENUMBER:            ds 3
vHOOK10_EXECSTMT:              ds 3
vHOOK11_PARSE_INPUT_LINE:      ds 3
vHOOK12_EDITLINE:              ds 3
vHOOK13_FREE:                  ds 3
vHOOK14_FREE:                  ds 3
;----------------
varUNKNOWN:                    ds 1
;----------------
LINUM_SAV:                     ds 2
;----------------
BUFFERKEYB:                    ds $80
                               ds 1
                               ds 1
;----------------
FTAMPON:                       ds $12       ; Tampon pour conversion float -> STRING
;-----------------
beginPrg:                      ds $14BA     ; $3346
areaStackByDefault:            ds $800
; end of 'RAM'

; ===========================================================================
;           PARTIE IO
; ===========================================================================
            org $B000
                ds $9FC         ; 0
                ds $524         ; 0
EF9345_R0:      ds 1            ; En lecture : registre des statuts
EF9345_R1:      ds 1
EF9345_R2:      ds 1
EF9345_R3:      ds 1
EF9345_R4:      ds 1
EF9345_R5:      ds 1
EF9345_R6:      ds 1
EF9345_R7:      ds 1
EF9345_EXEC:    ds 1
EF9345_R9:      ds 1
                ds 1
                ds 1
                ds 1
                ds 1
                ds 1
EF9345_RF:      ds 1
                ds $CF
IO_COL_KBD:     ds 1            ; pour une range active du clavier, indique par un 0 la touche du clavier active
                                ; est utilise aussi pour le son !
; end of 'IO'

; ===========================================================================
;           PARTIE CODE - ROM
; ===========================================================================
            seg code
            org $C000

; =============== S U B R O U T I N E =======================================

; FCT : point d'entre de l'diteur assembleur
;       L'cran passe en mode 80x25 ou en mode 40x25
;       (selon le mode de dpart !) en fond bleu et
;       encre blanche
; IN  : /
; OUT : /

ASS_MAIN_ENTRY:
            sts ASS_SAVEREGS_PERCENT
            jsr ASS_INIT_SCR_VAR            ; FCT : Initialise l'cran et diverses variables pour la partie assembleur
                                            ; IN  : /
                                            ; OUT : A,B,X modified

ASS_INTERPRET:
            lds ASS_SAVEREGS_PERCENT
            jsr ASS_printCURSOR             ; FCT : Gestion du curseur en mode assembleur
                                            ; IN  : /
                                            ; OUT : A,X modified
            jsr OS_POLCA                    ; FCT : polling keyboard
                                            ; IN  : /
                                            ; OUT : A=code ascii de la touche
                                            ;       X,B not modified
            beq ASS_INTERPRET
            staa ASS_CHAR
            jsr ASS_clrStateLine            ; FCT : efface la ligne d'tat
                                            ; IN  : /
                                            ; OUT : X,A,B modified

isASCII:
            tst ASS_CHAR
            bpl nextInput_ASS_INTERPRET
            tst TMPKBD
            beq next3Input_ASS_INTERPRET

nextInput_ASS_INTERPRET:
            ldaa ASS_CHAR
            clrb
            ldx #tabKEY_ASS                 ; pointe sur le tableau des caractres reconnus comme commande

bcl2Input_ASS_INTERPRET:
            cmpa $00,x
            beq next4Input_ASS_INTERPRET
            inx
            incb
            cpx #tabJMP_ASS
            bne bcl2Input_ASS_INTERPRET

next3Input_ASS_INTERPRET:
            ldx #ASS_insertChar                 ; FCT : Insert ou remplace (selon ASS_MODE_INS)  la position actuelle du curseur
                                                ;       le caractre stock dans ASS_CHAR
                                                ; IN  : ASS_CHAR  jour : caractre  insrer
                                                ;       ASS_MODE_INS    : mode insertion ou pas
                                                ; OUT : A,B,X modified
            bra executeInput_ASS_INTERPRET

next4Input_ASS_INTERPRET:
            ldx #tabJMP_ASS
            abx
            abx
            ldx 0,x

executeInput_ASS_INTERPRET:
            jsr 0,x
            ldx #tabASS_KEY_SPECIFICAL          ; 81 : CTRL+J (insert char), 9D : CTRL+8 (toggle mode screen) , 9C : CTRL+R (autorepeat keyb)

bcl6Input_ASS_INTERPRET:
            ldaa 0,x
            cmpa ASS_CHAR
            beq ASS_INTERPRET
            inx
            cpx #ASS_toggleModeScreenEdt        ; FCT : TOGGLE SCREEN 80x25<>40x25
                                                ; IN  : /
                                                ; OUT : A,B,X modified
            bne bcl6Input_ASS_INTERPRET
            ldaa ASS_MODE_KBD_AUTO
            beq ASS_INTERPRET
            ldx #ROLTB                          ; Mmorisation de la dernire touche entre
            ldaa #$FF

bcl7Input_ASS_INTERPRET:
            staa 0,x
            inx
            cpx #NUMRGKBD                       ; numro de ligne en cas de scanning : 0->7
            bne bcl7Input_ASS_INTERPRET
            bra ASS_INTERPRET
; End of function ASS_MAIN_ENTRY


; =============== S U B R O U T I N E =======================================

; FCT : Imprime le source assembleur de la ligne en cours d'dition
; IN  : ASS_NUMLINE : ligne du source  imprimer
; OUT : A,B,X modified

ASS_printSrc:
            clrb
            stab ASS_CURX                   ; TODO et CLR ASS_CURX; CLR ASS_CURY
            clr ASS_CURY                    ; TODO et ... stab ASS_CURY .. trop simple
            ldx ASS_NUMLINE                 ; sert par exemple  stocker le numro de ligne  chercher
            stx ASS_SAV_NUMLINE
            jsr ASS_printDeviceScreen       ; FCT : Imprime une ligne de source sur la sortie courante
                                            ; IN  : ASS_SAV_NUMLINE  jour
                                            ;       ASS_NUMLINE  jour
                                            ;       ASS_PTRTMP  jour
                                            ; OUT : A,B,X modified
            jsr ASS_setCURAD_YX_BEGIN_LINE  ; FCT : Initialise CURAD_YX en fonction de ASS_CURAD_Y et X=0
                                            ; IN  : /
                                            ; OUT : D=X=CURAD_YX=(ASS_CURY,0)

ASS_CopySourceToTarget:
            bsr ASS_initBuffer              ; FCT : copie de la zone pointe par ASS_PTRTMP vers
                                            ;       la zone ASS_BUF_CURINP_BOT
                                            ; IN  : ASS_PTRTMP(source) et ASS_BUF_CURINP_BOT (cible)
                                            ; OUT : A,X modified
            ldx ASS_PTRTMP
            ldab 0,x
            beq endASS_CopySourceToTarget
            cmpb #$FF
            beq endASS_CopySourceToTarget
            ldd #ASS_BUF_CURINP_BOT         ; Position du curseur d'dition
            jsr OS_copyMEM                  ; FCT : Copie la zone mmoire pointe par X
                                            ;       (le premier octet contient le nombre d'octets
                                            ;        copier) dans celle pointe par D
                                            ; IN  : X=SOURCE
                                            ;       D=CIBLE
                                            ; OUT : A,B,X modified

endASS_CopySourceToTarget:
            rts
; End of function ASS_printSrc


; =============== S U B R O U T I N E =======================================

; FCT : Initialise l'cran et diverses variables pour la partie assembleur
; IN  : /
; OUT : A,B,X modified

ASS_INIT_SCR_VAR:
            nop                     ; heureusement que c'est lanc rarement ...
            nop                     ; sinon on peut remplacer les nop par d'autres instructions ou les supprimer ...
            nop
            nop
            nop
            nop
            nop
            nop

InitScreen:
            jsr INASS               ; FCT : vecteur pour appeler INASS : effacement de l'cran
                                    ; IN  : /
                                    ; OUT : /

initMem:
            ldx MEMSIZ              ; Adresse - 1 de la fin de la RAM DISPONIBLE
            inx
            stx ASS_MEMMAX
            stx ASS_OBJ_BEGIN       ; dbut du programme objet
            ldaa #$FF
            staa 0,x

initAreaVARASS:
            ldx #ASS_CURY

bclInitAreaVARASS:
            clr 0,x
            inx
            cpx #(ASS_SAV_CURADXY+1)
            bne bclInitAreaVARASS
; End of function ASS_INIT_SCR_VAR


; =============== S U B R O U T I N E =======================================

; FCT : INTIALISE le tampon ASS_BUF_CURINP_BOT rceptionnant
;       les donnes  afficher via le DEVICE en cours (ou pas)
; IN  : /
; OUT : A,X modified

ASS_initBuffer:
            ldaa #cOS_SPACE                 ; ' '
            ldx #ASS_BUF_CURINP_BOT         ; Position du curseur d'dition

bclInitAreaVARASS_CLRBUF:
            staa 0,x
            inx
            cpx #ASS_MEMMAX
            bne bclInitAreaVARASS_CLRBUF
            clr ASS_LEN_INP_USR             ; Longueur de la saisie utilisateur
; End of function ASS_initBuffer


; =============== S U B R O U T I N E =======================================

; FCT : SHIFT+@ : ne fait rien
; IN  : /
; OUT : /

ASS_doNOPEdt:
            rts
; End of function ASS_doNOPEdt


; =============== S U B R O U T I N E =======================================

; FCT : efface la ligne d'tat
; IN  : /
; OUT : X,A,B modified

ASS_clrStateLine:
            ldx CURAD_YX
            pshx
            ldx #cASS_POSYX_STATELINE
            stx CURAD_YX
            jsr vectorOS_clrLineByMode      ; FCT : Appelle la routine d'effacement de l'cran selon le mode en cours
                                            ; IN  : X=POS(Y,X) position de la ligne  effacer
                                            ; OUT : A,B,X modified
            pulx
            stx CURAD_YX
            rts
; End of function ASS_clrStateLine


; =============== S U B R O U T I N E =======================================

; FCT : Imprime la chane pointe par ASS_PTRTMP  partir
;       de la position courante et au maximum jusqu' la fin de la ligne
;       Si nous avons atteint la fin de ligne alors on
;       effectue un retour  la ligne
; IN  : ASS_PTRTMP  jour
; OUT : A,B,X modified

ASS_printString:
            jsr ASS_initBuffer              ; FCT : INTIALISE le tampon ASS_BUF_CURINP_BOT rceptionnant
                                            ;       les donnes  afficher via le DEVICE en cours (ou pas)
                                            ; IN  : /
                                            ; OUT : A,X modified
            ldx ASS_PTRTMP
            ldab 0,x
            stab ASS_LEN_INP_USR            ; Longueur de la saisie utilisateur
            beq nextASS_printString
            ldd #ASS_BUF_CURINP_BOT         ; Position du curseur d'dition
            jsr OS_copyMEM                  ; FCT : Copie la zone mmoire pointe par X
                                            ;       (le premier octet contient le nombre d'octets
                                            ;        copier) dans celle pointe par D
                                            ; IN  : X=SOURCE
                                            ;       D=CIBLE
                                            ; OUT : A,B,X modified

nextASS_printString:
            ldx #ASS_LEN_INP_USR            ; Longueur de la saisie utilisateur
            ldab 0,x
            abx
            inx
            clr 0,x
            ldx #ASS_LEN_INP_USR            ; Longueur de la saisie utilisateur
            tst DEVNU                       ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            bne next1ASS_printString
                                            ; --- vrifie que la longueur de la chaine ne dpasse pas celle de l'cran
                                            ;     sinon fixe le maximum

setMaxLgString:
            ldaa XMAX_SCR                   ; longueur d'un cran
            cmpa $00,x
            bhi next1ASS_printString
            staa 0,x

next1ASS_printString:
            ldab 0,x
            beq next3ASS_printString

bcl2ASS_printString:
            inx
            ldaa 0,x
            jsr OS_printCHAR                ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                            ; IN  : A=caractre  imprimer
                                            ;       DEVNU mise  jour
                                            ; OUT : B, X unmodified
            decb
            bne bcl2ASS_printString
            bra next4ASS_printString

next3ASS_printString:
            ldaa #cOS_SPACE                 ; ' '
            jsr OS_printCHAR                ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                            ; IN  : A=caractre  imprimer
                                            ;       DEVNU mise  jour
                                            ; OUT : B, X unmodified

next4ASS_printString:
            tst DEVNU                       ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            bne next5ASS_printString_CR     ; imprime un retour chariot
            ldab ASS_LEN_INP_USR            ; Longueur de la saisie utilisateur
            cmpb XMAX_SCR                   ; longueur d'un cran
            beq endASS_printString

next5ASS_printString_CR:
            ldaa #cOS_CR                    ; imprime un retour chariot
            jsr OS_printCHAR                ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                            ; IN  : A=caractre  imprimer
                                            ;       DEVNU mise  jour
                                            ; OUT : B, X unmodified

endASS_printString:
            rts
; End of function ASS_printString


; =============== S U B R O U T I N E =======================================

; FCT : Gestion du curseur en mode assembleur : gre son clignotement
; IN  : /
; OUT : A,X modified

ASS_printCURSOR:
            jsr ASS_getPhysicalPosX         ; FCT : Renvoie l'adresse physique du curseur de saisie
                                            ;       dans le tampon d'dition assembleur
                                            ; IN  : /
                                            ; OUT : X=Adresse physique du curseur dans le tampon de saisie ASS_BUF_CURINP_BOT
            ldaa 0,x
            psha
            ldaa #cOS_PLEIN_INVERSE         ; $80
            bsr ASS_j_printCH               ; FCT : Appel  la routine d'impression d'un caractre
                                            ;       sans faire avancer le curseur d'une position
                                            ; IN  : A=caractre  imprimer
                                            ; OUT : /
            pula
            psha
            bsr ASS_j_printCH               ; FCT : Appel  la routine d'impression d'un caractre
                                            ;       sans faire avancer le curseur d'une position
                                            ; IN  : A=caractre  imprimer
                                            ; OUT : /
            ldaa COLOR_CARGRA               ; Code couleur cyclique pour les caractres graphiques via CTRL+0
            oraa #$8F                       ; $8F : 1000 1111
            bsr ASS_j_printCH               ; FCT : Appel  la routine d'impression d'un caractre
                                            ;       sans faire avancer le curseur d'une position
                                            ; IN  : A=caractre  imprimer
                                            ; OUT : /
            pula
; End of function ASS_printCURSOR


; =============== S U B R O U T I N E =======================================

; FCT : Appel  la routine d'impression d'un caractre
;       sans faire avancer le curseur d'une position
; IN  : A=caractre  imprimer
; OUT : /

ASS_j_printCH:
            jmp ASS_printCHARtCurrentPos        ; FCT : Imprime le caractre A  la position actuelle du curseur
                                                ; IN  : A=caractre  imprimer
                                                ; OUT : A,B,X modified
												;       CURAD_YX inchang

; End of function ASS_j_printCH
; ---------------------------------------------------------------------------
            dc.b     1
            dc.b     1
; =============== S U B R O U T I N E =======================================

; FCT : Imprime un caractre puis temporise $45E x s
; IN  : A=caractre  imprimer
; OUT : /

ASS_printCHWithTempo:
            jsr OS_printCHAR                ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                            ; IN  : A=caractre  imprimer
                                            ;       DEVNU mise  jour
                                            ; OUT : B, X unmodified
            jsr OS_doTempo0x45E             ; FCT : une tempo fixe de $45E x K microsecondes
                                            ; ST  : ACTIF
                                            ; IN  : /
                                            ; OUT : X modified
            rts
; End of function ASS_printCHWithTempo


; =============== S U B R O U T I N E =======================================

; FCT : met  jour la position Y du curseur texte 
;       partir de celle de l'assembleur
; IN  : ASS_CURY  jour
; OUT : CURAD_YX partie Y mise  jour

ASS_setCURAD_YtoASSCURAD_Y:
            ldx ASS_CURY
            stx CURAD_YX
            rts
; End of function ASS_setCURAD_YtoASSCURAD_Y


; =============== S U B R O U T I N E =======================================

; FCT : Initialise CURAD_YX en fonction de ASS_CURAD_Y et X=0
; IN  : /
; OUT : D=X=CURAD_YX=(ASS_CURY,0)

ASS_setCURAD_YX_BEGIN_LINE:
            ldaa ASS_CURY
            clrb
            std CURAD_YX
            ldx CURAD_YX
            rts
; End of function ASS_setCURAD_YX_BEGIN_LINEf$

; ---------------------------------------------------------------------------
tabKEY_ASS:     dc.b cKB_BREAK , cKB_LEFT  , cKB_RIGHT , cKB_DOWN  , cKB_UP    , cKB_ENTER , cKB_SHIFT_ARROBASE, cKB_CTRL_A      ; 0
                dc.b cKB_CTRL_Z, cKB_CTRL_J, cKB_CTRL_D, cKB_CTRL_I, cKB_CTRL_T, cKB_CTRL_1, cKB_CTRL_F        , cKB_CTRL_M      ; 8
                dc.b cKB_CTRL_6, cKB_CTRL_4, cKB_CTRL_3, cKB_CTRL_R, cKB_CTRL_8, cKB_CTRL_H, cKB_CTRL_V        , cKB_CTRL_L      ; 16
;----------------------------
tabJMP_ASS: dc.w ASS_manageBreakEdt         ; FCT : Gestion du BREAK
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            dc.w ASS_moveCursorLeftEdt      ; FCT : CTRL+Q : Dplacement d'1 car. vers la gauche
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            dc.w ASS_moveCursorRightEdt     ; FCT : CTRL + FLECHE DROITE : Dplace le curseur vers la droite
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            dc.w ASS_manageCursorUpDowntEdt ; FCT : CTRL+W (fleche bas),CTRL+Z (fleche haut),ENTER (fleche bas),fleche haut
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            dc.w ASS_manageCursorUpDowntEdt ; FCT : CTRL+W (fleche bas),CTRL+Z (fleche haut),ENTER (fleche bas),fleche haut
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            dc.w ASS_manageCursorUpDowntEdt ; FCT : CTRL+W (fleche bas),CTRL+Z (fleche haut),ENTER (fleche bas),fleche haut
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            dc.w ASS_doNOPEdt               ; FCT : SHIFT+@ : ne fait rien
                                            ; IN  : /
                                            ; OUT : /
            dc.w ASS_clearLineEdt           ; FCT : CTRL+A : effacer jusqu'au bout de la ligne  partir de la position du curseur
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            dc.w ASS_manageCursorUpDowntEdt ; FCT : CTRL+W (fleche bas),CTRL+Z (fleche haut),ENTER (fleche bas),fleche haut
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            dc.w ASS_ToggleModeInsertEdt    ; FCT : CTRL+J : insertion de caractre  la position du curseur
                                            ; IN  : /
                                            ; OUT : ASS_MODE_INS mise  jour
            dc.w ASS_deleteChartEdt         ; FCT : CTRL+D : effacer le caractre sous le curseur
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            dc.w ASS_insertLinetEdt         ; FCT : CTRL+I : insert line above current line
                                            ; IN  : /
                                            ; OUT : ASS_insertLinetEdt
            dc.w ASS_insertTabEdt           ; FCT : CTRL+T : TAB : Dplacement de 6 caractres  droite
                                            ; IN  : ASS_CURX mise  jour
                                            ; OUT : B modified
            dc.w ASS_goCompilerEdt          ; FCT : 0X8E=CTRL+1 : lancement de la compilation
                                            ; IN  : /
                                            ; OUT : /
            dc.w ASS_foundTextEdt           ; FCT : CTRL+F : texte  rechercher
                                            ; IN  : /
                                            ; OUT : /
            dc.w ASS_doLoadMergeVerifyEdt   ; FCT : Effectue la partie load : merge/load/verify
                                            ;        $92 : CTRL+M : MERGING PROGRAMME
                                            ;        $97 : CTRL+4 : CHARGE UN FICHIER
                                            ;        $B5 : CTRL+V : VERIFICATION D'UNE SAUVEGARDE
                                            ; IN  : A=touche presse
                                            ; OUT : A,B,X modified
            dc.w ASS_sendPrinter            ; FCT : CTRL+6 : print source to ... printer
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            dc.w ASS_doLoadMergeVerifyEdt   ; FCT : Effectue la partie load : merge/load/verify
                                            ;        $92 : CTRL+M : MERGING PROGRAMME
                                            ;        $97 : CTRL+4 : CHARGE UN FICHIER
                                            ;        $B5 : CTRL+V : VERIFICATION D'UNE SAUVEGARDE
                                            ; IN  : A=touche presse
                                            ; OUT : A,B,X modified
            dc.w ASS_saveSourceEdt          ; FCT : SAUVEGARDER LE FICHIER SOURCE : CTRL-3
                                            ; IN  : /
                                            ; OUT : /
            dc.w ASS_toggleModeRepeatEdt    ; FCT : CTRL+R : mode rptition des touches
                                            ; IN  : /
                                            ; OUT : X modified
            dc.w ASS_toggleModeScreenEdt    ; FCT : TOGGLE SCREEN 80x25<>40x25
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            dc.w ASS_copyScreenToPrinterEdt ; FCT : CTRL+H : copie cran
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            dc.w ASS_doLoadMergeVerifyEdt   ; FCT : Effectue la partie load : merge/load/verify
                                            ;        $92 : CTRL+M : MERGING PROGRAMME
                                            ;        $97 : CTRL+4 : CHARGE UN FICHIER
                                            ;        $B5 : CTRL+V : VERIFICATION D'UNE SAUVEGARDE
                                            ; IN  : A=touche presse
                                            ; OUT : A,B,X modified
            dc.w ASS_foundLineEdt           ; FCT : CTRL+L : numro de lignes  chercher
                                            ; IN  : /
                                            ; OUT : A,B,X modified
;----------------
tabASS_KEY_SPECIFICAL:  dc.b cKB_CTRL_J, cKB_CTRL_8, cKB_CTRL_R         ; 81 : CTRL+J (insert char), 9D : CTRL+8 (toggle mode screen) , 9C : CTRL+R (autorepeat keyb)

; =============== S U B R O U T I N E =======================================

; FCT : TOGGLE SCREEN 80x25<>40x25
;       Alterne la rsolution d'cran et raffiche le source
; IN  : /
; OUT : A,B,X modified

ASS_toggleModeScreenEdt:
            jsr ASS_isInProgress            ; FCT : teste ASS_INPUT_INPROGRESS si <> 0 sort en ERREUR 5
                                            ; IN  : /
                                            ; OUT : A modified

toggleModeScreen:
            ldaa TECRAN                     ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            eora #$01
            staa TECRAN                     ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            jsr INASS                       ; FCT : vecteur pour appeler INASS : effacement de l'cran
                                            ; IN  : /
                                            ; OUT : /
            jsr ASS_printSrc                ; FCT : Imprime le source assembleur de la ligne en cours d'dition
                                            ; IN  : ASS_NUMLINE : ligne du source  imprimer
                                            ; OUT : A,B,X modified
            rts
; End of function ASS_toggleModeScreenEdt


; =============== S U B R O U T I N E =======================================

; FCT : CTRL+D : effacer le caractre sous le curseur
; IN  : /
; OUT : A,B,X modified

ASS_deleteChartEdt:
            bsr ASS_getPhysicalPosX         ; FCT : Renvoie l'adresse physique du curseur de saisie
                                            ;       dans le tampon d'dition assembleur
                                            ; IN  : /
                                            ; OUT : X=Adresse physique du curseur dans le tampon de saisie ASS_BUF_CURINP_BOT

bclASS_deleteChartEdt:
            cpx #(ASS_BUF_TOP-1)            ; Fin du tampon de saisie pour l'editeur de l'assembleur
            beq nextASS_deleteChartEdt
            ldaa 1,x
            staa 0,x
            inx
            bra bclASS_deleteChartEdt

nextASS_deleteChartEdt:
            ldaa #cOS_SPACE                 ; ' '
            staa 0,x
            bsr ASS_printLine               ; FCT : Affiche le tampon de saisie utilisateur
                                            ; IN  : /
                                            ; OUT : ASS_INPUT_IN_PROGRESS est mis  1
                                            ;       A,X,Y modified
            jsr ASS_setCURAD_YtoASSCURAD_Y  ; FCT : met  jour la position Y du curseur texte 
                                            ;       partir de celle de l'assembleur
                                            ; IN  : ASS_CURY  jour
                                            ; OUT : CURAD_YX partie Y mise  jour
            rts
; End of function ASS_deleteChartEdt


; =============== S U B R O U T I N E =======================================

; FCT : Renvoie l'adresse physique du curseur de saisie
;       dans le tampon d'dition assembleur
; IN  : /
; OUT : X=Adresse physique du curseur dans le tampon de saisie ASS_BUF_CURINP_BOT

ASS_getPhysicalPosX:
            ldx #ASS_BUF_CURINP_BOT         ; Position du curseur d'dition
            ldab ASS_CURX
            abx
            rts
; End of function ASS_getPhysicalPosX


; =============== S U B R O U T I N E =======================================

; FCT : Affiche le tampon de saisie utilisateur
; IN  : /
; OUT : ASS_INPUT_IN_PROGRESS est mis  1
;       A,X,Y modified

ASS_printLine:
            ldaa #cASS_INP_ON
            staa ASS_INP_INPROGRESS
            ldaa #cASS_LG_MAX_INP
            staa ASS_LEN_INP_USR            ; Longueur de la saisie utilisateur
            jsr ASS_setCURAD_YX_BEGIN_LINE  ; FCT : Initialise CURAD_YX en fonction de ASS_CURAD_Y et X=0
                                            ; IN  : /
                                            ; OUT : D=X=CURAD_YX=(ASS_CURY,0)
            jsr nextASS_printString
            rts
; End of function ASS_printLine


; =============== S U B R O U T I N E =======================================

; FCT : Insert ou remplace (selon ASS_MODE_INS)  la position actuelle du curseur
;       le caractre stock dans ASS_CHAR
; IN  : ASS_CHAR  jour : caractre  insrer
;       ASS_MODE_INS    : mode insertion ou pas
; OUT : A,B,X modified

ASS_insertChar:
            ldaa ASS_CHAR
            cmpa #cOS_SPACE                 ; ' '
            bcs setCURAD_ASS_moveCursorLeftEdt
            bsr ASS_getPhysicalPosX         ; FCT : Renvoie l'adresse physique du curseur de saisie
                                            ;       dans le tampon d'dition assembleur
                                            ; IN  : /
                                            ; OUT : X=Adresse physique du curseur dans le tampon de saisie ASS_BUF_CURINP_BOT
            stx ASS_VARTMP
            tst ASS_MODE_INS                ; Mode insertion ou pas (CTRL+J)
            beq doASS_insertChar
            ldx #ASS_BUF_TOP                ; A quel moment cette variable est initialise ?  Sert de borne ?

bclShiftBuffer:
            ldaa 0,x
            staa 1,x
            cpx ASS_VARTMP
            beq doASS_insertChar
            dex
            bra bclShiftBuffer

doASS_insertChar:
            ldaa ASS_CHAR
            staa 0,x
            bsr ASS_printLine               ; FCT : Affiche le tampon de saisie utilisateur
                                            ; IN  : /
                                            ; OUT : ASS_INPUT_IN_PROGRESS est mis  1
                                            ;       A,X,Y modified
; End of function ASS_insertChar

; =============== S U B R O U T I N E =======================================

; FCT : CTRL + FLECHE DROITE : Dplace le curseur vers la droite
; IN  : /
; OUT : ASS_moveCursorRightEdt

ASS_moveCursorRightEdt:
            ldab ASS_CURX
            incb
            cmpb XMAX_SCR                   ; longueur d'un cran
            beq setCURAD_ASS_moveCursorLeftEdt
            bra saveASS_moveCursorLeftEdt
; End of function ASS_moveCursorRightEdt


; =============== S U B R O U T I N E =======================================

; FCT : CTRL+Q : Dplacement d'1 car. vers la gauche
; IN  : /
; OUT : A,B,X modified

ASS_moveCursorLeftEdt:
            ldab ASS_CURX
            beq saveASS_moveCursorLeftEdt   ; euh ... saut en C223 plutt ?
            decb

saveASS_moveCursorLeftEdt:
            stab ASS_CURX

setCURAD_ASS_moveCursorLeftEdt:
            jsr ASS_setCURAD_YtoASSCURAD_Y  ; FCT : met  jour la position Y du curseur texte 
                                            ;       partir de celle de l'assembleur
                                            ; IN  : ASS_CURY  jour
                                            ; OUT : CURAD_YX partie Y mise  jour
            rts
; End of function ASS_moveCursorLeftEdt


; =============== S U B R O U T I N E =======================================

; FCT : CTRL+J : insertion de caractre  la position du curseur
; IN  : /
; OUT : ASS_MODE_INS mise  jour

ASS_ToggleModeInsertEdt:
            ldx #ASS_MODE_INS               ; Mode insertion ou pas (CTRL+J)
            bra negASS_toggleModeRepeatEdt
; End of function ASS_ToggleModeInsertEdt


; =============== S U B R O U T I N E =======================================

; FCT : CTRL+R : mode rptition des touches
; IN  : /
; OUT : X modified

ASS_toggleModeRepeatEdt:
            ldx #ASS_MODE_KBD_AUTO
negASS_toggleModeRepeatEdt:
            com 0,x
            rts
; End of function ASS_toggleModeRepeatEdt


; =============== S U B R O U T I N E =======================================

; FCT : Gestion du BREAK
; IN  : /
; OUT : A,B,X modified

ASS_manageBreakEdt:
            ldx CURAD_YX
            pshx

ASS_manageBreakEdt_PSEUDOCLIGNOTEMENT:
            ldx #cASS_POSYX_STATELINE   ; Positionne le curseur sur la ligne d'tat
                                        ; (24me ligne et 1re colonne=0)
            stx CURAD_YX
            ldx #(aBreak_0-1)           ; "BREAK"
            jsr OS_OUTTX                ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                        ; IN : X=pointeur sur une chane de caractres termine par un 0
                                        ; OUT: A,B,X modified
            jsr OS_doTempo0x45E         ; FCT : une tempo fixe de $45E x K microsecondes
                                        ; ST  : ACTIF
                                        ; IN  : /
                                        ; OUT : X modified
            ldx #cASS_POSYX_STATELINE   ; Positionne le curseur sur la ligne d'tat
                                        ; (24me ligne et 1re colonne=0)
            stx CURAD_YX
            ldx #(aSpaces-1)            ; "     "
            jsr OS_OUTTX                ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                        ; IN : X=pointeur sur une chane de caractres termine par un 0
                                        ; OUT: A,B,X modified
            jsr OS_doTempo0x45E         ; FCT : une tempo fixe de $45E x K microsecondes
                                        ; ST  : ACTIF
                                        ; IN  : /
                                        ; OUT : X modified
            jsr OS_POLCA                ; FCT : polling keyboard
                                        ; IN  : /
                                        ; OUT : A=code ascii de la touche
										;       X,B not modified
            beq ASS_manageBreakEdt_PSEUDOCLIGNOTEMENT
            cmpa #cKB_BREAK
            beq jmpjmpNextDoEtCommercial
            pulx
            stx CURAD_YX
            rts

jmpjmpNextDoEtCommercial:
            jmp jmpNextDoEtCommercial
; End of function ASS_manageBreakEdt

; ---------------------------------------------------------------------------
aBreak_0:       dc.b "BREAK",0
;----------------
aSpaces:        dc.b "     ",0
; ---------------------------------------------------------------------------

ERROR_0_BADTYPEFILE:
            clra
            SKIP2_ASM

ERROR_4_OVERFLOWMEM:
            ldaa #cASS_ERR_OVERFLOW_MEM
            SKIP2_ASM

ERROR_5_INPROGRESS:
            ldaa #cASS_ERR_INPROGRESS
            SKIP2_ASM

ERROR_6_STR_UNKNOWN:
            ldaa #cASS_ERR_STR_UNKNOWN
            SKIP2_ASM

ERROR_7_BAD_NUMBER:
            ldaa #cASS_ERR_BAD_NUMBER
            SKIP2_ASM

ERROR_8:
            ldaa #cASS_ERR_EMPTY_00
            SKIP2_ASM

ERROR_9:
            ldaa #cASS_ERR_EMPTY_01

; =============== S U B R O U T I N E =======================================

; FCT : Affiche le numro de ligne et le numro de l'erreur sur la ligne d'tat
; IN  : A=numro de l'erreur
; OUT : Retourne  la boucle d'interprtation de l'assembleur

ASS_PRINTERROR:
            staa ASS_ERR
            jsr ASS_printDeviceScreen       ; FCT : Imprime une ligne de source sur la sortie courante
                                            ; IN  : ASS_SAV_NUMLINE  jour
                                            ;       ASS_NUMLINE  jour
                                            ;       ASS_PTRTMP  jour
                                            ; OUT : A,B,X modified
            jsr ASS_clrStateLine            ; FCT : efface la ligne d'tat
                                            ; IN  : /
                                            ; OUT : X,A,B modified
            ldx #cASS_POSYX_STATELINE
            stx CURAD_YX
            ldx #(aErreur-1)                ; "ERREUR "
            jsr OS_OUTTX                    ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                            ; IN : X=pointeur sur une chane de caractres termine par un 0
                                            ; OUT: A,B,X modified
printNumErr:
            ldaa ASS_ERR
            adda #$30                       ; '0'
            jsr OS_printCHAR                ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                            ; IN  : A=caractre  imprimer
                                            ;       DEVNU mise  jour
                                            ; OUT : B, X unmodified
            jsr ASS_CopySourceToTarget      ; FCT : copie de la zone pointe par ASS_PTRTMP vers
                                            ;       la zone ASS_BUF_CURINP_BOT
                                            ; IN  : ASS_PTRTMP(source) et ASS_BUF_CURINP_BOT (cible)
                                            ; OUT : A,B,X modified
            jsr ASS_setCURAD_YtoASSCURAD_Y  ; FCT : met  jour la position Y du curseur texte 
                                            ;       partir de celle de l'assembleur
                                            ; IN  : ASS_CURY  jour
                                            ; OUT : CURAD_YX partie Y mise  jour
            clr ASS_INP_INPROGRESS

emitBeep:
            ldaa #$80
            ldab #$01
            jsr initRomSound
            jmp ASS_INTERPRET
; End of function ASS_PRINTERROR

; ---------------------------------------------------------------------------
aErreur:        dc.b "ERREUR ",0

; =============== S U B R O U T I N E =======================================

; FCT : teste ASS_INPUT_INPROGRESS si <> 0 sort en ERREUR 5
; IN  : /
; OUT : A modified

ASS_isInProgress:
            ldaa ASS_INP_INPROGRESS
            bne ERROR_5_INPROGRESS
            rts
; End of function ASS_isInProgress


; =============== S U B R O U T I N E =======================================

; FCT : recherche dans le source la ligne demande
; IN  : ASS_NUMLINE: le numro de ligne recherche
; OUT : X=pointe sur le dbut de la source de la ligne recherche
;       ASS_NUMLINE mit  jour par la recherche
;       ASS_PTRTMP pointe sur le dbut de la source de la ligne recherche

ASS_searchLine:
            ldx #cOS_NULL
            stx ASS_VARTMP
            ldx ASS_MEMMAX

bclASS_SearchLine:
            pshx
            ldx ASS_VARTMP
            cpx ASS_NUMLINE             ; sert par exemple  stocker le numro de ligne  chercher
            beq nextASS_SearchLine
            pulx
            ldab 0,x
            cmpb #$FF
            beq endASS_SearchLine
            abx
            inx
            ldd ASS_VARTMP
            addd #$01
            std ASS_VARTMP
            bra bclASS_SearchLine

nextASS_SearchLine:
            pulx

endASS_SearchLine:
            stx ASS_PTRTMP
            ldd ASS_VARTMP
            std ASS_NUMLINE             ; sert par exemple  stocker le numro de ligne  chercher
            rts
; End of function ASS_searchLine


; =============== S U B R O U T I N E =======================================

; FCT : Recherche le dbut de la zone compile
; IN  : /
; OUT : X=ASS_OBJ_BEGIN=dbut de la zone compile

ASS_findBEGINOBJ:
            ldx ASS_MEMMAX

bclFndBEGINOBJ:
            ldab 0,x
            cmpb #$FF
            beq endFndBEGINOBJ
            abx
            inx
            bra bclFndBEGINOBJ

endFndBEGINOBJ:
            stx ASS_OBJ_BEGIN               ; dbut du programme objet
            rts
; End of function ASS_findBEGINOBJ


; =============== S U B R O U T I N E =======================================

; FCT : CTRL+W (fleche bas),CTRL+Z (fleche haut),ENTER (fleche bas),fleche haut
; IN  : /
; OUT : A,B,X modified

ASS_manageCursorUpDowntEdt:
            bsr ASS_searchLine              ; FCT : recherche dans le source la ligne demande
                                            ; IN  : ASS_NUMLINE: le numro de ligne recherche
                                            ; OUT : X=pointe sur le dbut de la source de la ligne recherche
                                            ;       ASS_NUMLINE mit  jour par la recherche
                                            ;       ASS_PTRTMP pointe sur le dbut de la source de la ligne recherche
            bsr ASS_findBEGINOBJ            ; FCT : Recherche le dbut de la zone compile
                                            ; IN  : /
                                            ; OUT : X=ASS_OBJ_BEGIN=dbut de la zone compile
            cpx ASS_PTRTMP
            beq initTRIM_ASS_manageCursorUpDowntEdt
            ldaa ASS_INP_INPROGRESS
            beq loadKeyPressed_ASS_manageCursorUpDowntEdt

initTRIM_ASS_manageCursorUpDowntEdt:
            ldaa #cASS_LG_MAX_INP
            ldx #(ASS_BUF_TOP-1)            ; Fin du tampon de saisie pour l'editeur de l'assembleur

bclTRIM_ASS_manageCursorUpDowntEdt:
            ldab 0,x
            cmpb #cOS_SPACE                 ; ' '
            bne nextASS_manageCursorUpDowntEdt
            dex
            deca
            bne bclTRIM_ASS_manageCursorUpDowntEdt

nextASS_manageCursorUpDowntEdt:
            staa ASS_LEN_INP_USR            ; Longueur de la saisie utilisateur
            ldx ASS_PTRTMP
            ldab 0,x
            cmpb #$FF
            bne next1ASS_manageCursorUpDowntEdt
            clrb

next1ASS_manageCursorUpDowntEdt:
            sba
            staa ASS_FCOPYSRC               ; donne le sens de la copie du source peut prendre la valeur 1
            jsr ASS_copySRC                 ; FCT : Dplace une zone mmoire du source assembleur
                                            ;       suivant le sens donn par ASS_FCOPYSRC
                                            ; IN  : ASS_PTRTMP, ASS_OBJ_BEGIN et ADRENDMEM doivent tre  jour
                                            ;       ASS_FCOPYSRC donne le sens de la copie
                                            ; OUT : A,B,X modified
            ldaa ASS_LEN_INP_USR            ; Longueur de la saisie utilisateur
            ldx ASS_PTRTMP
            staa 0,x
            beq loadKeyPressed_ASS_manageCursorUpDowntEdt
            ldx #ASS_LEN_INP_USR            ; Longueur de la saisie utilisateur
            ldd ASS_PTRTMP
            addd #$0001
            jsr OS_copyMEM                  ; FCT : Copie la zone mmoire pointe par X
                                            ;       (le premier octet contient le nombre d'octets
                                            ;        copier) dans celle pointe par D
                                            ; IN  : X=SOURCE
                                            ;       D=CIBLE
                                            ; OUT : A,B,X modified
loadKeyPressed_ASS_manageCursorUpDowntEdt:
            ldaa ASS_CHAR

isCTRLZ:
            cmpa #cKB_CTRL_Z
            beq manage_FlecheHaut

isArrowHigh:
            cmpa #cKB_CTRL_UP
            bne next5ASS_manageCursorUpDowntEdt

manage_FlecheHaut:
            ldaa ASS_CURY
            bne next2ASS_manageCursorUpDowntEdt
            ldx ASS_NUMLINE                 ; sert par exemple  stocker le numro de ligne  chercher
            beq next4ASS_manageCursorUpDowntEdt
            jsr ASS_scrollDown              ; FCT : Effectue un scrolling afin d'afficher la ligne prcdente
                                            ; IN  : ASS_SAV_NUMLINE  jour
                                            ; OUT : ASS_SAV_NUMLINE=ASS_SAV_NUMLINE-1
            bra next3ASS_manageCursorUpDowntEdt

next2ASS_manageCursorUpDowntEdt:
            dec ASS_CURY

next3ASS_manageCursorUpDowntEdt:
            ldx ASS_NUMLINE                 ; sert par exemple  stocker le numro de ligne  chercher
            dex
            stx ASS_NUMLINE                 ; sert par exemple  stocker le numro de ligne  chercher

next4ASS_manageCursorUpDowntEdt:
            bra next7ASS_manageCursorUpDowntEdt

next5ASS_manageCursorUpDowntEdt:
            ldx ASS_NUMLINE                 ; sert par exemple  stocker le numro de ligne  chercher
            inx
            stx ASS_NUMLINE                 ; sert par exemple  stocker le numro de ligne  chercher
            ldaa ASS_CURY
            cmpa #cASS_POSY_MAX_SRC
            bne next6ASS_manageCursorUpDowntEdt
            bsr ASS_scrollUP                ; FCT : Effectue un scrolling afin d'afficher la ligne suivante
                                            ; IN  : ASS_SAV_NUMLINE  jour
                                            ; OUT : ASS_SAV_NUMLINE=ASS_SAV_NUMLINE+1
            bra next7ASS_manageCursorUpDowntEdt

next6ASS_manageCursorUpDowntEdt:
            inc ASS_CURY

next7ASS_manageCursorUpDowntEdt:
            jsr ASS_initBuffer              ; FCT : INTIALISE le tampon ASS_BUF_CURINP_BOT rceptionnant
                                            ;       les donnes  afficher via le DEVICE en cours (ou pas)
                                            ; IN  : /
                                            ; OUT : A,X modified
            jsr ASS_searchLine              ; FCT : recherche dans le source la ligne demande
                                            ; IN  : ASS_NUMLINE: le numro de ligne recherche
                                            ; OUT : X=pointe sur le dbut de la source de la ligne recherche
                                            ;       ASS_NUMLINE mit  jour par la recherche
                                            ;       ASS_PTRTMP pointe sur le dbut de la source de la ligne recherche
            ldab 0,x
            beq next8ASS_manageCursorUpDowntEdt
            cmpb #$FF
            beq next8ASS_manageCursorUpDowntEdt
            ldd #ASS_BUF_CURINP_BOT         ; Position du curseur d'dition
            jsr OS_copyMEM                  ; FCT : Copie la zone mmoire pointe par X
                                            ;       (le premier octet contient le nombre d'octets
                                            ;        copier) dans celle pointe par D
                                            ; IN  : X=SOURCE
                                            ;       D=CIBLE
                                            ; OUT : A,B,X modified

next8ASS_manageCursorUpDowntEdt:
            jsr ASS_setCURAD_YX_BEGIN_LINE  ; FCT : Initialise CURAD_YX en fonction de ASS_CURAD_Y et X=0
                                            ; IN  : /
                                            ; OUT : D=X=CURAD_YX=(ASS_CURY,0)
            clr ASS_CURX
            clr ASS_INP_INPROGRESS
            clr ASS_MODE_INS                ; Mode insertion ou pas (CTRL+J)
            rts
; End of function ASS_manageCursorUpDowntEdt


; =============== S U B R O U T I N E =======================================

; FCT : Dplace une zone mmoire du source assembleur
;       suivant le sens donn par ASS_FCOPYSRC
; IN  : ASS_PTRTMP, ASS_OBJ_BEGIN et ADRENDMEM doivent tre  jour
;       ASS_FCOPYSRC donne le sens de la copie
; OUT : A,B,X modified

ASS_copySRC:
            ldab ASS_FCOPYSRC               ; donne le sens de la copie du source peut prendre la valeur 1
            blt next4ASS_COPYSRC            ; Saut si ASS_FCOPYSRC = [128;255]
            ldx ASS_OBJ_BEGIN               ; dbut du programme objet
            cpx ASS_PTRTMP
            bne nextASS_COPYSRC
            incb

nextASS_COPYSRC:
            abx
            cpx ADRENDMEM                   ; Adresse de la fin de mmoire
            bcs next2ASS_COPYSRC
            jmp ERROR_4_OVERFLOWMEM

next2ASS_COPYSRC:
            ldx ASS_OBJ_BEGIN               ; dbut du programme objet
            inx

bcl3ASS_COPYSRC:
            dex
            pshx
            ldaa 0,x
            abx
            staa 0,x
            pulx
            cpx ASS_PTRTMP
            bne bcl3ASS_COPYSRC
            rts

next4ASS_COPYSRC:
            negb
            ldx ASS_PTRTMP
            dex

bcl5ASS_COPYSRC:
            inx
            pshx
            abx
            ldaa 0,x
            pulx
            staa 0,x
            cpx ASS_OBJ_BEGIN               ; dbut du programme objet
            bne bcl5ASS_COPYSRC
            rts
; End of function ASS_copySRC


; =============== S U B R O U T I N E =======================================

; FCT : Effectue un scrolling afin d'afficher la ligne suivante
; IN  : ASS_SAV_NUMLINE  jour
; OUT : ASS_SAV_NUMLINE=ASS_SAV_NUMLINE+1

ASS_scrollUP:
            ldx ASS_SAV_NUMLINE
            inx
            bra ASS_doScrollX
; End of function ASS_scrollUP


; =============== S U B R O U T I N E =======================================

; FCT : Effectue un scrolling afin d'afficher la ligne prcdente
; IN  : ASS_SAV_NUMLINE  jour
; OUT : ASS_SAV_NUMLINE=ASS_SAV_NUMLINE-1

ASS_scrollDown:
            ldx ASS_SAV_NUMLINE
            dex

ASS_doScrollX:
            stx ASS_SAV_NUMLINE
            bra ASS_printDeviceScreen       ; FCT : Imprime une ligne de source sur la sortie courante
                                            ; IN  : ASS_SAV_NUMLINE  jour
                                            ;       ASS_NUMLINE  jour
                                            ;       ASS_PTRTMP  jour
                                            ; OUT : A,B,X modified
; End of function ASS_scrollDown

; =============== S U B R O U T I N E =======================================

; FCT : CTRL+H : copie cran sur imprimante
; IN  : /
; OUT : A,B,X modified

ASS_copyScreenToPrinterEdt:
            jsr ASS_isInProgress            ; FCT : teste ASS_INPUT_INPROGRESS si <> 0 sort en ERREUR 5
                                            ; IN  : /
                                            ; OUT : A modified
            ldaa #cOS_DEV_PRINTER           ; $01 : mode printer
            bsr ASS_printToDeviceX
            jsr ASS_CopySourceToTarget      ; FCT : copie de la zone pointe par ASS_PTRTMP vers
                                            ;       la zone ASS_BUF_CURINP_BOT
                                            ; IN  : ASS_PTRTMP(source) et ASS_BUF_CURINP_BOT (cible)
                                            ; OUT : A,B,X modified
            rts
; End of function ASS_copyScreenToPrinterEdt


; =============== S U B R O U T I N E =======================================

; FCT : CTRL+6 : print source to ... printer
; IN  : /
; OUT : A,B,X modified

ASS_sendPrinter:
            jsr ASS_isInProgress            ; FCT : teste ASS_INPUT_INPROGRESS si <> 0 sort en ERREUR 5
                                            ; IN  : /
                                            ; OUT : A modified
            ldaa #cOS_DEV_PRINTER
            staa DEVNU                      ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            ldaa #$FF
            staa ASS_VARTMP
            ldx ASS_MEMMAX
            stx ASS_PTRSOURCE
            bsr nextASS_printDeviceX
            jsr ASS_CopySourceToTarget      ; FCT : copie de la zone pointe par ASS_PTRTMP vers
                                            ;       la zone ASS_BUF_CURINP_BOT
                                            ; IN  : ASS_PTRTMP(source) et ASS_BUF_CURINP_BOT (cible)
                                            ; OUT : A,B,X modified
            rts
; End of function ASS_sendPrinter


; =============== S U B R O U T I N E =======================================

; FCT : Imprime une ligne de source sur la sortie courante
; IN  : ASS_SAV_NUMLINE  jour
;       ASS_NUMLINE  jour
;       ASS_PTRTMP  jour
; OUT : A,B,X modified

ASS_printDeviceScreen:
            clra

ASS_printToDeviceX:
            staa DEVNU                      ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            ldx ASS_PTRTMP
            pshx
            ldx ASS_NUMLINE                 ; sert par exemple  stocker le numro de ligne  chercher
            pshx
            ldx ASS_SAV_NUMLINE
            stx ASS_NUMLINE                 ; sert par exemple  stocker le numro de ligne  chercher
            jsr ASS_searchLine              ; FCT : recherche dans le source la ligne demande
                                            ; IN  : ASS_NUMLINE: le numro de ligne recherche
                                            ; OUT : X=pointe sur le dbut de la source de la ligne recherche
                                            ;       ASS_NUMLINE mit  jour par la recherche
                                            ;       ASS_PTRTMP pointe sur le dbut de la source de la ligne recherche
            stx ASS_PTRSOURCE
            pulx
            stx ASS_NUMLINE                 ; sert par exemple  stocker le numro de ligne  chercher
            pulx
            stx ASS_PTRTMP
            clr ASS_VARTMP

nextASS_printDeviceX:
            ldx ASS_PTRTMP
            pshx
            ldx ASS_PTRSOURCE
            stx ASS_PTRTMP
            ldaa ASS_CURY
            psha
            ldaa ASS_VARTMP
            staa ASS_CURY

bcl1ASS_printDeviceX:
            ldx ASS_PTRTMP
            ldab 0,x
            cmpb #$FF
            beq next2ASS_printDeviceX
            jsr ASS_setCURAD_YX_BEGIN_LINE  ; FCT : Initialise CURAD_YX en fonction de ASS_CURAD_Y et X=0
                                            ; IN  : /
                                            ; OUT : D=X=CURAD_YX=(ASS_CURY,0)
            jsr ASS_printString             ; FCT : Imprime la chane pointe par ASS_PTRTMP  partir
                                            ;       de la position courante et au maximum jusqu' la fin de la ligne
                                            ;       Si nous avons atteint la fin de ligne alors on
                                            ;       effectue un retour  la ligne
                                            ; IN  : ASS_PTRTMP  jour
                                            ; OUT : A,B,X modified
            ldx ASS_PTRTMP
            ldab 0,x
            abx
            inx
            stx ASS_PTRTMP
            ldaa ASS_CURY
            cmpa #$FF
            beq bcl1ASS_printDeviceX
            inca
            staa ASS_CURY
            cmpa #cASS_POSY_STATELINE       ; OJE TODO - Est-ce la position physique ou la taille d'un source ?
            bne bcl1ASS_printDeviceX
            bra next4ASS_printDeviceX

next2ASS_printDeviceX:
            tst DEVNU                       ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            bne next4ASS_printDeviceX
            ldaa #cOS_CR
            ldab ASS_CURY

bcl3ASS_printDeviceX:
            incb
            cmpb #(cASS_POSY_STATELINE+1)   ; OJE TODO - Est-ce la position physique ou la taille d'un source ?
            beq next4ASS_printDeviceX
            jsr OS_printCHAR                ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                            ; IN  : A=caractre  imprimer
                                            ;       DEVNU mise  jour
                                            ; OUT : B, X unmodified
            bra bcl3ASS_printDeviceX

next4ASS_printDeviceX:
            pula
            staa ASS_CURY
            pulx
            stx ASS_PTRTMP
            clr DEVNU                       ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            jsr ASS_setCURAD_YtoASSCURAD_Y  ; FCT : met  jour la position Y du curseur texte 
                                            ;       partir de celle de l'assembleur
                                            ; IN  : ASS_CURY  jour
                                            ; OUT : CURAD_YX partie Y mise  jour
            rts
; End of function ASS_printDeviceScreen


; =============== S U B R O U T I N E =======================================

; FCT : CTRL+I : insert line above current line
; IN  : /
; OUT : ASS_insertLinetEdt

ASS_insertLinetEdt:
            jsr ASS_isInProgress            ; FCT : teste ASS_INPUT_INPROGRESS si <> 0 sort en ERREUR 5
                                            ; IN  : /
                                            ; OUT : A modified
            jsr ASS_searchLine              ; FCT : recherche dans le source la ligne demande
                                            ; IN  : ASS_NUMLINE: le numro de ligne recherche
                                            ; OUT : X=pointe sur le dbut de la source de la ligne recherche
                                            ;       ASS_NUMLINE mit  jour par la recherche
                                            ;       ASS_PTRTMP pointe sur le dbut de la source de la ligne recherche

isEOL_ASS_insertLinetEdt:
            ldaa 0,x
            cmpa #$FF
            bne nextASS_insertLinetEdt
            rts

nextASS_insertLinetEdt:
            jsr ASS_findBEGINOBJ            ; FCT : Recherche le dbut de la zone compile
                                            ; IN  : /
                                            ; OUT : X=ASS_OBJ_BEGIN=dbut de la zone compile
            ldaa #$01
            staa ASS_FCOPYSRC               ; donne le sens de la copie du source peut prendre la valeur 1
            jsr ASS_copySRC                 ; FCT : Dplace une zone mmoire du source assembleur
                                            ;       suivant le sens donn par ASS_FCOPYSRC
                                            ; IN  : ASS_PTRTMP, ASS_OBJ_BEGIN et ADRENDMEM doivent tre  jour
                                            ;       ASS_FCOPYSRC donne le sens de la copie
                                            ; OUT : A,B,X modified
            ldx ASS_PTRTMP
            clr 0,x

next1ASS_insertLinetEdt:
            jsr ASS_printDeviceScreen       ; FCT : Imprime une ligne de source sur la sortie courante
                                            ; IN  : ASS_SAV_NUMLINE  jour
                                            ;       ASS_NUMLINE  jour
                                            ;       ASS_PTRTMP  jour
                                            ; OUT : A,B,X modified
            jmp next7ASS_manageCursorUpDowntEdt
; End of function ASS_insertLinetEdt


; =============== S U B R O U T I N E =======================================

; FCT : CTRL+A : effacer jusqu'au bout de la ligne  partir de la position du curseur
; IN  : /
; OUT : A,B,X modified

ASS_clearLineEdt:
            jsr ASS_isInProgress            ; FCT : teste ASS_INPUT_INPROGRESS si <> 0 sort en ERREUR 5
                                            ; IN  : /
                                            ; OUT : A modified
            jsr ASS_searchLine              ; FCT : recherche dans le source la ligne demande
                                            ; IN  : ASS_NUMLINE: le numro de ligne recherche
                                            ; OUT : X=pointe sur le dbut de la source de la ligne recherche
                                            ;       ASS_NUMLINE mit  jour par la recherche
                                            ;       ASS_PTRTMP pointe sur le dbut de la source de la ligne recherche
            jsr ASS_findBEGINOBJ            ; FCT : Recherche le dbut de la zone compile
                                            ; IN  : /
                                            ; OUT : X=ASS_OBJ_BEGIN=dbut de la zone compile
            ldx ASS_PTRTMP
            ldab 0,x
            incb
            negb
            stab ASS_FCOPYSRC               ; donne le sens de la copie du source
                                            ; peut prendre la valeur 1
            jsr ASS_copySRC                 ; FCT : Dplace une zone mmoire du source assembleur
                                            ;       suivant le sens donn par ASS_FCOPYSRC
                                            ; IN  : ASS_PTRTMP, ASS_OBJ_BEGIN et ADRENDMEM doivent tre  jour
                                            ;       ASS_FCOPYSRC donne le sens de la copie
                                            ; OUT : A,B,X modified
            bra next1ASS_insertLinetEdt
; End of function ASS_clearLineEdt


; =============== S U B R O U T I N E =======================================

; FCT : CTRL+T : TAB : Dplacement de 6 caractres  droite
; IN  : ASS_CURX mise  jour
; OUT : B modified

ASS_insertTabEdt:
            clrb

bclASS_insertTabEdt:
            cmpb ASS_CURX
            bgt next1ASS_insertTabEdt
            addb #cASS_TAB
            bra bclASS_insertTabEdt

next1ASS_insertTabEdt:
            cmpb #cASS_LG_MAX_INP           ; il y a 80 colonnes par ligne mme en mode 40 col !
            bcs next2ASS_insertTabEdt
            ldab #(cASS_LG_MAX_INP-1)

next2ASS_insertTabEdt:
            cmpb XMAX_SCR                   ; longueur d'un cran
            bcs next3ASS_insertTabEdt
            ldab XMAX_SCR                   ; longueur d'un cran
            decb

next3ASS_insertTabEdt:
            stab ASS_CURX
            jsr ASS_setCURAD_YtoASSCURAD_Y  ; FCT : met  jour la position Y du curseur texte 
                                            ;       partir de celle de l'assembleur
                                            ; IN  : ASS_CURY  jour
                                            ; OUT : CURAD_YX partie Y mise  jour
            rts
; End of function ASS_insertTabEdt


; =============== S U B R O U T I N E =======================================

; FCT : CTRL+L : numro de lignes  chercher
; IN  : /
; OUT : A,B,X modified

ASS_foundLineEdt:
            jsr ASS_isInProgress            ; FCT : teste ASS_INPUT_INPROGRESS si <> 0 sort en ERREUR 5
                                            ; IN  : /
                                            ; OUT : A modified

showPrompt_ASS_foundLineEdt:
            ldx #aPromptAss-1               ; "> "
            ldaa #$04
            bsr ASS_getInputUser            ; FCT : Affiche un message d'invite,
                                            ;       attend une saisie utilisateur limite  une longueur A
                                            ; IN  : A=longueur maximale de la saisie utilisateur
                                            ;       X=Position de la chane  afficher sur la ligne d'tat
                                            ; OUT : A=Code de la touche actionne par l'utilisateur
                                            ;       X=modified
            cmpa #cOS_CR
            bne nextASS_foundLineEdt
            bsr ASS_ASCIItoWORD             ; FCT : conversion d'une chane de caractres contenant un nombre en un mot
                                            ;       N'est pas optimis !
                                            ; IN  : ASS_BUF_CURINP_BOT pointe sur la chane  convertir
                                            ; OUT : ASS_VARTMP=rsultat de la conversion
                                            ;       X,B,A modified
            ldx ASS_VARTMP
            dex
            stx ASS_NUMLINE                 ; sert par exemple  stocker le numro de ligne  chercher

nextASS_foundLineEdt:
            jsr ASS_searchLine              ; FCT : recherche dans le source la ligne demande
                                            ; IN  : ASS_NUMLINE: le numro de ligne recherche
                                            ; OUT : X=pointe sur le dbut de la source de la ligne recherche
                                            ;       ASS_NUMLINE mit  jour par la recherche
                                            ;       ASS_PTRTMP pointe sur le dbut de la source de la ligne recherche
            jmp ASS_printSrc                ; FCT : Imprime le source assembleur de la ligne en cours d'dition
                                            ; IN  : ASS_NUMLINE : ligne du source  imprimer
                                            ; OUT : A,B,X modified
; End of function ASS_foundLineEdt

; ---------------------------------------------------------------------------
aPromptAss:     dc.b "> ",0

; =============== S U B R O U T I N E =======================================

; FCT : conversion d'une chane de caractres contenant un nombre en un mot
;       N'est pas optimis !
; IN  : ASS_BUF_CURINP_BOT pointe sur la chane  convertir
; OUT : ASS_VARTMP=rsultat de la conversion
;       X,B,A modified

ASS_ASCIItoWORD:
            ldx #cOS_NULL
            stx ASS_VARTMP
            stx ASS_SAV_CURADXY

bclASS_convASCIItoWORD:
            ldaa ASS_SAV_CURADXY
            cmpa ASS_LEN_INP_USR            ; Longueur de la saisie utilisateur
            beq end_ASS_convASCIItoWORD
            bsr multByTen_ASS_VAR_TMP       ; FCT : Multiplie ASS_VAR_TMP par 10
                                            ;       ==> N'est pas optimis !
                                            ; IN  : ASS_VARTMP  jour
                                            ; OUT : ASS_VAR_TMP=ASS_VAR_TMP*10
                                            ; ALG : I=10; REPEAT A=A+A;I=I-1 UNTIL I = 0
                                            ;       Nb de cycles : 9 + 110 = 119 !
                                            ; OPT : A=A*10=A*8 + A*2 = A*2 + A*8
                                            ;       ASL ASS_VARTMP ; A = A * 2          ; 6
                                            ;       LDD ASS_VARTMP ; D = A * 2          ; 5
                                            ;       LSLD           ; D = A * 4          ; 3
                                            ;       LSLD           ; D = A * 8          ; 3
                                            ;       ADDD ASS_VARTMP; A = A*2 + D = A*10 ; 6
                                            ;       STD  ASS_VARTMP                     ; 5
                                            ;       TOTAL CYCLES : 28 cycles !!
            ldab ASS_SAV_CURADXY
            ldx #ASS_BUF_CURINP_BOT         ; Position du curseur d'dition
            abx
            ldab 0,x
            subb #$30                       ; '0'
            bcs error_ASS_convASCIItoWORD
            cmpb #$0A
            bcc error_ASS_convASCIItoWORD
            clra
            addd ASS_VARTMP
            std ASS_VARTMP
            inc ASS_SAV_CURADXY
            bra bclASS_convASCIItoWORD

end_ASS_convASCIItoWORD:
            rts

error_ASS_convASCIItoWORD:
            bsr nextASS_foundLineEdt
            jmp ERROR_7_BAD_NUMBER
; End of function ASS_ASCIItoWORD


; =============== S U B R O U T I N E =======================================

; FCT : Multiplie ASS_VAR_TMP par 10
;   ==> N'est pas optimis !
; IN  : ASS_VARTMP  jour
; OUT : ASS_VAR_TMP=ASS_VAR_TMP*10
; ALG : I=10; REPEAT A=A+A;I=I-1 UNTIL I = 0
;       Nb de cycles : 9 + 110 = 119 !
; OPT : A=A*10=A*8 + A*2 = A*2 + A*8
;       ASL ASS_VARTMP ; A = A * 2          ; 6
;       LDD ASS_VARTMP ; D = A * 2          ; 5
;       LSLD           ; D = A * 4          ; 3
;       LSLD           ; D = A * 8          ; 3
;       ADDD ASS_VARTMP; A = A*2 + D = A*10 ; 6
;       STD  ASS_VARTMP                     ; 5
;       TOTAL CYCLES : 28 cycles

multByTen_ASS_VAR_TMP:
            ldx #$000A
            clra
            clrb

bclMultByTen_ASS_LEN_FILENAME:
            addd ASS_VARTMP
            dex
            bne bclMultByTen_ASS_LEN_FILENAME
            std ASS_VARTMP
            rts
; End of function multByTen_ASS_VAR_TMP


; =============== S U B R O U T I N E =======================================

; FCT : Affiche un message d'invite,
;       attend une saisie utilisateur limite  une longueur A
; IN  : A=longueur maximale de la saisie utilisateur
;       X=Position de la chane   afficher sur la ligne d'tat
; OUT : A=Code de la touche actionne par l'utilisateur
;       X=modified

ASS_getInputUser:
            staa ASS_VARTMP
            pshx
            ldx CURAD_YX
            stx ASS_SAV_CURADXY

bclASS_fetInputUser:
            jsr ASS_initBuffer              ; FCT : INTIALISE le tampon ASS_BUF_CURINP_BOT rceptionnant
                                            ;       les donnes  afficher via le DEVICE en cours (ou pas)
                                            ; IN  : /
                                            ; OUT : A,X modified
            jsr ASS_clrStateLine            ; FCT : efface la ligne d'tat
                                            ; IN  : /
                                            ; OUT : X,A,B modified
printMsgGetInputUser:
            ldx #cASS_POSYX_STATELINE
            stx CURAD_YX
            pulx
            pshx
            jsr OS_OUTTX                    ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                            ; IN : X=pointeur sur une chane de caractres termine par un 0
                                            ; OUT: A,B,X modified
getCharFromFilename:
            jsr OS_getKey
            cmpa #cKB_CTRL_A                ; $15 : CTRL+A : clear line
            beq bclASS_fetInputUser
            cmpa #cKB_BREAK                 ; $03 : touche BREAK
            bne hitkeyReturn

hitKEY_BREAK:
            jsr ASS_initBuffer              ; FCT : INTIALISE le tampon ASS_BUF_CURINP_BOT rceptionnant
			                                ;       les donnes  afficher via le DEVICE en cours (ou pas)
                                            ; IN  : /
                                            ; OUT : A,X modified
            jsr ASS_clrStateLine            ; FCT : efface la ligne d'tat
                                            ; IN  : /
                                            ; OUT : X,A,B modified
            bra exitGetInputUSer

hitkeyReturn:
            cmpa #cOS_CR
            beq exitGetInputUSer
            ldx #tabKEY_ASS

bclEscapeCTRLHITKEY:
            cmpa $00,x
            beq getCharFromFilename
            inx
            cpx #tabJMP_ASS
            bne bclEscapeCTRLHITKEY
            ldx #ASS_BUF_CURINP_BOT         ; Position du curseur d'dition
            ldab ASS_LEN_INP_USR            ; Longueur de la saisie utilisateur
            abx
            staa 0,x
            jsr OS_printCHAR                ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                            ; IN  : A=caractre  imprimer
                                            ;       DEVNU mise  jour
                                            ; OUT : B, X unmodified
            cmpb ASS_VARTMP
            bne getNextChar
            decb
            ldx CURAD_YX
            jsr vectorDecCursor             ; FCT : Appelle la routine de dcrmentation de la position du curseur
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : X=POS(Y,X-1)
                                            ;       A and B not modified
            stx CURAD_YX

getNextChar:
            incb
            stab ASS_LEN_INP_USR            ; Longueur de la saisie utilisateur
            bra getCharFromFilename

exitGetInputUSer:
            pulx
            ldx ASS_SAV_CURADXY
            stx CURAD_YX
            rts
; End of function ASS_getInputUser


; =============== S U B R O U T I N E =======================================

; FCT : CTRL+F : texte  rechercher
; IN  : /
; OUT : /

ASS_foundTextEdt:
            jsr ASS_isInProgress            ; FCT : teste ASS_INPUT_INPROGRESS si <> 0 sort en ERREUR 5
                                            ; IN  : /
                                            ; OUT : A modified
            ldx #(aQUESTION-1)              ; "? "
            ldaa XMAX_SCR                   ; longueur d'un cran
            suba #$04
            bsr ASS_getInputUser            ; FCT : Affiche un message d'invite,
                                            ;       attend une saisie utilisateur limite  une longueur A
                                            ; IN  : A=longueur maximale de la saisie utilisateur
                                            ;       X=Position de la chane  afficher sur la ligne d'tat
                                            ; OUT : A=A=Code de la touche actionne par l'utilisateur
                                            ;       X=modified
            ldaa ASS_LEN_INP_USR            ; Longueur de la saisie utilisateur
            bne nextASS_foundTextEdt
            jsr ASS_printSrc                ; FCT : Imprime le source assembleur de la ligne en cours d'dition
                                            ; IN  : ASS_NUMLINE : ligne du source  imprimer
                                            ; OUT : A,B,X modified
            rts

nextASS_foundTextEdt:
            ldx ASS_PTRTMP
            pshx
            ldx ASS_NUMLINE                 ; sert par exemple  stocker le numro de ligne  chercher
            pshx
            jsr ASS_findBEGINOBJ            ; FCT : Recherche le dbut de la zone compile
                                            ; IN  : /
                                            ; OUT : X=ASS_OBJ_BEGIN=dbut de la zone compile

bcl1ASS_foundTextEdt:
            ldx ASS_NUMLINE                 ; sert par exemple  stocker le numro de ligne  chercher
            inx
            stx ASS_NUMLINE                 ; sert par exemple  stocker le numro de ligne  chercher
            jsr ASS_searchLine              ; FCT : recherche dans le source la ligne demande
                                            ; IN  : ASS_NUMLINE: le numro de ligne recherche
                                            ; OUT : X=pointe sur le dbut de la source de la ligne recherche
                                            ;       ASS_NUMLINE mit  jour par la recherche
                                            ;       ASS_PTRTMP pointe sur le dbut de la source de la ligne recherche
            cpx ASS_OBJ_BEGIN               ; dbut du programme objet
            bcc next5ASS_foundTextEdt
            ldaa 0,x
            suba ASS_LEN_INP_USR            ; Longueur de la saisie utilisateur
            blt bcl1ASS_foundTextEdt
            inca
            staa ASS_VARTMP
            inx
            stx ASS_SAV_CURADXY
            clr ASS_VARTMP+1

bcl2ASS_foundTextEdt:
            pshx
            ldab ASS_LEN_INP_USR            ; Longueur de la saisie utilisateur
            ldx #ASS_BUF_CURINP_BOT         ; Position du curseur d'dition

bcl3ASS_foundTextEdt:
            ldaa 0,x
            pshx
            ldx ASS_SAV_CURADXY
            cmpa $00,x
            bne next4ASS_foundTextEdt
            inx
            stx ASS_SAV_CURADXY
            pulx
            inx
            decb
            bne bcl3ASS_foundTextEdt
            bra next6ASS_foundTextEdt

next4ASS_foundTextEdt:
            pulx
            pulx
            inx
            stx ASS_SAV_CURADXY
            inc ASS_VARTMP+1
            dec ASS_VARTMP
            bne bcl2ASS_foundTextEdt
            bra bcl1ASS_foundTextEdt

next5ASS_foundTextEdt:
            pulx
            stx ASS_NUMLINE                 ; sert par exemple  stocker le numro de ligne  chercher
            pulx
            stx ASS_PTRTMP
            jsr ASS_printSrc                ; FCT : Imprime le source assembleur de la ligne en cours d'dition
                                            ; IN  : ASS_NUMLINE : ligne du source  imprimer
                                            ; OUT : A,B,X modified
            jmp ERROR_6_STR_UNKNOWN

next6ASS_foundTextEdt:
            pulx
            pulx
            pulx
            ldab ASS_VARTMP+1
            stab ASS_CURX
            clr ASS_CURY
            ldx ASS_NUMLINE                 ; sert par exemple  stocker le numro de ligne  chercher
            stx ASS_SAV_NUMLINE
            tst TECRAN                      ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            beq next7ASS_foundTextEdt
            cmpb XMAX_SCR                   ; longueur d'un cran
            bcs next7ASS_foundTextEdt
            pshb
            jsr ASS_toggleModeScreenEdt     ; FCT : TOGGLE SCREEN 80x25<>40x25
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            pulb
            stab ASS_CURX

next7ASS_foundTextEdt:
            jsr ASS_printDeviceScreen       ; FCT : Imprime une ligne de source sur la sortie couranted
                                            ; IN  : ASS_SAV_NUMLINE  jour
                                            ;       ASS_NUMLINE  jour
                                            ;       ASS_PTRTMP  jour
                                            ; OUT : A,B,X modified
            jsr ASS_CopySourceToTarget      ; FCT : copie de la zone pointe par ASS_PTRTMP vers
                                            ;       la zone ASS_BUF_CURINP_BOT
                                            ; IN  : ASS_PTRTMP(source) et ASS_BUF_CURINP_BOT (cible)
                                            ; OUT : A,B,X modified

endASS_foundTextEdt:
            rts
; End of function ASS_foundTextEdt

; ---------------------------------------------------------------------------
aQUESTION:      dc.b "? ",0

; =============== S U B R O U T I N E =======================================

; FCT : SAUVEGARDER LE FICHIER SOURCE : CTRL-3
; IN  : /
; OUT : /

ASS_saveSourceEdt:
            jsr ASS_isInProgress                ; FCT : teste ASS_INPUT_INPROGRESS si <> 0 sort en ERREUR 5
                                                ; IN  : /
                                                ; OUT : A modified

ASS_GetFilenameToSave:                          ; "FICHIER A SAUVER : "
            ldx  #aFichierASauver-1
            ldaa #cASS_LG_MAX_FILENAME
            jsr ASS_getInputUser                ; FCT : Affiche un message d'invite,
                                                ;       attend une saisie utilisateur limite  une longueur A
                                                ; IN  : A=longueur maximale de la saisie utilisateur
                                                ;       X=Position de la chane  afficher sur la ligne d'tat
                                                ; OUT : A=Code de la touche actionne par l'utilisateur
                                                ;       X=modified
            cmpa #cOS_CR
            bne endASS_saveSourceEdt

searchEndOfSource:
            jsr ASS_findBEGINOBJ                ; FCT : Recherche le dbut de la zone compile
                                                ; IN  : /
                                                ; OUT : X=ASS_OBJ_BEGIN=dbut de la zone compile

initInfoHeader:
            ldx #cASS_K7_SAV_SRC
            stx ASS_SAVE_HEADER_K7_LM_BINAIRE   ; Peut prendre la valeur $0200, $0500
                                                ; si $0200 alors ($02=langage machine) et ($00=binaire)
                                                ; si $0500 alors ($05=fichier texte de l'diteur) et ($00=binaire)
            ldaa #cASS_K7_MODE_CONTIGU
            staa ASS_SAVE_HEADER_K7_CONTIGU     ; peut prendre la valeur 1 : contigu (code assembleur)
            ldx ASS_MEMMAX
            stx ASS_SAVE_HEADER_K7_EXEC         ; Adresse d'excution
            ldx #$0000
            stx ASS_SAVE_HEADER_K7_LOAD         ; Adresse de chargement

saveBLKTypeLM:
            ldaa #cK7_TYP_PRG_ASS
            staa fFICTYP_K7                     ; Type du fichier k7 : $00:BASIC,$01 ou $04 selon la rom ?:ARRAY,$02:LANGAGE MACHINE,$05:FICHIER TEXTE DE L'EDITEUR
            ldx #ASS_BUF_CURINP_BOT             ; Position du curseur d'dition
            stx pTMP_K7                         ; pointeur servant  tout ... FILENAME,CLOAD,CSAVE...
            jsr doWriteBLOCKFILENAME

sendBLKDATA:
            ldaa #cK7_TYP_BLK_DATA
            staa BLKTY_K7                       ; type de bloc : $00 nom du fichier,$01 bloc de donnes,$FF bloc de fin
            ldx ASS_MEMMAX
            stx pMEMBEGIN_K7
            ldx ASS_OBJ_BEGIN                   ; dbut du programme objet
            inx
            stx pMEMEND_K7
            jsr next1RomCSAVE

endASS_saveSourceEdt:
            jsr ASS_printSrc                    ; FCT : Imprime le source assembleur de la ligne en cours d'dition
                                                ; IN  : ASS_NUMLINE : ligne du source  imprimer
                                                ; OUT : A,B,X modified
            rts
; End of function ASS_saveSourceEdt

; ---------------------------------------------------------------------------
aFichierASauver:    dc.b "FICHIER A SAUVER : ",0

; =============== S U B R O U T I N E =======================================

; FCT : Effectue la partie load : merge/load/verify
;        $92 : CTRL+M : MERGING PROGRAMME
;        $97 : CTRL+4 : CHARGE UN FICHIER
;        $B5 : CTRL+V : VERIFICATION D'UNE SAUVEGARDE
; IN  : A=touche presse
; OUT : A,B,X modified

ASS_doLoadMergeVerifyEdt:
            jsr ASS_isInProgress                 ; FCT : teste ASS_INPUT_INPROGRESS si <> 0 sort en ERREUR 5
                                                 ; IN  : /
                                                 ; OUT : A modified
            ldx  #(aFichierALire-1)              ; "FICHIER A LIRE : "
            ldaa #cASS_LG_MAX_FILENAME
            jsr ASS_getInputUser                 ; FCT : Affiche un message d'invite,
                                                 ;       attend une saisie utilisateur limite  une longueur A
                                                 ; IN  : A=longueur maximale de la saisie utilisateur
                                                 ;       X=Position de la chane  afficher sur la ligne d'tat
                                                 ; OUT : A=Code de la touche actionne par l'utilisateur
                                                 ;       X=modified
            cmpa #cOS_CR
            beq nextMERGE_ASS
            jsr ASS_printSrc                     ; FCT : Imprime le source assembleur de la ligne en cours d'dition
                                                 ; IN  : ASS_NUMLINE : ligne du source  imprimer
                                                 ; OUT : A,B,X modified
            rts

nextMERGE_ASS:
            ldab #cASS_LG_MAX_FILENAME+1

bcl1MERGE_ASS:
            ldx #(ASS_LEN_INP_USR-1)             ; recopie le nom de fichier
            abx
            ldaa 0,x
            ldx #(sTMPBUFK7-1)
            abx
            staa 0,x
            decb
            bne bcl1MERGE_ASS

bcl2MERGE_ASS:
            ldx #$FFFF
            stx.w   CURLIN                      ; Le stockage se fait via l'adressage long et non pas court !!! OJE 12/02/2020
            jsr K7_searchBlockFilenameFromK7    ; FCT : Cherche le bloc de type FILENAME
                                                ;       2 points d'entresutiliss :
                                                ;        le 1er crit S puis F quand trouv
                                                ;        le 2eme ecrit F quand trouv
                                                ; NAME: CMPNA
                                                ; ST  : ACTIF
                                                ; IN  : la zone zTMPFICNM_K7 (ou sTMPBUFK7 ?) doit tre initialise   avec le nom du fichier
                                                ; OUT : A=$00 si trouv
            beq next3MERGE_ASS
            ldaa bNB_READ_K7                    ; compteur du nombre de donnes  lire : est dcrement de 1  chaque lecture d'octet de la K7
            beq bcl2MERGE_ASS
            jmp ASS_PRINTERROR                  ; FCT : Affiche le numro de ligne sur la ligne d'tat
                                                ; IN  : A=numro de  l'erreur
                                                ; OUT : Retourne  la boucle d'interprtation de l'assembleur

next3MERGE_ASS:
            ldaa fFICTYP_K7                     ; Type du fichier k7 : $00:BASIC,$01 ou $04 selon la rom ?:ARRAY,$02:LANGAGE MACHINE,$05:FICHIER TEXTE DE L'EDITEUR
            cmpa #cK7_TYP_PRG_ASS_SRC
            beq next4MERGE_ASS
            jmp ERROR_0_BADTYPEFILE

next4MERGE_ASS:
            clr fSAVEDATA_K7                    ; =$00:sauve les donnes K7 en mmoire sinon ne les sauve pas
            ldx ASS_MEMMAX
            ldaa ASS_CHAR
isCTRLV_VERIFY:
            cmpa #cKB_CTRL_V                    ; $B5
            beq next5MERGE_VERIFY_ASS
isCTRL4_LOAD:
            cmpa #cKB_CTRL_4                    ; $97
            beq bcl6MERGE_LOAD_ASS
isCTRLM_MERGE:
            jsr ASS_findBEGINOBJ                ; FCT : Recherche le dbut de la zone compile
                                                ; IN  : /
                                                ; OUT : X=ASS_OBJ_BEGIN=dbut de la zone compile
            bra bcl6MERGE_LOAD_ASS

next5MERGE_VERIFY_ASS:
            inc fSAVEDATA_K7                    ; =$00:sauve les donnes K7 en mmoire sinon ne les sauve pas

bcl6MERGE_LOAD_ASS:
            ldaa #$FF
            ldab fSAVEDATA_K7                   ; =$00:sauve les donnes K7 en mmoire sinon ne les sauve pas
            stx pTMP_K7                         ; pointeur servant  tout ... FILENAME,CLOAD,CSAVE...
            jsr K7LEC                           ; FCT : lit un programme sur K7
                                                ; ALG : 1 - synchronisation avec le caractre $3C
                                                ;       2 - Lit le type de bloc
                                                ;       3 - Lit la longueur du bloc
                                                ;       4 - itre sur la longueur de bloc pour rcuprer les donnes si ncessaire
                                                ;       5 - Lit un octet de vrification = somme des donnes + type  de bloc + longueur du bloc
                                                ; ST  : ACTIF
                                                ; IN  : A:longueur du bloc  lire
                                                ;       B=0 crit les donnes lues en mmoire <>0 ne les crit pas
                                                ;       X=pointeur sur la zone de stockage des donnes (si la demande est faite par B)
                                                ; OUT : A=$03:Erreur code bloc inattendu
                                                ;       A=$02:Erreur problme mmoire
                                                ;       A=$01:Erreur suite  la comparaison avec l'octet de vrification
                                                ;       A=$00:pas d'erreur
                                                ;       X=pointeur sur le dernier octet stock (si demande via B)
            bne ASS_MERGE_treatError            ; FCT : Effectue un traitement spcifique en cas d'erreur suivant la fonction traite : merge,verify,etc.
                                                ; IN  : A = numro de l'erreur
                                                ; OUT : A,B,X modified
            ldaa BLKTY_K7                       ; type de bloc : $00 nom du fichier,$01 bloc de donnes,$FF bloc de fin
            cmpa #cK7_TYP_BLK_END
            bne bcl6MERGE_LOAD_ASS
; End of function ASS_doLoadMergeVerifyEdt


; =============== S U B R O U T I N E =======================================

; FCT : Finalisation de la compilation
; IN  : /
; OUT : A,B,X modified

ASS_finalizeCompile:
            ldx #$0000
            stx ASS_NUMLINE                     ; sert par exemple  stocker le numro de ligne  chercher
            jsr ASS_printSrc                    ; FCT : Imprime le source assembleur de la ligne en cours d'dition
                                                ; IN  : ASS_NUMLINE : ligne du source  imprimer
                                                ; OUT : A,B,X modified
            jmp next7ASS_manageCursorUpDowntEdt
; End of function ASS_finalizeCompile


; =============== S U B R O U T I N E =======================================

; FCT : Effectue un traitement spcifique en cas d'erreur suivant la fonction traite : merge,verify,etc.
; IN  : A = numro de l'erreur
; OUT : A,B,X modified

ASS_MERGE_treatError:
            psha
            ldaa ASS_CHAR
isCTRLV_VERIFY_0:
            cmpa #cKB_CTRL_V                    ; CTRL+V
            beq nextPrintERR_ASS
isCTRLM_MERGE_0:
            cmpa #cKB_CTRL_M                    ; CTRL+M
            bne ASS_printERR
doCTRLM:                                        ; dbut du programme objet
            ldx ASS_OBJ_BEGIN
            ldaa #$FF
            staa 0,x
            bra nextPrintERR_ASS

ASS_printERR:
            jsr ASS_INIT_SCR_VAR                ; FCT : Initialise l'cran et diverses variables pour la partie assembleur
                                                ; IN  : /
                                                ; OUT : A,B,X modified

nextPrintERR_ASS:
            jsr ASS_finalizeCompile             ; FCT : Finalisation de la compilation
                                                ; IN  : /
                                                ; OUT : A,B,X modified
            pula

jmpASS_PRINTERROR:
            jmp ASS_PRINTERROR                  ; FCT : Affiche le numro de ligne sur la ligne d'tat
                                                ; IN  : A=numro de  l'erreur
                                                ; OUT : Retourne  la boucle d'interprtation de l'assembleur
; End of function ASS_MERGE_treatError

; ---------------------------------------------------------------------------
aFichierALire:      dc.b "FICHIER A LIRE : ",0

; =============== S U B R O U T I N E =======================================

; FCT : Point d'entre pour lancer l'assembleur
; IN  : /
; OUT : /

dovectorPERCENT:
            sts ASS_SAVEREGS_PERCENT
            jsr ASS_finalizeCompile             ; FCT : Finalisation de la compilation
                                                ; IN  : /
                                                ; OUT : A,B,X modified
            jmp ASS_INTERPRET
; End of function dovectorPERCENT


; =============== S U B R O U T I N E =======================================

; FCT : 0X8E=CTRL+1 : lancement de la compilation
; IN  : /
; OUT : /

ASS_goCompilerEdt:
            jsr ASS_isInProgress            ; FCT : teste ASS_INPUT_INPROGRESS si <> 0 sort en ERREUR 5
                                            ; IN  : /
                                            ; OUT : A modified
            bsr ASS_clsAndInitVar           ; FCT : Efface l'cran puis initialise diverses zones mmoires
                                            ;       pour la compilation
                                            ; IN  : /
                                            ; OUT : A,B,X modified

printQuestionAndBan:
            jsr ASS_0X8E_QUESTION_LISTING   ; FCT : Invite pour saisir les choix suivants :
                                            ;        E : rsultat de la compilation sur l'cran
                                            ;        I : rsultat de la compilation sur l'imprimante
                                            ;        ENTER : compilation sans echo
                                            ;       Affiche la banniere de compilation (ASSEMBLEUR ALICE ...)
                                            ; IN  : /
                                            ; OUT : A,B, modified

doPass1:
            bsr ASS_initVarBeforeCompile    ; FCT : Initialise diverses variables lies   la compilation
                                            ; IN  : /
                                            ; OUT : X modified
            jsr ASS_compile                 ; FCT : Effectue la compilation d'un source assembleur
                                            ; IN  : ASS_COMP_CURLINE  jour
                                            ; OUT : A,B,X modified
            inc ASS_COMP_EN_COURS           ; COMPILATION EN COURS - numro de passe - 1

doPass2:
            bsr ASS_initVarBeforeCompile    ; FCT : Initialise diverses variables lies   la compilation
                                            ; IN  : /
                                            ; OUT : X modified
            jsr ASS_compile                 ; FCT : Effectue la compilation d'un source assembleur
                                            ; IN  : ASS_COMP_CURLINE  jour
                                            ; OUT : A,B,X modified

resumeCompilation:
            jsr ASS_showResultatCompilation ; FCT : Imprime le rsultat de la compilation
                                            ;       c'est  dire : le nombre d'erreur pour les deux passes de compilation
                                            ;       puis la liste des symboles
                                            ; IN  : /
                                            ; OUT : A,B,X modified

printQuestionSaveOrExec:
            jsr ASS_saveOrExecPrg           ; FCT : Demande  l'utilisateur s'il faut sauvegarder
                                            ;       ou excuter le rsultat de la compilation
                                            ; IN  : /
                                            ; OUT : A,X,Y modified
            jmp ASS_finalizeCompile         ; FCT : Finalisation de la compilation
                                            ; IN  : /
                                            ; OUT : A,B,X modified
; End of function ASS_goCompilerEdt

; =============== S U B R O U T I N E =======================================

; FCT : Efface l'cran puis initialise diverses zones mmoires
;       pour la compilation
; IN  : /
; OUT : A,B,X modified

ASS_clsAndInitVar:
            jsr GRNCH                       ; FCT : GRNCH : efface l'cran selon le mode donn par TECRAN
                                            ; IN  : /
                                            ; OUT : /
            jsr ASS_findBEGINOBJ            ; FCT : Recherche le dbut de la zone compile
                                            ; IN  : /
                                            ; OUT : X=ASS_OBJ_BEGIN=dbut de la zone compile

initAREA:
            ldx #ASS_COMP_LOAD

bclInitAREA:
            clr 0,x
            inx
            cpx #ASS_FLGPAG
            bne bclInitAREA
            ldx ADRENDMEM                   ; Adresse de la fin de mmoire
            stx ASS_BOT_SYMB
            stx ASS_PTR_TMP_SYMB            ; Pointeur sur la liste des symboles compils (tiquettes, etc.)
            rts
; End of function ASS_clsAndInitVar


; =============== S U B R O U T I N E =======================================

; FCT : Initialise diverses variables lies  la compilation
; IN  : /
; OUT : X modified

ASS_initVarBeforeCompile:
            ldx ASS_OBJ_BEGIN               ; dbut du programme objet
            inx
            stx ASS_OBJ_END                 ; Fin du programme objet
            ldx ASS_MEMMAX
            stx ASS_COMP_CURLINE
            ldx #$0000
            stx ASS_CURNUMLINE              ; numro de ligne courante traite durant la compilation
            stx ASS_ORG                     ; flag directive ORG dfinie : =0 non sinon  oui
            rts
; End of function ASS_initVarBeforeCompile


; =============== S U B R O U T I N E =======================================

; FCT : Invite pour saisir les choix suivants :
;       E : rsultat de la compilation sur l'cran
;       I : rsultat de la compilation sur l'imprimante
;       ENTER : compilation sans echo
;       Affiche la banniere de compilation (ASSEMBLEUR ALICE ...)
; IN  : /
; OUT : A,B, modified

ASS_0X8E_QUESTION_LISTING:
            ldaa #$03
            ldx #aListScrImpEnt-1           ; "LISTING (ECRAN,IMP,ENTER) ? "
            jsr ASS_getInputUser            ; FCT : Affiche un message d'invite,
                                            ;       attend une saisie utilisateur limite  une longueur A
                                            ; IN  : A=longueur maximale de la saisie utilisateur
                                            ;       X=Position de la chane  afficher sur la ligne d'tat
                                            ; OUT : A=Code de la touche actionne par l'utilisateur
                                            ;       X=modified
            ldaa ASS_LEN_INP_USR            ; Longueur de la saisie utilisateur
            beq printBanASSALICE
            ldaa ASS_BUF_CURINP_BOT         ; Position du curseur d'dition

isListToScreen:
            cmpa #cASS_KB_E                 ; 'E'
            beq doListToScreen

isListToImp:
            cmpa #cASS_KB_I                 ; 'I'
            bne ASS_0X8E_QUESTION_LISTING   ; FCT : Invite pour saisir les choix suivants :
                                            ;       E : rsultat de la compilation sur l'cran
                                            ;       I : rsultat de la compilation sur l'imprimante
                                            ;       ENTER : compilation sans echo
                                            ;       Affiche la banniere de compilation (ASSEMBLEUR ALICE ...)
                                            ; IN  : /
                                            ; OUT : A,B, modified
            inc ASS_DEVNU                   ; Indique la port de sortie du listing (0 : ECRAN; 1 : IMPRIMANTE)

doListToScreen:
            inc ASS_FLGSHOWPARSE            ; Flag indiquant qu'il y a eu un demande de compilation
            inc ASS_FLGLI                   ; Flag indiquant que les lignes compiles + source sont  montrer lors de la compilation
            jsr GRNCH                       ; FCT : GRNCH : efface l'cran selon le mode donn par TECRAN
                                            ; IN  : /
                                            ; OUT : /
            ldaa ASS_DEVNU                  ; Indique la port de sortie du listing (0 : ECRAN; 1 : IMPRIMANTE)
            staa DEVNU                      ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante

printBanASSALICE:
            ldx #(aASSALICE-1)              ; "ASSEMBLEUR ALICE REV 1.00*\r"
            jsr OS_OUTTX                    ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                            ; IN : X=pointeur sur une chane de caractres termine par un 0
                                            ; OUT: A,B,X modified
            clr DEVNU                       ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            rts
; End of function ASS_0X8E_QUESTION_LISTING

; ---------------------------------------------------------------------------
aListScrImpEnt:     dc.b "LISTING (ECRAN,IMP,ENTER) ? ",0
aASSALICE:          dc.b "ASSEMBLEUR ALICE REV 1.00*",$D
aCopyRightMatra:    dc.b "COPYRIGHT MATRA,1984      ",$D," ",$D,0

; =============== S U B R O U T I N E =======================================

; FCT : ignore les espaces, le nombre maximal est donn par ASS_LGSRC
;       Sort en erreur si nous avons atteint ce nombre sans rencontrer autre chose que le caractre espace
;       Le retour est un peu particulier car s'il n'y a
;       pas d'erreur nous manipulons la pile pour que le
;       retour se fasse 3 octets plus loin de l'appelant.
;       ==> cela permet de faire un jmp XXXX en cas d'erreur
;       sinon on enchaine le code suivant
; IN  : ASS_LGSRC et ASS_PTRCUROP  jour
; OUT : A,B,X modified

ASS_escapeSPACE:
            ldaa ASS_LGSRC                  ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            bne nextASS_escapeSPACE
            rts
nextASS_escapeSPACE:
            ldx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            ldaa 0,x
            cmpa #cOS_SPACE                 ; ' '
            beq next1ASS_escapeSPACE
modifyStackptr:
            tsx
            ldd 0,x
            addd #$03
            std 0,x
            rts
next1ASS_escapeSPACE:
            dec ASS_LGSRC                   ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            inx
            stx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            bra ASS_escapeSPACE             ; FCT : ignore les espaces, le nombre maximal est donn par ASS_LGSRC
                                            ;       Sort en erreur si nous avons atteint ce nombre sans rencontrer autre chose que le caractre espace
                                            ;       Le retour est un peu particulier car s'il n'y a
                                            ;       pas d'erreur nous manipulons la pile pour que le
                                            ;       retour se fasse 3 octets plus loin de l'appelant.
                                            ;       ==> cela permet de faire un jmp XXXX en cas d'erreur
                                            ;       sinon on enchaine le code suivant
                                            ; IN  : ASS_LGSRC et ASS_PTRCUROP  jour
                                            ; OUT : A,B,X modified
; End of function ASS_escapeSPACE

; =============== S U B R O U T I N E =======================================

; FCT : Recherche si l'opcode en cours de traitement est dans le tableau des opcodes pass en paramtre
; IN  : X=pointeur sur un tableau contenant des opcodes  rechercher
; OUT : X=pointeur +1 sur le tableau contenant des opcodes
;       B=longueur de tous les opcodes contenus dans le tableau des opcodes

ASS_searchOPCODE:
            ldab 0,x                        ; obtient la longueur de tous les opcodes contenus dans le tableau
            inx

bclASS_searchOpcode:
            pshb
            pshx
            ldaa 0,x

isEndOfArray:
            cmpa #$FF
            bne bcl2ASS_searchOpcode
            pulx
            pulb
            rts

bcl2ASS_searchOpcode:
            decb
            abx
            ldaa 0,x
            ldx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            abx
            cmpa $00,x
            bne next3ASS_searchOpcode_nextOpcode
            pulx
            pshx
            tstb
            beq next4SS_searchOpcode_found
            bra bcl2ASS_searchOpcode

next3ASS_searchOpcode_nextOpcode:
            pulx
            pulb
            abx
            inx
            bra bclASS_searchOpcode

next4SS_searchOpcode_found:
            pulx
            pulb
            abx
            ldaa 0,x
            staa ASS_CURDIRECTIVE           ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante
            ldx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            abx
            stx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            ldaa ASS_LGSRC                  ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            sba
            staa ASS_LGSRC                  ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            tsx
            ldd 0,x
            addd #$03
            std 0,x
            rts
; End of function ASS_searchOPCODE

; ---------------------------------------------------------------------------
tabOpcode1_INH_STACK:
            dc.b     4                      ; Liste des opcodes de type INHERENT et manipulation de la pile
aLSRD:      dc.b "LSRD"
            dc.b     4
aASLD:      dc.b "ASLD"
            dc.b     5
aLSLD:      dc.b "LSLD"
            dc.b     5
aPULA:      dc.b "PULA"
            dc.b $32
aPULB:      dc.b "PULB"
            dc.b $33
aPSHA:      dc.b "PSHA"
            dc.b $36
aPSHB:      dc.b "PSHB"
            dc.b $37
aPULX:      dc.b "PULX"
            dc.b $38
aPSHX:      dc.b "PSHX"
            dc.b $3C
            dc.b $FF
;----------------
tabOpcode2_INH_COND_X:
            dc.b   3            ; Liste des opcodes de type INHERENT manipulant
                                ; le registre de condition ainsi que INC/DEC REG X
aNOP:       dc.b "NOP"
            dc.b     1
aTAP:       dc.b "TAP"
            dc.b     6
aTPA:       dc.b "TPA"
            dc.b 7
aINX:       dc.b "INX"
            dc.b 8
aDEX:       dc.b "DEX"
            dc.b 9
aCLV:       dc.b "CLV"
            dc.b $A
aSEV:       dc.b "SEV"
            dc.b $B
aCLC:       dc.b "CLC"
            dc.b $C
aSEC:       dc.b "SEC"
            dc.b $D
aCLI:       dc.b "CLI"
            dc.b $E
aSEI:       dc.b "SEI"
            dc.b $F
aSBA:       dc.b "SBA"
            dc.b $10
aCBA:       dc.b "CBA"
            dc.b $11
aTab:       dc.b "TAB"
            dc.b $16
aTba:       dc.b "TBA"
            dc.b $17
aDaa:       dc.b "DAA"
            dc.b $19
aAba:       dc.b "ABA"
            dc.b $1B
aTsx:       dc.b "TSX"
            dc.b $30
aIns:       dc.b "INS"
            dc.b $31
aDes:       dc.b "DES"
            dc.b $34
aTxs:       dc.b "TXS"
            dc.b $35
aRts:       dc.b "RTS"
            dc.b $39
aAbx:       dc.b "ABX"
            dc.b $3A
aRti:       dc.b "RTI"
            dc.b $3B
aMul:       dc.b "MUL"
            dc.b $3D
aWai:       dc.b "WAI"
            dc.b $3E
aSwi:       dc.b "SWI"
            dc.b $3F
            dc.b $FF
;----------------
tabOpcode3_SUB_ADD_REGD:
            dc.b   4             ; Liste des opcodes de type SUB/ADD pour le registre D
aSubd:      dc.b "SUBD"
            dc.b $83
aAddd:      dc.b "ADDD"
            dc.b $C3
            dc.b $FF
;----------------
tabOpcode4_ARITH:
            dc.b   3             ; Liste des opcodes de type arithmetique
aSUB:       dc.b "SUB"
            dc.b $80
aCMP:       dc.b "CMP"
            dc.b $81
aSBC:       dc.b "SBC"
            dc.b $82
aAND_0:     dc.b "AND"
            dc.b $84
aBIT:       dc.b "BIT"
            dc.b $85
aLDA:       dc.b "LDA"
            dc.b $86
aSTA:       dc.b "STA"
            dc.b $87
aEOR:       dc.b "EOR"
            dc.b $88
aADC:       dc.b "ADC"
            dc.b $89
aORA:       dc.b "ORA"
            dc.b $8A
aADD:       dc.b "ADD"
            dc.b $8B
            dc.b $FF
;----------------
tabOpcode5_INHERENT_OTHER:
            dc.b   3             ; Liste des opcodes de type INHERENT et etendu de longueur 3
aNEG:       dc.b "NEG"
            dc.b $40
aCOM:       dc.b "COM"
            dc.b $43
aLSR:       dc.b "LSR"
            dc.b $44
aROR:       dc.b "ROR"
            dc.b $46
aASR:       dc.b "ASR"
            dc.b $47
aASL:       dc.b "ASL"
            dc.b $48
aLSL:       dc.b "LSL"
            dc.b $48
aROL:       dc.b "ROL"
            dc.b $49
aDEC:       dc.b "DEC"
            dc.b $4A
aINC:       dc.b "INC"
            dc.b $4C
aTST:       dc.b "TST"
            dc.b $4D
aCLR:       dc.b "CLR"
            dc.b $4F
            dc.b $FF
;----------------
tabOpcode6_IMM_LG3:
            dc.b   3           ; Liste des opcodes de type immediat de longeur 3 (opcode + mot)
aJMP:       dc.b "JMP"
            dc.b $4E
aCPX:       dc.b "CPX"
            dc.b $8C
aJSR:       dc.b "JSR"
            dc.b $8D
aLDS:       dc.b "LDS"
            dc.b $8E
aSTS:       dc.b "STS"
            dc.b $8F
aLDD:       dc.b "LDD"
            dc.b $CC
aSTD:       dc.b "STD"
            dc.b $CD
aLDX:       dc.b "LDX"
            dc.b $CE
aSTX:       dc.b "STX"
            dc.b $CF
            dc.b $FF
;----------------
tabOpcode_BRANCH:
            dc.b   3           ; Liste des opcodes de branchement relatif
aBra:       dc.b "BRA"
            dc.b $20
aBrn:       dc.b "BRN"
            dc.b $21
aBhi:       dc.b "BHI"
            dc.b $22
aBls:       dc.b "BLS"
            dc.b $23
aBhs:       dc.b "BHS"
            dc.b $24
aBcc:       dc.b "BCC"
            dc.b $24
aBlo:       dc.b "BLO"
            dc.b $25
aBcs:       dc.b "BCS"
            dc.b $25
aBne:       dc.b "BNE"
            dc.b $26
aBeq:       dc.b "BEQ"
            dc.b $27
aBvc:       dc.b "BVC"
            dc.b $28
aBvs:       dc.b "BVS"
            dc.b $29
aBpl:       dc.b "BPL"
            dc.b $2A
aBmi:       dc.b "BMI"
            dc.b $2B
aBge:       dc.b "BGE"
            dc.b $2C
aBlt:       dc.b "BLT"
            dc.b $2D
aBgt:       dc.b "BGT"
            dc.b $2E
aBle:       dc.b "BLE"
            dc.b $2F
aBsr:       dc.b "BSR"
            dc.b $8D
            dc.b $FF
;----------------
tabDirectiveASS:
            dc.b  3            ; Liste des directives assembleurs
aORG:       dc.b "ORG"
            dc.b 0
aEXC:       dc.b "EXC"
            dc.b 2
aBLC:       dc.b "BLC"
            dc.b 4
aLIplus:    dc.b "LI+"
            dc.b 6
aLIinus:    dc.b "LI-"
            dc.b 8
aPAG:       dc.b "PAG"
            dc.b $A
aDFO:       dc.b "DFO"
            dc.b $C
aDFD:       dc.b "DFD"
            dc.b $E
            dc.b $FF

; =============== S U B R O U T I N E =======================================

; FCT : Ajoute le symbole point par ASS_PTRCUROP dans la zone des symboles
; ERR : A : NO MEMORY
;       B : SYMBOL ALREADY EXIST
; IN  : ASS_PTRCUROP : pointeur sur le texte du symbole
; OUT : A,B,X modified

ASS_addSYMBOL:
            ldd ASS_BOT_SYMB
            subd #cASS_LG_AREA_SYMB
            std ASS_VARTMP
            ldx ASS_OBJ_BEGIN           ; dbut du programme objet
            cpx ASS_VARTMP
            bcs initSearchSymbol

setNUMERRto0X41_A_NO_MEM:
            ldaa #cASS_ERR_NOMEM        ; 'A'
            staa ASS_NUMERR             ; numro de l'erreur
            rts

initSearchSymbol:
            ldx ASS_BOT_SYMB

isEnd:
            stx ASS_PTR_TMP_SYMB        ; Pointeur sur la liste des symboles compils (tiquettes, etc.)
            cpx ADRENDMEM               ; Adresse de la fin de mmoire
            beq copySymbol
            ldaa ASS_LGSRC              ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            inca
            staa ASS_SAV_CURADXY
            clrb

bclSearchSymbol:
            ldx ASS_PTR_TMP_SYMB        ; Pointeur sur la liste des symboles compils (tiquettes, etc.)
            abx
            ldaa 0,x
            ldx ASS_PTRCUROP            ; Pointeur sur l'opcode en cours de dcodage
            abx
            dec ASS_SAV_CURADXY
            beq foundSearchSymbol
            cmpa #cOS_SPACE             ; ' '
            bne cmpSearchSymbol
            ldaa 0,x

foundSearchSymbol:
            cmpa #cOS_SPACE             ; ' '
            bne getNextSymbol
            bra setNUMERRto0X42_SymbolAlreadyExistAndTODO

cmpSearchSymbol:
            cmpa $00,x
            bne getNextSymbol
            incb
            cmpb #cASS_LG_NAME_SYMB
            bne bclSearchSymbol

setNUMERRto0X42_SymbolAlreadyExistAndTODO:
            ldaa #cASS_ERR_SYMB_EXIST   ; 'B'
            staa ASS_NUMERR             ; numro de l'erreur
            bra copySymbol

getNextSymbol:
            ldx ASS_PTR_TMP_SYMB        ; Pointeur sur la liste des symboles compils (tiquettes, etc.)
            ldab #cASS_LG_AREA_SYMB
            abx
            bra isEnd

copySymbol:
            ldx ASS_VARTMP
            stx ASS_BOT_SYMB
            ldaa #cOS_SPACE             ; ' '
            ldab #cASS_LG_NAME_SYMB

clrNextSymbol:
            staa 0,x
            inx
            decb
            bne clrNextSymbol

bclCopySymbol:
            ldx ASS_PTRCUROP            ; Pointeur sur l'opcode en cours de dcodage
            abx
            ldaa 0,x
            cmpa #cOS_SPACE             ; ' '
            beq endASS_addSYMBOL
            tst ASS_LGSRC               ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            beq endASS_addSYMBOL
            ldx ASS_BOT_SYMB
            abx
            staa 0,x
            dec ASS_LGSRC               ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            incb
            cmpb #cASS_LG_NAME_SYMB
            bne bclCopySymbol

endASS_addSYMBOL:
            ldx ASS_PTRCUROP            ; Pointeur sur l'opcode en cours de dcodage
            abx
            stx ASS_PTRCUROP            ; Pointeur sur l'opcode en cours de dcodage
            ldx ASS_BOT_SYMB
            ldd ASS_CURADRCMP           ; Adresse du rsultat de la compilation
            std 5,x
            jsr ASS_escapeSPACE         ; FCT : ignore les espaces, le nombre maximal est donn par ASS_LGSRC
                                        ;       Sort en erreur si nous avons atteint ce nombre sans rencontrer autre chose que le caractre espace
                                        ;       Le retour est un peu particulier car s'il n'y a
                                        ;       pas d'erreur nous manipulons la pile pour que le
                                        ;       retour se fasse 3 octets plus loin de l'appelant.
                                        ;       ==> cela permet de faire un jmp XXXX en cas d'erreur
                                        ;       sinon on enchaine le code suivant
                                        ; IN  : ASS_LGSRC et ASS_PTRCUROP  jour
                                        ; OUT : A,B,X modified
            bra POP_DWORD
; End of function ASS_addSYMBOL

; ---------------------------------------------------------------------------
            dc.b     1

; =============== S U B R O U T I N E =======================================

; FCT : Effectue une affectation 
; IN  : /
; OUT : A,B,X modified

isLetValueOnSymbol:
            ldx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            ldaa 0,x
            cmpa #cBAS_EQUAL                ; '='
            bne POP_DWORD
            jsr ASS_incPTRCUROP             ; FCT : Incrmente de 1 la valeur de ASS_PTRCUROP
                                            ;       Puis dcremente le nombre d'lment constituant l'opcode en cours
                                            ;       Si = 0 alors ERREUR
                                            ; IN  : X=La position de la ligne assembleur en cours de compilation
                                            ; OUT : X=X+1 et ASS_PTRCUROP = X+1
            nop                             ; TODO
            jsr ASS_ParseParam              ; FCT : rcupre un paramtre de type hexa ou un symbole dans le flot
                                            ;       d'interprtation assembleur.
                                            ;       Ignore les espaces en dbut de flot d'interprtation
                                            ; ERR : $44 : D : expression incomplte
                                            ; IN  : ASS_PTRCUROP : le pointeur sur le flot d'interprtation assembleur
                                            ; OUT : /
            rts
; End of function isLetValueOnSymbol


; =============== S U B R O U T I N E =======================================


ASS_dummy2:
            brn .+2
; End of function ASS_dummy2


; =============== S U B R O U T I N E =======================================


storeAdrOnSymbol:
            ldx ASS_BOT_SYMB
            ldd ASS_TMP_CONV                ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            std 5,x

POP_DWORD:
            tsx
            ldd 0,x
            addd #$03
            std 0,x
            rts
; End of function storeAdrOnSymbol


; =============== S U B R O U T I N E =======================================

; FCT : Interprte l'expression de type octet dans le flot d'interprtation assembleur
; IN  : le flot d'interprtation assembleur
; OUT : A,B,X modified

ASS_ParseParam_byte:
            bsr ASS_ParseParam              ; FCT : rcupre un paramtre de type hexa ou un symbole dans le flot
                                            ;       d'interprtation assembleur.
                                            ;       Ignore les espaces en dbut de flot d'interprtation
                                            ; ERR : $44 : D : expression incomplte
                                            ; IN  : ASS_PTRCUROP : le pointeur sur le flot d'interprtation assembleur
                                            ; OUT : /
            rts
; End of function ASS_ParseParam_byte


; =============== S U B R O U T I N E =======================================


ASS_dummy7:
            brn .+2
; End of function ASS_dummy7


; =============== S U B R O U T I N E =======================================

; FCT : Interprte l'expression de type octet dans le flot d'interprtation assembleur
; IN  : le flot d'interprtation assembleur
; OUT : A,B,X modified

nextASS_ParseParam_BYTE:
            ldx ASS_TMP_CONV                ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            cpx #$0100
            bcc setNUMERRto0X43_Overflowvalue
            ldaa ASS_TMP_CONV+1             ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            staa ASS_TMP_CONV               ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            clr ASS_TMP_CONV+1              ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure

POPS:
            tsx
            ldd 0,x
            addd #$03
            std 0,x
            rts

setNUMERRto0X43_Overflowvalue:
            ldaa #cASS_ERR_VAL_OVERFLOW ; 'C'
            staa ASS_NUMERR             ; numro de l'erreur
            rts
; End of function nextASS_ParseParam_BYTE


; =============== S U B R O U T I N E =======================================

; FCT : rcupre un paramtre de type hexa ou un symbole dans le flot
;       d'interprtation assembleur.
;       Ignore les espaces en dbut de flot d'interprtation
; ERR : $44 : D : expression incomplte
; IN  : ASS_PTRCUROP : le pointeur sur le flot d'interprtation assembleur
; OUT : /

ASS_ParseParam:
            jsr ASS_escapeSPACE             ; FCT : ignore les espaces, le nombre maximal est donn par ASS_LGSRC
                                            ;       Sort en erreur si nous avons atteint ce nombre sans rencontrer autre chose que le caractre espace
                                            ;       Le retour est un peu particulier car s'il n'y a
                                            ;       pas d'erreur nous manipulons la pile pour que le
                                            ;       retour se fasse 3 octets plus loin de l'appelant.
                                            ;       ==> cela permet de faire un jmp XXXX en cas d'erreur
                                            ;       sinon on enchaine le code suivant
                                            ; IN  : ASS_LGSRC et ASS_PTRCUROP  jour
                                            ; OUT : A,B,X modified
            bra setASSERR_0X44_D_EXPR_INCOMPLETE
; End of function ASS_ParseParam

; ---------------------------------------------------------------------------
            dc.b     1

; =============== S U B R O U T I N E =======================================

; FCT : procdure de base pour rcuprer un paramtre
;       de type HEXA ($XXXX) ou un symbole dans le flot
;       d'interprtation assembleur
; ERR : $44 : D : Expression incomplte
; IN  : le flot d'interprtation assembleur
; OUT : /
; RMQ :  optimiser !

ASS_ParseParam_1:
            ldx #$0000
            stx ASS_TMP_CONV                ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            clr ASS_CONV_EN_COURS
            clr ASS_CONV_POS_OR_NEG

bclASS_ParseParam_1:
            ldx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            ldaa 0,x
            cmpa #cMATH_PLUS                ; '+'
            bne next1ASS_ParseParam_1
            clr ASS_CONV_POS_OR_NEG         ;  On le fait deux fois
                                            ;  On remplace :
                                            ;   bne
                                            ;   clr
                                            ;   bra
                                            ;   par beq et pour les appels par doHexa, etc.
                                            ;   on le fait un cran plus haut avec le CLR ASS_CONV_POS_OR_NEG
            bra next2ASS_ParseParam_1

next1ASS_ParseParam_1:
            cmpa #cASS_MINUS                ; '-'
            bne next3ASS_ParseParam_1
            inc ASS_CONV_POS_OR_NEG

next2ASS_ParseParam_1:
            ldx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            inx
            stx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            dec ASS_LGSRC                   ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            bne bclASS_ParseParam_1

setASSERR_0X44_D_EXPR_INCOMPLETE:
            ldaa #cASS_ERR_EXPR_MISSING     ; $44 'D'
            bra storeNumERR

next3ASS_ParseParam_1:
            cmpa #cASS_TYPE_HEXA
            bne next4ASS_ParseParam_1

doParseHexa:
            ldx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            inx
            stx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            dec ASS_LGSRC                   ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            beq setASSERR_0X44_D_EXPR_INCOMPLETE
            bsr ASS_ParseNum                ; FCT : Conversion d'un nombre sous forme ASCII point
                                            ;       par ASS_PTRCUROP en word
                                            ;       Manipule l'adresse de retour sur la pile
                                            ; IN  : ASS_PTRCUROP  jour
                                            ; OUT : ASS_VARTMP contient la converion ou zro en  cas d'erreur
                                            ; ERR : $46 : Bad expression
            rts
; End of function ASS_ParseParam_1


; =============== S U B R O U T I N E =======================================


ASS_dummy:
            brn .+2
; End of function ASS_dummy


; =============== S U B R O U T I N E =======================================

doHexa:
            inc ASS_CONV_EN_COURS
            ldaa ASS_LGSRC                  ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            beq next5ASS_ParseParam_1
            bra bclASS_ParseParam_1
; End of function doHexa


; =============== S U B R O U T I N E =======================================

next4ASS_ParseParam_1:
            cmpa #cOS_SPACE                 ; ' '
            beq next5ASS_ParseParam_1
            cmpa #cASS_comma                ; ','
            beq next5ASS_ParseParam_1

doParseSymbol:
            jsr searchSymbol                ; FCT : Recherche si le texte point par ASS_PTRCUROP est un symbole dj dfinie
                                            ; ERR : $47 : G : symbole inconnue
                                            ; IN  : ASS_PTRCUROP : pointeur sur le flot d'interprtation assembleur
                                            ; OUT : /
            rts
; End of function next4ASS_ParseParam_1


; =============== S U B R O U T I N E =======================================


ASS_dummy1:
            brn .+2
; End of function ASS_dummy1


; =============== S U B R O U T I N E =======================================


doSymbol:
            inc ASS_CONV_EN_COURS
            ldaa ASS_LGSRC              ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            beq next5ASS_ParseParam_1
            bra bclASS_ParseParam_1

next5ASS_ParseParam_1:
            tst ASS_CONV_EN_COURS
            bne add3toReturnAdr

setNUMERRto0X45_EXPR_INEXISTANTE:
            ldaa #cASS_ERR_EXPR_UNDEF   ; 'E'

storeNumERR:
            staa ASS_NUMERR             ; numro de l'erreur
            rts
; End of function doSymbol

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR ASS_ParseParam

add3toReturnAdr:
            tsx
            ldd 0,x
            addd #$03
            std 0,x
            rts
; END OF FUNCTION CHUNK FOR ASS_ParseParam

; =============== S U B R O U T I N E =======================================

; FCT : Conversion d'un nombre sous forme ASCII point
;       par ASS_PTRCUROP en word
;       Manipule l'adresse de retour sur la pile
; IN  : ASS_PTRCUROP  jour
; OUT : ASS_VARTMP contient la converion ou zro en cas  d'erreur
; ERR : $46 : Bad expression

ASS_ParseNum:
            clr ASS_VARTMP
            clr ASS_VARTMP+1
            bsr ASS_isNUM                   ; FCT : Teste si le texte en cours de traitement point par ASS_PTRCUROP est un nombre
                                            ; IN  : ASS_PTRCUROP  jour
                                            ; OUT : A=Le nombre lu
                                            ;       C=0 : est un nombre
                                            ;       C=1 : n'est pas un nombre
            bcc nextASS_ParseNum

setNUMERRto0X46_BADEXPR:
            ldaa #cASS_ERR_EXPR_BAD         ; 'F'
            staa ASS_NUMERR                 ; numro de l'erreur
            rts

nextASS_ParseNum:
            staa ASS_VARTMP+1

bcl1ASS_ParseNum:
            ldaa ASS_LGSRC                  ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            beq next2ASS_ParseNum
            bsr ASS_isNUM                   ; FCT : Teste si le texte en cours de traitement point par ASS_PTRCUROP est un nombre
                                            ; IN  : ASS_PTRCUROP  jour
                                            ; OUT : A=Le nombre lu
                                            ;       C=0 : est un nombre
                                            ;       C=1 : n'est pas un nombre
            bcs next2ASS_ParseNum
            psha
            ldd ASS_VARTMP
            lsld
            lsld
            lsld
            lsld
            std ASS_VARTMP
            ldx ASS_VARTMP
            pulb
            abx
            stx ASS_VARTMP
            bra bcl1ASS_ParseNum

next2ASS_ParseNum:
            ldd ASS_TMP_CONV                ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            tst ASS_CONV_POS_OR_NEG
            bne next3ASS_ParseNum
            addd ASS_VARTMP
            bra next4ASS_ParseNum

next3ASS_ParseNum:
            subd ASS_VARTMP

next4ASS_ParseNum:
            std ASS_TMP_CONV                ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            tsx
            ldd 0,x
            addd #$03
            std 0,x
            rts
; End of function ASS_ParseNum


; =============== S U B R O U T I N E =======================================

; FCT : Teste si le texte en cours de traitement point par ASS_PTRCUROP est un nombre
; IN  : ASS_PTRCUROP  jour
; OUT : A=Le nombre lu
;       C=0 : est un nombre
;       C=1 : n'est pas un nombre

ASS_isNUM:
            ldx ASS_PTRCUROP            ; Pointeur sur l'opcode en cours de dcodage
            ldaa 0,x
            suba #$30 ; '0'
            bcs endASS_isNUM
            cmpa #$0A
            bcs nextASS_isNUM
            suba #$07
            cmpa #$0A
            bcs endASS_isNUM
            cmpa #$0F
            bhi endASS_isNUM

nextASS_isNUM:
            inx
            stx ASS_PTRCUROP            ; Pointeur sur l'opcode en cours de dcodage
            dec ASS_LGSRC               ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            clc
            rts

endASS_isNUM:
            sec
            rts
; End of function ASS_isNUM


; =============== S U B R O U T I N E =======================================

; FCT : Recherche si le texte point par ASS_PTRCUROP est un symbole dj dfinie
; ERR : $47 : G : symbole inconnue
; IN  : ASS_PTRCUROP : pointeur sur le flot d'interprtation assembleur
; OUT : /

searchSymbol:
            ldx ASS_BOT_SYMB

nextSearchSymbol:
            stx ASS_PTR_TMP_SYMB            ; Pointeur sur la liste des symboles compils (tiquettes, etc.)
            cpx ADRENDMEM                   ; Adresse de la fin de mmoire
            bcs next1SearchSymbol

setNUMERRto0X47_SYMB_UNKNOWN:
            ldaa #cASS_ERR_SYMB_UNKNOWN     ; 'G'
            staa ASS_NUMERR                 ; numro de l'erreur
            rts

next1SearchSymbol:
            clrb
            ldaa ASS_LGSRC                  ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            inca
            staa ASS_VARTMP

bcl2SearchSymbol:
            dec ASS_VARTMP
            bne readAndCompareCurrentOp

bcl3SearchSymbol:
            ldx ASS_PTR_TMP_SYMB            ; Pointeur sur la liste des symboles compils (tiquettes, etc.)
            abx
            ldaa 0,x
            cmpa #cOS_SPACE                 ; ' '
            beq next5SearchSymbol
            bra next4SearchSymbol

readAndCompareCurrentOp:
            ldx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            abx
            ldaa 0,x
            cmpa #cOS_SPACE                 ; ' '
            beq bcl3SearchSymbol
            cmpa #cMATH_PLUS                ; '+'
            beq bcl3SearchSymbol
            cmpa #cASS_comma                ; ','
            beq bcl3SearchSymbol
            cmpa #cMATH_MINUS               ; '-'
            beq bcl3SearchSymbol
            ldx ASS_PTR_TMP_SYMB            ; Pointeur sur la liste des symboles compils (tiquettes, etc.)
            abx
            cmpa $00,x
            bne next4SearchSymbol
            incb
            cmpb #cASS_LG_NAME_SYMB
            bne bcl2SearchSymbol
            bra next5SearchSymbol

next4SearchSymbol:
            ldx ASS_PTR_TMP_SYMB            ; Pointeur sur la liste des symboles compils (tiquettes, etc.)
            ldab #cASS_LG_AREA_SYMB
            abx
            bra nextSearchSymbol

next5SearchSymbol:
            ldaa ASS_LGSRC                  ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            sba
            staa ASS_LGSRC                  ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            ldx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            abx
            stx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            ldx ASS_PTR_TMP_SYMB            ; Pointeur sur la liste des symboles compils (tiquettes, etc.)
            ldd ASS_TMP_CONV                ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            tst ASS_CONV_POS_OR_NEG
            bne popAndEndSearchSymbol
            addd 5,x
            bra endSearchSymbol

popAndEndSearchSymbol:
            subd 5,x

endSearchSymbol:
            std ASS_TMP_CONV                ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            tsx
            ldd 0,x
            addd #$03
            std 0,x
            rts
; End of function searchSymbol


; =============== S U B R O U T I N E =======================================

; FCT : Effectue la compilation d'un source assembleur
; IN  : ASS_COMP_CURLINE  jour
; OUT : A,B,X modified

ASS_compile:
            ldx ASS_CURNUMLINE              ; numro de ligne courante traite durant la compilation
            inx
            stx ASS_CURNUMLINE              ; numro de ligne courante traite durant la compilation
            ldx ASS_COMP_CURLINE
            ldaa 0,x
            cmpa #$FF
            bne nextASS_compile
            rts

nextASS_compile:
            staa ASS_LGSRC                  ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            inx
            stx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            ldx #$0000
            stx ASS_LENCUROP                ; Longueur de l'opcode courante
            stx ASS_TMP_CONV                ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            bsr ASS_FCT_FINALIZE_COMP       ; FCT : Finalise la compilation d'une ligne assembleur
                                            ; IN  : ASS_LGSRC : si =0 alors nous avons termin la compilation
                                            ;       de la ligne assembleur en cours de compilation
                                            ;       ASS_PTRCUROP : pointeur sur la ligne assembleur en cours de compilation
                                            ; OUT : A,B,X modified
            tst ASS_NUMERR                  ; numro de l'erreur
            bne next1ASS_compile
            tst ASS_COMP_EN_COURS           ; COMPILATION EN COURS - numro de passe - 1
            beq next2ASS_compile
            tst ASS_FLGSHOWPARSE            ; Flag indiquant qu'il y a eu un demande de compilation
            beq next2ASS_compile
            tst ASS_FLGLI                   ; Flag indiquant que les lignes compiles + source sont  montrer lors de la compilation
            beq next2ASS_compile

next1ASS_compile:
            jsr ASS_listCompilation         ; FCT : Imprime le rsultat de la compilation d'une ligne
                                            ;       + le numro de ligne du source
                                            ;       + adresse de la compilation
                                            ;       + octets de la compilation
                                            ;       + source de la compilation
                                            ; IN  : ASS_DEVNU, ASS_FLGPAG, ASS_CURNUMLINE
                                            ; OUT : A,B,X modified

next2ASS_compile:
            bsr ASS_saveNumErrForPassX      ; FCT : en cas d'erreur, sauve le numro de l'erreur pour la passe de compilation courante N
                                            ; IN  : ASS_COMP_EN_COURS donne le numro de passe courante
                                            ;       ASS_NUMERR : numro de l'erreur lors de la passe courante de la compilation
                                            ; OUT : ASS_NUMERR=0
            ldx ASS_COMP_CURLINE
            ldab 0,x
            abx
            inx
            stx ASS_COMP_CURLINE
            bra ASS_compile                 ; FCT : Effectue la compilation d'un source assembleur
                                            ; IN  : ASS_COMP_CURLINE  jour
                                            ; OUT : A,B,X modified
; End of function ASS_compile

; =============== S U B R O U T I N E =======================================

; FCT : en cas d'erreur, sauve le numro de l'erreur pour la passe de compilation courante N
; IN  : ASS_COMP_EN_COURS donne le numro de passe courante
;       ASS_NUMERR : numro de l'erreur lors de la passe courante de la compilation
; OUT : ASS_NUMERR=0

ASS_saveNumErrForPassX:
            ldx ASS_CURADRCMP               ; Adresse du rsultat de la compilation
            ldab ASS_LENCUROP               ; Longueur de l'opcode courante
            abx
            stx ASS_CURADRCMP               ; Adresse du rsultat de la compilation
            ldaa ASS_NUMERR                 ; numro de l'erreur
            beq resetNUMERR
            ldab ASS_COMP_EN_COURS          ; COMPILATION EN COURS - numro de passe - 1
            ldx #ASS_ERR_PASSE_1
            abx
            inc 0,x

resetNUMERR:
            clr ASS_NUMERR                  ; numro de l'erreur
            rts
; End of function ASS_saveNumErrForPassX


; =============== S U B R O U T I N E =======================================

; FCT : Finalise la compilation d'une ligne assembleur
; IN  : ASS_LGSRC : si =0 alors nous avons termin la compilation
;       de la ligne assembleur en cours de compilation
;       ASS_PTRCUROP : pointeur sur la ligne assembleur en cours de compilation
; OUT : A,B,X modified

ASS_FCT_FINALIZE_COMP:
            ldaa ASS_LGSRC                  ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            beq saveCompToObj
            ldx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            ldaa 0,x
            cmpa #cOS_SPACE                 ; ' '
            beq ASS_trimSpacesAndSaveComp

isCommentaire:
            cmpa #cASS_SEP_COMMENT          ; ';'
            beq saveCompToObj

isSymbol:
            tst ASS_COMP_EN_COURS           ; COMPILATION EN COURS - numro de passe - 1
            bne ASS_SetValueToSymbol        ; FCT : Affecte la valeur  un symbole lors de la deuxime de compilation.
                                            ; IN  : le flot d'interprtation assembleur
                                            ; OUT : /
            jsr ASS_addSYMBOL               ; FCT : Ajoute le symbole point par ASS_PTRCUROP dans la zone des symboles
                                            ; ERR : A : NO MEMORY
                                            ;       B : SYMBOL ALREADY EXIST
                                            ; IN  : ASS_PTRCUROP : pointeur sur le texte du symbole
                                            ; OUT : A,B,X modified
            rts
; End of function ASS_FCT_FINALIZE_COMP


; =============== S U B R O U T I N E =======================================


ASS_dummy3:
            brn .+2
; End of function ASS_dummy3


; =============== S U B R O U T I N E =======================================

j_ASS_trimSpacesAndSaveComp:
            bra ASS_trimSpacesAndSaveComp
; End of function j_ASS_trimSpacesAndSaveComp


; =============== S U B R O U T I N E =======================================

; FCT : Affecte la valeur  un symbole lors de la deuxime de compilation.
; IN  : le flot d'interprtation assembleur
; OUT : /

ASS_SetValueToSymbol:
            jsr ASS_getLet                  ; FCT : Parse une expression de type affectation de variable
                                            ;       exemple TITI=
                                            ; IN  : ASS_PTRCUROP : pointeur sur le flot d'interprtation assembleur
                                            ; OUT : /

ASS_trimSpacesAndSaveComp:
            jsr ASS_escapeSPACE             ; FCT : ignore les espaces, le nombre maximal est donn par ASS_LGSRC
                                            ;       Sort en erreur si nous avons atteint ce nombre sans rencontrer autre chose que le caractre espace
                                            ;       Le retour est un peu particulier car s'il n'y a
                                            ;       pas d'erreur nous manipulons la pile pour que le
                                            ;       retour se fasse 3 octets plus loin de l'appelant.
                                            ;       ==> cela permet de faire un jmp XXXX en cas d'erreur
                                            ;       sinon on enchaine le code suivant
                                            ; IN  : ASS_LGSRC et ASS_PTRCUROP  jour
                                            ; OUT : A,B,X modified
            bra saveCompToObj
; End of function ASS_SetValueToSymbol

; ---------------------------------------------------------------------------
            dc.b     1

; =============== S U B R O U T I N E =======================================

; FCT : parse et compile une ligne de source assembleur
;       reconnait le dbut de commentaire (symbolis par ;)
; IN  : ASS_PTRCUROP pointe sur la ligne de source  traiter
; OUT : A,B,X modified

ASS_parseAndCompOpcode:
            ldx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            ldaa 0,x
            cmpa #cASS_SEP_COMMENT          ; ';' ; c'est le dbut de la zone commentaire donc on finalise la compilation
            beq saveCompToObj
            cmpa #cASS_SEP_TEXT             ; ''' ; c'est le dbut d'une zone de texte
            bne initSearchOpcode
            jmp ASS_treatTexte

initSearchOpcode:
            clrb

bclSearchOpcodeInARRAY:
            ldx #tabOpcode
            abx
            ldx 0,x
            pshb
            jsr ASS_searchOPCODE            ; FCT : Recherche si l'opcode en cours de traitement est dans le tableau des opcodes pass en paramtre
                                            ; IN  : X=pointeur sur un tableau contenant des opcodes  rechercher
                                            ; OUT : X=pointeur +1 sur le tableau contenant des opcodes
                                            ;       B=longueur de tous les opcodes contenus dans le tableau des opcodes
            bra nextTabOpcode

            dc.b     1

; ---------------------------------------------------------------------------
; l'opcode a t trouv donc nous appelons la routine de compilation associe
; ---------------------------------------------------------------------------

foundOpcode:
            pulb
            ldx #tabTreatOpcode
            abx
            ldx 0,x
            jsr 0,x
            bra saveCompToObj

nextTabOpcode:
            pulb
            addb #$02
            cmpb #$10
            bne bclSearchOpcodeInARRAY

setNUMERRto0X48_H_INSTR_UNKNOWN:
            ldaa #cASS_ERR_INST_UNKNOWN     ; 'H'
            staa ASS_NUMERR                 ; numro de l'erreur

saveCompToObj:
            bsr ASS_copyCompToObj           ; FCT : Recopie le rsultat de la compilation d'un opcode
                                            ;       dans la mmoire objet (=rsultat de la compilation du source assembleur)
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            rts
; End of function ASS_parseAndCompOpcode

; ---------------------------------------------------------------------------
tabOpcode:  dc.w tabOpcode1_INH_STACK       ; Liste des opcodes de type INHERENT et manipulation de la pile
            dc.w tabOpcode2_INH_COND_X      ; Liste des opcodes de type INHERENT manipulant
                                            ; le registre de condition ainsi que INC/DEC REG X
            dc.w tabOpcode3_SUB_ADD_REGD    ; Liste des opcodes de type SUB/ADD pour le registre D
            dc.w tabOpcode4_ARITH           ; Liste des opcodes de type arithmetique
            dc.w tabOpcode5_INHERENT_OTHER  ; Liste des opcodes de type INHERENT et etendu de longueur 3
            dc.w tabOpcode6_IMM_LG3         ; Liste des opcodes de type immediat de longeur 3 (opcode + mot)
            dc.w tabOpcode_BRANCH           ; Liste des opcodes de branchement relatif
            dc.w tabDirectiveASS            ; Liste des directives assembleurs
;----------------
tabTreatOpcode:
            dc.w treatOpcodeSingleByte      ; FCT : Ajoute 1  longueur courante de l'opcode
                                            ; IN  : ASS_LENCUROP  jour
                                            ; OUT : ASS_LENCUROP=ASS_LENCUROP+1
            dc.w treatOpcodeSingleByte      ; FCT : Ajoute 1  longueur courante de l'opcode
                                            ; IN  : ASS_LENCUROP  jour
                                            ; OUT : ASS_LENCUROP=ASS_LENCUROP+1
            dc.w treatOpcodeDoubleByte      ; FCT : Ajoute 2  longueur courante de l'opcode
                                            ; IN  : ASS_LENCUROP  jour
                                            ; OUT : ASS_LENCUROP=ASS_LENCUROP+2
            dc.w treatOpcodeWithReg         ; FCT : Traite les opcodes qui s'appliquent sur les registres A et B
                                            ; IN  : ASS_PTRCUROP  jour
                                            ; OUT : /
            dc.w treatOpcodeInherent        ; FCT : Traite les opcodes de type inherent (donc de taille 1)
                                            ;       ou tendu de taille  3
                                            ; IN  : ASS_PTRCUROP  jour
                                            ; OUT : ASS_CURDIRECTIVE contient le code de l'opcode en cours de traitement
            dc.w treatOpcodeDoubleByte      ; FCT : Ajoute 2  longueur courante de l'opcode
                                            ; IN  : ASS_LENCUROP  jour
                                            ; OUT : ASS_LENCUROP=ASS_LENCUROP+2
            dc.w treatOpcodeBranchRel       ; FCT : Traite les opcoces de type branchement relatif
                                            ; IN  : ASS_PTRCUROP pointant sur un Dplacement relatif
                                            ; OUT : /
            dc.w treatDirectiveASS          ; FCT : fonction appelant la routine de compilation des directives assembleurs
                                            ;       La directive tant connue via ASS_CURDIRECTIVE
                                            ; IN  : ASS_CURDIRECTIVE : le numro de la directive assembleur  traiter
                                            ; OUT : A,B,X modified

; =============== S U B R O U T I N E =======================================

; FCT : Recopie le rsultat de la compilation d'un opcode
;       dans la mmoire  objet (rsultat de la compilation du source assembleur)
; IN  : /
; OUT : A,B,X modified

ASS_copyCompToObj:
            ldx ASS_OBJ_END             ; Fin du programme objet
            ldab ASS_LENCUROP           ; Longueur de l'opcode courante
            beq endASS_copyCompToObj
            tst ASS_ORG                 ; flag directive ORG dfinie : =0 non sinon  oui
            bne nextASS_copyCompToObj

setNUMERRto0X4E_COUNTERORGNOTDEFINED:
            ldaa #cASS_ERR_ORG_UNKNOWN  ; $4E 'N'
            bra setNUMERRfromREG_A

nextASS_copyCompToObj:
            abx
            cpx ASS_BOT_SYMB
            bcc setNUMERRto0x4D_M_OUT_OF_MEM_COMPILE

bclCopyComp:
            decb                        ; Recopie le rsultatat de la compilaton dans la mmoire objet
            ldx #ASS_CURDIRECTIVE       ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante
            abx
            ldaa 0,x
            ldx ASS_OBJ_END             ; Fin du programme objet
            abx
            staa 0,x
            tstb
            bne bclCopyComp
            ldx ASS_OBJ_END             ; Fin du programme objet
            ldab ASS_LENCUROP           ; Longueur de l'opcode courante
            abx
            stx ASS_OBJ_END             ; Fin du programme objet

endASS_copyCompToObj:
            rts

setNUMERRto0x4D_M_OUT_OF_MEM_COMPILE:
            ldaa #cASS_ERR_OBJ_OUTOFMEM ; 'M'
setNUMERRfromREG_A:
            staa ASS_NUMERR             ; numro de l'erreur
            rts
; End of function ASS_copyCompToObj


; =============== S U B R O U T I N E =======================================

; FCT : Parse une expression de type affectation de variable
;       exemple TITI=
; IN  : ASS_PTRCUROP : pointeur sur le flot d'interprtation assembleur
; OUT : /

ASS_getLet:
            jsr searchSymbol            ; FCT : Recherche si le texte point par ASS_PTRCUROP est un symbole dj dfinie
                                        ; ERR : $47 : G : symbole inconnue
                                        ; IN  : ASS_PTRCUROP : pointeur sur le flot d'interprtation assembleur
                                        ; OUT : /
; End of function ASS_getLet

; =============== S U B R O U T I N E =======================================

ASS_dummy5:
            brn .+2
            rts
; End of function ASS_dummy5


; =============== S U B R O U T I N E =======================================

; FCT : suppression des espaces  partir de la position courante de l'interprtation
; IN  : ASS_LGSRC et ASS_PTRCUROP  jour
; OUT : A,B,X modified

ASS_TRIM:
            jsr ASS_escapeSPACE         ; FCT : ignore les espaces, le nombre maximal est donn par ASS_LGSRC
                                        ;       Sort en erreur si nous avons atteint ce nombre sans rencontrer autre chose que le caractre espace
                                        ;       Le retour est un peu particulier car s'il n'y a
                                        ;       pas d'erreur nous manipulons la pile pour que le
                                        ;       retour se fasse 3 octets plus loin de l'appelant.
                                        ;       ==> cela permet de faire un jmp XXXX en cas d'erreur
                                        ;       sinon on enchaine le code suivant
                                        ; IN  : ASS_LGSRC et ASS_PTRCUROP  jour
                                        ; OUT : A,B,X modified
; End of function ASS_TRIM

; =============== S U B R O U T I N E =======================================

ASS_dummy6:
            brn .+2
            rts
; End of function ASS_dummy6


; =============== S U B R O U T I N E =======================================

; FCT : vrifie  si le caractre en cours est le signe "gal"
;       Si oui alors nous avons termin l'interprtation en cours
; IN  : ASS_PTRCUROP
; OUT : A,X modified
;       ASS_LGSRC = 0 si le signe "gal" a t rencontr

ASS_isEqual:
            ldx ASS_PTRCUROP            ; Pointeur sur l'opcode en cours de dcodage
            ldaa 0,x
            cmpa #cBAS_EQUAL            ; '='
            bne endASS_isEqual
            clr ASS_LGSRC               ; Longueur du source restant  interprter lors de la compilation de l'opcode courant

endASS_isEqual:
            rts
; End of function ASS_isEqual

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR ASS_FCT_FINALIZE_COMP

ASS_treatTexte:
            jsr ASS_incPTRCUROP             ; FCT : Incrmente de 1 la valeur de ASS_PTRCUROP
                                            ;       Puis dcremente le nombre d'lment constituant l'opcode en cours
                                            ;       Si = 0 alors ERREUR
                                            ; IN  : X=La position de la ligne assembleur en cours de compilation
                                            ; OUT : X=X+1 et ASS_PTRCUROP = X+1
            tst ASS_ORG                     ; flag directive ORG dfinie : =0 non sinon  oui
            beq setNUMERRto0X4E_COUNTERORGNOTDEFINED
            ldab ASS_LGSRC                  ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            ldx ASS_OBJ_END                 ; Fin du programme objet
            abx
            cpx ASS_BOT_SYMB
            bcc setNUMERRto0x4D_M_OUT_OF_MEM_COMPILE
            stab ASS_LENCUROP               ; Longueur de l'opcode courante
            clrb

ASS_treatTexte_bcl:
            ldx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            abx
            ldaa 0,x
            cmpb #3
            bcc ASS_treatTexte_next1
            ldx #ASS_CURDIRECTIVE           ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante
            abx
            staa 0,x

ASS_treatTexte_next1:
            ldx ASS_OBJ_END                 ; Fin du programme objet
            abx
            staa 0,x
            incb
            cmpb ASS_LENCUROP               ; Longueur de l'opcode courante
            bls ASS_treatTexte_bcl
            stx ASS_OBJ_END                 ; Fin du programme objet
            rts
; END OF FUNCTION CHUNK FOR ASS_FCT_FINALIZE_COMP

; =============== S U B R O U T I N E =======================================

; FCT : Ajoute 1  longueur courante de l'opcode
; IN  : ASS_LENCUROP  jour
; OUT : ASS_LENCUROP=ASS_LENCUROP+1

treatOpcodeSingleByte:
            ldaa #$01
            staa ASS_LENCUROP               ; Longueur de l'opcode courante
            rts
; End of function treatOpcodeSingleByte


; =============== S U B R O U T I N E =======================================

; FCT : Ajoute 2  longueur courante de l'opcode
; IN  : ASS_LENCUROP  jour
; OUT : ASS_LENCUROP=ASS_LENCUROP+2

treatOpcodeDoubleByte:
            ldaa #$02
            staa ASS_LENCUROP               ; Longueur de l'opcode courante
            jsr ASS_escapeSPACE             ; FCT : ignore les espaces, le nombre maximal est donn par ASS_LGSRC
                                            ;       Sort en erreur si nous avons atteint ce nombre sans rencontrer autre chose que le caractre espace
                                            ;       Le retour est un peu particulier car s'il n'y a
                                            ;       pas d'erreur nous manipulons la pile pour que le
                                            ;       retour se fasse 3 octets plus loin de l'appelant.
                                            ;       ==> cela permet de faire un jmp XXXX en cas d'erreur
                                            ;       sinon on enchaine le code suivant
                                            ; IN  : ASS_LGSRC et ASS_PTRCUROP  jour
                                            ; OUT : A,B,X modified
            jmp setNUMERRto0X4F_BADINSTR    ; FCT : Initialise le code ERREUR  'O' : instruction incomplte
                                            ; IN  : /
                                            ; OUT : A=ASS_NUMERR=$4F
; End of function treatOpcodeDoubleByte

; =============== S U B R O U T I N E =======================================


dotreatOpcodeDoubleByte:
            ldab ASS_CURDIRECTIVE           ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante
            ldx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            ldaa 0,x

isAdrImm:
            cmpa #cASS_ADR_IMM              ; '#'
            bne isAdrDirect
            bra doTreatOpcodeDoubleByte_ADR_IMM
; End of function dotreatOpcodeDoubleByte


; =============== S U B R O U T I N E =======================================

; FCT : Traite les opcodes qui s'appliquent sur les registres A et B
; IN  : ASS_PTRCUROP  jour
; OUT : /

treatOpcodeWithReg:
            ldaa #$02
            staa ASS_LENCUROP               ; Longueur de l'opcode courante
            ldab ASS_CURDIRECTIVE           ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante
            ldx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            ldaa 0,x
            cmpa #$41 ; 'A'
            beq isREGA
            cmpa #$42 ; 'B'
            beq isREGB

setNUMERRto0X49_REG_UNKNOWN:                ; registre inconnu
            ldaa #cASS_ERR_REG_UNKNOWN      ; 'I'
            staa ASS_NUMERR                 ; numro de l'erreur
            rts

isREGB:
            addb #$40 ; '@'
            stab ASS_CURDIRECTIVE           ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante

isREGA:
            jsr ASS_incPTRCUROP             ; FCT : Incrmente de 1 la valeur de ASS_PTRCUROP
                                            ;       Puis dcremente le nombre d'lment constituant l'opcode en cours
                                            ;       Si = 0 alors ERREUR
                                            ; IN  : X=La position de la ligne assembleur en cours de compilation
                                            ; OUT : X=X+1 et ASS_PTRCUROP = X+1
            jsr ASS_escapeSPACE             ; FCT : ignore les espaces, le nombre maximal est donn par ASS_LGSRC
                                            ;       Sort en erreur si nous avons atteint ce nombre sans rencontrer autre chose que le caractre espace
                                            ;       Le retour est un peu particulier car s'il n'y a
                                            ;       pas d'erreur nous manipulons la pile pour que le
                                            ;       retour se fasse 3 octets plus loin de l'appelant.
                                            ;       ==> cela permet de faire un jmp XXXX en cas d'erreur
                                            ;       sinon on enchaine le code suivant
                                            ; IN  : ASS_LGSRC et ASS_PTRCUROP  jour
                                            ; OUT : A,B,X modified

isERROR:
            jmp setNUMERRto0X4F_BADINSTR    ; FCT : Initialise le code ERREUR  'O' : instruction incompltete
                                            ; IN  : /
                                            ; OUT : A=ASS_NUMERR=$4F
; End of function treatOpcodeWithReg


; =============== S U B R O U T I N E =======================================


nextTreatOpcodeWithReg:
            ldx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            ldab ASS_CURDIRECTIVE           ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante
            ldaa 0,x
            cmpa #cASS_ADR_IMM              ; '#'
            beq treatParamAdr
            bra isAdrDirect
; End of function nextTreatOpcodeWithReg


; =============== S U B R O U T I N E =======================================

; FCT : Traite les opcodes de type inherent (donc de taille 1)
;       ou tendu de taille 3
; IN  : ASS_PTRCUROP  jour
; OUT : ASS_CURDIRECTIVE contient le code de l'opcode en cours de traitement

treatOpcodeInherent:
            ldaa #$01
            staa ASS_LENCUROP               ; Longueur de l'opcode courante
            ldx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            ldab ASS_CURDIRECTIVE           ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante
            ldaa 0,x

isOpcodeForREGA:
            cmpa #$41 ; 'A'
            beq endtTreatOpcodeInherent

isOpcodeForREGB:
            cmpa #$42 ; 'B'
            bne incLENCUROP
            addb #$10
            stab ASS_CURDIRECTIVE           ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante

endtTreatOpcodeInherent:
            rts

incLENCUROP:
            inc ASS_LENCUROP                ; Longueur de l'opcode courante
            bra doTreatOpcodeEtendu

isAdrDirect:
            cmpa #cASS_ADR_DIRECT           ; '<'
            bne doTreatOpcodeEtendu
            addb #$10
            stab ASS_CURDIRECTIVE           ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante

treatParamAdr:
            jsr ASS_incPTRCUROP             ; FCT : Incrmente de 1 la valeur de ASS_PTRCUROP
                                            ;       Puis dcremente le nombre d'lment constituant l'opcode en cours
                                            ;       Si = 0 alors ERREUR
                                            ; IN  : X=La position de la ligne assembleur en cours de compilation
                                            ; OUT : X=X+1 et ASS_PTRCUROP = X+1
            jsr ASS_ParseParam_byte         ; FCT : Interprte l'expression de type octet dans le flot d'interprtation assembleur
                                            ; IN  : le flot d'interprtation assembleur
                                            ; OUT : A,B,X modified
            jsr ASS_storeResultatInTmp      ; FCT : Stocke le mot contenu  l'adresse ASS_CURADRCMP
                                            ;       dans ASS_TMP_CONV si la compilation est termine
                                            ; IN  : ASS_COMP_EN_COURS : flag compilation en cours
                                            ;       ASS_CURADRCMP     : Adresse du rsultat de la compilation
                                            ; OUT : Si pas de compilation en cours alors :
                                            ;       ASS_TMP_CONV=ASS_CURADRCMP
                                            ;       ASS_NUMERR=0
                                            ;       sinon ne fait rien
            bra verifyOpcodeToExclclude

doTreatOpcodeEtendu:
            addb #$30 ; '0'
            stab ASS_CURDIRECTIVE           ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante
            bra nextDoTreatOpcodeDoubleByte_ADR_IMM

doTreatOpcodeDoubleByte_ADR_IMM:
            jsr ASS_incPTRCUROP             ; FCT : Incrmente de 1 la valeur de ASS_PTRCUROP
                                            ;       Puis dcremente le nombre d'lment constituant l'opcode en cours
                                            ;       Si = 0 alors ERREUR
                                            ; IN  : X=La position de la ligne assembleur en cours de compilation
                                            ; OUT : X=X+1 et ASS_PTRCUROP = X+1

nextDoTreatOpcodeDoubleByte_ADR_IMM:
            inc ASS_LENCUROP                ; Longueur de l'opcode courante
            jsr ASS_ParseParam              ; FCT : rcupre un paramtre de type hexa ou un symbole dans le flot
                                            ;       d'interprtation assembleur.
                                            ;       Ignore les espaces en dbut de flot d'interprtation
                                                        ; ERR  $44 : D : expression incomplte
                                            ; IN  : ASS_PTRCUROP : le pointeur sur le flot d'interprtation assembleur
                                            ; OUT : /
            jsr ASS_storeResultatInTmp      ; FCT : Stocke le mot contenu  l'adresse ASS_CURADRCMP
                                            ;       dans ASS_TMP_CONV si la compilation est termine
                                            ; IN  : ASS_COMP_EN_COURS : flag compilation en cours
                                            ;       ASS_CURADRCMP     : Adresse du rsultat de la compilation
                                            ; OUT : Si pas de compilation en cours alors :
                                            ;       ASS_TMP_CONV=ASS_CURADRCMP
                                            ;       ASS_NUMERR=0
                                            ;       sinon ne fait rien
            ldx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            ldaa 0,x
            cmpa #cASS_SEP_ARG              ; ','
            bne verifyOpcodeToExclclude
            inx
            ldaa 0,x
            cmpa #$58                       ; 'X'
            bne setNUMERRto0x4A_J_ADR_IND_INCORRECT
            jsr nextASS_ParseParam_BYTE     ; FCT : Interprte l'expression de type octet dans le flot d'interprtation assembleur
                                            ; IN  : le flot d'interprtation assembleur
                                            ; OUT : A,B,X modified
            rts
; End of function treatOpcodeInherent

; ---------------------------------------------------------------------------
            brn .+2

; =============== S U B R O U T I N E =======================================

doTreatADRESSAGE:
            ldab ASS_CURDIRECTIVE           ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante
            subb #$10
            stab ASS_CURDIRECTIVE           ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante
            dec ASS_LENCUROP                ; Longueur de l'opcode courante

verifyOpcodeToExclclude:
            ldab ASS_CURDIRECTIVE           ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante
            ldx #tabOpcodeToExclude         ; Liste des opcodes qui n'existent pas

bclIsOpcodeToExclclude:
            cmpb 0,x
            beq setNUMERRto0x50_P_BAD_INSTR
            inx
            cpx #treatOpcodeBranchRel       ; FCT : Traite les opcoces de type branchement relatif
                                            ; IN  : ASS_PTRCUROP pointant sur un Dplacement relatif
                                            ; OUT : /
            bne bclIsOpcodeToExclclude
            rts

setNUMERRto0x4A_J_ADR_IND_INCORRECT:
            ldaa #cASS_ERR_ADR_IND_BAD      ; 'J'
            bra setNUMERRto0xXX

setNUMERRto0x50_P_BAD_INSTR:
            ldaa #cASS_ERR_INST_UNDEF       ; 'P'

setNUMERRto0xXX:
            staa ASS_NUMERR                 ; numro de l'erreur
            rts
; End of function doTreatADRESSAGE

; ---------------------------------------------------------------------------
tabOpcodeToExclude: dc.b $4E,$5E,$87,$8F,$C7,$CD,$CF   ; Liste des opcodes qui n'existent pas

; =============== S U B R O U T I N E =======================================

; FCT : Traite les opcoces de type branchement relatif
; IN  : ASS_PTRCUROP pointant sur un Dplacement relatif
; OUT : /

treatOpcodeBranchRel:
            ldaa #$02
            staa ASS_LENCUROP               ; Longueur de l'opcode courante
            jsr ASS_ParseParam              ; FCT : rcupre un paramtre de type hexa ou un symbole dans le flot
                                            ;       d'interprtation assembleur.
                                            ;       Ignore les espaces en dbut de flot d'interprtation
                                            ; ERR : $44 : D : expression incomplte
                                            ; IN  : ASS_PTRCUROP : le pointeur sur le flot d'interprtation assembleur
                                            ; OUT : /
            jsr ASS_storeResultatInTmp      ; FCT : Stocke le mot contenu  l'adresse ASS_CURADRCMP
                                            ;       dans ASS_TMP_CONV si la compilation est termine
                                            ; IN  : ASS_COMP_EN_COURS : flag compilation en cours
                                            ;       ASS_CURADRCMP     : Adresse du rsultat de la compilation
                                            ; OUT : Si pas de compilation en cours alors :
                                            ;       ASS_TMP_CONV=ASS_CURADRCMP
                                            ;       ASS_NUMERR=0
                                            ;       sinon ne fait rien
            ldd ASS_TMP_CONV                ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            subd #$02
            subd ASS_CURADRCMP              ; Adresse du rsultat de la compilation
            tsta
            bne nextTreatOpcodeBranchRel
            cmpb #$7F
            bls endRreatOpcodeBranchRel
            bra setNUMERRto0X4B_K_ADR_REL_OVF

nextTreatOpcodeBranchRel:
            cmpa #$FF
            bne setNUMERRto0X4B_K_ADR_REL_OVF
            cmpb #$7F
            bls setNUMERRto0X4B_K_ADR_REL_OVF

endRreatOpcodeBranchRel:
            stab ASS_TMP_CONV               ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            rts

setNUMERRto0X4B_K_ADR_REL_OVF:
            ldx #$0000
            stx ASS_TMP_CONV                ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            ldab #cASS_ERR_ADR_REL_OVR      ; 'K'
            stab ASS_NUMERR                 ; numro de l'erreur
            rts
; End of function treatOpcodeBranchRel


; =============== S U B R O U T I N E =======================================

; FCT : Stocke le mot contenu  l'adresse ASS_CURADRCMP
;       dans ASS_TMP_CONV si la compilation est termine
; IN  : ASS_COMP_EN_COURS : flag compilation en cours
;       ASS_CURADRCMP     : Adresse du rsultat de la compilation
; OUT : Si pas de compilation en cours alors :
;       ASS_TMP_CONV=ASS_CURADRCMP
;       ASS_NUMERR=0
;       sinon ne fait rien

ASS_storeResultatInTmp:
            tst ASS_COMP_EN_COURS           ; COMPILATION EN COURS - numro de passe - 1
            bne endASS_storeResultatInTmp
            clr ASS_NUMERR                  ; numro de l'erreur
            ldx ASS_CURADRCMP               ; Adresse du rsultat de la compilation
            stx ASS_TMP_CONV                ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure

endASS_storeResultatInTmp:
            rts
; End of function ASS_storeResultatInTmp


; =============== S U B R O U T I N E =======================================

; FCT : Initialise le code ERREUR  'O' : instruction incomplte
; IN  : /
; OUT : A=ASS_NUMERR=$4F

setNUMERRto0X4F_BADINSTR:
            ldaa #cASS_ERR_INST_MISSING ; 'O'
            staa ASS_NUMERR             ; numro de l'erreur
            rts
; End of function setNUMERRto0X4F_BADINSTR


; =============== S U B R O U T I N E =======================================

; FCT : fonction appelant la routine de compilation des directives assembleurs
;       La directive tant connue via ASS_CURDIRECTIVE
; IN  : ASS_CURDIRECTIVE : le numro de la directive assembleur  traiter
; OUT : A,B,X modified

treatDirectiveASS:
            ldx #tabjmpDirectiveASS
            ldab ASS_CURDIRECTIVE           ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante
            abx
            ldx 0,x
            jsr 0,x
            rts
; End of function treatDirectiveASS

; ---------------------------------------------------------------------------
tabjmpDirectiveASS:
            dc.w doASS_ORG                  ; FCT : Traite la directive assembleur ORG
                                            ; ERR : $4C : L : ORG already exist
                                            ; IN  : /
                                            ; OUT : /
            dc.w doASS_EXC                  ; FCT : traite la directive assembleur EXC (excute) qui permet
                                            ;       de fixer le point d'entre de la routine assembleur
                                            ; IN  : le flot d'interprtation assembleur
                                            ; OUT : la variable ASS_COMP_EXC est mise  jour avec le paramtre
            dc.w doASS_BLC                  ; FCT : Rserve un bloc pouvant contenir 255 octets
                                            ; IN  : le flot d'interprtation assembleur
                                            ; OUT : Rservation  d'une zone mmoire de n octets
            dc.w doASS_LIplus               ; FCT : LIST OFF : affichage autoris du source lors de la compilation
                                            ; IN  : /
                                            ; OUT : ASS_FLGLI = 1
            dc.w doASS_LIminus              ; FCT : LIST OFF : affichage inhib du source lors de la compilation
                                            ; IN  : /
                                            ; OUT : ASS_FLGLI = 0
            dc.w doASS_PAG                  ; FCT : MET A 1 le flag de saut de page lors la commande assembleur PAG est rencontr
                                            ; IN  : /
                                            ; OUT : ASS_FLGPAG=ASS_FLGPAG+1
            dc.w doASS_FDO                  ; FCT : Compilation de la directive assembleur DFO
                                            ;       qui permet de stocker l'octet "val"
                                            ;        l'adresse symbole
                                            ; STX : symbole DFO val
                                            ; IN  : le paramtre val contenu dans le flot d'interprtation assembleur
                                            ; OUT : /
            dc.w doASS_DFD                  ; FCT : Compilation de la directive assembleur DFD
                                            ;       qui permet de stocker le mot 16 bits "val"
                                            ;        l'adresse symbole
                                            ; STX : symbole DFD val
                                            ; IN  : le paramtre val contenu dans le flot d'interprtation assembleur
                                            ; OUT : /

; =============== S U B R O U T I N E =======================================

; FCT : Traite la directive assembleur ORG
; ERR : $4C : L : ORG already exist
; IN  : /
; OUT : /

doASS_ORG:
            tst ASS_ORG                           ; flag directive ORG dfinie : =0 non sinon  oui
            bne setNUMERRto0x4C_ORGALREADYEXIST   ; FCT : Positionne le code erreur assembleur  'L' : ORG ALREADY EXIST
                                                  ; IN  : /
                                                  ; OUT : A=$4C
            jsr ASS_ParseParam                    ; FCT : rcupre un paramtre de type hexa ou un symbole dans le flot
                                                  ;       d'interprtation assembleur.
                                                  ;       Ignore les espaces en dbut de flot d'interprtation
                                                  ; ERR : $44 : D : expression incomplte
                                                  ; IN  : ASS_PTRCUROP : le pointeur sur le flot d'interprtation assembleur
                                                  ; OUT : /
            rts
; End of function doASS_ORG


; =============== S U B R O U T I N E =======================================


ASS_dummy4:
            brn .+2
; End of function ASS_dummy4


; =============== S U B R O U T I N E =======================================

treatASS_ORG:
            ldx ASS_TMP_CONV                ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            stx ASS_COMP_LOAD
            stx ASS_CURADRCMP               ; Adresse du rsultat de la compilation
            inc ASS_ORG                     ; flag directive ORG dfinie : =0 non sinon  oui
            rts
; End of function treatASS_ORG


; =============== S U B R O U T I N E =======================================

; FCT : Positionne le code erreur assembleur  'L' : ORG ALREADY EXIST
; IN  : /
; OUT : A=$4C

setNUMERRto0x4C_ORGALREADYEXIST:
            ldaa #cASS_ERR_ORG_ALREADY     ; 'L'
            staa ASS_NUMERR                ; numro de l'erreur
            rts
; End of function setNUMERRto0x4C_ORGALREADYEXIST


; =============== S U B R O U T I N E =======================================

; FCT : traite la directive assembleur EXC (excute) qui permet
;       de fixer le point d'entre de la routine assembleur
; IN  : le flot d'interprtation assembleur
; OUT : la variable ASS_COMP_EXC est mise  jour avec le paramtre

doASS_EXC:
            jsr ASS_ParseParam              ; FCT : rcupre un paramtre de type hexa ou un symbole dans le flot
                                            ;       d'interprtation assembleur.
                                            ;       Ignore les espaces en dbut de flot d'interprtation
                                            ; ERR : $44 : D : expression incomplte
                                            ; IN  : ASS_PTRCUROP : le pointeur sur le flot d'interprtation assembleur
                                            ; OUT : /
            jsr ASS_storeResultatInTmp      ; FCT : Stocke le mot contenu  l'adresse ASS_CURADRCMP
                                            ;       dans ASS_TMP_CONV si la compilation est termine
                                            ; IN  : ASS_COMP_EN_COURS : flag compilation en cours
                                            ;       ASS_CURADRCMP     : Adresse du rsultat de la compilation
                                            ; OUT : Si pas de compilation en cours alors :
                                            ;       ASS_TMP_CONV=ASS_CURADRCMP
                                            ;       ASS_NUMERR=0
                                            ;       sinon ne fait rien
            ldx ASS_TMP_CONV                ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            stx ASS_COMP_EXC                ; Pointeur sur le dbut du code  excuter
            rts
; End of function doASS_EXC


; =============== S U B R O U T I N E =======================================

; FCT : Rserve  un bloc pouvant contenir 255 octets
; IN  : le flot d'interprtation assembleur
; OUT : Rservation d'une zone mmoire de n octets

doASS_BLC:
            jsr ASS_ParseParam_byte         ; FCT : Interprte l'expression de type octet dans le flot d'interprtation assembleur
                                            ; IN  : le flot d'interprtation assembleur
                                            ; OUT : A,B,X modified
            rts
; End of function doASS_BLC


; =============== S U B R O U T I N E =======================================


ASS_dummyBLC:
            brn .+2
; End of function ASS_dummyBLC


; =============== S U B R O U T I N E =======================================

; FCT : Termine l'action en mettant  disposition le
;       paramtre dans ASS_LENCUROP ainsi que dans ASS_TMP_CONV
; IN  : ASS_TMP_CONV mise  jour
; OUT : ASS_TMP_CONV=ASS_LENCUROP=valeur du paramtre pass

treatBLC_ASS:
            ldab ASS_TMP_CONV               ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            stab ASS_LENCUROP               ; Longueur de l'opcode courante
            ldx #$0000
            stx ASS_CURDIRECTIVE            ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante
            clr ASS_TMP_CONV+1              ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            rts
; End of function treatBLC_ASS


; =============== S U B R O U T I N E =======================================

; FCT : LIST OFF : affichage autoris du source lors de la compilation
; IN  : /
; OUT : ASS_FLGLI = 1

doASS_LIplus:
            ldaa #$01
            staa ASS_FLGLI              ; Flag indiquant que les lignes compiles + source sont  montrer lors de la compilation
            rts
; End of function doASS_LIplus


; =============== S U B R O U T I N E =======================================

; FCT : LIST OFF : affichage inhib du source lors de la compilation
; IN  : /
; OUT : ASS_FLGLI = 0

doASS_LIminus:
            clr ASS_FLGLI               ; Flag indiquant que les lignes compiles + source sont  montrer lors de la compilation
            rts
; End of function doASS_LIminus


; =============== S U B R O U T I N E =======================================

; FCT : MET A 1 le flag de saut de page lors la commande assembleur PAG est rencontr
; IN  : /
; OUT : ASS_FLGPAG=ASS_FLGPAG+1

doASS_PAG:
            inc ASS_FLGPAG
            rts
; End of function doASS_PAG


; =============== S U B R O U T I N E =======================================

; FCT : Compilation de la directive assembleur DFO
;       qui permet de stocker l'octet "val"
;        l'adresse symbole
; STX : symbole DFO val
; IN  : le paramtre val contenu dans le flot d'interprtation assembleur
; OUT : /

doASS_FDO:
            jsr ASS_ParseParam_byte         ; FCT : Interprte l'expression de type octet dans le flot d'interprtation assembleur
                                            ; IN  : le flot d'interprtation assembleur
                                            ; OUT : A,B,X modified
            jsr ASS_storeResultatInTmp      ; FCT : Stocke le mot contenu  l'adresse ASS_CURADRCMP
                                            ;       dans ASS_TMP_CONV si la compilation est termine
                                            ; IN  : ASS_COMP_EN_COURS : flag compilation en cours
                                            ;       ASS_CURADRCMP     : Adresse du rsultat de la compilation
                                            ; OUT : Si pas de compilation en cours alors :
                                            ;       ASS_TMP_CONV=ASS_CURADRCMP
                                            ;       ASS_NUMERR=0
                                            ;       sinon ne fait rien
            ldaa ASS_TMP_CONV               ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            staa ASS_CURDIRECTIVE           ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante
            inc ASS_LENCUROP                ; Longueur de l'opcode courante
            rts
; End of function doASS_FDO


; =============== S U B R O U T I N E =======================================

; FCT : Compilation de la directive assembleur DFD
;       qui permet de stocker le mot 16 bits "val"
;        l'adresse symbole
; STX : symbole DFD val
; IN  : le paramtre val contenu dans le flot d'interprtation assembleur
; OUT : /

doASS_DFD:
            jsr ASS_ParseParam              ; FCT : rcupre un paramtre de type hexa ou un symbole dans le flot
                                            ;       d'interprtation assembleur.
                                            ;       Ignore les espaces en dbut de flot d'interprtation
                                            ; ERR : $44 : D : expression incomplte
                                            ; IN  : ASS_PTRCUROP : le pointeur sur le flot d'interprtation assembleur
                                            ; OUT : /
            jsr ASS_storeResultatInTmp      ; FCT : Stocke le mot contenu  l'adresse ASS_CURADRCMP
                                            ;       dans ASS_TMP_CONV si la compilation est termine
                                            ; IN  : ASS_COMP_EN_COURS : flag compilation en cours
                                            ;       ASS_CURADRCMP     : Adresse du rsultat de la compilation
                                            ; OUT : Si pas de compilation en cours alors :
                                            ;       ASS_TMP_CONV=ASS_CURADRCMP
                                            ;       ASS_NUMERR=0
                                            ;       sinon ne fait rien
            ldx ASS_TMP_CONV                ; Permet de stocker le rsultat d'un calcul pour une rutilisation ultrieure
            stx ASS_CURDIRECTIVE            ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante
            ldaa #$02
            staa ASS_LENCUROP               ; Longueur de l'opcode courante
            rts
; End of function doASS_DFD


; =============== S U B R O U T I N E =======================================

; FCT : Incrmente de 1 la valeur de ASS_PTRCUROP
;       Puis dcremente  le nombre d'lment constituant l'opcode en cours
;       Si = 0 alors ERREUR
; IN  : X=La position de la ligne assembleur en cours de compilation
; OUT : X=X+1 et ASS_PTRCUROP = X+1

ASS_incPTRCUROP:
            inx
            stx ASS_PTRCUROP                ; Pointeur sur l'opcode en cours de dcodage
            dec ASS_LGSRC                   ; Longueur du source restant  interprter lors de la compilation de l'opcode courant
            beq popAndError
            rts

popAndError:
            pulx
            jmp setNUMERRto0X4F_BADINSTR    ; FCT : Initialise le code ERREUR  'O' : instruction incomplte
                                            ; IN  : /
                                            ; OUT : A=ASS_NUMERR=$4F
; End of function ASS_incPTRCUROP

; =============== S U B R O U T I N E =======================================

; FCT : Imprime le rsultat de la compilation d'une ligne
;       + le numro de ligne du source
;       + adresse de la compilation
;       + octets de la compilation
;       + source de la compilation
; IN  : ASS_DEVNU, ASS_FLGPAG, ASS_CURNUMLINE
; OUT : A,B,X modified

ASS_listCompilation:
            ldaa ASS_DEVNU              ; Indique la port de sortie du listing (0 : ECRAN; 1 : IMPRIMANTE)
            staa DEVNU                  ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            tst ASS_FLGPAG
            beq nextASS_listCompilation_format
            ldaa #$0C
            jsr OS_printCHAR            ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                        ; IN  : A=caractre  imprimer
                                        ;       DEVNU mise  jour
                                        ; OUT : B, X unmodified
            clr ASS_FLGPAG
            rts
; ---------------------------------------------------------------------------

nextASS_listCompilation_format:
            clrb

bcl1ASS_listCompilation_format:
            ldx #tabASS_FORMAT              ; permet de cadrer  droite le nombre  imprimer
            abx
            ldx 0,x
            cpx ASS_CURNUMLINE              ; numro de ligne courante traite durant la compilation
            bls next2ASS_listCompilation
            ldaa #cOS_SPACE                 ; ' '
            jsr OS_printCHAR                ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                            ; IN  : A=caractre  imprimer
                                            ;       DEVNU mise  jour
                                            ; OUT : B, X unmodified
            addb #$02
            bra bcl1ASS_listCompilation_format
; ---------------------------------------------------------------------------
; === Imprime le numro de ligne en cours de compilation

next2ASS_listCompilation:
            ldd ASS_CURNUMLINE                          ; numro de ligne courante traite durant la compilation
            jsr LIPTR                                   ; FCT : Imprime le chiffre contenu dans D
                                                        ; IN  : D : le chiffre  afficher
                                                        ; OUT : A,B,X modified
            jsr ASS_initBuffer                          ; FCT : INTIALISE le tampon ASS_BUF_CURINP_BOT rceptionnant
                                                        ;       les donnes  afficher via le DEVICE en cours (ou pas)
                                                        ; IN  : /
                                                        ; OUT : A,X modified
            ldaa ASS_NUMERR                             ; numro de l'erreur
            beq next3ASS_listCompilation_printCodeASS
            staa ASS_SAVE_HEADER_K7_LM_BINAIRE+1        ; Peut prendre la valeur $0200, $0500
                                                        ; si $0200 alors ($02=langage machine) et ($00=binaire)
                                                        ; si $0500 alors ($05=fichier texte de l'diteur) et ($00=binaire)

next2ASS_listCompilation_PrintErreur:
            ldx #lgStrErr
            ldd #(ASS_TAMPONTMP+1)
            jsr OS_copyMEM                              ; FCT : Copie la zone mmoire pointe par X
                                                        ;       (le premier octet contient le nombre d'octets
                                                        ;        copier) dans celle pointe par D
                                                        ; IN  : X=SOURCE
                                                        ;       D=CIBLE
                                                        ; OUT : A,B,X modified
            bra next6ASS_listCompilation_PrintSource

; === Imprime le code assmbl si nous compilons une opcode
next3ASS_listCompilation_printCodeASS:
            ldaa ASS_LENCUROP                           ; Longueur de l'opcode courante
            beq next6ASS_listCompilation_PrintSource
            cmpa #3
            bls next4ASS_listCompilation
            ldaa #$03

next4ASS_listCompilation:
            staa ASS_VARTMP
            ldaa ASS_CURADRCMP                          ; Adresse du rsultat de la compilation
            ldx #ASS_TAMPONTMP
            bsr convNumToASCII                          ; FCT : Convertit un nombre (octet) en sa reprsentation ASCII
                                                        ; IN  : A=Nombre  convertir
                                                        ;       X=Tampon de conversion
                                                        ; OUT : X et A modified
            ldaa ASS_CURADRCMP+1                        ; Adresse du rsultat de la compilation
            bsr convNumToASCII                          ; FCT : Convertit un nombre (octet) en sa reprsentation ASCII
                                                        ; IN  : A=Nombre  convertir
                                                        ;       X=Tampon de conversion
                                                        ; OUT : X et A modified
            clrb
            inx

bcl5ASS_listCompilation:
            pshx
            ldx #ASS_CURDIRECTIVE                       ; Valeur de l'opcode en cours de lecture ou directive d'assemblage courante
            abx
            ldaa 0,x
            pulx
            bsr convNumToASCII                          ; FCT : Convertit un nombre (octet) en sa reprsentation ASCII
                                                        ; IN  : A=Nombre  convertir
                                                        ;       X=Tampon de conversion
                                                        ; OUT : X et A modified
            incb
            cmpb ASS_VARTMP
            bne bcl5ASS_listCompilation

; === Imprime le code source de la ligne affiche

next6ASS_listCompilation_PrintSource:
            clr ASS_SAVE_HEADER_K7_LOAD                 ; Adresse de chargement
            ldx #ASS_LEN_INP_USR                        ; Longueur de la saisie utilisateur
            jsr OS_OUTTX                                ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                                        ; IN : X=pointeur sur une chane de caractres termine par un 0
                                                        ; OUT: A,B,X modified
            ldx ASS_COMP_CURLINE
            stx ASS_PTRTMP
            jsr ASS_printString                         ; FCT : Imprime la chane pointe par ASS_PTRTMP  partir
                                                        ;       de la position courante et au maximum jusqu' la fin de la ligne
                                                        ;       Si nous avons atteint la fin de ligne alors on
                                                        ;       effectue un retour  la ligne
                                                        ; IN  : ASS_PTRTMP  jour
                                                        ; OUT : A,B,X modified
            tst DEVNU                                   ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            bne next7ASS_listCompilation_SuspendListing
            cmpb XMAX_SCR                               ; longueur d'un cran
            bne next7ASS_listCompilation_SuspendListing
            jsr next5ASS_printString_CR                 ; imprime un retour chariot

next7ASS_listCompilation_SuspendListing:
            bsr ASS_TESTSHIFTAROBASE                    ; FCT : Test si on appuie sur SHIFT+@
                                                        ;       Si oui alors on attend la fin de l'appui
                                                        ;       Si non on sort
                                                        ; IN  : /
                                                        ; OUT : /
            clr DEVNU                                   ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            rts
; End of function ASS_listCompilation


; =============== S U B R O U T I N E =======================================

; FCT : Convertit un nombre (octet) en sa reprsentation ASCII
; IN  : A=Nombre  convertir
;       X=Tampon de conversion
; OUT : X et A modified

convNumToASCII:
            psha
            lsra
            lsra
            lsra
            lsra
            bsr nextConvNumToASCII          ; FCT : Conversion du chiffre contenu dans A en son quivalent ASCII
                                            ; IN  : A=chiffre  convertir; A=[0;9]
                                            ;       X=ptr o stocker le  rsultat
                                            ; OUT : A=ASCII(A)
                                            ;       X=X+1
            pula
            anda #$0F
; End of function convNumToASCII


; =============== S U B R O U T I N E =======================================

; FCT : Conversion du chiffre contenu dans A en son quivalent ASCII
; IN  : A=chiffre  convertir; A=[0;9]
;       X=ptr o stocker le rsultat
; OUT : A=ASCII(A)
;       X=X+1

nextConvNumToASCII:
            cmpa #$0A
            bcs next1ConvNumToASCII
            adda #$07

next1ConvNumToASCII:
            adda #$30 ; '0'
            staa 0,x
            inx
            rts
; End of function nextConvNumToASCII


; =============== S U B R O U T I N E =======================================

; FCT : Test si on appuie sur SHIFT+@
;       Si oui alors on attend la fin de l'appui
;       Si non on sort
; IN  : /
; OUT : /

ASS_TESTSHIFTAROBASE:
            jsr OS_POLCA                    ; FCT : polling keyboard
                                            ; IN  : /
                                            ; OUT : A=code ascii de la touche
                                            ;       X,B not modified
            cmpa #$13
            bne endASS_TESTSHIFTAROBASE

bcdlASS_TESTSHIFTAROBASE:
            jsr OS_POLCA                    ; FCT : polling keyboard
                                            ; IN  : /
                                            ; OUT : A=code ascii de la touche
                                            ;       X,B not modified
            beq bcdlASS_TESTSHIFTAROBASE
            bra ASS_TESTSHIFTAROBASE        ; FCT : Test si on appuie sur SHIFT+@
                                            ;       Si oui alors on attend la fin de l'appui
                                            ;       Si non on sort
                                            ; IN  : /
                                            ; OUT : /

endASS_TESTSHIFTAROBASE:
            rts
; End of function ASS_TESTSHIFTAROBASE

; ---------------------------------------------------------------------------
lgStrErr:       dc.b 6
aErreur_0:      dc.b "ERREUR"
; Tableau pour effectuer un formatage
; 1000;100;10;0
tabASS_FORMAT:  dc.w  $3E8, $64, $0A, $00

; =============== S U B R O U T I N E =======================================

; FCT : Demande  l'utilisateur s'il faut sauvegarder
;       ou excuter le rsultat de la compilation
; IN  : /
; OUT : A,X,Y modified

ASS_saveOrExecPrg:
            ldx  #(aFichierObjet-1)            ; "FICHIER OBJET ? "
            ldaa #cASS_LG_MAX_FILENAME
            jsr ASS_getInputUser               ; FCT : Affiche un message d'invite,
                                               ;       attend une saisie utilisateur limite  une longueur A
                                               ; IN  : A=longueur maximale de la saisie utilisateur
                                               ;       X=Position de la chane  afficher sur la ligne d'tat
                                               ; OUT : A=Code de la touche actionne par l'utilisateur
                                               ;       X=modified
            cmpa #cOS_CR
            bne printExecImm

initHeaderK7_LM:
            ldx # cASS_K7_SAV_BIN
            stx ASS_SAVE_HEADER_K7_LM_BINAIRE  ; Peut prendre la valeur $0200, $0500
                                               ; si $0200 alors ($02=langage machine) et ($00=binaire)
                                               ; si $0500 alors ($05=fichier texte de l'diteur) et ($00=binaire)
            ldaa #$01
            staa ASS_SAVE_HEADER_K7_CONTIGU    ; peut prendre la valeur 1 : contigu (code assembleur)
            ldx ASS_COMP_EXC                   ; Pointeur sur le dbut du code  excuter
            stx ASS_SAVE_HEADER_K7_EXEC        ; Adresse d'excution
            ldx ASS_COMP_LOAD
            stx ASS_SAVE_HEADER_K7_LOAD        ; Adresse de chargement

sendBLKFILENAME_TO_K7:                         ; Position du curseur d'dition
            ldx #ASS_BUF_CURINP_BOT
            stx pTMP_K7                        ; pointeur servant  tout ... FILENAME,CLOAD,CSAVE...
            jsr doWriteBLOCKFILENAME

sendBLKOBJET_TO_K7:                            ; dbut du programme objet
            ldx ASS_OBJ_BEGIN
            inx
            stx pMEMBEGIN_K7
            ldx ASS_OBJ_END                    ; Fin du programme objet
            stx pMEMEND_K7
            jsr next1RomCSAVE

printExecImm:
            ldx #(aEXECIMM-1)                  ; "EXECUTION IMMEDIATE ? "
            ldaa #$03
            jsr ASS_getInputUser               ; FCT : Affiche un message d'invite,
                                               ;       attend une saisie utilisateur limite  une longueur A
                                               ; IN  : A=longueur maximale de la saisie utilisateur
                                               ;       X=Position de la chane  afficher sur la ligne d'tat
                                               ; OUT : A=Code de la touche actionne par l'utilisateur
                                               ;       X=modified
            ldaa ASS_BUF_CURINP_BOT            ; Position du curseur d'dition
            cmpa #$4F ; 'O'
            beq doExecIMM
            rts

doExecIMM:
            ldx ASS_COMP_LOAD
            cpx ASS_MEMMAX
            bcs printAdrIncorrecte
            cpx ASS_OBJ_BEGIN               ; dbut du programme objet
            bcs next1DoExecIMM
            ldx ASS_OBJ_END                 ; Fin du programme objet

bclDoExecIMM:
            ldaa 0,x
            dex
            pshx
            ldx ASS_CURADRCMP               ; Adresse du rsultat de la compilation
            staa 0,x
            dex
            stx ASS_CURADRCMP               ; Adresse du rsultat de la compilation
            pulx
            cpx ASS_OBJ_BEGIN               ; dbut du programme objet
            bne bclDoExecIMM
            bra goExecImm

next1DoExecIMM:
            ldx ASS_OBJ_BEGIN               ; dbut du programme objet

bcl2DoExecIMM:
            inx
            ldaa 0,x
            pshx
            ldx ASS_COMP_LOAD
            staa 0,x
            inx
            stx ASS_COMP_LOAD
            pulx
            cpx ASS_OBJ_END                 ; Fin du programme objet
            bne bcl2DoExecIMM

goExecImm:
            lds ASS_SAVEREGS_PERCENT
            ldx ASS_COMP_EXC                ; Pointeur sur le dbut du code  excuter
            jmp 0,x

printAdrIncorrecte:
            ldx #(aAdrIncorrecte-1)         ; "ADRESSE INCORRECTE !!! "
            jsr ASS_getInputUser            ; FCT : Affiche un message d'invite,
                                            ;       attend une saisie utilisateur limite  une longueur A
                                            ; IN  : A=longueur maximale de la saisie utilisateur
                                            ;       X=Position de la chane  afficher sur la ligne d'tat
                                            ; OUT : A=Code de la touche actionne par l'utilisateur
                                            ;       X=modified
            rts
; End of function ASS_saveOrExecPrg

; ---------------------------------------------------------------------------
aFichierObjet:      dc.b "FICHIER OBJET ? ",0
aEXECIMM:           dc.b "EXECUTION IMMEDIATE ? ",0
aAdrIncorrecte:     dc.b "ADRESSE INCORRECTE !!! ",0

; =============== S U B R O U T I N E =======================================

; FCT : Imprime le rsultat de la compilation
;       c'est  dire : le nombre d'erreur pour les deux passes de compilation
;       puis la liste des symboles
; IN  : /
; OUT : A,B,X modified

ASS_showResultatCompilation:
            tst ASS_FLGSHOWPARSE            ; Flag indiquant qu'il y a eu un demande de compilation
            bne nextShowResultatCompilation
            rts

nextShowResultatCompilation:
            ldaa ASS_DEVNU                  ; Indique la port de sortie du listing (0 : ECRAN; 1 : IMPRIMANTE)
            staa DEVNU                      ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante

printSPACE_0:
            ldaa #cOS_SPACE                 ; ' '
            jsr OS_printCHAR                ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                            ; IN  : A=caractre  imprimer
                                            ;       DEVNU mise  jour
                                            ; OUT : B, X unmodified

printCR_1:
            ldaa #cOS_CR
            jsr OS_printCHAR                ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                            ; IN  : A=caractre  imprimer
                                            ;       DEVNU mise  jour
                                            ; OUT : B, X unmodified

passeUne:
            clra
            ldab ASS_ERR_PASSE_1
            jsr ASS_printErreurPasse        ; FCT : Affiche le nombre d'erreur B pour le numro de passe A
                                            ; IN  : A=numro de  passe avec A=[0..1]
                                            ;       B=nombre d'erreurs pour la passe A
                                            ; OUT : A,B,X modified

passeDeux:
            ldaa #$01
            ldab ASS_ERR_PASSE_2
            bsr ASS_printErreurPasse        ; FCT : Affiche le nombre d'erreur B pour le numro de passe A
                                            ; IN  : A=numro de  passe avec A=[0..1]
                                            ;       B=nombre d'erreurs pour la passe A
                                            ; OUT : A,B,X modified

printSymboles:
            ldx #aSymboles-1                ; "SYMBOLES :\r--------\r"
            jsr OS_OUTTX                    ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                            ; IN : X=pointeur sur une chane de caractres termine par un 0
                                            ; OUT: A,B,X modified
            jsr ASS_initBuffer              ; FCT : INTIALISE le tampon ASS_BUF_CURINP_BOT rceptionnant
                                            ;       les donnes  afficher via le DEVICE en cours (ou pas)
                                            ; IN  : /
                                            ; OUT : A,X modified
            ldx ADRENDMEM                   ; Adresse de la fin de mmoire
            stx ASS_PTR_TMP_SYMB            ; Pointeur sur la liste des symboles compils (tiquettes, etc.)

bclCopySymboleAndAdr:
            ldaa #cASS_LG_NAME_SYMB
            staa ASS_VARTMP
            ldx #ASS_BUF_CURINP_BOT         ; Position du curseur d'dition

bc1lCopyNameOfSymb:
            stx ASS_VARTMP+1
            ldx ASS_PTR_TMP_SYMB            ; Pointeur sur la liste des symboles compils (tiquettes, etc.)
            cpx ASS_BOT_SYMB
            beq endPrintStringOfSymb
            ldd ASS_PTR_TMP_SYMB            ; Pointeur sur la liste des symboles compils (tiquettes, etc.)
            subd #cASS_LG_AREA_SYMB
            std ASS_PTR_TMP_SYMB            ; Pointeur sur la liste des symboles compils (tiquettes, etc.)
            clrb

bclCopyNameOfSymb:
            ldx ASS_PTR_TMP_SYMB            ; Pointeur sur la liste des symboles compils (tiquettes, etc.)
            abx
            ldaa 0,x
            ldx ASS_VARTMP+1
            abx
            staa 0,x
            incb
            cmpb #cASS_LG_NAME_SYMB
            bne bclCopyNameOfSymb
            inx

addEqual:
            ldaa #cBAS_EQUAL                 ; '='
            staa 0,x
            inx
            pshx

printADDRofSymbol:
            ldx ASS_PTR_TMP_SYMB            ; Pointeur sur la liste des symboles compils (tiquettes, etc.)
            ldd 5,x
            pulx
            jsr convNumToASCII              ; FCT : Convertit un nombre (octet) en sa reprsentation ASCII
                                            ; IN  : A=Nombre  convertir
                                            ;       X=Tampon de conversion
                                            ; OUT : X et A modified
            tba
            jsr convNumToASCII              ; FCT : Convertit un nombre (octet) en sa reprsentation ASCII
                                            ; IN  : A=Nombre  convertir
                                            ;       X=Tampon de conversion
                                            ; OUT : X et A modified
            inx
            dec ASS_VARTMP
            bne bc1lCopyNameOfSymb
            dex

endPrintsymbole:
            ldd #$0D00                      ; on termine la chane de caractres reprsentant les
                                            ; symboler  imprimer par un $0D $00
            std 0,x

printStringOfSymb:
            ldx #ASS_LEN_INP_USR            ; Longueur de la saisie utilisateur
            jsr OS_OUTTX                    ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                            ; IN : X=pointeur sur une chane de caractres termine par un 0
                                            ; OUT: A,B,X modified
            jsr ASS_TESTSHIFTAROBASE        ; FCT : Test si on appuie sur SHIFT+@
                                            ;       Si oui alors on attend la fin de l'appui
                                            ;       Si non on sort
                                            ; IN  : /
                                            ; OUT : /
            bra bclCopySymboleAndAdr

endPrintStringOfSymb:
            ldx ASS_VARTMP+1
            ldd #$0C00
            std 0,x
            ldx #ASS_LEN_INP_USR            ; Longueur de la saisie utilisateur
            jsr OS_OUTTX                    ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                            ; IN : X=pointeur sur une chane de caractres termine par un 0
                                            ; OUT: A,B,X modified
            clr DEVNU                       ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            rts
; End of function ASS_showResultatCompilation


; =============== S U B R O U T I N E =======================================

; FCT : Affiche le nombre d'erreur B pour le numro de passe A
; IN  : A=numro de passe avec A=[0..1]
;       B=nombre d'erreurs pour la passe A
; OUT : A,B,X modified

ASS_printErreurPasse:
            inca
            psha
            clra
            jsr LIPTR                       ; FCT : Imprime le chiffre contenu dans D
                                            ; IN  : D : le chiffre  afficher
                                            ; OUT : A,B,X modified
            ldx #aERREURSPASSE-1            ; " ERREUR(S) PASSE "
            jsr OS_OUTTX                    ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                            ; IN : X=pointeur sur une chane de caractres termine par un 0
                                            ; OUT: A,B,X modified
            clra
            pulb
            jsr LIPTR                       ; FCT : Imprime le chiffre contenu dans D
                                            ; IN  : D : le chiffre  afficher
                                            ; OUT : A,B,X modified

CR:
            ldaa #cOS_CR
            jsr OS_printCHAR                ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                            ; IN  : A=caractre  imprimer
                                            ;       DEVNU mise  jour
                                            ; OUT : B, X unmodified
            rts
; End of function ASS_printErreurPasse

; ---------------------------------------------------------------------------
aERREURSPASSE:  dc.b " ERREUR(S) PASSE ",0
aSymboles:      dc.b "SYMBOLES :",$D,"--------",$0D,0
OS_FREE_1:      dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF

; =============== S U B R O U T I N E =======================================

; FCT : Imprime le caractre A  la position actuelle du curseur
; IN  : A=caractre  imprimer
; OUT : A,B,X modified
;       CURAD_YX inchang

ASS_printCHARtCurrentPos:
            ldx CURAD_YX
            pshx
            jsr ASS_printCHWithTempo        ; FCT : Imprime un caractre puis temporise  $45E x  s
                                            ; IN  : A=caractre  imprimer
                                            ; OUT : /
            pulx
            stx CURAD_YX
            rts
; End of function ASS_printCHARtCurrentPos

; ---------------------------------------------------------------------------
OS_FREE_0:  dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 0
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 15
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 30
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 45
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 60
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 75
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 90
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 105
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 120
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 135
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 150
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 165
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 180
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 195
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 210
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 225
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 240
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 255
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 270
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 285
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 300
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 315
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 330
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 345
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF; 360
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF;   375

; =============== S U B R O U T I N E =======================================

vectorPercent:
            jmp dovectorPERCENT             ; FCT : Point d'entre pour lancer l'assembleur
                                            ; IN  : /
                                            ; OUT : /
; End of function vectorPercent
; =============== S U B R O U T I N E =======================================

vectorinitVIDEO_mode40:
            jmp initVIDEO_mode40            ; FCT : Permet d'initialiser le mode 40 colonnes 24 bits
                                            ;       Par dfaut, le dcoupage mmoire s'effectue de
                                            ;       la faon suivante :
                                            ;        RAM VIDEO : 8ko : $2000 soit 8192 octets
                                            ;        mode 40 col :  40x25 = 1000 octets, ligne de service 24 octets
                                            ;        0x0000 - $03FF : C : caractres
                                            ;        0x0400 - 0x07FF : B : attributs
                                            ;        0x0800 - 0x0AFF : A : couleurs
                                            ;        $0B00 - 0x1FFF : FREE
                                            ; IN  : /
                                            ; OUT : A,B,X modified
; End of function vectorinitVIDEO_mode40

; =============== S U B R O U T I N E =======================================

vectorInitCarSemiGraph_EF9345:
            jmp initCarSemiGraph_EF9345     ; FCT : Initialise les caractres semi-graphiques
                                            ;       identiques  ceux du premier ALICE  base de MC6847
                                            ;       car ceux de EF9345 ne sont pas les mmes !
                                            ; IN  : /
                                            ; OUT : A,B,modified
; End of function vectorInitCarSemiGraph_EF9345

; =============== S U B R O U T I N E =======================================

; FCT : Efface l'cran
; IN  : B=code couleur du fond de l'cran
; OUT : A,B,X modified

vectorCLRSCR:
            jmp GR_CLRSCR                   ; FCT : Efface l'cran
                                            ; IN  : B=code couleur
                                            ; OUT : A,B,X modified
; End of function vectorCLRSCR

; =============== S U B R O U T I N E =======================================

; FCT : Appel la routine de SCROLLING de l'cran
; IN  : /
; OUT : A et B unmodified

vectorSCROLLUP:
            jmp GR_SCROLLUP                 ; FCT : Excute un scrolling vers le haut de l'cran
                                            ;       La dernire ligne de l'cran est efface
                                            ; ALG : Dplacement de la ligne L+1 vers la ligne L via EF9345
                                            ; IN  : /
                                            ; OUT : A et B unmodified
; End of function vectorSCROLLUP

; =============== S U B R O U T I N E =======================================

; FCT : Stocke  la position X(Y,X) le caractre A
; IN  : A=caractre  afficher
;       X=POS (Y,X) du caractre  afficher
; OUT : A,B,X modified

vectorOS_PRINT:
            jmp OS_PRINT                    ; FCT : Imprime le caractre A dans  la mmoire vido
                                            ; IN  : A=CODE ASCII  imprimer ou couleur pixel
                                            ;       A=[32..127] et [128-255]
                                            ;       X=POS(Y,X)
                                            ; OUT : /
; End of function vectorOS_PRINT

; =============== S U B R O U T I N E =======================================

; FCT : vecteur pour la routine de lecture d'un
;   caractre en mmoire vido.
;   Retourne espace si ATTRIBUT sinon le code ascii
; IN  : X=POS(Y,X)
; OUT : A=$20 si ATTRIBUT
;   sinon CODE ASCII si A>$20 et A<=$7F
;   sinon CODE SEMI GRAPHIQUE si A>=$80

vectorGR_READ_ASCII:
            jmp GR_READ_ASCII               ; FCT : Lit le caractre  la position (Y,X) et retourne espace
                                            ;       si attribut sinon le code ASCII du caractre
                                            ; ST  : ACTIF
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : A=$20 si ATTRIBUT
                                            ;       sinon CODE ASCII si A>$20 et A<=$7F
                                            ;       sinon CODE SEMI GRAPHIQUE si A>=$80
                                            ;       X unmodified
; End of function vectorGR_READ_ASCII

; =============== S U B R O U T I N E =======================================

; FCT : Appelle la routine de gestion du curseur
;   Incrmente de 1 la position X et effectue un dfilement vers le haut si ncessaire
; IN  : X=POS(Y,X)
; OUT : Y=POS(Y,X+1)

vectorIncCurorAndScrollUp:
            jmp GR_doincX_AND_SCROLLUP      ; FCT : Incrmente de 1 la position du curseur  l'cran
                                            ;       et effectue un dfilement vers le haut si ncessaire
                                            ; IN  : X=pos(Y,X)
                                            ; OUT : X=pos(Y,X+1) + scrollup si ncessaire
; End of function vectorIncCurorAndScrollUp

; =============== S U B R O U T I N E =======================================

; FCT : Appelle la routine de dcrmentation de la position du curseur
; IN  : X=POS(Y,X)
; OUT : X=POS(Y,X-1)
;       A and B not modified

vectorDecCursor:
            jmp GR_decCursor                ; FCT : dcremente de 1 la position X,Y donne par le registre X
                                            ; IN  : X=La position (X,Y)
                                            ; OUT : X=X-1 en position (X,Y)
                                            ;       A et B not modified
; End of function vectorDecCursor

; =============== S U B R O U T I N E =======================================


vectorIncCursor:
            jmp GR_incCursor                ; FCT : Gestion du curseur physique : Incrmente de 1 la position horizontale
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : X=POS(Y,X+1)
                                            ;       A,B unmodified
; End of function vectorIncCursor

; =============== S U B R O U T I N E =======================================


vectorOS_CLRLINE:
            jmp GR_ClrLine                  ; FCT : Efface la ligne de la position de Y.
                                            ;       Les registres R1 et R2 doivent tre initialiss  la bonne valeur
                                            ; ST  : ACTIF
                                            ; IN  : X=POS(X,Y) de dpart
                                            ; OUT : A,B modified
                                            ;       X : unmodified
;End of function vectorOS_CLRLINE

; =============== S U B R O U T I N E =======================================


vectorGR_initVIDEO_mode80_NORM:
            jmp GR_initVIDEO_mode80_NORM     ; FCT : Initialise le EF9345 pour le mode 80 caractres en mode invers
                                            ; IN  : /
                                            ; OUT : A,B,X modified
; End of function vectorGR_initVIDEO_mode80_NORM

; ---------------------------------------------------------------------------
;----------------
tabScanCode:        dc.w TABNOR
                    dc.w TABCON
                    dc.w TABSHF
                    dc.w TABCON
;----------------

; =============== S U B R O U T I N E =======================================

; FCT : Appelle la routine d'effacement de l'cran selon le mode en cours
; IN  : X=POS(Y,X) position de la ligne  effacer
; OUT : A,B,X modified

vectorOS_clrLineByMode:
            jmp OS_clrLineByMode            ; FCT : Efface la ligne courante selon le mode graphique en cours
                                            ; IN  : X=POS(Y,X) position de la ligne  effacer
                                            ; OUT : A,B,X modified
; End of function vectorOS_clrLineByMode

; =============== S U B R O U T I N E =======================================

; FCT : vecteur pour appeller INASS : effacement de l'cran
; IN  : /
; OUT : /

INASS:
            jmp vectorINASS                 ; FCT : Initialise le mode HIRES
                                            ; IN  : /
                                            ; OUT : A,B,X modified
; End of function INASS

; ---------------------------------------------------------------------------

jmpNextDoEtCommercial:
            jmp nextDoEtCommercial

; ---------------------------------------------------------------------------
OS_FREE_2:      dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF;   0

; =============== S U B R O U T I N E =======================================

; FCT : test if EF9345 is ready
; IN  : /
; OUT : A,X,Y unmodified

isEF9345ready:
            psha
            ldaa #$80

bclIsEF9345ready:
            tst EF9345_R0
            bpl endIdEF9345ready
            deca
            bne bclIsEF9345ready
            bsr NOP_EF9345              ; FCT : excute on EF9345 a No OPeration
                                        ; IN  : /
                                        ; OUT : A modified

endIdEF9345ready:
            pula
            rts
; End of function isEF9345ready


; =============== S U B R O U T I N E =======================================

; FCT : Permet de paramtrer les registres TGS,MAT,PAT,DOR,ROR
; IN  : X=pointeur sur paramtrage pour  EF9345
; OUT : A,B,X modified

progEF9345:
            ldab #$05

bclProgEF9345:
            bsr isEF9345ready               ; B=nb octet  crire (R1,EXEC) X = position du paramtrage
            ldaa 0,x
            staa EF9345_R1
            ldaa 1,x
            staa EF9345_EXEC
            inx
            inx
            decb
            bne bclProgEF9345               ; B=nb octet  crire (R1,EXEC) X = position du paramtrage
            bsr isEF9345ready               ; FCT : test if EF9345 is ready
                                            ; IN  : /
                                            ; OUT : A,X,Y unmodified
            rts
; End of function progEF9345


; =============== S U B R O U T I N E =======================================

; FCT : Permet d'initialiser le mode 40 colonnes 24 bits
;   Par dfaut, le dcoupage mmoire s'effectue de
;   la faon suivante :
;    RAM VIDEO : 8ko : $2000 soit 8192 octets
;    mode 40 col :  40x25 = 1000 octets, ligne de service 24 octets
;    $0000 - $03FF : C : caractres
;    $0400 - $07FF : B : attributs
;    $0800 - $0AFF : A : couleurs
;    $0B00 - $1FFF : lire
; IN  : /
; OUT : A,B,X modified

initVIDEO_mode40:
            ldx #tabEF9345_MODE40       ; Init en mode 40 (puis on rgle plus loin dans la ROM les marges pour faire 32 col)
            bsr progEF9345              ; FCT : Permet de paramtrer les registres TGS,MAT,PAT,DOR,ROR
                                        ; IN  : X=pointeur sur paramtrage pour EF9345
                                        ; OUT : A,B,X modified

initRegEF9345:
            clra
            clrb
            staa EF9345_R1              ; R1=C =$00=0 0000000 DONT_CARE CODE CARACTERE
            staa EF9345_R3              ; R3=A =$00=0 000 0 000 : no reverse black foreground no flash black background
            std EF9345_R6               ; R6=MP=$0000 = service row
            inca
            staa EF9345_R2              ; R2:B =$01=0000 0 0 0 1 : 1 mode insert
            staa EF9345_EXEC            ; $01=KRF:0000 0 00 1 : KRF/WRITE/00/Pointer inc

initVRAM_InitVIDEO_mode40:
            bsr isEF9345ready           ; FCT : test if EF9345 is ready
                                        ; IN  : /
                                        ; OUT : A,X,Y unmodified
            clra
            std EF9345_R6               ; R6-R7=$0000 : MP
            incb
            std EF9345_R4               ; R4-R5=$00-01 : AP : 0000 0000-0000 0001
            ldaa #(cVDP_CMD_MVT+cVDP_COPY_MVP_TO_AP+cVDP_STOP_EOB) ; $F5
                                        ; $F5=MVT:1111 01 01 : MVT/MP->AP/stop at end of buffer
                                        ; ==> fill 40 bytes
            staa EF9345_EXEC
            bsr isEF9345ready           ; FCT : test if EF9345 is ready
                                        ; IN  : /
                                        ; OUT : A,X,Y unmodified

initvRAM_0x0800_0x1FFF:
            ldd #$0800
            std EF9345_R6               ; R6-R7 = $0800 : MP : 0000 1000-000 0000
            ldaa #(cVDP_CMD_MVT+cVDP_COPY_AP_TO_MVP+cVDP_STOP_NO) ; #$FA
                                        ; $FA=1111 10 10 : cmd : 1111 MVT (move triple buffer)
                                        ;              ss  : 10 = source AP destination MP
                                        ;              aa  : 10 = no stop
                                        ; AP is already setting to 0x28 ?
            staa EF9345_EXEC

setTempoInitVideo40:
            ldx #$0A00

bclI2nitVIDEO_mode40:
            dex
            bne bclI2nitVIDEO_mode40
; End of function initVIDEO_mode40


; =============== S U B R O U T I N E =======================================

; FCT : excute on EF9345 a No OPeration
; IN  : /
; OUT : A modified

NOP_EF9345:
            ldaa #(cVDP_CMD_NOP-1)          ; Cela devrait tre $91 et non pas $90 !
            staa EF9345_EXEC
            rts
; End of function NOP_EF9345

; ---------------------------------------------------------------------------
;----------------
;; MAT +    PAT : 40 colonnes mode long (R1,R2,R3)
;; $81=TGS,$10=00 0 1 0 0 0 0
;         0  : 625 lignes / 50Hz
;         0  : NOT INTERLACED
;         0  : HOR RESYNC DISABLED
;         0  : VERT RESYNC DISABLED
;         1  : Type SYNC OUT
;         0  : SERVICE ROW Y=0
;         00 : 40 CHAR/ROW MODE, LONG CHAR CODE (3 bytes) with PAT7
;; $82=MAT,$28=0 0 10 1 000
;         000 MARGE NOIRE
;         0   PAS DE CURSEUR
;         10  CURSEUR FIXE SOULIGNE
;         1   I SIGNAL AU NIVEAU HAUT DURANT LA PERIODE DE MARGE
;         0   PAS DE ZOOM
;; $83=PAT,$67=0 1 10 0 1 1 1
;   bit 7 0   40 CHAR/ROW MODE, LONG CODE with TGS7 and TGS6
;         1   FLASHING ENABLE
;         10  CHARACTER MARK (INSERT MODE)
;         0   CONCEAL DISABLE
;         1   LOWER BULK ENABLED
;         1   UPPER BULK ENABLED
;   bit 0 1   SERVICE ROW ENABLED
;; $84=DOR,$13=0 001 0011
;         0011 : ALPHA UDS SLICES IN BLOCK 3
;         001  : SEMI GRAPHIC UDS SLICES IN BLOCK 2 and 3
;         0    : QUADRICHROME SLICES FROM BLOCK 0
;; $87=ROR,$08=000 01000
;         010000 : ORIGIN ROW = 8
;         000    : Displayed Page Memory starts from block 0

VDP_40_TGS EQU (cVDP_TGS_625+cVDP_TGS_NO_INTERLACE+cVDP_TGS_NO_HOR_RESYNC+cVDP_TGS_NO_HOR_RESYNC+cVDP_TGS_NO_VER_RESYNC+cVDP_TGS_SYNC_OUT_COMP+cVDP_TGS_NO_SERVICE_ROW+cVDP_TGS_MODE_40_LONG)
VDP_40_MAT EQU (cVDP_MAT_NO_DBL_HEIGHT+cVDP_MAT_NO_CURSOR_DISP+cVDP_MAT_MD_CURS_FLS_CPL+cVDP_MAT_MARG_INS+cVDP_BLACK)
VDP_40_PAT EQU (cVDP_PAT_MODE_80_LONG+cVDP_PAT_FLASH_EN+cVDP_PAT_INS_MODE_CHAR_MARK+cVDP_PAT_NO_CONCEAL_EN+cVDP_PAT_DW_BULK_EN+cVDP_PAT_UP_BULK_EN+cVDP_PAT_SERVICE_ROW_EN)
VDP_40_DOR EQU (cVDP_DOR_HI_INS_HI+(cVDP_WHITE*16)+cVDP_DOR_HI_INS_LO+cVDP_GREEN)

tabEF9345_MODE40:
    dc.b VDP_40_TGS, cVDP_CMD_IND+cVDP_REG_TGS ; 0 : $10,$81
    dc.b VDP_40_MAT, cVDP_CMD_IND+cVDP_REG_MAT ; 2 : $28,$82
    dc.b VDP_40_PAT, cVDP_CMD_IND+cVDP_REG_PAT ; 4 : $67,$83
    dc.b $13       , cVDP_CMD_IND+cVDP_REG_DOR ; 6 : $13,$84
    dc.b $08       , cVDP_CMD_IND+cVDP_REG_ROR ; 8 : $08,$87

; =============== S U B R O U T I N E =======================================

; FCT : Set MP (R6 EF9345) from logical coordinate given by X
; IN  : X=POS(Y,X)
; OUT : A and B unmodified
;       X=POS(Y,X)

setR6_MP_EF9345:
            psha
            pshb
            bsr isEF9345ready               ; FCT : test if EF9345 is ready
                                            ; IN  : /
                                            ; OUT : A,X,Y unmodified
            bsr computeMP_EF9345            ; FCT : calcule la position compatible EF9345  partir
                                            ;       des coordonnes logiques fournies via le registre X
                                            ;       Rappel : Ligne 0 : numro de ligne = 0
                                            ;                Ligne >=1  numro de ligne  + 7
                                            ; IN  : X=(Y,X) position de l'cran logique
                                            ; OUT : D=(Y,X) position (X,Y) dans EF9345
            std EF9345_R6
            pulb
            pula
            rts
; End of function setR6_MP_EF9345


; =============== S U B R O U T I N E =======================================

; FCT : set value of R4 (AP)
; IN  : X=(Y,X) position de l'cran logique
; OUT : D modified

setR4_EF9345:
            bsr computeMP_EF9345            ; FCT : calcule la position compatible EF9345  partir
                                            ;       des coordonnes logiques fournies via le registre X
                                            ;       Rappel : Ligne 0 : numro de ligne = 0
                                            ;                Ligne >=1  numro de ligne  + 7
                                            ; IN  : X=(Y,X) position de l'cran logique
                                            ; OUT : D=(Y,X) position (X,Y) dans EF9345
            std EF9345_R4
            rts
; End of function setR4_EF9345


; =============== S U B R O U T I N E =======================================

; FCT : calcule la position compatible EF9345  partir
;       des coordonnes logiques fournies via le registre X
;       Rappel : Ligne 0 : numro de ligne = 0
;                Ligne >=1  numro de ligne + 7
; IN  : X=(Y,X) position de l'cran logique
; OUT : D=(Y,X) position (X,Y) dans EF9345

computeMP_EF9345:
            pshx                        ; si on avait eu TXD ...
            pula                        ; Coordonne Y
            pulb                        ; Coordonne X
            addd SCR_MARGEXY
            tsta
            beq nextComputeMP_EF9345
            adda #$07                   ; ajoute 7 si le numro de ligne > 0 (ah ! La joie du EF9345)

nextComputeMP_EF9345:
            tst TECRAN                  ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            bne endComputeMP_EF9345
            lsrb                        ; B=B/2 : numro de  colonne / 2 car mode 80 colonnes
            bcc endComputeMP_EF9345
            addb #$80                   ; B=B+$80 si colonne impaire

endComputeMP_EF9345:
            rts
; End of function computeMP_EF9345


; =============== S U B R O U T I N E =======================================

; FCT : Lit le caractre  la position (Y,X) et retourne espace
;       si attribut sinon le code ASCII du caractre
; ST  : ACTIF
; IN  : X=POS(Y,X)
; OUT : A=$20 si ATTRIBUT
;       sinon CODE ASCII si A>$20 et A<=$7F
;       sinon CODE SEMI GRAPHIQUE si A>=$80
;       X unmodified

GR_READ_ASCII:
            tst TECRAN                      ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            bne READ_ASCII_EF9345_LORES
            jmp READ_ASCII_EF9345_HIRES     ; FCT : Read CHAR + ATTRIBUT MODE 80 COL 12 bits
                                            ; IN  : X=POS(Y,X) de l'octet  lire
                                            ; OUT : A=$20 si attribut sinon le code ASCII

READ_ASCII_EF9345_LORES:
            bsr setR6_MP_EF9345             ; FCT : Set MP (R6 EF9345) from logical coordinate given by X
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : A and B unmodified
                                            ;       X=POS(Y,X)
            ldaa #(cVDP_CMD_KRF+cVDP_RD+cVDP_NO_INC)
                                            ; 0x08 : 0000/1/00/0:KRF/READ/null/No Inc pointer
            staa EF9345_EXEC                ; Lit la mmoire en  position POS(Y,X)
            jsr isEF9345ready               ; FCT : test if EF9345 is ready
                                            ; IN  : /
                                            ; OUT : A,X,Y unmodified

getColorLORES:
            ldab EF9345_R3                  ; READ A : code couleur xCCCyFFF avec CCC : couleur du caractre
                                            ;                                  et FFF : couleur du fond
                                            ;                                  et x   : mode inverse video (=1 oui)
                                            ;                                  et y   : clignotement du caractre

getAttribLORES:
            ldaa EF9345_R2                  ; READ B : attribut
            bmi next1READ_ASCII_EF9345_LORES; est-ce que l'attribut correspond  un caractre semi-graphique ?
                                            ; Si oui alors saut (car BIT 7 = 1)

getCharLORES:
            ldaa EF9345_R1                  ; READ C : caractre
            andb #$80                       ; $80: 1000 000 : mode inverse video activ ?
            beq nextREAD_ASCII_EF9345_LORES
            adda #$20 ; ' '

nextREAD_ASCII_EF9345_LORES:
            bsr convUnderscore              ; FCT : Si A=$0C alors conversion en code ASCII '_' sinon rien
                                            ; ST  : ACTIF
                                            ; IN  : A=$0C
                                            ; OUT : A=$5F si A=0X0C ou A
            rts                             ; TODO jmp convUnderscore au lieu de BSR + RTS ...
; ---------------------------------------------------------------------------
; -- En entre
; A = attribut : jeu de caractres L  M H i
;       avec i : bit d'inscrutation
;            H : double hauteur
;            M : bit de masqage
;            L : double largeur
; B = code couleur : xFFFyCCC

next1READ_ASCII_EF9345_LORES:
            anda #$01                   ; =1 inscrustation autoris
            bne next2READ_ASCII_EF9345_LORES
            clrb

next2READ_ASCII_EF9345_LORES:
            pshx
            ldx #tabEF9345_COLOR
            andb #$70                   ; $70=$01110000 : ne garder que la couleur du fond
                                        ; si mode inscrustation active
            asrb
            asrb
            asrb
            asrb                        ; B=00000FFF
            abx                         ; X=tabEF9345_COLOR[couleur du fond]
            ldaa EF9345_R1              ; rcupration du charactre
            anda #$DF                   ; A AND $DF=1101 1111 - Annulation du 6me bit
            oraa 0,x                    ; A= A OR tabEF935_COLOR[couleur de fond]
                                        ; note : le quartet infrieur de A garde sa valeur
                                        ; seul le quartet suprieur de A est mis  jour par
                                        ; le OR du fait des valeurs du tableau
            pulx
            rts
; End of function GR_READ_ASCII


; =============== S U B R O U T I N E =======================================

; FCT : Si A=$0C alors conversion en code ASCII '_' sinon rien
; ST  : ACTIF
; IN  : A=$0C
; OUT : A=$5F si A=0X0C ou A

convUnderscore:
            cmpa #$0C
            bne endConvUnderscore
            ldaa #$5F ; '_'

endConvUnderscore:
            rts
; End of function convUnderscore

; ---------------------------------------------------------------------------
; Tableau de conversion pour les couleurs
tabEF9345_COLOR:  dc.b $F0,$B0,$80,$90,$A0,$E0,$D0,$C0

; =============== S U B R O U T I N E =======================================

; FCT : Efface l'cran
; IN  : B=code couleur
; OUT : A,B,X modified

GR_CLRSCR:
            tba
            bsr computeParamColor_EF9345    ; FCT : compute param (A=R1,B=R2,C=R3) for COLOR given by A
                                            ; IN  : A=code ascii
                                            ; OUT : A, B modified ; X unmodified
            ldx HOME_YX                     ; il faut bien commencer  un endroit ...

bclDoCLRSCR:
            jsr GR_ClrLine                  ; FCT : Efface la ligne de la position de Y.
                                            ;       Les registres R1 et R2 doivent tre initialiss  la bonne valeur
                                            ; ST  : ACTIF
                                            ; IN  : X=POS(X,Y) de dpart
                                            ; OUT : A,B modified
                                            ;       X : unmodified
            pshx                            ; opration  : Y=Y+1 et X=(Y+1,X)
            pula
            inca                            ; Y=Y+1
            psha
            pulx
            cmpa SCR_LGY                    ; Nous avons atteint le nombre de lignes maximales ?
            bne bclDoCLRSCR                 ; non alors on boucle
            rts
; End of function GR_CLRSCR


; =============== S U B R O U T I N E =======================================

; FCT : compute param (A=R1,B=R2,C=R3) for COLOR given by A
; IN  : A=code ascii
; OUT : A, B modified ; X unmodified

computeParamColor_EF9345:
            tst TECRAN                      ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            bne computeParamColor_EF9345_LORES
            jmp treatHICHAR_HIRES           ; FCT : Imprime caractre plein si mod $F sinon espace
                                            ; IN  : A=caractre  dont l'intervalle est 0x80-0xFF
                                            ; OUT : A et B modified
; ---------------------------------------------------------------------------
;A=x CCC cccc avec x    : dont'care
;                  CCC  : code couleur
;                  cccc : code du caractre semi-graphique

computeParamColor_EF9345_LORES:
            tab
            anda #$F                        ; keep low nibble : on rcupre code semi-graphique (pav de 2x2 pixels)
            oraa #$20 ; ' '                 ; $20 : 0 01000 00 : don't care/N de tampon/N du caractre
                                            ; dans le tampon de redfinition des caractres (compatibilit
                                            ; avec les ALICE de premire gnration)
            staa EF9345_R1                  ; stockage dans R1 du caractre  afficher
            pshx

computeColorForSemiGraph:
            ldx #tabColor
            andb #$70                       ; $70:0 111 0000 : ne garder que le code couleur pour le caractre ....
            lsrb
            lsrb
            lsrb
            lsrb
            abx

setColor:
            ldab #$B1                       ; B=$B1 : 1011 0 0 0 1 / G'11 _ _ _ incrustation
            ldaa 0,x                        ; rcupration du code de couleur en table
            bne setR3R2
            ldaa #$30                       ; A=$30=0 011 / 0 000
            andb #$FE                       ; B=$B1 AND $FE = $B0 = 1011 0 0 0 1 / G'11 _ _ _ pas d'incrustation

setR3R2:
            staa EF9345_R3                  ; set color background and foreground
            stab EF9345_R2                  ; set mode demi-graphique
            pulx
            rts
; End of function computeParamColor_EF9345

; ---------------------------------------------------------------------------
; Code couleur
; $20 : vert  $30 : jaune $40 : bleu   $10 : rouge
; $70 : blanc $60 : cyan  $50 : violet $00 : orange
tabColor:   dc.b cVDP_GREEN*16,cVDP_YELLOW*16,cVDP_BLUE*16,cVDP_RED*16,cVDP_WHITE*16,cVDP_CYAN*16,cVDP_MAGENTA*16,cVDP_ORANGE


; =============== S U B R O U T I N E =======================================

; FCT : Initialise les caractres semi-graphiques
;       identiques  ceux du premier ALICE  base de MC6847
;       car ceux de EF9345 ne sont pas les mmes !
; IN  : /
; OUT : A,B,modified

initCarSemiGraph_EF9345:
            ldaa #(cVDP_CMD_OCT+cVDP_WR+cVDP_USE_AUX+cVDP_NO_INC)
                                            ; $34(0011 0 1 0 0) : OCT/Write/AuxiliaryPtr/null/NoInc
            staa EF9345_R0
            ldx #tab9345SLICE

bclInitCarSemiGraph_EF9345:
            ldd 0,x
            pshx
            bsr initSLICE                   ; FCT : Initialise les SLICE en mmoire selon le registre D
                                            ; IN  : D=valeur du slice
                                            ; OUT : A,B,X modified
            pulx
            inx
            inx
            cpx #(tab9345SLICE+8)
            bne bclInitCarSemiGraph_EF9345
            rts
; End of function initCarSemiGraph_EF9345


; =============== S U B R O U T I N E =======================================

; FCT : Initialise les SLICE en mmoire selon le registre D
; IN  : D=valeur du slice
; OUT : A,B,X modified

initSLICE:
            pshb
            ldab #$C0                       ; R4:$C0 : 11 0 00000 dont_care/Z2/C6-C2
            std EF9345_R4                   ; init AuxilliaryPointer partie Y
            pula
            ldx #(tab9345SLICE+1)

bclinitSLICE:
            ldab 0,x
            psha
            bsr createOneSLICE              ; FCT : valeurs  stocker par colonne (dfinition 2 col x 5 lignes)
                                            ; IN  : A=valeur de la colonne gauche
                                            ;       B=valeur de la colonne droite
                                            ; OUT : A,B modified
            pula
            ldab EF9345_R5
            andb #$C3                       ; 0xC3 : 1100 0011
            incb
            stab EF9345_R5
            inx
            inx
            cmpb #$C4
            bne bclinitSLICE
            rts
; End of function initSLICE


; =============== S U B R O U T I N E =======================================

; FCT : valeurs  stocker par colonne (dfinition 2 col x 5 lignes)
; IN  : A=valeur de la colonne gauche
;       B=valeur de la colonne droite
; OUT : A,B modified

createOneSLICE:
            pshb
            bsr doCreateOneSLICE
            pula

doCreateOneSLICE:
            ldab #$05

bclCreateOneSLICE:
            pshb
            staa EF9345_R9                  ; R9 : DATA to store private MEM video
            jsr isEF9345ready               ; FCT : test if EF9345 is ready
                                            ; IN  : /
                                            ; OUT : A,X,Y unmodified

setNextSlice:
            ldab EF9345_R5                  ; compute next slice
            addb #$04
            stab EF9345_R5
            pulb
            decb
            bne bclCreateOneSLICE
            rts
; End of function createOneSLICE

; ---------------------------------------------------------------------------
tab9345SLICE:       dc.b    $08,$00         ; 0
                    dc.b    $09,$F0         ; 2
                    dc.b    $0A,$0F         ; 4
                    dc.b    $0B,$FF         ; 6

; =============== S U B R O U T I N E =======================================

; FCT : Excute un scrolling vers le haut de l'cran
;       La dernire ligne de l'cran est efface
; ALG : Dplacement le ligne L+1 vers la ligne L via EF9345
; IN  : /
; OUT : A et B unmodified

GR_SCROLLUP:
            psha
            pshb
            ldx HOME_YX                     ; Position de l'cran en haut  gauche =(0,0)

bclX_EF9345_SCROLLUP:
            jsr setR6_MP_EF9345             ; FCT : Set MP (R6 EF9345) from logical coordinate given by X
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : A and B unmodified
                                            ;       X=POS(Y,X)
            pshx                            ; quel bordel pour faire +1 sur la position de ligne !
            pula
            inca
            psha
            pulx
            psha
            jsr setR4_EF9345                ; FCT : set value of R4 (AP)
                                            ; IN  : X=(Y,X) position de l'cran logique
                                            ; OUT : D modified
            ldab #(cVDP_CMD_MVT+cVDP_COPY_AP_TO_MVP+cVDP_STOP_EOB)
                                            ; EXEC CMD $F9 = 1111 10 01 :
                                            ;            (1111) MVT
                                            ;            (11) copy AP -> MP
                                            ;            (01) stop at the end of buffer
            stab EF9345_EXEC
            jsr isEF9345ready               ; FCT : test if EF9345 is ready
                                            ; IN  : /
                                            ; OUT : A,X,Y unmodified
            pula
            inca
            cmpa SCR_LGY
            bne bclX_EF9345_SCROLLUP
            stx CURAD_YX

clearOneLine:
            bsr OS_clrLineByMode            ; FCT : Efface la ligne courante selon le mode graphique en cours
                                            ; IN  : X=POS(Y,X) position de la ligne  effacer
                                            ; OUT : A,B,X modified
            pulb
            pula
            rts
; End of function GR_SCROLLUP


; =============== S U B R O U T I N E =======================================

; FCT : Efface la ligne courante selon le mode graphique en cours
; IN  : X=POS(Y,X) position de la ligne  effacer
; OUT : A,B,X modified

OS_clrLineByMode:
            tst TECRAN                      ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            bne OS_clrLineLORES
            jmp GR_clrLineHIRES             ; FCT : Efface une ligne en mode haute rsolution
                                            ; IN  : /
                                            ; OUT : A,B,X modified

OS_clrLineLORES:
            ldaa ColorBG_SCR_LINE           ; Couleur du fond de la ligne insre suite au scrolling de l'cran
            staa EF9345_R3                  ; DATA (A)

nextOS_clrLineLORES:
            ldaa #$01                       ; Dfinition des attributs : mode insert
            staa EF9345_R2                  ; DATA (B)
            ldaa #cOS_PLEIN                 ; $7F : caractre plein
            staa EF9345_R1                  ; DATA (C)
            jsr GR_ClrLine                  ; FCT : Efface la ligne de la position de Y.
                                            ;       Les registres R1 et R2 doivent tre initialiss  la bonne valeur
                                            ; ST  : ACTIF
                                            ; IN  : X=POS(X,Y) de dpart
                                            ; OUT : A,B modified
                                            ;       X : unmodified
            rts
; End of function OS_clrLineByMode


; =============== S U B R O U T I N E =======================================

; FCT : Efface la ligne de la position de Y.
;       Les registres R1 et R2 doivent tre initialiss  la bonne valeur
; ST  : ACTIF
; IN  : X=POS(X,Y) de dpart
; OUT : A,B modified
;   X : unmodified

GR_ClrLine:
            tst TECRAN                      ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            bne GR_ClrLine_LORES
            jmp GR_ClrLine_HIRES            ; FCT : Efface la ligne  la position (X,Y) en mode HIRES
                                            ; IN  : X=POS(X,Y) de dpart
                                            ; OUT : X unmodified

GR_ClrLine_LORES:
            jsr setR6_MP_EF9345             ; FCT : Set MP (R6 EF9345) from logical coordinate given by X
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : A and B unmodified
                                            ;       X=POS(Y,X)
            ldab XMAX_SCR                   ; longueur d'un cran

bclGR_ClrLine_LORES:
            jsr doWriteKRF_EF9365           ; FCT : Store A,B,C(R3,R2,41) to MP (R6,R7) + increment
                                            ; IN  : /
                                            ; OUT : A modified
            decb
            bne bclGR_ClrLine_LORES
            rts
; End of function GR_ClrLine


; =============== S U B R O U T I N E =======================================

; FCT : Imprime le caractre A dans la mmoire vido
; IN  : A=CODE ASCII  imprimer ou couleur pixel
;   A=[32..127] et [128-255]
;   X=POS(Y,X)
; OUT : /

OS_PRINT:
            tst TECRAN                      ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            bne OS_PRINT_LORES
            jmp GR_PRINT_HIRES              ; FCT : crit en mmoire vido le caractre A en position X(YX)
                                            ; IN  : A: le caractre  crire
                                            ;       range : 0x00-0x1F : ne fait rien (pas d'affichage)
                                            ;               0x20-0x7F : caractre ASCII
                                            ;               0x80-0xFF : ?
                                            ;       X: la position(Y,X) o crire le caractre
                                            ; OUT : A,B modified

OS_PRINT_LORES:
            jsr isEF9345ready               ; FCT : test if EF9345 is ready
                                            ; IN  : /
                                            ; OUT : A,X,Y unmodified
            cmpa #$20 ; ' '
            bcs endReadKRF_EF9365           ; Si A < $20 alors on ne fait rien !
            cmpa #$80
            bcs nextPRINT_ASCII_LORES       ; Si A < $80 alors c'est un caractre imprimable

PRINT_SEMI_GRAPHIC_LORES:
            jsr computeParamColor_EF9345    ; FCT : compute param (A=R1,B=R2,C=R3) for COLOR given by A
                                            ; IN  : A=code ascii
                                            ; OUT : A, B modified ; X unmodified
            bra next2PRINT_LORES

nextPRINT_ASCII_LORES:
            ldab #$01                       ; $01:0000 0001 : mode G0/no dbl width/no conceal/no double height/insert
            stab EF9345_R2
            ldab ColorFGBG_CAR              ; Couleur de fond et d'criture du caractre !
            cmpa #$60 ; '`'
            bmi next1PRINT_LORES
            orab #$80
            suba #$20 ; ' '

next1PRINT_LORES:
            stab EF9345_R3                  ; Couleur : x FFF y CCC
            bsr storeAToR1_EF9345           ; FCT : stocke A dans R1 du EF9345;
                                            ;       Si A=$5F alors on stocke $0C dans R1
                                            ; IN  : A=caractre  stocker dans R1 :$ 00-$7F
                                            ; OUT : A=$0C si A=$5F sinon inchang

next2PRINT_LORES:
            jsr setR6_MP_EF9345             ; FCT : Set MP (R6 EF9345) from logical coordinate given by X
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : A and B unmodified
                                            ;       X=POS(Y,X)
; End of function OS_PRINT

; =============== S U B R O U T I N E =======================================

; FCT : Store A,B,C(R3,R2,41) to MP (R6,R7) + increment
; IN  : /
; OUT : A modified

doWriteKRF_EF9365:

            ldaa #cVDP_CMD_KRF+cVDP_WR+cVDP_INC     ; $01 : 0000 0 00 1 : KRF (40 COL / 24 bits) write IncPtr
            staa EF9345_EXEC
            jsr isEF9345ready                       ; FCT : test if EF9345 is ready
                                                    ; IN  : /
                                                    ; OUT : A,X,Y unmodified

endReadKRF_EF9365:
            rts
; End of function doWriteKRF_EF9365


; =============== S U B R O U T I N E =======================================

; FCT : stocke A dans R1 du EF9345;
;       Si A=$5F alors on stocke $0C dans R1
; IN  : A=caractre  stocker dans R1 :$ 00-$7F
; OUT : A=$0C si A=$5F sinon inchang

storeAToR1_EF9345:
            cmpa #$5F                               ;  $5F : code ascii de l'underscore '_'
            bne endStoreAToR1_EF9345
            ldaa #$0C

endStoreAToR1_EF9345:
            staa EF9345_R1
            rts
; End of function storeAToR1_EF9345


; =============== S U B R O U T I N E =======================================

; FCT : Initialise le mode HIRES
; IN  : /
; OUT : A,B,X modified

vectorINASS:
            bsr GR_initColorASM             ; FCT : Initialise les couleurs de l'cran, du caractre
                                            ;       affich en mode HIGH RESOLUTION
                                            ; IN  : /
                                            ; OUT : A modified
            clr Attribute_HIRES             ; contient l'attribut du caractre en mode haute rsolution
                                            ; Par dfaut contient $00 (mode inversion) sinon $88.
                                            ; C'est un nibble donc l'attribut doit tre rpt 2
                                            ; fois dans l'octet (car colonne paire/impaire !)
                                            ; Sinon cela fait des effets sympas
            tst TECRAN                      ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            beq nextVectorINASS_HIRES_NORM
            ldaa #cVDP_MODE_40x25
            staa TECRAN                     ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            jmp next1DoRomCLS_setMode40

nextVectorINASS_HIRES_NORM:
            jsr GR_initVIDEO_mode80_ASS     ; FCT : Initialise le EF9345 pour le mode 80 caractres en mode assembleur
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            jmp next2DoRomCLS
; End of function vectorINASS


; =============== S U B R O U T I N E =======================================

; FCT : Initialise la couleur de fond et d'encre par dfaut
;       en mode LOW RESOLUTION
; IN  : /
; OUT : A modified

GR_initColorLOWRES:
            ldaa #(cVDP_GREEN*16)+cVDP_GREEN       ; $22 : 0 010 0 010 : NO_NEGATIVE / C1=GREEN / NO_FLASH / C0=GREEN
            staa ColorBG_SCR_LINE                  ; Couleur du fond de la ligne insre suite au scrolling de l'cran
            ldaa #(cVDP_BLACK*16)+cVDP_GREEN       ; $02
            staa ColorFGBG_CAR                     ; Couleur de fond et d'criture du caractre !
            ldaa #(cVDP_GREEN*64)+cVDP_PLEIN_LO    ; $8F : $80:vert, $90:jaune, $A0:bleu, $B0:rouge, $C0:blanc; $D0:cyan; $E0:violet; $F0:orange
            staa ColorCLS
            rts
; End of function GR_initColorLOWRES


; =============== S U B R O U T I N E =======================================

; FCT : Initialise les couleurs de l'cran, du caractre
;       affich en mode HIGH RESOLUTION pour la partie ASSEMBLEUR
; IN  : /
; OUT : A modified

GR_initColorASM:
            ldaa #(cVDP_BLUE*16)+cVDP_BLUE         ; $44 : 0 100 / 0 100 : NO_NEGATIVE / C1=BLUE / NO_FLASH / C0=BLUE			
            staa ColorBG_SCR_LINE                  ; Couleur du fond de la ligne insre suite au scrolling de l'cran
            ldaa #(cVDP_WHITE*16)+cVDP_BLUE        ; $74
            staa ColorFGBG_CAR                     ; Couleur de fond et d'criture du caractre !
            ldaa #(cVDP_BLUE*40)+cVDP_PLEIN_LO     ; $AF : $80:vert, $90:jaune, $A0:bleu, $B0:rouge, $C0:blanc; $D0:cyan; $E0:violet; $F0:orange
            staa ColorCLS                          ; Couleur pour effacer l'cran
            rts
; End of function GR_initColorASM

; ---------------------------------------------------------------------------
OS_FREE_3:      dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF

; =============== S U B R O U T I N E =======================================

; FCT : Mode text 32x16, efface l'cran, autorepeat non autoris,
;       Initialise le pointeur sur les tableaux de conversions ASCII du clavier
;       Initialise les couleurs du fond et d'encre de l'cran
; IN  : /
; OUT : A,B,X modified

doInitGraphAndKbd:
            ldaa #cVDP_MODE_32x16
            staa TECRAN                 ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            clr fAUTOREPEAT             ; =0:no autorepat;<>0:AUTOREPAT ON et est dcremente
                                        ; d'1 unit  chaque rptition

initPTRTABCONVASCII:
            ldx #tabScanCode
            stx TABAD                   ; pointeur sur les tableaux de conversion KEYB -> ASCII

nextDoRomCLS:
            jsr GR_initColorLOWRES      ; FCT : Initialise la couleur de fond et d'encre par dfaut
                                        ;       en mode LOW RESOLUTION
                                        ; IN  : /
                                        ; OUT : A modified

isLowOrHighRes:
            tst TECRAN                  ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            bne next1DoRomCLS_setMode40

setEF9345toHires:
            jsr vectorGR_initVIDEO_mode80_NORM
            bra next2DoRomCLS

next1DoRomCLS_setMode40:
            jsr vectorinitVIDEO_mode40
            jsr vectorInitCarSemiGraph_EF9345

next2DoRomCLS:
            jsr GR_initParamByDevice    ; FCT : INIT PARAM BASIC POUR ECRAN SELON LE MODE
                                        ; IN  : /
                                        ; OUT : X,A,B modified
            jsr GRNCH                   ; FCT : GRNCH : efface l'cran selon le mode donn par TECRAN
                                        ; IN  : /
                                        ; OUT : /
            rts
; End of function doInitGraphAndKbd


; =============== S U B R O U T I N E =======================================

; FCT : Affiche la caractre A  la position (X-1,Y) donne par X=(Y,X)
; ST  : NON ACTIF
; IN  : A=caractre  afficher
;       X=pos(X,Y) : position du caractre  afficher avec X+1
; OUT : A,B,X modified

GR_printChar_Xminus1:
            jsr GR_decCursor            ; FCT : dcremente de 1 la position  X,Y donne par le registre X
                                        ; IN  : X=La position (X,Y)
                                        ; OUT : X=X-1 en position (X,Y)
                                        ;       A et B not modified
            bsr jsrjsrPRINT_EF9345      ; FCT : Stocke  la position X=POS(Y,X) le caractre A
                                        ; IN  : A=caractre  afficher
                                        ;       X=POS (Y,X) du caractre  afficher
                                        ; OUT : A,B,X modified
            rts
; End of function GR_printChar_Xminus1


; =============== S U B R O U T I N E =======================================

; FCT : Affiche la caractre A  la position (X,Y) donne par X=(Y,X)
;       puis effectue un scrolling si X=X+1 fait retourner  la ligne suivante
; ST  : NON ACTIF
; IN  : A=caractre  afficher
;       X=pos(Y,X) : position du caractre  afficher
; OUT : A,B,X modified

GR_printChar_AndScroll:
            bsr jsrjsrPRINT_EF9345      ; FCT : Stocke  la position X=POS(Y,X) le caractre A
                                        ; IN  : A=caractre  afficher
                                        ;       X=POS (Y,X) du caractre  afficher
                                        ; OUT : A,B,X modified
            jsr GR_doincX_AND_SCROLLUP  ; FCT : Incrmente de 1 la position du curseur  l'cran
                                        ;       et effectue un dfilement vers le haut si ncessaire
                                        ; IN  : X=pos(Y,X)
                                        ; OUT : X=pos(Y,X+1) + scrollup si ncessaire
            rts
; End of function GR_printChar_AndScroll


; =============== S U B R O U T I N E =======================================

; FCT : Imprime le caractre A
; IN  : A=char to print
; OUT : A unmodified

GR_printCHARAtCurrentPos:
            psha
            ldx CURAD_YX
            bsr jsrjsrPRINT_EF9345      ; FCT : Stocke  la position X=POS(Y,X) le caractre A
                                        ; IN  : A=caractre  afficher
                                        ;       X=POS (Y,X) du caractre  afficher
                                        ; OUT : A,B,X modified
            pula
            rts
; End of function GR_printCHARAtCurrentPos


; =============== S U B R O U T I N E =======================================

; FCT : Imprime le caractre stock en B
; IN  : B=caractre  imprimer
; OUT : A not modified

GR_printCHARfromBAtCURAD_YX:
            psha
            ldx CURAD_YX
            bsr moveBtoABeforeJ_WRITE_EF9345        ; FCT :  Stocke  la position X=POS(Y,X) le caractre B
                                                    ; IN  : B=caractre  afficher
                                                    ;       X=POS (Y,X) du caractre  afficher
                                                    ; OUT : A,B,X modified
            pula
            rts
; End of function GR_printCHARfromBAtCURAD_YX


; =============== S U B R O U T I N E =======================================

; FCT : Obtient le code couleur du fond du caractre
; IN  : X=POS(Y,X)
; OUT : A=unmodified
;       B=0 si caractre lu est un attribut ou un caractre
;       sinon le code caractre AND $70 (0111 0000)

GR_getBackColor:
            psha
            jsr vectorGR_READ_ASCII         ; FCT : vecteur pour la routine de lecture d'un
                                            ;       caractre en mmoire vido.
                                            ;       Retourne espace si ATTRIBUT sinon le code ascii
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : A=$20 si ATTRIBUT
                                            ;       sinon CODE ASCII si A>$20 et A<=$7F
                                            ;       sinon CODE SEMI GRAPHIQUE si A>=$80
            tab
            bpl enddGetBackColor
            andb #$70
			SKIP1                           ; opcode BRN ! Permet de ne pas excuter le CLRB suivant !

enddGetBackColor:
            clrb
            pula
            rts
; End of function GR_getBackColor


; =============== S U B R O U T I N E =======================================

; FCT : Lit la zone mmoire pointe par X pour rcuprer
;       la couleur, l'attribut et le caractre
; IN  : X=POS(Y,X)
; OUT : A=0 si code ASCII lu sinon valeur du caractre semi-graphique

GR_getCharSemiGraphFromXY:
            jsr vectorGR_READ_ASCII         ; FCT : vecteur pour la routine de lecture d'un
                                            ;       caractre en mmoire vido.
                                            ;       Retourne espace si ATTRIBUT sinon le code ascii
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : A=$20 si ATTRIBUT
                                            ;       sinon CODE ASCII si A>$20 et A<=$7F
                                            ;       sinon CODE SEMI GRAPHIQUE si A>=$80
            tsta
            bmi endGetCharSemiGraphFromXY
            clra

endGetCharSemiGraphFromXY:
            rts
; End of function GR_getCharSemiGraphFromXY


; =============== S U B R O U T I N E =======================================

; FCT : rcupre la valeur du caractre situ  la position X
; IN  : X=POS(Y,X)
; OUT : A=0
;       B=$20=ATTRIBUT        si valeur lue <$20
;       B=CODE ASCII          si valeur lue >$20 et <=$7F
;       B=CODE SEMI GRAPHIQUE si valeur lue >= $80
; OPT : jsr vREAD_ASCII_EF9345
;       tab
;       clra
;       rts
;       et on change le code suivant l'appel ...
;       ===> c'est mieux non ?

GR_getCharFromX_RESET:
            clra
            psha                            ; Pas logique car n'est pas utilis par le jsr ...
            jsr vectorGR_READ_ASCII         ; FCT : vecteur pour la routine de lecture d'un
                                            ;       caractre en mmoire vido.
                                            ;       Retourne espace si ATTRIBUT sinon le code ascii
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : A=$20 si ATTRIBUT
                                            ;       sinon CODE ASCII si A>$20 et A<=$7F
                                            ;       sinon CODE SEMI GRAPHIQUE si A>=$80
            tab
            pula
            rts
; End of function GR_getCharFromX_RESET


; =============== S U B R O U T I N E =======================================

; FCT :  Stocke  la position X=POS(Y,X) le caractre B
; IN  : B=caractre  afficher
;       X=POS (Y,X) du caractre  afficher
; OUT : A,B,X modified

moveBtoABeforeJ_WRITE_EF9345:
            tba
; End of function moveBtoABeforeJ_WRITE_EF9345


; =============== S U B R O U T I N E =======================================

; FCT : Stocke  la position X=POS(Y,X) le caractre A
; IN  : A=caractre  afficher
;       X=POS (Y,X) du caractre  afficher
; OUT : A,B,X modified

jsrjsrPRINT_EF9345:
            jsr vectorOS_PRINT              ; FCT : Stocke  la position X(Y,X) le caractre A
                                            ; IN  : A=caractre  afficher
                                            ;       X=POS (Y,X) du caractre  afficher
                                            ; OUT : A,B,X modified
            rts
; End of function jsrjsrPRINT_EF9345


; =============== S U B R O U T I N E =======================================

; FCT : Lecture de la donne  la position X=POS(Y,X)
; IN  : X=POS(Y,X)
; OUT : B=$FF
;       A=Code ASCII ou ATTRIBUT

subREAD_EF9345:
            jsr vectorGR_READ_ASCII         ; FCT : vecteur pour la routine de lecture d'un
                                            ;       caractre en mmoire vido.
                                            ;       Retourne espace si ATTRIBUT sinon le code ascii
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : A=$20 si ATTRIBUT
                                            ;       sinon CODE ASCII si A>$20 et A<=$7F
                                            ;       sinon CODE SEMI GRAPHIQUE si A>=$80
            ldab #$FF
            tsta
            rts
; End of function subREAD_EF9345


; =============== S U B R O U T I N E =======================================

; FCT : Lit le code ASCII  la position (Y,X)
; IN  : X=POS(Y,X)
; OUT : B=le code ascii / 2 lu  la position (Y,X)
;       A=le code ascii lu  la position (Y,X)

subREAD_EF9345_TODO:
            jsr vectorGR_READ_ASCII         ; FCT : vecteur pour la routine de lecture d'un
                                            ;       caractre en mmoire vido.
                                            ;       Retourne espace si ATTRIBUT sinon le code ascii
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : A=$20 si ATTRIBUT
                                            ;       sinon CODE ASCII si A>$20 et A<=$7F
                                            ;       sinon CODE SEMI GRAPHIQUE si A>=$80
            tab
            lsrb
            rts
; End of function subREAD_EF9345_TODO


; =============== S U B R O U T I N E =======================================

; FCT : Lit le caractre en mmoire vido  la position (0,0)
; IN  : /
; ST  : ACTIF
; OUT : X unmodified
;       A=$20 si attribut sinon code ASCII du caractre lu

GR_readASCII_HOME:
            pshx
            ldx HOME_YX                     ; Position de l'cran en haut  gauche =(0,0)
            jsr vectorGR_READ_ASCII         ; FCT : vecteur pour la routine de lecture d'un
                                            ;       caractre en mmoire vido.
                                            ;       Retourne espace si ATTRIBUT sinon le code ascii
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : A=$20 si ATTRIBUT
                                            ;       sinon CODE ASCII si A>$20 et A<=$7F
                                            ;       sinon CODE SEMI GRAPHIQUE si A>=$80
            pulx
            rts
; End of function GR_readASCII_HOME


; =============== S U B R O U T I N E =======================================

; FCT : Imprime le caractre A  la position (0,0) de l'cran
; IN  : A=caractre  imprimer
; OUT : A,B modified
;       X unmodified

GR_printCarAtHome:
            pshx
            ldx HOME_YX                     ; Position de l'cran en haut  gauche =(0,0)
            bsr jsrjsrPRINT_EF9345          ; FCT : Stocke  la position X=POS(Y,X) le caractre A
                                            ; IN  : A=caractre  afficher
                                            ;       X=POS (Y,X) du caractre  afficher
                                            ; OUT : A,B,X modified
            pulx
            rts
; End of function GR_printCarAtHome


; =============== S U B R O U T I N E =======================================

; FCT : lit un paramtre suivant la commande basic CLS
;       Change le paramtre TECRAN si paramtre = [32,40,80,81]
;       paramtre autoris 0  7 : pour  fixer la couleur du fond
;       paramtre autoris 32    : mode 32 caractres
;       paramtre autoris 40    : mode 40 caractres
;       paramtre autoris 80    : mode 80 caractres
;       paramtre autoris 81    : mode 80 caractres et inversion
; IN  : flux  interprter
; OUT : B = valeur du paramtre
;       A = 0

GR_getParamCLS:
            jsr GETBYT                          ; FCT : EVALUATE EXPRESSION AT TXTPTR, AND
                                                ;       CONVERT IT TO SINGLE BYTE IN B-REG
                                                ; ERR : FC : fonction incorrecte
                                                ; IN  : le flot d'interprtation
                                                ; OUT : B=la partie haute de la conversion (ACC1+3,ACC1+4)
            clra                                ; Mode 0 : 80x25
            cmpb #cOS_CLS_MODE_HIRES            ; $50
            beq doHIRES80_getParamCLS
            cmpb #cOS_CLS_MODE_HIRES_INV        ; $51
            beq doHIRES81_getParamCLS
            inca                                ; MODE 1 : 40x25
            cmpb #cOS_CLS_MODE_TEXTE
            beq doSetTECRAN_GetParamCLS
            inca                                ; MODE 2 : 32x16
            cmpb #cOS_CLS_MODE_LORES
            beq doSetTECRAN_GetParamCLS
            rts

doHIRES81_getParamCLS:
            clrb
            bra nextGetParamCLS

doHIRES80_getParamCLS:
            ldab #cVDP_80_AT_N*16+cVDP_80_AT_N  ; $88 ; Attibut 80 col ngatif

nextGetParamCLS:
            stab Attribute_HIRES                ; contient l'attribut du caractre en mode haute rsolution
                                                ; Par dfaut contient $00 (mode inversion) sinon $88.
                                                ; C'est un nibble donc l'attribut doit tre rpt 2
                                                ; fois dans l'octet (car colonne paire/impaire !)
                                                ; Sinon cela fait des effets sympas

doSetTECRAN_GetParamCLS:
            staa TECRAN                         ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            jmp doRESET                         ; FCT : Point d'entre pour la rinitialisation
                                                ; ST  : ACTIF
                                                ; IN  : /
                                                ; OUT : /
; End of function GR_getParamCLS

; =============== S U B R O U T I N E =======================================

; FCT : effectue le reset "hard" de l'ordinateur
; IN  : /
; OUT : /

OS_HardReset:
            lds #areaStackByDefault         ; Set STACK to $4800
            jsr vectorinitVIDEO_mode40
            ldx #cCPU_BEGIN_RAM             ; pointer to 0x0080
            jmp OS_CLRMEM                   ; FCT : Effectue diverses initialisations systmes :
                                            ;       - la zone mmoire entre X et $100
                                            ;       - la zone vecteur CPU
                                            ;       - pile systme
                                            ;       - saisie utilisateur
                                            ;       - Hook
                                            ;       - Basic
                                            ;       - Ecran
                                            ;       Puis imprime la bannire MICROSOFT
                                            ;       ENFIN entre dans la boucle d'interprtation du BASIC
                                            ; IN  : X=dbut de la zone mmoire  initialiser
                                            ; OUT : A,X modified
; End of function OS_HardReset

; =============== S U B R O U T I N E =======================================

; FCT : Incrmente de 1 la position du curseur  l'cran
;       et effectue un dfilement vers le haut si ncessaire
; IN  : X=pos(Y,X)
; OUT : X=pos(Y,X+1) + scrollup si ncessaire

GR_doincX_AND_SCROLLUP:
            bsr GR_incCursor                ; FCT : Gestion du curseur physique : Incrmente de 1 la position horizontale
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : X=POS(Y,X+1)
                                            ;       A,B unmodified
            bne endDoincX_AND_SCROLL_EF9345
            jsr vectorSCROLLUP              ; FCT : Appel la routine de SCROLLING de l'cran
                                            ; IN  : /
                                            ; OUT : A et B unmodified

endDoincX_AND_SCROLL_EF9345:
            rts
; End of function GR_doincX_AND_SCROLLUP


; =============== S U B R O U T I N E =======================================

; FCT : Gestion du curseur physique : Incrmente de 1 la position horizontale
; IN  : X=POS(Y,X)
; OUT : X=POS(Y,X+1)
;       A,B unmodified

GR_incCursor:
            psha
            pshb
            pshx
            pula
            pulb
            incb
            cmpb SCR_LGX                ; taille max sur X en mode 32, 40 ou 80 colonnes
            bne pushDpopX
            ldab HOME_YX+1              ; Position de l'cran en haut  gauche =(0,0)
            inca
            cmpa SCR_LGY
            bne pushDpopX
            bra popD
; End of function GR_incCursor


; =============== S U B R O U T I N E =======================================

; FCT : dcremente de 1 la position X,Y donne par le registre X
; IN  : X=La position (X,Y)
; OUT : X=X-1 en position (X,Y)
;       A et B not modified

GR_decCursor:
            psha
            pshb
            pshx
            pula
            pulb
            cmpb HOME_YX+1              ; Position de l'cran en haut  gauche =(0,0)
            bne dodecX_EF9345
            ldab SCR_LGX                ; taille max sur X en mode 32, 40 ou 80 colonnes
            cmpa HOME_YX                ; Position de l'cran en haut  gauche =(0,0)
            bne dodecYdecX_EF9345
            ldab HOME_YX+1              ; Position de l'cran en haut  gauche =(0,0)

dodecYdecX_EF9345:
            deca

dodecX_EF9345:
            decb

pushDpopX:
            pshb
            psha
            pulx

popD:
            pulb
            pula
            rts
; End of function GR_decCursor


; =============== S U B R O U T I N E =======================================

; FCT : vrifie que D est bien contenu dans l'intervalle
;       d'un affichage via PRINT @
;       au minimum : 0
;       au maximum : dpend de l'cran 32*16 ou 40*25 ou 80*25
; IN  : D=Position du curseur en nombre de caractre
;       et non pas en position (X,Y)
; OUT : Met  jour CURAD_YX
;       D=CURAD_YX=nouvelle position impose par D

OS_verifyParam_AT:
            pshx
            ldx #$0000

bclVerifyParam_AT:
            subd SCROFSY                ; OFFSET A AJOUTER POUR ALLER A LA LIGNE SUIVANTE POUR UN MEME X
            bmi nextVerifyParam_AT
            inx
            bra bclVerifyParam_AT

nextVerifyParam_AT:
            addd SCROFSY                ; OFFSET A AJOUTER POUR ALLER A LA LIGNE SUIVANTE POUR UN MEME X
            pshx
            pula
            pula
            pulx
            adda HOME_YX                ; Position de l'cran en haut  gauche =(0,0)
            cmpa SCR_LGY
            bcc jmpErrorMsg_0X08
            addb HOME_YX+1              ; Position de l'cran en haut  gauche =(0,0)
            std CURAD_YX
            rts

jmpErrorMsg_0X08:
            jmp printErrorMSG_0x08_FC_FctIncorrect
; End of function OS_verifyParam_AT


; =============== S U B R O U T I N E =======================================

; FCT : INITIALISATION PARAMETRAGE BASIC POUR ECRAN SELON LE MODE
; IN  : /
; OUT : X,A,B modified
; OPT : TODO

GR_initParamByDevice:
            ldx #tabINITPRM_SCR
            ldab TECRAN                 ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            ldaa #$0A
            mul
            abx
            ldab #$0A

bclinitParamByDevice:
            ldaa 0,x
            psha
            inx
            decb
            bne bclinitParamByDevice
            ldab #$0A
            ldx #SCR_LGY

bcl2initParamByDevice:
            pula
            staa 0,x
            inx
            decb
            bne bcl2initParamByDevice

setOffMemEF9345:
            ldx #$0000
            stx HOME_YX                 ; Position de l'cran en haut  gauche =(0,0)
            rts
; End of function GR_initParamByDevice

; ---------------------------------------------------------------------------
; paramtrage des modes crans
; 1ere ligne : 80x25
; 2eme ligne : 40x25
; 3eme ligne : 32x16
; Les donnes sont  l'envers de leur stockage !
;=====================================================================
;MARGE_DROITE, MARGE_GAUCHE,PIX_XMAX, PIX_YMAX,OFSLINHI,OFSLINLOW,XMIN,YMIN,XMAX,YMAX
;=====================================================================
;        160     ,      125
;$40,$10,$A0     ,       $7D,    $50,    0,    0,    0, $50, $19
;=====================================================================
;        80      ,       50
;$10,$10,$50     ,       $32,    $28,    0,    0,    0, $28, $19
;=====================================================================
;         64     ,       32
;$10,$10,$40     ,       $20,    $20,    0,    4,    4, $20, $10
;---------------------------------------------------
tabINITPRM_SCR:
            dc.b $40,$10,$A0,$7D,$50,$00,$00,$00,$50,$19; 0
            dc.b $10,$10,$50,$32,$28,$00,$00,$00,$28,$19; 10
            dc.b $10,$10,$40,$20,$20,$00,$04,$04,$20,$10; 20
;----------------
OS_FREE_5   dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
;----------------
;--------------------
; -- SHIFT
;--------------------
TABSHF:     dc.b cKB_NULL           , cKB_SHIFT_ARROBASE, cKB_SHIFT_Q, cKB_SHIFT_B     , cKB_SHIFT_C, cKB_SHIFT_D  , cKB_SHIFT_E     , cKB_SHIFT_F         ; 0
            dc.b cKB_SHIFT_G        , cKB_SHIFT_H       , cKB_SHIFT_I, cKB_SHIFT_J     , cKB_SHIFT_K, cKB_SHIFT_L  , cKB_SHIFT_DIVIDE, cKB_SHIFT_N         ; 8
            dc.b cKB_SHIFT_O        , cKB_SHIFT_P       , cKB_SHIFT_A, cKB_SHIFT_R     , cKB_SHIFT_S, cKB_SHIFT_T  , cKB_SHIFT_U     , cKB_SHIFT_V         ; 16
            dc.b cKB_SHIFT_Z        , cKB_SHIFT_X       , cKB_SHIFT_Y, cKB_SHIFT_W     , cKB_NULL   , cKB_NULL     , cKB_NULL        , cKB_SHIFT_ENTER     ; 24
            dc.b cKB_SHIFT_ESPACE   , cKB_SHIFT_0       , cKB_SHIFT_1, cKB_SHIFT_2     , cKB_SHIFT_3, cKB_SHIFT_4  , cKB_SHIFT_5     , cKB_SHIFT_6         ; 32
            dc.b cKB_SHIFT_7        , cKB_SHIFT_8       , cKB_SHIFT_9, cKB_SHIFT_2POINT, cKB_SHIFT_M, cKB_SHIFT_inf, cKB_SHIFT_egal  , cKB_SHIFT_sup       ; 40
            dc.b cKB_SHIFT_SEMICOLON, cKB_NULL          , cKB_NULL   , cKB_BREAK       , cKB_LEFT   , cKB_DOWN     , cKB_RIGHT       , cKB_UP              ; 48
;--------------------
; -- CTRL
;--------------------
TABCON:     dc.b cKB_NULL  , cKB_CTRL_ARROBASE, cKB_CTRL_Q, cKB_CTRL_B     , cKB_CTRL_C, cKB_CTRL_D, cKB_CTRL_E     , cKB_CTRL_F      ; 0
            dc.b cKB_CTRL_G, cKB_CTRL_H       , cKB_CTRL_I, cKB_CTRL_J     , cKB_CTRL_K, cKB_CTRL_L, cKB_CTRL_DIVIDE, cKB_CTRL_N      ; 8
            dc.b cKB_CTRL_O, cKB_CTRL_P       , cKB_CTRL_A, cKB_CTRL_R     , cKB_CTRL_S, cKB_CTRL_T, cKB_CTRL_U     , cKB_CTRL_V      ; 16
            dc.b cKB_CTRL_Z, cKB_CTRL_X       , cKB_CTRL_Y, cKB_CTRL_W     , cKB_NULL  , cKB_NULL  , cKB_NULL       , cKB_ENTER       ; 24
            dc.b $07       , $30              , cKB_CTRL_1, cKB_CTRL_2     , cKB_CTRL_3, cKB_CTRL_4, cKB_CTRL_5     , cKB_CTRL_6      ; 32
            dc.b cKB_CTRL_7, cKB_CTRL_8       , cKB_CTRL_9, cKB_CTRL_2POINT, cKB_CTRL_M, $BB       , cKB_CTRL_minus , $B7             ; 40
            dc.b $B6       , cKB_NULL         , cKB_NULL  , cKB_BREAK      , cKB_LEFT  , cKB_DOWN  , cKB_RIGHT      , cKB_UP          ; 48

; =============== S U B R O U T I N E =======================================

j_setError0x02_SYNTAXERROR:
            jmp setError0x02_SYNTAXERROR
; End of function j_setError0x02_SYNTAXERROR


; =============== S U B R O U T I N E =======================================

; FCT : vrifie  si les touches '*', '&' ou '%' ont t actives
;   * : pour entrer dans l'diteur mode ligne
;   & : pour entrer dans l'assembleur
;   % : pour reentrer dans l'assembleur suite  une sortie prmature
; IN  : A=le caractre courant lu
; OUT : /

OS_PRE_PARSE_INPUT_LINE:
            cmpa #cBAS_CMD_GO_LINEEDIT          ; $2A ; '*'
            beq doEDITLINE

isEtcommercial:
            cmpa #cBAS_CMD_RETURN_ASS           ; $26 ; '&'
            bne isPERCENT                       ; FCT : & est le caractre pour entrer dans  l'assembleur
                                                ; IN  : A=caractre  courant lu
                                                ; OUT : /

doEtCommercial:
            jsr ASS_MAIN_ENTRY                  ; FCT : point d'entre de l'diteur assembleur
                                                ;       L'cran passe en mode 80x25 ou en mode 40x25
                                                ;       (selon le mode de dpart !) en fond bleu et
                                                ;       encre blanche
                                                ; IN  : /
                                                ; OUT : /

nextDoEtCommercial:
            ldaa #cVDP_80_AT_N*16+cVDP_80_AT_N  ; $88 ; Attibut 80 col ngatif
            staa Attribute_HIRES                ; contient l'attribut du caractre en mode haute rsolution
                                                ; Par dfaut contient $00 (mode inversion) sinon $88.
                                                ; C'est un nibble donc l'attribut doit tre rpt 2
                                                ; fois dans l'octet (car colonne paire/impaire !)
                                                ; Sinon cela fait des effets sympas
            jmp doRESET                         ; FCT : Point d'entre pour la rinitialisation
                                                ; ST  : ACTIF
                                                ; IN  : /
                                                ; OUT : /
; End of function OS_PRE_PARSE_INPUT_LINE

; =============== S U B R O U T I N E =======================================

; FCT : & est le caractre pour entrer dans l'assembleur
; IN  : A=caractre courant lu
; OUT : /

isPERCENT:
            cmpa #cBAS_CMD_GO_ASS           ; $25 ; '%'
            bne doPARSE_INPUT_LINE          ; FCT : Attend une saisie d'une commande ou d'une ligne
                                            ;       avant de l'interpreter
                                            ; IN  : /
											; OUT : /

doPERCENT:
            jsr vectorPercent
            bra nextDoEtCommercial
; End of function isPERCENT


; =============== S U B R O U T I N E =======================================

; FCT : Attend une saisie d'une commande ou d'une ligne
;       avant de l'interpreter
; IN  : /
; OUT : /

doPARSE_INPUT_LINE:
            jsr CRUNCH                      ; FCT : CRUNCH - Transforme les mots clefs BASIC en leur quivalent code token
                                            ;       venant du flot  interprter
                                            ; IN  : le flot  interprter
                                            ; OUT : X=position de la ligne BASIC convertie
                                            ;       D=Taille de la ligne BASIC convertie
            jmp NEWSTT2
; End of function doPARSE_INPUT_LINE

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR OS_PRE_PARSE_INPUT_LINE

doEDITLINE:
            clr POS_BUFFERKEYB
            jsr.w   CHRGET                  ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR ;
                                            ; L'appel se fait via l'adressage long et non pas court !!! OJE 12/02/2020
                                            ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                            ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                            ; NOT C= NUMERIC ("0" THRU "9")
                                            ; Z= ":" OR END-OF-LINE (A NULL)
                                            ; [ACCA] = NEW CHAR.
                                            ; [TXTPTR]=[TXTPTR]+1
            jsr LINGET                      ; FCT : Obtient un numro de ligne dans le flux d'entre
                                            ; IN  : le flot  interprter via CHRGET
                                            ; OUT : LINUM = numro de ligne obtenu en premire position
                                            ;       dans le flot  interprter
            jsr FNDLIN                      ; FCT : FNDLIN SEARCHES THE PROGRAM TEXT FOR THE LINE
                                            ;       WHOSE NUMBER IS PASSED IN "LINNUM".
                                            ;       THERE ARE TWO POSSIBLE RETURNS:
                                            ;
                                            ;       1) CARRY SET.
                                            ;          LOWTR POINTS TO THE LINK FIELD IN THE LINE
                                            ;          WHICH IS THE ONE SEARCHED FOR.
                                            ;
                                            ;       2) CARRY NOT SET.
                                            ;          LINE NOT FOUND. [LOWTR] POINTS TO THE LINE IN THE
                                            ;          PROGRAM GREATER THAN THE ONE SOUGHT AFTER.
                                            ; IN  : /
                                            ; OUT : C=1 : Ligne trouve
                                            ;       X=Position en mmoire de la ligne trouve
            pshx
            jsr.w   CHRGOT                  ; OJE Le stockage se fait via l'adressage long et non pas court !!! OJE 12/02/2020
            bne j_setError0x02_SYNTAXERROR
            pulx
            clr POS_BUFFERKEYB
            ldaa #cOS_DEV_BUFFER
            staa.w DEVNU                    ; OJE 13/02/2020 ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            ldd 0,x
            beq j_setError0x02_SYNTAXERROR
            ldd 2,x
            subd.w LINUM                    ; OJE 13/02/2020
            bhi j_setError0x02_SYNTAXERROR
            ldd 2,x
            pshx
            jsr LIPTR                       ; FCT : Imprime le chiffre contenu dans D
                                            ; IN  : D : le chiffre  afficher
                                            ; OUT : A,B,X modified
            pulx
            inx
            inx
            inx
            inx
            stx.w   INDEX                   ; OJE 13/02/2020
            clr fEDITLINE_SEP               ; en mode dition ligne ou LIST, l'opcode lu est un ", un :, un DATA, un REM

printSPACE:
            ldaa #cOS_SPACE                 ; ' '
            SKIP2

bclDoEDITLINE_PRINT_PT_EXCL:
            ldaa #cEDT_UNKNOWN              ; '!'  ; Affiche un ! dans le cas d'un opcode > $C8

bcl1DoEDITLINE:
            ldx.w   INDEX                   ; OJE 13/02/2020
            anda #$7F

bcl2DoEDITLINE:
            jsr j_printCHAR_1               ; FCT : Imprime un caractre sur le dispositif selectionn par DEVNU : Appel indirect  printCHAR_1
                                            ; IN  : A=char to print
                                            ; OUT : A modified
            ldaa 0,x
            inx
            tsta
            beq ED_EditLine                 ; FCT : dbut de la partie dition en mode ligne
                                            ; IN  : BUFFERKEYB contient un texte  diter
                                            ; OUT : En fin d'dition retourne  l'Interprteur
                                            ;       Si touche BREAK active alors on ne  fait rien
                                            ;          et entre dans la boucle principale d'interprtation du BASIC
                                            ;       Sinon entre dans la boucle secondaire d'interprtation du BASIC
            ldab fEDITLINE_SEP              ; en mode dition ligne ou LIST, l'opcode lu est un ", un :, un DATA, un REM

isDoubleGuillemet:
            cmpa #cBAS_SEP_STR              ; '"'
            bne next3DoEDITLINE
            eorb #$01
            stab fEDITLINE_SEP              ; en mode dition ligne ou LIST, l'opcode lu est un ", un :, un DATA, un REM

next3DoEDITLINE:
            cmpa #cBAS_SEP ; ':'
            bne next4DoEDITLINE
            bitb #$01
            bne next4DoEDITLINE
            andb #$FD
            stab fEDITLINE_SEP              ; en mode dition ligne ou LIST, l'opcode lu est un ", un :, un DATA, un REM

next4DoEDITLINE:
            tsta
            bpl bcl2DoEDITLINE
            tstb
            bne bcl2DoEDITLINE
            cmpa #cBAS_TOKEN_DATA           ; $85 : Opcode DATA
            bne next5DoEDITLINE
            orab #$02

next5DoEDITLINE:
            cmpa #cBAS_TOKEN_REM            ; $83 : Opcode REM
            bne next6DoEDITLINE
            orab #$04

next6DoEDITLINE:
            stab fEDITLINE_SEP              ; en mode dition ligne ou LIST, l'opcode lu est un ", un :, un DATA, un REM
            cmpa #cBAS_TOKEN_ALL_MAX        ; $C8 : numro max des opcodes BASIC
            bhi bclDoEDITLINE_PRINT_PT_EXCL
            jsr BAS_searchTextBASIC         ; FCT : Recherche la position du nom de la commande
                                            ;       BASIC associe au code BASIC.
                                            ; IN  : A=code de la fonction BASIC A>= $80
                                            ;       X=position dans le source BASIC
                                            ; OUT : X=position en rom du texte du code BASIC recherch

bcl7DoEDITLINE:
            ldaa 0,x
            bmi bcl1DoEDITLINE
            inx
            jsr j_printCHAR_1               ; FCT : Imprime un caractre sur le dispositif selectionn par DEVNU : Appel indirect  printCHAR_1
                                            ; IN  : A=char to print
                                            ; OUT : A modified
            bra bcl7DoEDITLINE
; END OF FUNCTION CHUNK FOR OS_PRE_PARSE_INPUT_LINE

; =============== S U B R O U T I N E =======================================

; FCT : dbut de la partie dition en mode ligne
; IN  : BUFFERKEYB contient un texte  diter
; OUT : En fin d'dition retourne  l'Interprteur
;       Si touche BREAK active alors on ne fait rien
;       et entre dans la boucle principale d'interprtation du BASIC
;       Sinon entre dans la boucle secondaire d'interprtation du BASIC

ED_EditLine:
            clr DEVNU                       ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante

AddCR:
            ldx #BUFFERKEYB                 ; BUFFERKEYB contient la ligne  diter
            ldab POS_BUFFERKEYB
            abx
            ldaa #cOS_CR
            staa 0,x
            clrb

entryEditLine:
            ldx #BUFFERKEYB

echoLine:
            jsr ED_EchoLine                 ; FCT : Imprime  l'cran une ligne termine par CR pointe par X
                                            ;       Le curseur d'dition est  la premire position du texte dit
                                            ; IN  : X=Le tampon  afficher
                                            ;       B=le dbut du tampon  afficher
                                            ; OUT : A,B,X modified
                                            ; RMQ : La gestion du curseur est calamiteuse :
                                            ;       pourquoi rimprimer  les caractres dj affichs
                                            ;       au dbut de la procdure pour imprimer le curseur
                                            ;       en dbut de ligne ou du fait d'une ligne BASIC multiligne ?
                                            ;       ===> TODO : une nouvelle optimisation en vue

waitCmdUserAndDoIt:
            jsr ED_Manage                   ; FCT : gre le mode dition ligne d'une ligne basic
                                            ; IN  : /
                                            ; OUT : C=0:no hit key 'BREAK'
                                            ;       C=1:hit key 'BREAK'
            bcs doBREAK
            ldx #$00FF
            stx.w   CURLIN                  ; OJE 13/02/2020
            jsr ED_finalyzeBUFFERKEYB       ; FCT : Permet de reinitialiser diverses variables lies
                                            ;       au tampon clavier lors de l'dition en mode ligne
                                            ;       Ajoute un 0 en fin de tampon de saisie
                                            ;       Effectue un CR  l'cran
                                            ; IN  : /
                                            ; OUT : X=pointeur sur la zone tampon de saisie
                                            ;       A,B modidied

callInterpret:
            stx.w   TXTPTR                  ; OJE 13/02/2020
            jmp INTERPRET

doBREAK:
            jsr printCR                     ; FCT : effectue un retour  la ligne
                                            ; IN  : /
                                            ; OUT : A modified
            jmp MAIN
; End of function ED_EditLine


; =============== S U B R O U T I N E =======================================

; FCT : Imprime un caractre sur le dispositif selectionn par DEVNU
; IN  : A=char to print
; OUT : A modified

printCHAR_1:
            pshb
            pshx
            ldab.w DEVNU                    ; OJE 13/02/2020 ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            cmpb #cOS_DEV_BUFFER
            bne doprintChar

printer_PrintCHAR_1:
            ldab POS_BUFFERKEYB
            cmpb #$7F
            beq endPRINT_CHAR_1
            ldx #BUFFERKEYB
            abx
            inc POS_BUFFERKEYB
            staa 0,x

endPRINT_CHAR_1:
            pulx
            pulb
            rts

doprintChar:
            pulx
            pulb
            jmp OS_printCHAR                ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                            ; IN  : A=caractre  imprimer
                                            ;       DEVNU mise  jour
                                            ; OUT : B, X unmodified
; End of function printCHAR_1

; =============== S U B R O U T I N E =======================================

; FCT : gre le  mode dition ligne d'une ligne basic
; IN  : /
; OUT : C=0:no hit key 'BREAK'
;       C=1:hit key 'BREAK'

ED_Manage:
            clr fFLASHCAR                   ; dtermine si c'est le caractre en dessous du curseur qui doit tre "flash" (clignotement)
            clr fFLASHCUR                   ; dtermine si c'est le curseur qui doit tre "flash" (clignotement)

bclEditLine:
            jsr OS_getKEY                   ; FCT : Attend une saisie utilisateur
                                            ;       gre le clignotement du curseur
                                            ; IN  : /
                                            ; OUT : A=la touche actionne
isBREAK:
            cmpa #cKB_BREAK
            beq manageBREAK
isRIGHT:
            cmpa #cKB_RIGHT
            beq manageARROWRIGHT
isLEFT:
            cmpa #cKB_LEFT
            beq manageCTRLQ_BS              ; FCT : DEL
isDOWN:
            cmpa #cKB_DOWN
            beq manageCTRLW_SUPPR
isCTRLESAPCE:
            cmpa #cKB_CTRL_ESPACE
            beq manageCTRLSPACE_AUTOREPEAT_OFF
isSHIFTESPACE
            cmpa #cKB_SHIFT_ESPACE
            beq manageSHIFTSPACE_AUTOREPEAT_ON
isENTER:
            cmpa #cKB_ENTER
            beq manageENTER
            tsta
            bpl ED_manage_next
            tst TMPKBD
            beq ED_manage_next
            jsr BAS_searchTextBASIC         ; FCT : Recherche la position du nom de la commande
                                            ;       BASIC associe au code BASIC.
                                            ; IN  : A=code de la fonction BASIC A>= $80
                                            ;       X=position dans le source BASIC
                                            ; OUT : X=position en rom du texte du code BASIC recherch
            bsr ED_insTextInEditLine        ; FCT : Affiche une chane  la position du curseur dans le tampon de ligne
                                            ; IN  : X=position du texte  ajouter au tampon d'dition de ligne
                                            ;       B=Nombre de caractres dj insrs dans le tampon d'dition
                                            ; OUT : X=nouvelle position dans le tampon de ligne
            bra bclEditLine

manageCTRLSPACE_AUTOREPEAT_OFF:
            clr fAUTOREPEAT                 ; =0:no autorepat;<>0:AUTOREPAT ON et est dcremente
                                            ; d'1 unit  chaque rptition
            bra bclEditLine

manageSHIFTSPACE_AUTOREPEAT_ON:
            ldaa #$FF
            staa fAUTOREPEAT                ; =0:no autorepat;<>0:AUTOREPAT ON et est dcremente
                                            ; d'1 unit  chaque rptition
            bra bclEditLine

ED_manage_next:
            cmpa #cKB_ESPACE                ; $20 ; ' '
            bcs bclEditLine
            bsr ED_insCharIntoBuffer        ; FCT : Insre le caractre A dans le tampon d'dition
                                            ; IN  : B=Nombre de caractres dj insrs dans le tampon d'dition
                                            ;       A=caractre  insrer
                                            ; OUT : A,B,X modified
            bsr ED_echoCharWithoutCursor    ; FCT : affiche sur le device courant un caractre
                                            ;       pointe par X et ne fait rien quand rencontre $0D
                                            ; IN  : X=pointeur sur le caractre  afficher
                                            ;       B=position du caractre  afficher dans le tampon point par X
                                            ; OUT : Si A = $0D  : A=0xD
                                            ;       Si A <> $0D : A=quelconque B=B+1, X=X+1
                                            ;       B=B+1
                                            ;       X=X+1
            bra bclEditLine

manageENTER:
            bsr ED_echoCharWithoutCursor    ; FCT : affiche sur le device courant un caractre
                                            ;       pointe par X et ne fait rien quand rencontre $0D
                                            ; IN  : X=pointeur sur le caractre  afficher
                                            ;       B=position du caractre  afficher dans le tampon point par X
                                            ; OUT : Si A = $0D  : A=0xD
                                            ;       Si A <> $0D : A=quelconque B=B+1, X=X+1
                                            ;       B=B+1
                                            ;       X=X+1
            bne manageENTER                 ; boucle tant qu'on n'a pas rencont le Carriage Return
            clr fAUTOREPEAT                 ; =0:no autorepat;<>0:AUTOREPAT ON et est dcremente
                                            ; d'1 unit  chaque rptition
            clc
            rts

manageBREAK:
            bsr ED_echoCharWithoutCursor    ; FCT : affiche sur le device courant un caractre
                                            ;       pointe par X et ne fait rien quand rencontre $0D
                                            ; IN  : X=pointeur sur le caractre  afficher
                                            ;       B=position du caractre  afficher dans le tampon point par X
                                            ; OUT : Si A = $0D  : A=0xD
                                            ;       Si A <> $0D : A=quelconque B=B+1, X=X+1
                                            ;       B=B+1
                                            ;       X=X+1
            bne manageBREAK
            sec
            rts

manageARROWRIGHT:
            bsr ED_echoCharWithoutCursor    ; FCT : affiche sur le device courant un caractre
                                            ;       pointe par X et ne fait rien quand rencontre $0D
                                            ; IN  : X=pointeur sur le caractre  afficher
                                            ;       B=position du caractre  afficher dans le tampon point par X
                                            ; OUT : Si A = $0D  : A=0xD
                                            ;       Si A <> $0D : A=quelconque B=B+1, X=X+1
                                            ;       B=B+1
                                            ;       X=X+1
            bra bclEditLine

manageCTRLQ_BS:
            bsr ED_EchoCharWithCursorAndDecPosCur   ; FCT : DEL
            bra bclEditLine

manageCTRLW_SUPPR:
            bsr ED_SUPPR_EDITLINE           ; FCT : Permet de supprimer le caractre en dessous du curseur d'dition du curseur
                                            ; IN  : B=Nombre de caractres dj saisis dans le tampon
                                            ;       X=Pointeur du texte  diteur  la position du curseur  l'cran
                                            ; OUT : X unmodified
                                            ;       B unmodified
            bra bclEditLine
; End of function ED_Manage


; =============== S U B R O U T I N E =======================================

; FCT : Affiche une chane  la position du curseur dans le tampon de ligne
; IN  : X=position du texte  ajouter au tampon d'dition de ligne
;       B=Nombre de caractres dj insrs dans le tampon d'dition
; OUT : X=nouvelle position dans le tampon de ligne

ED_insTextInEditLine:
            ldaa 0,x
            inx
            pshx
            psha
            anda #$7F
            ldx.w   INDEX                   ; OJE 13/02/2020
            bsr ED_insCharIntoBuffer        ; FCT : Insre le caractre A dans le tampon d'dition
                                            ; IN  : B=Nombre de caractres dj insrs dans le tampon d'dition
                                            ;       A=caractre  insrer
                                            ; OUT : A,B,X modified
            bsr ED_echoCharWithoutCursor    ; FCT : affiche sur le device courant un caractre
                                            ;       pointe par X et ne fait rien quand rencontre $0D
                                            ; IN  : X=pointeur sur le caractre  afficher
                                            ;       B=position du caractre  afficher dans le tampon point par X
                                            ; OUT : Si A = $0D  : A=0xD
                                            ;       Si A <> $0D : A=quelconque B=B+1, X=X+1
                                            ;       B=B+1
                                            ;       X=X+1
            stx.w   INDEX                   ; OJE 13/02/2020
            pula
            pulx
            tsta
            bpl ED_insTextInEditLine        ; FCT : Affiche une chane  la position du curseur dans le tampon de ligne
                                            ; IN  : X=position du texte  ajouter au tampon d'dition de ligne
                                            ;       B=Nombre de caractres dj insrs dans le tampon d'dition
                                            ; OUT : X=nouvelle position dans le tampon de ligne
            ldx.w   INDEX                   ; OJE 13/02/2020
            rts
; End of function ED_insTextInEditLine


; =============== S U B R O U T I N E =======================================

; FCT : Insre le caractre A dans le tampon d'dition
; IN  : B=Nombre de caractres dj insrs dans le tampon d'dition
;       A=caractre  insrer
; OUT : A,B,X modified

ED_insCharIntoBuffer:
            cmpb #$7F
            beq endED_insChar
            psha
            pshb
            ldx #BUFFERKEYB
            inc POS_BUFFERKEYB
            bpl nextED_insChar
            dec POS_BUFFERKEYB
            dex
            incb

nextED_insChar:
            tba
            suba POS_BUFFERKEYB
            nega
            ldab POS_BUFFERKEYB
            abx
            tsta
            beq next2ED_insChar

bcl1ED_insChar:
            dex
            ldab 0,x
            stab 1,x
            deca
            bne bcl1ED_insChar

next2ED_insChar:
            pulb
            pula
            staa 0,x
            jsr ED_EchoLine                 ; FCT : Imprime  l'cran une ligne termine par CR pointe par X
                                            ;       Le curseur d'dition est  la premire position du texte dit
                                            ; IN  : X=Le tampon  afficher
                                            ;       B=le dbut du tampon  afficher
                                            ; OUT : A,B,X modified
                                            ; RMQ : La gestion du curseur est calamiteuse :
                                            ;       pourquoi rimprimer  les caractres dj affichs
                                            ;       au dbut de la procdure pour imprimer le curseur
                                            ;       en dbut de ligne ou du fait d'une ligne BASIC multiligne ?
                                            ;       ===> TODO : une nouvelle optimisation en vue

endED_insChar:
            rts
; End of function ED_insCharIntoBuffer


; =============== S U B R O U T I N E =======================================

; FCT : affiche sur le device courant un caractre
;       pointe par X et ne fait rien quand rencontre $0D
; IN  : X=pointeur sur le caractre  afficher
;       B=position du caractre  afficher dans le tampon point par X
; OUT : Si A = $0D  : A=0xD
;       Si A <> $0D : A=quelconque B=B+1, X=X+1
;       B=B+1
;       X=X+1

ED_echoCharWithoutCursor:
            ldaa 0,x
            cmpa #cOS_CR
            beq endPprintCharAndInc_X_B
            jsr OS_printCHAR                ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                            ; IN  : A=caractre  imprimer
                                            ;       DEVNU mise  jour
                                            ; OUT : B, X unmodified
            incb
            inx

endPprintCharAndInc_X_B:
            rts
; End of function ED_echoCharWithoutCursor


; =============== S U B R O U T I N E =======================================

; FCT : Imprime le caractre point par X puis
;       dcremente de 1 la position du curseur  l'cran
;       dcremente de 1 aussi le pointeur X et B
; IN  : B=Position du curseur dans le tampon de ligne
;       X=Position du tampon de ligne
; OUT : B=B-1
;       X=X-1

ED_EchoCharWithCursorAndDecPosCur:
            tstb
            beq ED_EchoChar_EDITLINE_end
            ldaa 0,x
            cmpa #cOS_CR
            bne ED_EchoChar_EDITLINE_next
            ldaa #cOS_SPACE                 ; ' '

ED_EchoChar_EDITLINE_next:
            jsr ED_PrintAndDecCur           ; FCT : Imprime le caractre A puis le curseur courant est dcrement d'une position
                                            ; IN  : A=Caractre  imprimer
                                            ; OUT : X unmodified
            decb
            dex

ED_EchoChar_EDITLINE_end:
            rts
; End of function ED_EchoCharWithCursorAndDecPosCur


; =============== S U B R O U T I N E =======================================

; FCT : Permet de supprimer le caractre en dessous du curseur d'dition du curseur
; IN  : B=Nombre de caractres dj saisies dans le tampon
;       X=Pointeur du texte  diteur  la position du curseur  l'cran
; OUT : X unmodified
;       B unmodified

ED_SUPPR_EDITLINE:
            cmpb POS_BUFFERKEYB
            beq endSUPPR_EDITLINE
            pshx
            dex

bclSUPPR_EDITLINE:
            inx
            ldaa 1,x
            staa 0,x
            cmpa #cOS_CR
            bne bclSUPPR_EDITLINE
            pulx
            dec POS_BUFFERKEYB
            jsr ED_EchoLine                 ; FCT : Imprime  l'cran une ligne termine par CR pointe par X
                                            ;       Le curseur d'dition est  la premire position du texte dit
                                            ; IN  : X=Le tampon  afficher
                                            ;       B=le dbut du tampon  afficher
                                            ; OUT : A,B,X modified
                                            ; RMQ : La gestion du curseur est calamiteuse :
                                            ;       pourquoi rimprimer  les caractres dj affichs
                                            ;       au dbut de la procdure pour imprimer le curseur
                                            ;       en dbut de ligne ou du fait d'une ligne BASIC multiligne ?
                                            ;       ===> TODO : une nouvelle optimisation en vue

endSUPPR_EDITLINE:
            rts
; End of function ED_SUPPR_EDITLINE


; =============== S U B R O U T I N E =======================================

; FCT : Attend une saisie utilisateur
;       gre le clignotement du curseur
; IN  : /
; OUT : A=la touche actionne

OS_getKEY:
            jsr OS_manageCURSOR             ; FCT : gre le clignotement du curseur
                                            ; IN  : /
                                            ; OUT : A,B,X unmodified
            jsr OS_POLCA                    ; FCT : polling keyboard
                                            ; IN  : /
                                            ; OUT : A=code ascii de la touche
                                            ;       X,B not modified
            beq OS_getKEY                   ; FCT : Attend une saisie utilisateur
                                            ;       gre le clignotement du curseur
                                            ; IN  : /
                                            ; OUT : A=la touche actionne
            rts
; End of function OS_getKEY


; =============== S U B R O U T I N E =======================================

; FCT : Imprime  l'cran une ligne termine par CR pointe par X
;       Le curseur d'dition est  la premire position du texte dit
; IN  : X=Le tampon  afficher
;       B=le dbut du tampon  afficher
; OUT : A,B,X modified
; RMQ : La gestion du curseur est calamiteuse :
;       pourquoi rimprimer les caractres dj affichs
;       au dbut de la procdure pour imprimer le curseur
;       en dbut de ligne ou du fait d'une ligne BASIC multiligne ?
;       ===> TODO : une nouvelle optimisation en vue

ED_EchoLine:
            stx.w   INDEX                           ; OJE 13/02/2020

ED_EchoLine_bcl:
            bsr ED_echoCharWithoutCursor            ; FCT : affiche sur le device courant un caractre
                                                    ;       pointe par X et ne fait rien quand rencontre $0D
                                                    ; IN  : X=pointeur sur le caractre  afficher
                                                    ;       B=position du caractre  afficher dans le tampon point par X
                                                    ; OUT : Si A = $0D  : A=0xD
                                                    ;       Si A <> $0D : A=quelconque B=B+1, X=X+1
                                                    ;       B=B+1
                                                    ;       X=X+1
            bne ED_EchoLine_bcl

ED_EchoLine_bcl1:
            cpx.w   INDEX                           ; OJE 13/02/2020
            beq ED_EchoLine_end
            bsr ED_EchoCharWithCursorAndDecPosCur   ; FCT : Imprime le caractre point   par X puis
                                                    ;       dcremente de 1 la position du curseur  l'cran
                                                    ;       dcremente de 1 aussi le pointeur X  et B
                                                    ; IN  : B=Position du curseur dans le tampon de ligne
                                                    ;       X=Position du tampon de ligne
                                                    ; OUT : B=B-1
                                                    ;       X=X-1
            bra ED_EchoLine_bcl1

ED_EchoLine_end:
            rts
; End of function ED_EchoLine


; =============== S U B R O U T I N E =======================================

; FCT : Permet de reinitialiser diverses variables lies
;       au tampon clavier lors de l'dition en mode ligne
;       Ajoute un 0 en fin de tampon de saisie
;       Effectue un CR  l'cran
; IN  : /
; OUT : X=pointeur sur la zone tampon de saisie
;       A,B modidied

ED_finalyzeBUFFERKEYB:
            clr charKEYB
            ldx #BUFFERKEYB
            ldab POS_BUFFERKEYB
            abx
            clra
            tpa
            psha
            jsr printCR                     ; FCT : effectue un retour  la ligne
                                            ; IN  : /
                                            ; OUT : A modified
            clr 0,x
            ldx #(BUFFERKEYB-1)
            pula
            tap
            rts
; End of function ED_finalyzeBUFFERKEYB


; =============== S U B R O U T I N E =======================================

; FCT : gre le clignotement du curseur
; IN  : /
; OUT : A,B,X unmodified

OS_manageCURSOR:
            pshx
            dec CURWAITCLIGNOTEMENT
            bne endManageCURSORT_TEMPO
            psha
            ldaa 0,x
            cmpa #cOS_CR
            bne nextManageCURSOR
            ldaa #cOS_SPACE                 ; ' '

nextManageCURSOR:
            com fFLASHCAR
            beq next1ManageCURSOR
            ldaa #$80
            com fFLASHCUR
            beq next1ManageCURSOR
            ldaa COLOR_CARGRA               ; Code couleur cyclique pour les caractres graphiques via CTRL+0
            oraa #$8F

next1ManageCURSOR:
            jsr OS_prAtCURPOS               ; FCT : Affiche le caractre A  la position X=CURAD(Y,X)
                                            ; IN  : A=CHAR TO PRINT
                                            ; OUT : A, B unmodified
            ldaa #$5B ; '['
            staa CURWAITCLIGNOTEMENT
            pula
            pulx
            rts

endManageCURSORT_TEMPO:
            ldx #$0100

bclEndManageCURSORT_TEMPO:
            dex
            bne bclEndManageCURSORT_TEMPO
            pulx
            rts
; End of function OS_manageCURSOR


; =============== S U B R O U T I N E =======================================

; FCT : Affiche le caractre A  la position X=CURAD(Y,X)
; IN  : A=CHAR TO PRINT
; OUT : A, B unmodified

OS_prAtCURPOS:
            ldx CURAD_YX
            psha
            pshb
            jsr vectorOS_PRINT              ; FCT : Stocke  la position X(Y,X) le caractre A
                                            ; IN  : A=caractre  afficher
                                            ;       X=POS (Y,X) du caractre  afficher
                                            ; OUT : A,B,X modified
            pulb
            pula
            rts
; End of function OS_prAtCURPOS


; =============== S U B R O U T I N E =======================================

; FCT : Imprime le caractre A puis le curseur courant est dcrement d'une position
; IN  : A=Caractre  imprimer
; OUT : X unmodified

ED_PrintAndDecCur:
            pshx
            bsr OS_prAtCURPOS               ; FCT : Affiche le caractre A  la position X=CURAD(Y,X)
                                            ; IN  : A=CHAR TO PRINT
                                            ; OUT : A, B unmodified
            jsr vectorDecCursor             ; FCT : Appelle la routine de dcrmentation de la position du curseur
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : X=POS(Y,X-1)
                                            ;       A and B not modified
            stx CURAD_YX
            pulx
            rts
; End of function ED_PrintAndDecCur

; ---------------------------------------------------------------------------
tabDUMMY:       dc.b $FF,$FF,$FF,$FF,$FF

; =============== S U B R O U T I N E =======================================

; FCT : Initialise le EF9345 pour le mode 80 caractres en mode assembleur
; IN  : /
; OUT : A,B,X modified

GR_initVIDEO_mode80_ASS:
            ldx #tabEF9345_HIRES_ASM
            bra nextInitVIDEO_mode80
; End of function GR_initVIDEO_mode80_ASS


; =============== S U B R O U T I N E =======================================

; FCT : Initialise le EF9345 pour le mode 80 caractres en mode normal
; IN  : /
; OUT : A,B,X modified

GR_initVIDEO_mode80_NORM:
            ldx #tabEF9345_HIRES_NOR

nextInitVIDEO_mode80:
            jsr progEF9345                          ; FCT : Permet de paramtrer les registres TGS,MAT,PAT,DOR,ROR
                                                    ; IN  : X=pointeur sur paramtrage pour EF9345
                                                    ; OUT : A,B,X modified
            ldaa #cOS_PLEIN                         ; $7F : caractre plein
            staa EF9345_R1                          ; = CARACTERE (C)
            ldaa Attribute_HIRES                    ; contient l'attribut du caractre en mode haute rsolution
                                                    ; Par dfaut contient $00 (mode inversion) sinon $88.
                                                    ; C'est un nibble donc l'attribut doit tre rpt 2
                                                    ; fois dans l'octet (car colonne paire/impaire !)
                                                    ; Sinon cela fait des effets sympas
            staa EF9345_R3                          ; = ATTRIBUTS (A)
            ldd #$0000
            std EF9345_R6
            ldaa #cVDP_CMD_KRL+cVDP_WR+cVDP_NO_INC  ; $50 : 0101/1/00/0 : KRL/WRITE/null/NO INC PTR
            staa EF9345_EXEC
            jsr isEF9345ready                       ; FCT : test if EF9345 is ready
                                                    ; IN  : /
                                                    ; OUT : A,X,Y unmodified
            eorb #$80
            stab EF9345_RF
            clrb
            jmp initVRAM_InitVIDEO_mode40
; End of function GR_initVIDEO_mode80_NORM


; =============== S U B R O U T I N E =======================================

; FCT : Read CHAR + ATTRIBUT MODE 80 COL 12 bits
; IN  : X=POS(Y,X) de l'octet  lire
; OUT : A=$20 si attribut sinon le code ASCII

READ_ASCII_EF9345_HIRES:
            jsr setR6_MP_EF9345                     ; FCT : Set MP (R6 EF9345) from logical coordinate given by X
                                                    ; IN  : X=POS(Y,X)
                                                    ; OUT : A and B unmodified
                                                    ;       X=POS(Y,X)
            ldaa #cVDP_CMD_KRL+cVDP_RD+cVDP_NO_INC  ; $58 : 0101/1/00/0 : KRL/READ/null/NO INC PTR
            staa EF9345_EXEC
            jsr isEF9345ready                       ; FCT : test if EF9345 is ready
                                                    ; IN  : /
                                                    ; OUT : A,X,Y unmodified
            ldaa EF9345_R1
            bmi endREAD_ASCII_EF9345_HIRES
            jsr convUnderscore                      ; FCT : Si A=$0C alors conversion en code ASCII '_' sinon rien
                                                    ; ST  : ACTIF
                                                    ; IN  : A=$0C
                                                    ; OUT : A=$5F si A=0X0C ou A
            rts

endREAD_ASCII_EF9345_HIRES:
            ldaa #$20 ; ' '
            rts
; End of function READ_ASCII_EF9345_HIRES


; =============== S U B R O U T I N E =======================================

; FCT : Imprime caractre plein si mod $F sinon espace
; IN  : A=caractre dont l'intervalle est 0x80-0xFF
; OUT : A et B modified

treatHICHAR_HIRES:
            ldab #cOS_SPACE                     ; ' ' ; espace
            anda #$0F
            bne nextTreatHICHAR_HIRES
            ldab #cOS_PLEIN                     ; $7F ; caractre plein

nextTreatHICHAR_HIRES:
            tba
            ldab Attribute_HIRES                ; TODO pourquoi tant de haine ... tba  supprimer, lda Color , ainsi de suite
            stab EF9345_R3                      ; set attibute
            staa EF9345_R1                      ; set char
            rts
; End of function treatHICHAR_HIRES


; =============== S U B R O U T I N E =======================================

; FCT : Efface la ligne  la position (X,Y) en mode HIRES
; IN  : X=POS(X,Y) de dpart
; OUT : X unmodified

GR_ClrLine_HIRES:
            pshx
            ldab XMAX_SCR                       ; longueur d'un cran

bclGR_ClrLine_HIRES:
            jsr setR6_MP_EF9345                 ; FCT : Set MP (R6 EF9345) from logical coordinate given by X
                                                ; IN  : X=POS(Y,X)
                                                ; OUT : A and B unmodified
                                                ;       X=POS(Y,X)

            ldaa #cVDP_CMD_KRL+cVDP_WR+cVDP_INC ; $51 : 0000 0 00 1 : KRL (80 COL / 12 bits) write IncPtr
            staa EF9345_EXEC
            inx
            decb
            bne bclGR_ClrLine_HIRES
            pulx
            rts
; End of function GR_ClrLine_HIRES


; =============== S U B R O U T I N E =======================================

; FCT : crit en mmoire vido le caractre A en position X(YX)
; IN  : A: le caractre  crire
;       range : 0x00-0x1F : ne fait rien (pas d'affichage)
;               0x20-0x7F : caractre ASCII
;               0x80-0xFF : ?
;       X: la position(Y,X) o crire le caractre
; OUT : A,B modified

GR_PRINT_HIRES:
            jsr isEF9345ready                   ; FCT : test if EF9345 is ready
                                                ; IN  : /
                                                ; OUT : A,X,Y unmodified

isCharPrinting:
            cmpa #$20 ; ' '
            bcs endGR_PRINT_HIRES
            cmpa #$80
            bcs nextGR_PRINT_HIRES
            jsr treatHICHAR_HIRES               ; FCT : Imprime caractre plein si mod $F sinon espace
                                                ; IN  : A=caractre  dont l'intervalle est 0x80-0xFF
                                                ; OUT : A et B modified
            bra next1GR_PRINT_HIRES

nextGR_PRINT_HIRES:
            ldab Attribute_HIRES                ; contient l'attribut du caractre en mode haute rsolution
                                                ; Par dfaut contient $00 (mode inversion) sinon $88.
                                                ; C'est un nibble donc l'attribut doit tre rpt 2
                                                ; fois dans l'octet (car colonne paire/impaire !)
                                                ; Sinon cela fait des effets sympas
            stab EF9345_R3
            jsr storeAToR1_EF9345               ; FCT : stocke A dans R1 du EF9345;
                                                ;       Si A=$5F alors on stocke $0C dans R1
                                                ; IN  : A=caractre  stocker dans R1 :$ 00-$7F
                                                ; OUT : A=$0C si A=$5F sinon inchang

next1GR_PRINT_HIRES:
            jsr setR6_MP_EF9345                 ; FCT : Set MP (R6 EF9345) from logical coordinate given by X
                                                ; IN  : X=POS(Y,X)
                                                ; OUT : A and B unmodified
                                                ;       X=POS(Y,X)
            ldaa #cVDP_CMD_KRL+cVDP_WR+cVDP_INC ; $51 : 0000 0 00 1 : KRL (80 COL / 12 bits) write IncPtr
            staa EF9345_EXEC
            jsr isEF9345ready                   ; FCT : test if EF9345 is ready
                                                ; IN  : /
                                                ; OUT : A,X,Y unmodified

endGR_PRINT_HIRES:
            rts
; End of function GR_PRINT_HIRES


; =============== S U B R O U T I N E =======================================

; FCT : Efface une ligne en mode haute rsolution
; IN  : /
; OUT : A,B,X modified

GR_clrLineHIRES:
            ldaa Attribute_HIRES            ; contient l'attribut du caractre en mode haute rsolution
                                            ; Par dfaut contient $00 (mode inversion) sinon $88.
                                            ; C'est un nibble donc l'attribut doit tre rpt 2
                                            ; fois dans l'octet (car colonne paire/impaire !)
                                            ; Sinon cela fait des effets sympas
            staa EF9345_R3
            ldaa #cOS_SPACE                 ; $20 ; ' '
            staa EF9345_R1
            jsr GR_ClrLine                  ; FCT : Efface la ligne de la position de Y.
                                            ;       Les registres R1 et R2 doivent tre initialiss  la bonne valeur
                                            ; ST  : ACTIF
                                            ; IN  : X=POS(X,Y) de dpart
                                            ; OUT : A,B modified
                                            ;       X : unmodified
            rts
; End of function GR_clrLineHIRES

; ---------------------------------------------------------------------------
;----------------
; MAT + PAT : 80 colonnes mode long (R1,R2,R3)
;; $81=TGS,$D0=11 0 1  0 0 0 0
;         0  : 625 lignes / 50Hz
;         0  : NOT INTERLACED
;         0  : HOR RESYNC DISABLED
;         0  : VERT RESYNC DISABLED
;         1  : SYNC OUT (composite sync)
;         0  : SERVICE ROW Y=0
;         11 : 80 CHAR/ROW MODE, LONG CHAR CODE (1.5 bytes) with PAT7 set to 0
;; $82=MAT,$28=0 0 10 1 000
;         000 MARGE NOIRE
;         0   PAS DE CURSEUR
;         10  CURSEUR FIXE SOULIGNE
;         1   I SIGNAL AU NIVEAU HAUT DURANT LA PERIODE DE MARGE
;         0   PAS DE ZOOM
;; $83=PAT,$67=0    1 10 0 1 1 1
;   bit 7 0   80 CHAR/ROW MODE, LONG CODE with TGS7 and TGS6
;         1   FLASHING ENABLE
;         10  CHARACTER MARK (INSERT MODE)
;         0   CONCEAL DISABLE
;         1   LOWER BULK ENABLED
;         1   UPPER BULK ENABLED
;   bit 0 1   SERVICE ROW ENABLED
;; $84=DOR,$FA=1 111 1 010
;         1 010 : insert / Color C0 = VERT
;         1 111 : insert / Color C1 = BLANC
;
;; $87=ROR,$08=000 01000
;         010000 : ORIGIN ROW = 8
;         000    : Displayed Page Memory starts from block 0

VDP_HIR_NOR_TGS EQU (cVDP_TGS_625+cVDP_TGS_NO_INTERLACE+cVDP_TGS_NO_HOR_RESYNC+cVDP_TGS_NO_HOR_RESYNC+cVDP_TGS_NO_VER_RESYNC+cVDP_TGS_SYNC_OUT_COMP+cVDP_TGS_NO_SERVICE_ROW+cVDP_TGS_MODE_80_LONG)
VDP_HIR_NOR_MAT EQU (cVDP_MAT_NO_DBL_HEIGHT+cVDP_MAT_NO_CURSOR_DISP+cVDP_MAT_MD_CURS_FLS_CPL+cVDP_MAT_MARG_INS+cVDP_BLACK)
VDP_HIR_NOR_PAT EQU (cVDP_PAT_MODE_80_LONG+cVDP_PAT_FLASH_EN+cVDP_PAT_INS_MODE_CHAR_MARK+cVDP_PAT_NO_CONCEAL_EN+cVDP_PAT_DW_BULK_EN+cVDP_PAT_UP_BULK_EN+cVDP_PAT_SERVICE_ROW_EN)
VDP_HIR_NOR_DOR EQU (cVDP_DOR_HI_INS_HI+(cVDP_WHITE*16)+cVDP_DOR_HI_INS_LO+cVDP_GREEN)

tabEF9345_HIRES_NOR:
    dc.b VDP_HIR_NOR_TGS, cVDP_CMD_IND+cVDP_REG_TGS   ; 0 : $D0,$81
    dc.b VDP_HIR_NOR_MAT, cVDP_CMD_IND+cVDP_REG_MAT   ; 2 : $28,$82
    dc.b VDP_HIR_NOR_PAT, cVDP_CMD_IND+cVDP_REG_PAT   ; 4 : $67,$83
    dc.b VDP_HIR_NOR_DOR, cVDP_CMD_IND+cVDP_REG_DOR   ; 6 : $FA,$84
    dc.b $08            , cVDP_CMD_IND+cVDP_REG_ROR   ; 8 : $08,$87


; =============== S U B R O U T I N E =======================================

; FCT : Efface l'cran selon le mode graphique
; ST  : CODE INACTIF
; IN  : /
; OUT : /

CLREOL:
            tst TECRAN                              ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            bne CLREOL_LORES
            jmp GR_ClrLine_HIRES                    ; FCT : Efface la ligne  la position (X,Y) en mode HIRES
                                                    ; IN  : X=POS(X,Y) de dpart
                                                    ; OUT : X unmodified

CLREOL_LORES:
            jmp nextOS_clrLineLORES
; End of function CLREOL


; =============== S U B R O U T I N E =======================================

; FCT : Allume le pixel en position X. Utilise RDPIX_EF9345 pour connaitre le pixel  allumer
; IN  : X=(X div 2,Y div 5) position du pixel  traiter !
; OUT : A,B,X modified

setPixel_HIRES_EF9345:
            jsr setR6_MP_EF9345                     ; FCT : Set MP (R6 EF9345) from logical coordinate given by X
                                                    ; IN  : X=POS(Y,X)
                                                    ; OUT : A and B unmodified
                                                    ;       X=POS(Y,X)

readPixelBlock:
            ldaa #cVDP_CMD_KRL+cVDP_RD+cVDP_NO_INC  ; $58 : 0101/1/00/0 : KRL/READ/null/NO INC PTR
                                                    ; le rsultat de trouvera dans R1=C et R3=A
            staa EF9345_EXEC
            jsr isEF9345ready                       ; FCT : test if EF9345 is ready
                                                    ; IN  : /
                                                    ; OUT : A,X,Y unmodified
            ldd RDPIX_EF9345
            lsld                                    ; D=D*2: C=BIT[15] OF D
            rorb                                    ; D=BA so ?
            asla
            adca #$00
            anda #$0F
            stab EF9345_R1
            ldab EF9345_R3
            tst EF9345_R7
            bmi nextSetPixel_HIRES_EF9345
            asla
            asla
            asla
            asla
            andb #$0F
            bra next1SetPixel_HIRES_EF9345

nextSetPixel_HIRES_EF9345:
            andb #$F0

next1SetPixel_HIRES_EF9345:
            aba
            staa EF9345_R3
            ldaa #cVDP_CMD_KRL+cVDP_WR+cVDP_NO_INC  ; $50 : 0101/1/00/0 : KRL/WRITE/null/NO INC PTR
            staa EF9345_EXEC
            rts
; End of function setPixel_HIRES_EF9345


; =============== S U B R O U T I N E =======================================

; FCT : Lit la couleur de la position d'un pixel en mode haute rsolution
; IN  : X=Position Y,X selon le mode semigraphique = (Y div 5, X div 2)
;       D=Position Y,X selon la matrice 5x2 du pixel recherch
; OUT : D=La valeur des pixels (0,1) contenus dans la matrice 5x2
;       au format sm0000A2A1/A0C6C5C4C3C2C1C0

readHIRES_EF9345:
            jsr setR6_MP_EF9345                     ; FCT : Set MP (R6 EF9345) from logical coordinate given by X
                                                    ; IN  : X=POS(Y,X)
                                                    ; OUT : A and B unmodified
                                                    ;       X=POS(Y,X)
            ldaa #cVDP_CMD_KRL+cVDP_RD+cVDP_NO_INC  ; $58 : 0101/1/00/0 : KRL/READ/null/NO INC PTR
            staa EF9345_EXEC
            jsr isEF9345ready                       ; FCT : test if EF9345 is ready
                                                    ; IN  : /
                                                    ; OUT : A,X,Y unmodified
            ldaa EF9345_R3                          ; read nibble A (EF9345)
            tst EF9345_R7                           ; Test la parit de  X dans R7 car les pixels A3,A2,A1
                                                    ; ne sont pas au mme endroit dans R3 !
            bmi nextReadHIRES_EF9345
            anda #$F0                               ; nous sommes en colonne paire donc on dcale de 4 vers la droite
                                                    ; pour rcuprer 0000 A3A2A1D avec D : couleur active
            lsra
            lsra
            lsra
            lsra
            bra next1ReadHIRES_EF9345

nextReadHIRES_EF9345:
            anda #$0F                               ; nous sommes en colonne impaire alors on efface le nibble de poids fort

next1ReadHIRES_EF9345:
            ldab EF9345_R1                          ; on rcupre les donnes concernant les pixels C6  C0 !
            lsra                                    ; nous rcuprons le bit D (code couleur : 0=couleur de l'encre/1=couleur de la marge)
            bcc next2ReadHIRES_EF9345
            adda #$80                               ; nous indiquons que la couleur de la pixel est celui de la marge

next2ReadHIRES_EF9345:
            aslb                                    ; On rcupre le bit 7 indiquant un caractre semi-graphique ou pas
            rora                                    ; on propage ce bit dans A (pixel A3,A2,A1) puis le bit 0 dans C
            rorb                                    ; on propage le bit 0 de A dans B
            std RDPIX_EF9345                        ; et on stocke dans RDPIX_EF9345 la valeur sm0000A2A1A0C6C5C4C3C2C1C0
            rts
; End of function readHIRES_EF9345


; =============== S U B R O U T I N E =======================================

; FCT : dtermine le pixel impact grce au masque
; IN  : /
; OUT : RDPIX_EF9345 = RDPIX_EF9345 OR MSKPIX_EF9345

setPixelWithMask:
            ldd  RDPIX_EF9345
            oraa MSKPIX_EF9345              ; Masque du pixel recherch en mode HIRES
            orab MSKPIX_EF9345+1            ; Masque du pixel recherch en mode HIRES
            std  RDPIX_EF9345
            rts
; End of function setPixelWithMask


; =============== S U B R O U T I N E =======================================

; FCT : Slectionne le pixel(dans la matrice 5x2)  teindre
; IN  : /
; OUT : D=RDPIX_EF9345=le pixel  mettre  jour

resetPixel_HIRES:
            ldd  RDPIX_EF9345
            com  MSKPIX_EF9345
            com  MSKPIX_EF9345+1
            anda MSKPIX_EF9345              ; Masque du pixel recherch en mode HIRES
            andb MSKPIX_EF9345+1            ; Masque du pixel recherch en mode HIRES
            com  MSKPIX_EF9345
            com  MSKPIX_EF9345+1
            std  RDPIX_EF9345
            rts
; End of function resetPixel_HIRES


; =============== S U B R O U T I N E =======================================

; FCT : Applique le masque de recherche de pixel sur la valeur lue
;   (matrice 5x2)
; IN  : /
; OUT : D=0 si pixel eteint sinon <> 0 pour pixel allum

convPixelToXY:
            ldd RDPIX_EF9345
            anda MSKPIX_EF9345              ; Masque du pixel recherch en mode HIRES
            bne endConvPixelToXY
            andb MSKPIX_EF9345+1            ; Masque du pixel recherch en mode HIRES

endConvPixelToXY:
            rts
; End of function convPixelToXY


; =============== S U B R O U T I N E =======================================

; FCT : retourne la position du pixel en mode semi-graphique
;   Le pixel est contenu dans une zone de 2 colonnes de 5 ranges
;   C0 C1
;   C2 C3
;   C4 C5
;   C6 A1
;   A2 A3
; IN  : A=Y mod 5 c'est  dire le numro de ligne dans la matrice 5x2 de pixels
;       B=Parit de X
; OUT : D=La position du pixel recherch selon (Y=A,X=B) dans la matrice 5x2

convXY2NumPixel:
            asla                    ; A=(Y div 5) * 2
            aba                     ; A=(Y div 5) * 2 + (0 ou 1)
            ldx #tabXY2Pixel
            tab                     ; B=(Y div 5) * 2 + (0 ou 1)
            aslb                    ; B=((Y div 5)*2 + (0 ou 1))*2
            abx
            ldd 0,x
            std MSKPIX_EF9345       ; Masque du pixel recherch en mode HIRES
            rts
; End of function convXY2NumPixel

; ---------------------------------------------------------------------------
; Tableau de conversion pour obtenir la position
; du pixel recherch dans la matrice 5x2 en mode HIRES
tabXY2Pixel:        dc.b  $00,$01  ; 0
                    dc.b  $00,$02  ; 2
                    dc.b  $00,$04  ; 4
                    dc.b  $00,$08  ; 6
                    dc.b  $00,$10  ; 8
                    dc.b  $00,$20  ; 10
                    dc.b  $00,$40  ; 12
                    dc.b  $00,$80  ; 14
                    dc.b  $01,$00  ; 16
                    dc.b  $02,$00  ; 18

; =============== S U B R O U T I N E =======================================

; FCT : dfinit les deux couleurs actives en mode 80 colonnes
;       Par dfaut, encre blanche et fond vert
;       Si A ou B >= $08 alors on prend la couleur par dfaut !
; IN  : A=code couleur du l encre C1
;       B=code couleur de l'encre C2
; OUT : /

GR_setColorHIRES:
            pshb
            ldab #cVDP_DOR_HI_INS_HI+cVDP_WHITE*16+cVDP_DOR_HI_INS_LO+cVDP_GREEN
			                                        ; $FA=1/111|1/010 : Par dfaut, encre blanche et fond vert
            stab dataR4_EF9345
            bsr computeColorEF9345                  ; FCT : Calcule le code couleur quivalent EF9345 selon A
                                                    ; IN  : A=code couleur
                                                    ; OUT : Si A=0     alors A=$80   et C=1
                                                    ;       Si A=1  6 alors A= [$A0,$B0,$C0,$90,$F0,$E0,$D0] et C=1
                                                    ;       SI A=7     alors A=$30   et C=1
                                                    ;       Si A>=8    alors A=A     et C=0
            bcc nextSetDOR_EF9345
            lsra                                    ; dcalage de 4 bits pour mettre  jour du quartet encre ?
            lsra
            lsra
            lsra
            ldab dataR4_EF9345
            andb #$F0                               ; Mise  jour de la couleur C0 du registre DOR
            aba
            staa dataR4_EF9345

nextSetDOR_EF9345:
            pula
            bsr computeColorEF9345                  ; FCT : Calcule le code couleur quivalent EF9345 selon A
                                                    ; IN  : A=code couleur
                                                    ; OUT : Si A=0     alors A=$80   et C=1
                                                    ;       Si A=1  6 alors A= [$A0,$B0,$C0,$90,$F0,$E0,$D0] et C=1
                                                    ;       SI A=7     alors A=$30   et C=1
                                                    ;       Si A>=8    alors A=A     et C=0
            bcc dosetDOR_EF9345
            ldab dataR4_EF9345
            andb #$0F
            aba                                     ; Mise  jour de la couleur C1 du registre DOR
            staa dataR4_EF9345

dosetDOR_EF9345:
            ldaa #cVDP_CMD_IND+cVDP_WR+cVDP_REG_DOR ; $84 ; write R1 of EF9345 into DOR Register
            staa cmdR4_EF9345
            ldab #$01
            ldx #dataR4_EF9345
            jsr bclProgEF9345                       ; B=nb octet  crire (R1,EXEC) X = position du paramtrage
            rts
; End of function GR_setColorHIRES


; =============== S U B R O U T I N E =======================================

; FCT : Calcule le code couleur quivalent EF9345 selon A
; IN  : A=code couleur
; OUT : Si A=0     alors A=$80   et C=1
;       Si A=1  6 alors A= [$A0,$B0,$C0,$90,$F0,$E0,$D0] et C=1
;       Si A=7     alors A=$30   et C=1
;       Si A>=8    alors A=A     et C=0

computeColorEF9345:
            tsta
            beq endComputeColorEF9345
            cmpa #$08
            bcc end1ComputeColorEF9345          ; Si A >= $08 alors C=1
            deca
            ldx #tabColor
            tab
            abx
            ldaa 0,x
            bne endComputeColorEF9345
            ldaa #$B0

endComputeColorEF9345:
            eora #$80
            sec
            rts

end1ComputeColorEF9345:
            clc
            rts
; End of function computeColorEF9345

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR getPixel_HIRES

jmpPrintErrorMSg0x08_FC:

            jmp printErrorMSG_0x08_FC_FctIncorrect
; END OF FUNCTION CHUNK FOR getPixel_HIRES

; =============== S U B R O U T I N E =======================================

; FCT : effectue l'interprtation de l'expression (X,Y
; IN  : le flot d'interprtation
; OUT : X=POS(X div 2,Y div 5)
;       D=la valeur des pixels (0,1) contenus dans une matrice 5x2  la POS(X,Y)
;       MSKPIX_EF9345 est mise  jour : masque d'accs au pixel (X,Y)
;       RDPIX_EF9345  est mise  jour : valeur du pixel lu en POS(X,Y)

checkOPNBeforGetPixel_HIRES:
            jsr CHKOPN
; End of function checkOPNBeforGetPixel_HIRES


; =============== S U B R O U T I N E =======================================

; FCT : rcupre les paramtres X et Y dans le flot d'interprtation
;       et retourne dans D l'tat des pixels dans une matrice 2 col x 5 lig
;       rsolution en modes HIRES : 160  x 125
;       X=0-159 et Y=0-124
; IN  : /
; OUT : D=La valeur des pixels (0,1) contenus dans la matrice 5x2
;       Cette valeur est stocke dans RDPIX_EF9345
;       X=POS(X div 2,Y div 5)
;       MSKPIX_EF9345 est mise  jour : masque d'accs au pixel (X,Y)
;       RDPIX_EF9345  est mise  jour : valeur du pixel lu en POS(X,Y)
; ERR : $08 : FC

getPixel_HIRES:
            jsr GETBYT                      ; FCT : EVALUATE EXPRESSION AT TXTPTR, AND
                                            ;       CONVERT IT TO SINGLE BYTE IN B-REG
                                            ; ERR : FC : fonction incorrecte
                                            ; IN  : le flot d'interprtation
                                            ; OUT : B=la partie haute de la conversion (ACC1+3,ACC1+4)
            cmpb SCRPIX_XMAX                ; Taille max en pixel pour X
            bcc jmpPrintErrorMSg0x08_FC
            clra
            lsrb
            adca #$00
            psha                            ; sauvegarde si c'est une colonne paire(=0) ou impaire(=1)
            stab POINT_YX_HIRES+1           ; stocke la valeur de X div 2

getY_POINT:
            jsr getByteAfterComma           ; FCT : Retourne la valeur de l'expression aprs la
                                            ;       virgule contenue dans le flot d'interprtation
                                            ; IN  : /
                                            ; OUT : B=la valeur en octet de l'expression
            cmpb SCRPIX_YMAX                ; Taille max en pixel pour Y
            bcc jmpPrintErrorMSg0x08_FC
            clra

findLineMod5:
            inca                            ; Mode HIRES : mode semi-graphique rsolution / 2
            subb #$05
            bpl findLineMod5
            deca
            addb #$05
            staa POINT_YX_HIRES             ; stocke la valeur Y div 5
            tba                             ; Y mod 5
            pulb                            ; rcupre la parit de X
            jsr convXY2NumPixel             ; FCT : retourne la position du pixel en mode semi-graphique
                                            ;       Le pixel est contenu dans une zone de 2 colonnes de 5 ranges
                                            ;       C0 C1
                                            ;       C2 C3
                                            ;       C4 C5
                                            ;       C6 A1
                                            ;       A2 A3
                                            ; IN  : A=Y mod 5 c'est  dire le numro de ligne dans la matrice 5x2 de pixels
                                            ;       B=Parit de  X
                                            ; OUT : D=La position du pixel recherch selon (Y=A,X=B) dans la matrice 5x2
            ldx POINT_YX_HIRES
            jsr readHIRES_EF9345            ; FCT : Lit la couleur de la position d'un pixel en mode haute rsolution
                                            ; IN  : X=Position Y,X selon le mode semigraphique = (Y div 5, X div 2)
                                            ;       D=Position Y,X selon la matrice 5x2 du pixel recherch
                                            ; OUT : D=La valeur des pixels (0,1) contenus dans la matrice 5x2
											;       au format sm0000A2A1/A0C6C5C4C3C2C1C0
            rts
; End of function getPixel_HIRES


; =============== S U B R O U T I N E =======================================

; FCT : Effectue les deux actions possibles en haute rsolution
;       SET* C0,C1,C2 : pour fixer les couleurs
;       SET (X,Y,[0,1,2]) : pour allumer le pixel X,Y avec la couleur prdfinie par SET*
; ERR : 0X08 : FC
; IN  : le flot d'interprtation
; OUT : A,B,X modified

doRomSET_HIRES:
            jsr.w   CHRGOT                  ; OJE 13/02/2020
            cmpa #cBAS_TOKEN_mult           ; $A9 : opcode * pour SET*
            bne nextDoRomSET_HIRES
            jmp doSetColor_HIRES            ; FCT : traite la commmande SET* C0,C1,C2 en haute rsolution
                                            ;       initialise les couleurs de la marge et les deux couleurs possibles en HIRES
                                            ; IN  : le flot d'interprtation aprs SET*
                                            ; OUT : /

nextDoRomSET_HIRES:
            jsr checkOPNBeforGetPixel_HIRES ; FCT : effectue l'interprtation de l'expression (X,Y
                                            ; IN  : le flot d'interprtation
                                            ; OUT : X=POS(X div 2,Y div 5)
                                            ;       D=la valeur des pixels (0,1) contenus dans une matrice 5x2  la POS(X,Y)
                                            ;       MSKPIX_EF9345 est mise  jour : masque d'accs au pixel (X,Y)
                                            ;       RDPIX_EF9345  est mise  jour : valeur du pixel lu en POS(X,Y)
            pshx                            ; sauvegarde X,Y

getColor:
            jsr getByteAfterComma           ; FCT : Retourne la valeur de l'expression aprs la
                                            ;       virgule contenue dans le flot d'interprtation
                                            ; IN  : /
                                            ; OUT : B=la valeur en octet de l'expression
            pulx                            ; rcupre X,Y
            pshb                            ; sauvegarde C : le code couleur [0..2] avec 0:couleur marge
            jsr jmpIsRightParen             ; FCT : vrifie que le prochain caractre est une ')'
                                            ;       sort en erreur si ce n'est pas le cas
                                            ; IN  : le flot d'interprtation
                                            ; OUT : /
            pulb                            ; rcupre le code couleur
            cmpb #$03                       ; < 3 ?
            bcc jmpPrintErrorMSg0x08_FC     ; non alors erreur !
            tstb
            beq nextDoRomRESET_HIRES        ; code couleur=marge ? Oui alors on eteint le point via RESET !
            ldaa RDPIX_EF9345               ; rcupration de la valeur de la zone 2x5 contenant le pixel demand
            bmi next1DoRomSET_HIRES
            clr RDPIX_EF9345+1
            ldaa #$80

next1DoRomSET_HIRES:
            anda #$BF
            decb
            beq next2DoRomSET_HIRES
            oraa #$40

next2DoRomSET_HIRES:
            staa RDPIX_EF9345
            ldd RDPIX_EF9345                ; code mort car tu le fais le load aussi dans SetPixelWithMask
            jsr setPixelWithMask            ; FCT : dtermine le pixel impact grce au masque
                                            ; IN  : /
                                            ; OUT : RDPIX_EF9345 = RDPIX_EF9345 OR MSKPIX_EF9345
            jsr setPixel_HIRES_EF9345       ; FCT : Allume le pixel en position X. Utilise RDPIX_EF9345 pour connaitre le pixel  allumer
                                            ; IN  : X=(X div 2,Y div 5) position du pixel  traiter !
                                            ; OUT : A,B,X modified
            rts
; End of function doRomSET_HIRES


; =============== S U B R O U T I N E =======================================

; FCT : teint le pixel   la position (X,Y) obtenue via le flux d'interprtation
; IN  : le flot d'interprtation contenant la squence (X,Y)
; OUT : /

doRomRESET_HIRES:
            jsr checkOPNBeforGetPixel_HIRES ; FCT : effectue l'interprtation de l'expression (X,Y
                                            ; IN  : le flot d'interprtation
                                            ; OUT : X=POS(X div 2,Y div 5)
                                            ;       D=la valeur des pixels (0,1) contenus dans une matrice 5x2  la POS(X,Y)
                                            ;       MSKPIX_EF9345 est mise  jour : masque d'accs au pixel (X,Y)
                                            ;       RDPIX_EF9345  est mise  jour : valeur du pixel lu en POS(X,Y)
            jsr jmpIsRightParen             ; FCT : vrifie que le prochain caractre est une ')'
                                            ;       sort en erreur si ce n'est pas le cas
                                            ; IN  : le flot d'interprtation
                                            ; OUT : /

nextDoRomRESET_HIRES:
            tst RDPIX_EF9345
            bpl endDoRomRESET_HIRES
            jsr resetPixel_HIRES            ; FCT : Slectionne  le pixel(dans la matrice 5x2)  teindre
                                            ; IN  : /
                                            ; OUT : D=RDPIX_EF9345=le pixel  mettre  jour
            jsr setPixel_HIRES_EF9345       ; FCT : Allume le pixel en position X. Utilise RDPIX_EF9345 pour connaitre le pixel  allumer
                                            ; IN  : X=(X div 2,Y div 5) position du pixel  traiter !
                                            ; OUT : A,B,X modified

endDoRomRESET_HIRES:
            rts
; End of function doRomRESET_HIRES


; =============== S U B R O U T I N E =======================================

; FCT : retourne l'tat du pixel  la position (X,Y)
; IN  : le flot d'interprtation contenant les paramtres sous forme (X,Y)
; OUT : retourne -1 (=$FF : caractre),0(pixel teint),1(pixel allum) ou 2 (couleur de la marge) sous forme de word

doRomPoint_HIRES:
            jsr getPixel_HIRES              ; FCT : rcupre les paramtres X et Y dans le flot d'interprtation
                                            ;       et retourne dans D l'tat des pixels dans une matrice 2 col x 5 lig
                                            ;       rsolution en modes  HIRES : 160 x 125
                                            ;       X=0-159 et Y=0-124
                                            ; IN  : /
                                            ; OUT : D=La valeur des pixels (0,1) contenus dans la matrice 5x2
                                            ;       Cette valeur est stocke dans RDPIX_EF9345
                                            ;       X=POS(X div 2,Y div 5)
                                            ;       MSKPIX_EF9345 est mise  jour : masque d'accs au pixel (X,Y)
                                            ;       RDPIX_EF9345  est mise  jour : valeur du pixel lu en POS(X,Y)
                                            ; ERR : $08 : FC
            ldab #$FF                       ; =$FF si la position lue contient un caractre
            tst RDPIX_EF9345
            bpl nextdoRomPoint_HIRES
            incb                            ; =$00 : le pixel est teint
            pshb
            jsr convPixelToXY               ; FCT : Applique le masque de recherche de pixel sur la valeur lue
                                            ;       (matrice 5x2)
                                            ; IN  : /
                                            ; OUT : D=0 si pixel eteint sinon <> 0 pour pixel allum
            pulb
            beq nextdoRomPoint_HIRES
            incb                            ; =$01 : le pixel est allum
            ldaa RDPIX_EF9345
            bita #$40                       ; Le bit [14] de RDPIX_EF9345 est-il  1 ? oui alors c'est un pixel allum avec la couleur de la marge ...
            beq nextdoRomPoint_HIRES
            incb                            ; =$02 : la couleur du bit (en fait du pav de 5 col x 2 lignes) est celle de la marge

nextdoRomPoint_HIRES:

            jsr returnWordFromB             ; FCT : Retourne un mot issu de B
                                            ;       range : 0x00 - 0x7F => 0000 007F
                                            ;               0x80 - 0xFF => FF80 FFFF
                                            ; IN  : B=byte to convert to signed word
                                            ; OUT : D=convInt2Word(B)
            jmp CHKCLS                      ; FCT : check close parenthesis and get next char
                                            ; IN  : TXTPTR mise  jour
                                            ; OUT : X modified, A et B modified
; End of function doRomPoint_HIRES

; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC SET
;   2 utilisations
;   1re : LORES
;   CLS0:SET(X,Y,C) avec X=[0;63 ou 79] si mode 32 ou 40 colonnes
;   2me : HIRES
;   CLS80:
;   SET* C0,C1,C2 avec C0: couleur marge [0;7],
;              C1: couleur intensit [0..7],
;              C2: couleur demi-intensit [0..7]
;   SET (X,Y,C) avec C=[0,1,2] (marge, intensit, demi-intensit)
; OP  : $9B
; IN  : le flot d'interprtation
; OUT : A,B,X modified

doRomSET:
            tst TECRAN                  ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            beq vectorSET_HIRES

getXYParamDoRomSET:
            jsr parsePRM_GR             ; FCT : parse l'expression de type (X,Y dans le flot d'interprtation
                                        ; STX : /
                                        ; ALG : /
                                        ; ST  : ACTIF
                                        ; IN  : le flot d'interprtation
                                        ; OUT : adrMEM_XY=(X,Y) en mode LORES
                                        ;       X=POS(Y,X)
            pshx                        ; sauvegarde POS(Y,X)
            jmp doRomSET_LORES          ; FCT : Effectue l'opration SET (X,Y,C) pour le mode basse rsolution
                                        ; ALG : Rcupre le paramtre C (C=[0..8]) dans le flot d'interprtation
                                        ; ST  : ACTIF
                                        ; IN  : Flot d'intrerprtation
                                        ;       S->POS(X,Y)
                                        ;       adrMEM_XY : mise  jour
                                        ; OUT : /
; End of function doRomSET

; =============== S U B R O U T I N E =======================================

; FCT : teint un pixel en mode LORES et HIRES
; IN  : le flot d'interprtation
; OUT : /

doRomRESET:
            tst TECRAN                  ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            beq vectorRESET_HIRES

doRomRESET_LORES:
            jsr parsePRM_GR             ; FCT : parse l'expression de type (X,Y dans le flot d'interprtation
                                        ; STX : /
                                        ; ALG : /
                                        ; ST  : ACTIF
                                        ; IN  : le flot d'interprtation
                                        ; OUT : adrMEM_XY=(X,Y) en mode LORES
                                        ;       X=POS(Y,X)
            jsr jmpIsRightParen         ; FCT : vrifie que le prochain caractre est une ')'
                                        ;       sort en erreur si ce n'est pas le cas
                                        ; IN  : le flot d'interprtation
                                        ; OUT : /
            jmp doDoRomRESET_LORES      ; FCT : Effectue l'action d'teindre un pixel
                                        ;       Si  la position X,Y, nous avons un caractre ASCII
                                        ;       alors on teint tous les pixels du caractre ASCII !
                                        ; IN  : X=POS(Y,X)
                                        ; OUT : A,X,Y : modified
; End of function doRomRESET

; =============== S U B R O U T I N E =======================================

; FCT : retourne la couleur du pixel en position (X,Y) en mode HIRES ou LOWRES
; IN  : le flot d'interprtation contenant les paramtres sous forme (X,Y)
; OUT : retourne
;   en HIRES :-1 (caractre),0 (teint),1 (couleur 1=encre) ou 2 (couleur 2=marge) sous forme de word
;   en LORES :-1 (caractre),0 (teint),1  8 code couleur si allum
;

doRomPOINT:
            tst TECRAN                      ; TYPE D ECRAN : 0 , 1 ,2 : 80x25, 40x25, 32x16
            beq vectorDoRomPoint_HIRES      ; FCT : retourne la couleur du pixel en position (X,Y) en mode HIRES
                                            ; IN  : le flot d'interprtation contenant les paramtres sous forme (X,Y)
                                            ; OUT : retourne -1 (=$FF : caractre),0(pixel teint),1(pixel allum) ou 2 (couleur de la marge) sous forme de word
            jsr getParamXY_PPWP             ; FCT : Parse l'expression du type X,Y dans le flot d'interprtation
                                            ; ALG : /
                                            ; STX : /
                                            ; ST  : ACTIF
                                            ; IN  : le flot d'interprtation
                                            ; OUT : adrMEM_XY a jour
                                            ;       A,B,X modified
            jmp doRomPOINT_LOWRES           ; FCT : FCT : retourne la couleur du pixel en position (X,Y) en mode LOWRES
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : D=code couleur de la position (Y,X)
; End of function doRomPOINT

; =============== S U B R O U T I N E =======================================


vectorSET_HIRES:
            jmp doRomSET_HIRES              ; FCT : Effectue les deux actions possibles en haute rsolution
                                            ;       SET* C0,C1,C2 : pour fixer les couleurs
                                            ;       SET (X,Y,[0,1,2]) : pour allumer le pixel X,Y avec la couleur prdfinie par SET*
                                            ; ERR : 0X08 : FC
                                            ; IN  : le flot d'interprtation
                                            ; OUT : A,B,X modified
; End of function vectorSET_HIRES

; =============== S U B R O U T I N E =======================================


vectorRESET_HIRES:
            jmp doRomRESET_HIRES            ; FCT : teint le pixel  la position (X,Y)  obtenue via le flux d'interprtation
                                            ; IN  : le flot d'interprtation contenant la squence (X,Y)
                                            ; OUT : /
; End of function vectorRESET_HIRES

; =============== S U B R O U T I N E =======================================

; FCT : retourne la couleur du pixel en position (X,Y) en mode HIRES
; IN  : le flot d'interprtation contenant les paramtres sous forme (X,Y)
; OUT : retourne -1 (=$FF : caractre),0(pixel teint),1(pixel allum) ou 2 (couleur de la marge) sous forme de word

vectorDoRomPoint_HIRES:
            jmp doRomPoint_HIRES            ; FCT : retourne l'tat du pixel  la position (X,Y)
                                            ; IN  : le flot d'interprtation contenant les paramtres sous forme (X,Y)
                                            ; OUT : retourne -1 (=$FF : caractre),0(pixel teint),1(pixel allum) ou 2 (couleur de la marge) sous forme de word
; End of function vectorDoRomPoint_HIRES

; =============== S U B R O U T I N E =======================================

; FCT : traite la commmande SET* C0,C1,C2 en haute rsolution
;       initialise les couleurs de la marge et les deux couleurs possibles en HIRES
; IN  : le flot d'interprtation aprs SET*
; OUT : /

doSetColor_HIRES:
            jsr.w   CHRGET                          ; OJE 13/02/2020
                                                    ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                                    ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                                    ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                                    ; NOT C= NUMERIC ("0" THRU "9")
                                                    ; Z= ":" OR END-OF-LINE (A NULL)
                                                    ; [ACCA] = NEW CHAR.
                                                    ; [TXTPTR]=[TXTPTR]+1

getC0:
            jsr GETBYT                              ; FCT : EVALUATE EXPRESSION AT TXTPTR, AND
                                                    ;       CONVERT IT TO SINGLE BYTE IN B-REG
                                                    ; ERR : FC : fonction incorrecte
                                                    ; IN  : le flot d'interprtation
                                                    ; OUT : B=la partie haute de la conversion (ACC1+3,ACC1+4)

savecC0:
            pshb                                    ; sauvegarde la couleur de la marge

getC1:
            jsr getByteAfterComma                   ; FCT : Retourne la valeur de l'expression aprs la
                                                    ;       virgule contenue dans le flot d'interprtation
                                                    ; IN  : /
                                                    ; OUT : B=la valeur en octet de l'expression

saveC1:
            pshb                                    ; sauvegarde la couleur intensit

getC2:
            jsr getByteAfterComma                   ; FCT : Retourne la valeur de l'expression aprs la
                                                    ;       virgule contenue dans le flot d'interprtation
                                                    ; IN  : /
                                                    ; OUT : B=la valeur en octet de l'expression

popC1:
            pula                                    ; Les couleurs B=C2 et A=C1
            jsr GR_setColorHIRES                    ; FCT : dfinit les deux couleurs actives en mode 80 colonnes
                                                    ;       Par dfaut, encre noire et fond vert
                                                    ;       Si A ou B >= $08 alors on prend la couleur par dfaut !
                                                    ; IN  : A=code couleur du l encre C1
                                                    ;       B=code couleur de l'encre C2
                                                    ; OUT : /

popC0:
            pula                                    ; rcupre la couleur de la marge
                                                    ; R1=$28: 0/0/10/1/000 : Pas Double hauteur / Pas curseur/ Curseur flash complement / Inscrustation de la marge / marge noire
            ldab #(cVDP_MAT_NO_DBL_HEIGHT+cVDP_MAT_NO_CURSOR_DISP+cVDP_MAT_MD_CURS_FLS_CPL+cVDP_MAT_MARG_INS+cVDP_BLACK)
            stab dataR1_EF9345
            jsr computeColorEF9345                  ; FCT : Calcule le code couleur quivalent EF9345 selon A
                                                    ; IN  : A=code couleur
                                                    ; OUT : Si A=0     alors A=$80   et C=1
                                                    ;       Si A=1  6 alors A= [$A0,$B0,$C0,$90,$F0,$E0,$D0] et C=1
                                                    ;       SI A=7     alors A=$30   et C=1
                                                    ;       Si A>=8    alors A=A     et C=0
            bcc setValueToMAT                       ; TODO : quel bordel !
            lsra
            lsra
            lsra
            lsra
            ldab dataR1_EF9345
            andb #$F0
            aba
            staa dataR1_EF9345

setValueToMAT:
            ldaa #cVDP_CMD_IND+cVDP_WR+cVDP_REG_MAT ; $82 ; write R1 of EF9345 into MAT Register
            staa cmdR1_EF9345
            ldab #$01
            ldx #dataR1_EF9345
            jsr bclProgEF9345                       ; B=nb octet  crire (R1,EXEC) X = position du paramtrage
            rts
; End of function doSetColor_HIRES

; ---------------------------------------------------------------------------
;----------------
; MAT + PAT : 80 colonnes mode long (R1,R2,R3)
;; $81=TGS,$D0=11 0 1  0    0 0 0
;         0  : 625 lignes / 50Hz
;         0  : NOT INTERLACED
;         0  : HOR RESYNC DISABLED
;         0  : VERT RESYNC DISABLED
;         1  : SYNC OUT (composite sync)
;         0  : SERVICE ROW Y=0
;         11 : 80 CHAR/ROW MODE, LONG CHAR CODE (1.5 bytes) with PAT7 set to 0
;; $82=MAT,$2C,=0 0 10 1 100
;         100 MARGE BLEUE
;         1   MARGE INSERER
;         10  CURSEUR FLASH INVERSE
;         0   PAS DE CURSEUR
;         0   PAS DE DOUBLE HAUTEUR
;; $83=PAT,$67=0 1 10 0 1 1 1
;   bit 7 0   80 CHAR/ROW MODE, LONG CODE with TGS7 and TGS6
;         1   FLASHING ENABLE
;         10  CHARACTER MARK (INSERT MODE)
;         0   CONCEAL DISABLE
;         1   LOWER BULK ENABLED
;         1   UPPER BULK ENABLED
;   bit 0 1   SERVICE ROW ENABLED
;; $84=DOR,$AF=1 010 / 1 111
;         1 111 : insert / Color C0 = BLANC
;         1 010 : insert / Color C1 = VERT
;
;; $87=ROR,$08=000 01000
;         010000 : ORIGIN ROW = 8
;         000    : Displayed Page Memory starts from block 0
;

VDP_HIR_ASM_MAT EQU (cVDP_MAT_NO_DBL_HEIGHT+cVDP_MAT_NO_CURSOR_DISP+cVDP_MAT_MD_CURS_FLS_CPL+cVDP_MAT_MARG_INS+cVDP_BLUE)
VDP_HIR_ASM_TGS EQU (cVDP_TGS_625+cVDP_TGS_NO_INTERLACE+cVDP_TGS_NO_HOR_RESYNC+cVDP_TGS_NO_HOR_RESYNC+cVDP_TGS_NO_VER_RESYNC+cVDP_TGS_SYNC_OUT_COMP+cVDP_TGS_NO_SERVICE_ROW+cVDP_TGS_MODE_80_LONG)
VDP_HIR_ASM_PAT EQU (cVDP_PAT_MODE_80_LONG+cVDP_PAT_FLASH_EN+cVDP_PAT_INS_MODE_CHAR_MARK+cVDP_PAT_NO_CONCEAL_EN+cVDP_PAT_DW_BULK_EN+cVDP_PAT_UP_BULK_EN+cVDP_PAT_SERVICE_ROW_EN)
VDP_HIR_ASM_DOR EQU cVDP_DOR_HI_INS_HI+(cVDP_GREEN*16)+cVDP_DOR_HI_INS_LO+cVDP_WHITE

tabEF9345_HIRES_ASM:
     dc.b VDP_HIR_ASM_TGS, cVDP_CMD_IND+cVDP_REG_TGS ; 0 : $D0,$81
     dc.b VDP_HIR_ASM_MAT, cVDP_CMD_IND+cVDP_REG_MAT ; 2 : $2C,$82
     dc.b VDP_HIR_ASM_PAT, cVDP_CMD_IND+cVDP_REG_PAT ; 4 : $67,$83
     dc.b VDP_HIR_ASM_DOR, cVDP_CMD_IND+cVDP_REG_DOR ; 6 : $AF,$84
     dc.b $08            , cVDP_CMD_IND+cVDP_REG_ROR ; 8 : $08,$87
;----------------
OS_FREE:    dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 0
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 8
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 16
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 24
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 32
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 40
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 48
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 56
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 64
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 72
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 80
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 88
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 96
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 104
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 112
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 120
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 128
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 136
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 144
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 152
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 160
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 168
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 176
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 184
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 192
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 200
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 208
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 216
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 224
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 232
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 240
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 248
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 256
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 264
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 272
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 280
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 288
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 296
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 304
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 312
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 320
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 328
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 336
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 344
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 352
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 360
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 368
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 376
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 384
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 392
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 400
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 408
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 416
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 424
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 432
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 440
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 448
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 456
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 464
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 472
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 480
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 488
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 496
            dc.b $FF,$FF,$FF,$FF,$FF                    ; 504

; =============== S U B R O U T I N E =======================================

; FCT : criture d'un programme sur K7
; STX : /
; OP  : /
; ST  : NON ACTIF
; IN  : /
; OUT : B unmodified

K7WRT:
            pshb
            ldx #FILNA_K7               ; nom du fichier
            stx pTMP_K7                 ; pointeur servant  tout ... FILENAME,CLOAD,CSAVE...
            jsr doWriteBLOCKFILENAME
            ldx ADDEB_K7                ; Adresse dbut de la zone  sauvegarder
            stx pMEMBEGIN_K7
            ldx ADFIN_K7                ; Adresse fin de la zone  sauvegarder
            inx
            stx pMEMEND_K7
            jsr next1RomCSAVE
            pulb
            rts
; End of function K7WRT


; =============== S U B R O U T I N E =======================================

; FCT : lit un programme en provenance du magntophone
; STX : /
; OP  : /
; ST  : NON ACTIF
; IN  : /
; OUT : /

K7REA:
            pshb
            clr fSAVEDATA_K7                ; =$00:sauve les donnes K7 en mmoire sinon ne les sauve pas
            ldab #cBAS_LG_FILENAME+1        ; longueur du fichier + nom du fichier

bclK7REA:
            ldx #NBNAM_K7-1
            abx
            ldaa 0,x
            ldx #sTMPBUFK7-1                ; stocke :
                                            ;  - la longueur du nom du fichier (maxi 8 caractres)
                                            ;  - le nom du fichier
            abx
            staa 0,x
            decb
            bne bclK7REA

bcl1K7REA:
            clr CURLIN
            jsr nextSearchHeaderFromK7
            beq next2K7REA
            ldaa bNB_READ_K7                ; compteur du nombre de donnes  lire : est dcrement de 1  chaque lecture d'octet de la K7
            beq bcl1K7REA
            bra endK7REA

next2K7REA:
            clra
            ldab fFICTYP_K7                 ; Type du fichier k7 : $00:BASIC,$01 ou $04 selon la rom ?:ARRAY,$02:LANGAGE MACHINE,$05:FICHIER TEXTE DE L'EDITEUR
            cmpb FILTY_K7                   ; Type du FICHIER
            bne endK7REA
            ldx ADDEB_K7                    ; Adresse dbut de la zone  sauvegarder

bcl3K7REA:
            ldaa #$FF
            ldab fSAVEDATA_K7               ; =$00:sauve les donnes K7 en mmoire sinon ne les sauve pas
            stx pTMP_K7                     ; pointeur servant  tout ... FILENAME,CLOAD,CSAVE...
            jsr K7LEC                       ; FCT : lit un programme sur K7
                                            ; ALG : 1 - synchronisation avec le caractre $3C
                                            ;       2 - Lit le type de bloc
                                            ;       3 - Lit la longueur du bloc
                                            ;       4 - itre sur la longueur de bloc pour rcuprer les donnes si ncessaire
                                            ;       5 - Lit un octet de vrification = somme des donnes + type  de bloc + longueur du bloc
                                            ; ST  : ACTIF
                                            ; IN  : A:longueur du bloc  lire
                                            ;       B=0 crit les donnes lues en mmoire <>0 ne les crit pas
                                            ;       X=pointeur sur la zone de stockage des donnes (si la demande est faite par B)
                                            ; OUT : A=$03:Erreur code bloc inattendu
                                            ;       A=$02:Erreur problme mmoire
                                            ;       A=$01:Erreur suite  la comparaison avec l'octet de vrification
                                            ;       A=$00:pas d'erreur
                                            ;       X=pointeur sur le dernier octet stock (si demande via B)
            bne endK7REA
            ldaa BLKTY_K7                   ; type de bloc : $00 nom du fichier,$01 bloc de donnes,$FF bloc de fin
            cmpa #$FF
            bne bcl3K7REA

endK7REA:
            inca
            pulb
            rts
; End of function K7REA

; ---------------------------------------------------------------------------
OS_FREE_4:
            dc.b $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF        ; 0
            dc.b $FF,$FF,$FF,$FF,$FF                    ; 8
;----------------
jmpFONCTION:
            dc.w romSGN         ; FCT : COMMANDE BASIC SGN : retourne le signe de l'expression
                                ; STX : A=SGN(-12)  : retourne -1
                                ;       B=SGN(0)    : retourne 0
                                ;       C=SGN(14.3) : retourne 1
                                ; OP  : $B1
                                ; ST  : ACTIF
                                ; IN  : le flot  interprter
                                ; OUT : ACC1 avec le signe de l'expression
jmpINT:
            dc.w romINT         ; FCT : COMMANDE BASIC INT : retourne la partie entire de l'expression
                                ; STX : A=INT(5.25)  : retourne 5
                                ; OP  : $B2
                                ; ST  : ACTIF
                                ; IN  : le flot  interprter
                                ; OUT : ACC1 avec la partie entire  de l'expression
jmpABS:
            dc.w romABS         ; FCT : COMMANDE BASIC ABS(X) : retourne la valeur absolue d'un nombre de type float
                                ; STX : A=ABS(-5.4) retourne 5.4
                                ; OP  : $B3
                                ; ST  : ACTIF
                                ; IN  : /
                                ; OUT : ACC1=ABS(ACC1)
jmpUSER:
            dc.w doUSER
jmpRND:
            dc.w romRND         ; FCT : COMMANDE BASIC RND : retourne une valeur pseudo-alatoire entre 1 et n
                                ; STX : PRINT RND(15) retourne 5.4
                                ; OP  : $B5
                                ; ST  : ACTIF
                                ; IN  : /
                                ; OUT : ACC1=nombre pseudo-alatoire  entre 1 et n
jmpSQR:
            dc.w romSQR         ; FCT : COMMANDE BASIC SQR(X) : retourne la racine carre de X
                                ; STX : A=SQR(4) : retourne 2
                                ; OP  : $B6
                                ; ST  : ACTIF
                                ; IN  : /
                                ; OUT : ACC1=SQR(X)
jmpLOG:
            dc.w romLOG         ; FCT : COMMANDE BASIC LOG(X) : retourne le logarithme NATUREL (ou NEPERIEN) de X
                                ; ALG : LN(F*2^N)=(N+LOG2(F))*LN(2)
                                ;       approximation par polynome sur l'intervalle [0;1]
                                ;       Si N=1/2 alors LN(F*2^N) = LN (F*SQR(2))
                                ;                    = (-0.5+LOG2(F))*LN(2)
                                ; STX : A=LOG(10) : retourne 2.30258509
                                ; OP  : $B7
                                ; ST  : ACTIF
                                ; IN  : ACC1 > 0
                                ; OUT : ACC1=LOG(ACC1)
jmpEXP:
            dc.w romEXP         ; FCT : COMMANDE BASIC EXP(X) : retourne l'exponentiel de X
                                ; ALG : FIRST SAVE THE ORIGINAL ARGUMENT AND MULTIPLY THE FAC BY
                                ;       LOG2(E). THE RESULT IS USED TO DETERMINE IF OVERFLOW
                                ;       WILL OCCUR SINCE EXP(X)=2^(X*LOG2(E)) WHERE
                                ;       LOG2(E)=LOG(E) BASE 2. THEN SAVE THE INTEGER PART OF
                                ;       THIS TO SCALE THE ANSWER AT THE END. SINCE
                                ;       2^Y=2^INT(Y)*2^(Y-INT(Y)) AND 2^INT(Y) IS EASY TO COMPUTE.
                                ;       NOW COMPUTE 2^(X*LOG2(E)-INT(X*LOG2(E)) BY
                                ;       P(LN(2)*(INT(X*LOG2(E))+1)-X) WHERE P IS AN APPROXIMATION
                                ;       POLYNOMIAL. THE RESULT IS THEN SCALED BY THE POWER OF 2
                                ;       PREVIOUSLY SAVED.
                                ; STX : A=EXP(10) : retourne 22026.4658
                                ; OP  : $B8
                                ; ST  : ACTIF
                                ; IN  : ACC1
                                ; OUT : ACC1=EXP(ACC1)
jmpSIN:
            dc.w romSIN         ; FCT : COMMANDE BASIC SIN(X) : retourne le sinus de X
                                ; ALG : approximation
                                ; STX : A=SIN(3.14/2) : retourne 0.999999683
                                ; OP  : $B9
                                ; ST  : ACTIF
                                ; IN  : ACC1
                                ; OUT : ACC1=SIN(ACC1)
jmpCOS:
            dc.w romCOS         ; FCT : COMMANDE BASIC SIN(X) : retourne le sinus de X
                                ; ALG : COS(X)=SIN(X+PI/2)
                                ; STX : A=COS(3.14) : retourne -0.999998732
                                ; OP  : $BA
                                ; ST  : ACTIF
                                ; IN  : ACC1
                                ; OUT : ACC1=COS(ACC1)
jmpTAN:
            dc.w romTAN         ; FCT : COMMANDE BASIC TAN(X) : retourne la tangente de X
                                ; ALG : TAN(X)=SIN(X)/COS(X)
                                ; STX : A=TAN(3.14/3) : retourne 1.72992922
                                ; OP  : $BB
                                ; ST  : ACTIF
                                ; IN  : ACC1
                                ; OUT : ACC1=TAN(ACC1)
jmpPEEK:
            dc.w romPEEK        ; FCT : COMMANDE BASIC PEEK(X) : rcupre la valeur de l'octet  l'adresse X
                                ; STX : A=PEEK(12000)
                                ; ALG  : /
                                ; OP  : $BC
                                ; ST  : ACTIF
                                ; IN  : le flot d'interprtation
                                ; OUT : ACC1=la valeur pointe par X
jmpLEN:
            dc.w romLEN         ; FCT : COMMANDE BASIC LEN(A$) : rcupre la longueur de la   chane A$
                                ; STX : A=LEN(A$)
                                ; BUG : B=LEN(A) donne B=255 !!
                                ; ALG  : /
                                ; OP  : $BD
                                ; ST  : ACTIF
                                ; IN  : le flot d'interprtation
                                ; OUT : ACC1=la longueur de la chane A$ > 0
jmpSTRdollar:
            dc.w romSTRdollar   ; FCT : COMMANDE BASIC CHR$(A) : retourne l'quivalent en string de l'expression numrique A
                                ; STX : A$=CHR$(100)
                                ; BUG : Q=STR$(100) ne retourne pas d'erreur !
                                ; ALG : /
                                ; OP  : $BE
                                ; ST  : ACTIF
                                ; IN  : le flot d'interprtation
                                ; OUT : une chane de caractres
jmpVAL:
            dc.w romVAL         ; FCT : COMMANDE BASIC VAL("X") : retourne l'quivalent numrique d'un string
                                ; STX : A=VAL("100")
                                ; BUG : A$=STR$("45")) ne retourne pas d'erreur !
                                ; ALG  : /
                                ; OP  : $BF
                                ; ST  : ACTIF
                                ; IN  : le flot d'interprtation
                                ; OUT : ACC1 : reprsentation numrique de l'entre
jmpASC:
            dc.w romASC         ; FCT : COMMANDE BASIC ASC("TEST") : retourne le code ASCII du premier caractre du  paramtre
                                ;       retourne l'erreur FC si chane vide
                                ; STX : A=ASC("100") retourne 49 (=ASCII de 1)
                                ; BUG : A$=ASC("45") ne retourne pas d'erreur !
                                ; ALG  : /
                                ; OP  : $C0
                                ; ST  : ACTIF
                                ; IN  : le flot d'interprtation
                                ; OUT : ACC1 : code ASCII du premier caractre
jmpCHRdollar:
            dc.w romCHRdollar   ; FCT : Commande BASIC CHR$ : Renvoie le caractre ou
                                ;       la commande correpondant  N
                                ; STX : PRINT CHR$(65)
                                ; BUG : /
                                ; ALG : /
                                ; OP  : $C1
                                ; ST  : ACTIF
                                ; IN  : le flot d'interprtation
                                ; OUT:  /
jmpLEFTdollar:
            dc.w romLEFTdollar  ; FCT : Extrait les n premiers caractres d'une chane de caractres
                                ; STX : A$=LEFT$(B$,3)
                                ; ALG : /
                                ; ST  : ACTIF
                                ; OP  : $C2
                                ; IN  : le flot d'interprtation
                                ; OUT : un descripteur de chane de caractres
jmpRIGHTdollar:
            dc.w romRIGHTdollar ; FCT : Extrait les n dernires caractres d'une chane
                                ; STX : A$=RIGHT$(B$,3)
                                ; ALG : /
                                ; ST  : ACTIF
                                ; OP  : $C3
                                ; IN  : le flot d'interprtation
                                ; OUT : un descripteur de chane de caractres
jmpMIDdollar:
            dc.w romMIDdollar   ; FCT : Extrait de la chaine c, partir de la position n1, n2 caractres
                                ; STX : A$=MID$(c,N1,N2)
                                ; ALG : /
                                ; ST  : ACTIF
                                ; OP  : $C4
                                ; IN  : le flot d'interprtation
                                ; OUT : un descripteur de chane de caractres
jmpPOINT:
            dc.w romPOINT       ; FCT : COMMANDE BASIC POINT(X,Y) : retourne l'tat du pixel aux coordonnes (X,Y)
                                ; STX : A=POINT(10,10)
                                ; BUG : /
                                ; ALG : /
                                ; ST  : ACTIF								
                                ; OP  : $C5
                                ; IN  : le flot d'interprtation
                                ; OUT : ACC1 : tat  du pixel aux coordonnes (X,Y)
                                ;       -1 si il y a un caractre
                                ;       0  si il est teint
                                ;       Si LORES : 1  8 selon la couleur si allum
                                ;       Si HIRES : 1  2 si allum
jmpVARPTR:
            dc.w romVARPTR      ; FCT : Donne le pointeur sur la variable donne en paramtre
                                ;       Il faut que la variable existe sinon message d'erreur
                                ; STX : B=VARPTR(A)
                                ; OP  : $C6
                                ; ST  : ACTIF
                                ; IN  : le flot d'interprtation contenant (A[$])
                                ; OUT : ACC1=Le pointeur sur la variable
jmpINKEYdollar:
            dc.w romINKEYdollar ; FCT : Lit un caractre provenant du clavier
                                ; OP  : $C7
                                ; ST  : ACTIF
                                ; IN  : /
                                ; OUT : Retourne une chane de caractre
jmpMEM:
            dc.w romMEM         ; FCT : Donne la taille mmoire disponible
                                ; OP  : $C8
                                ; ST  : ACTIF
                                ; IN  : /
                                ; OUT : ACC1=taille mmoire  disponible
;----------------
aOperator:  dc.b $79
            dc.w romPLUS        ; FCT : Add ACC2 to ACC1
                                ; STX : /
                                ; ALG : /
                                ; ST  : ACTIF
                                ; IN  : ACC1 and ACC2 set
                                ;       B <> 0 ?
                                ; OUT : ACC1=ACC1+ACC2
            dc.b $79
            dc.w romMINUS       ; FCT : Subtract ACC2 to ACC1
                                ; STX : /
                                ; ALG : /
                                ; ST  : ACTIF
                                ; IN  : ACC1 and ACC2 set
                                ; OUT : ACC1=ACC1-ACC2
            dc.b $7B
            dc.w romMULT        ; FCT : multiply ACC1 by ACC2
                                ; ALG : /
                                ; ST  : ACTIF
                                ; IN  : ACC1 set
                                ; OUT : ACC1=ACC1*ACC2
            dc.b $7B
            dc.w romDIV         ; FCT : divide ACC1 by ACC2
                                ; STX : /
                                ; ALG : /
                                ; ST  : ACTIF
                                ; IN  : ACC1 and ACC2 set
                                ; OUT : ACC1=ACC1/ACC2
            dc.b $7F
            dc.w FPWRT          ; FCT : COMMANDE BASIC ^ : retourne X^Y
                                ; ALG : N.B. 0^0=1
                                ;       FIRST CHECK IF Y=0. IF SO, THE RESULT IS 1.
                                ;       NEXT CHECK IF X=0. IF SO THE RESULT IS 0.
                                ;       THEN CHECK IF X.GT.0. IF NOT CHECK THAT Y IS AN INTEGER.
                                ;       IF SO, NEGATE X, SO THAT LOG DOESN'T GIVE FCERR.
                                ;       IF X IS NEGATIVE AND Y IS ODD, NEGATE THE RESULT
                                ;       RETURNED BY EXP.
                                ;       TO COMPUTE THE RESULT USE X^Y=EXP((Y*LOG(X)).
                                ; STX : A=2^3: retourne 8
                                ; OP  : $B1
                                ; ST  : ACTIF
                                ; IN  : /
                                ; OUT : ACC1=ACC2^ACC1
            dc.b $50
            dc.w doOP_AND       ; FCT : do "AND" ACC1 with ACC2
                                ; STX : IF A AND B THEN PRINT "A AND B"
                                ; ALG : /
								; OP  : $AC
                                ; ST  : ACTIF
                                ; IN  : ACC1 and ACC2 set
                                ; OUT : ACC1=ACC1 AND ACC2
            dc.b $46
            dc.w doOP_OR        ; FCT : do AND ACC1 with ACC2
                                ; STX : IF A OR B THEN PRINT "A OR B"
                                ; ALG : /
                                ; OP  : $AD
                                ; ST  : ACTIF
                                ; IN  : ACC1 and ACC2 set
                                ; OUT : ACC1=ACC1 AND ACC2
;----------------
aFOR:         dc.b "FO"    ,"R"+$80 ;     : Opcode $80
aGOTO:        dc.b "GOT"   ,"O"+$80
aGOSUB:       dc.b "GOSU"  ,"B"+$80
aREM:         dc.b "RE"    ,"M"+$80 ;     : Opcode $83
aIF:          dc.b "I"     ,"F"+$80
aDATA:        dc.b "DAT"   ,"A"+$80 ;     : Opcode $85
aPRINT:       dc.b "PRIN"  ,"T"+$80 ;     : Opcode $86
aON:          dc.b "O"     ,"N"+$80
aINPUT:       dc.b "INPU"  ,"T"+$80
aEND:         dc.b "EN"    ,"D"+$80
aNEXT:        dc.b "NEX"   ,"T"+$80
aDIM:         dc.b "DI"    ,"M"+$80
aREAD:        dc.b "REA"   ,"D"+$80
aLET:         dc.b "LE"    ,"T"+$80
aRUN:         dc.b "RU"    ,"N"+$80
aRESTORE:     dc.b "RESTOR","E"+$80
aRETURN:      dc.b "RETUR" ,"N"+$80
aSTOP:        dc.b "STO"   ,"P"+$80
aPOKE:        dc.b "POK"   ,"E"+$80
aCONT:        dc.b "CON"   ,"T"+$80
aLIST:        dc.b "LIS"   ,"T"+$80
aCLEAR:       dc.b "CLEA"  ,"R"+$80
aNEW:         dc.b "NE"    ,"W"+$80
aCLOAD:       dc.b "CLOA"  ,"D"+$80
aCSAVE:       dc.b "CSAV"  ,"E"+$80
aLLIST:       dc.b "LLIS"  ,"T"+$80
aLPRINT:      dc.b "LPRIN" ,"T"+$80
aSET:         dc.b "SE"    ,"T"+$80
aRESET:       dc.b "RESE"  ,"T"+$80
aCLS:         dc.b "CL"    ,"S"+$80
aSOUND:       dc.b "SOUN"  ,"D"+$80
aEXEC:        dc.b "EXE"   ,"C"+$80
aSKIPF:       dc.b "SKIP"  ,"F"+$80
aTAB:         dc.b "TAB"   ,"("+$80 ;     : Opcode $A1
aTO:          dc.b "T"     ,"O"+$80 ;     : Opcode $A2
aTHEN:        dc.b "THE"   ,"N"+$80
aNOT:         dc.b "NO"    ,"T"+$80
aSTEP:        dc.b "STE"   ,"P"+$80
aOFF:         dc.b "OF"    ,"F"+$80
;----------------
aplus:        dc.b "+"+$80          ; $AB : Opcode $A7
aminus:       dc.b "-"+$80          ; $AD : Opcode $A8
amult:        dc.b "*"+$80          ; $AA : Opcode $A9
adiv:         dc.b "/"+$80          ; $AF : Opcode $B0
aexp:         dc.b "^"+$80          ; $DE : Opcode $B1
aAND:         dc.b "AN","D"+$80     ;     : Opcode $AC
aOR:          dc.b "O" ,"R"+$80     ;     : Opcode $AD
asup:         dc.b ">"+$80          ; $BE : Opcode $AE
aegal:        dc.b "="+$80          ; $BD : Opcode $AF
ainf:         dc.b "<"+$80          ; $BC : Opcode $B0
;----------------
aSGN:         dc.b "SG"   ,"N"+$80  ;     : Opcode $B1
aINT:         dc.b "IN"   ,"T"+$80
aABS:         dc.b "AB"   ,"S"+$80
aUSR:         dc.b "US"   ,"R"+$80
aRND:         dc.b "RN"   ,"D"+$80
aSQR:         dc.b "SQ"   ,"R"+$80
aLOG:         dc.b "LO"   ,"G"+$80
aEXP:         dc.b "EX"   ,"P"+$80
aSIN:         dc.b "SI"   ,"N"+$80
aCOS:         dc.b "CO"   ,"S"+$80
aTAN:         dc.b "TA"   ,"N"+$80
aPEEK:        dc.b "PEE"  ,"K"+$80
aLEN:         dc.b "LE"   ,"N"+$80
aSTRdollar:   dc.b "STR"  ,"$"+$80
aVAL:         dc.b "VA"   ,"L"+$80
aASC:         dc.b "AS"   ,"C"+$80  ; opcode $C0
aCHRdollar:   dc.b "CHR"  ,"$"+$80  ; opcode $C1
aLEFTdollar:  dc.b "LEFT" ,"$"+$80
aRIGHTdollar: dc.b "RIGHT","$"+$80
aMIDdollar:   dc.b "MID"  ,"$"+$80
aPOINT:       dc.b "POIN" ,"T"+$80
aVARPTR:      dc.b "VARPT","R"+$80
aINKEYdollar: dc.b "INKEY","$"+$80
aMEM:         dc.b "ME"   ,"M"+$80  ; opcode $C8
              dc.b $00
;----------------
jmpINSTRUCTION:
            dc.w romFOR         ; FCT : COMMANDE BASIC FOR
                                ; FOR PUSHES 18 BYTES ON THE STACK:
                                ;  2 -- TXTPTR
                                ;  2 -- LINE NUMBER
                                ;  5 -- INITIAL (CURRENT)  FOR VARIABLE VALUE
                                ;  1 -- STEP SIGN
                                ;  5 -- STEP VALUE
                                ;  2 -- ADDRESS OF FOR VARIABLE IN VARTAB
                                ;  1 -- FOR TOKEN ($81)
                                ; IN  : le flot d'interprtation
                                ; OUT : A,B,X modified
jmpGOTO:
            dc.w romGOTO        ; FCT : Effectue un saut  la ligne L
                                ; STX : 10 GOTO 100 ==> OK
                                ;       10 GOTO A   ==> KO
                                ; OP  : $81
                                ; IN  : le flot d'interprtation qui doit contenir un numro de ligne
                                ; OUT : /
jmpGOSUB:
            dc.w romGOSUB       ; FCT :
                                ;  "GOSUB" STATEMENT
                                ;  LEAVES 5 ou 7 BYTES ON STACK
                                ;  2 -- RETURN ADDRESS (NEWSTT)
                                ;  2 -- TXTPTR
                                ;  2 -- LINE #
                                ;  1 -- GOSUB TOKEN
                                ; OP  : $82
                                ; IN  : /
                                ; OUT : /
jmpREM:
            dc.w romREM         ; FCT : Instruction BASIC pour mettre en commentaire
                                ; STX : REM mon commentaire
                                ; OP  : $83
                                ; IN  : le flot d'interprtation
                                ; OUT : TXTPTR pointe sur la prochaine instruction
jmpIF:
            dc.w romIF          ; FCT : Commande BASIC IF
                                ; STX : IF A THEN 10
                                ;       IF A THEN GOTO 10
                                ; OP  : $84
                                ; BUG : IF A THEN A=A-2 GOTO 20 ne drange pas le basic ...
                                ;       Par contre IF A=1 THEN A=A-2 GOTO 20 le drange !!
                                ; IN  : le flot  interprter suivant le IF
                                ; OUT : /
jmpDATA:
            dc.w romDATA        ; FCT : Instruction BASIC pour enregistrer des donnes squentielles
                                ; OP  : $85
                                ; BUG : 10 DATA 10,"TITI,12 : PRINT 34 ne pose pas de problme au basic
                                ; IN  : le flot d'interprtation contenant les donnes squentielles
                                ; OUT : en mode interprtation ignore la ligne contenant les data
jmpPRINT:
            dc.w romPRINT       ; FCT : Imprime les expressions sur l'cran
                                ; STX : PRINT A;B
                                ; OP  : $86
                                ; ST  : ACTIF
                                ; IN  : le flot  interpreter
                                ; OUT : A,B,X modified
jmpON:
            dc.w romON          ; FCT : Branche vers un numro de ligne selon la valeur "variable"
                                ; STX : ON variable GOTO n1,n2,...
                                ;       ON variable GOSUB n1,n2,...
                                ; OP  : $87
                                ; BUG : /
                                ; IN  : le flot d'interprtation contenant le reste de l'instruction (variable GOTO n1,...)
                                ; OUT : /
jmpINPUT:
            dc.w romINPUT       ; FCT : CMD BASIC INPUT : permet  l'utilisateur de saisir des donnes
                                ; STX : 100 INPUT A$
                                ;       110 INPUT B
                                ; OP  : $88
                                ; ST  : ACTIF
                                ; IN  : le flot  interprter
                                ; OUT : /
jmpEND:
            dc.w romEND         ; FCT : CMD BASIC END : arrte le programme
                                ; STX : 100 END
                                ; OP  : $89
                                ; ST  : ACTIF
                                ; IN  : /
                                ; OUT : /
jmpNEXT:
            dc.w romNEXT        ; FCT : CMD BASIC NEXT : Le retour pour le FOR associ
                                ; STX : 100 FOR I=1 TO 10:PRINT I: NEXT I
                                ; OP  : $8A
                                ; ST  : ACTIF
                                ; IN  : le flot d'interprtation
                                ; OUT : /
jmpDIM:
            dc.w romDIM         ; FCT : CREATION D'UN TABLEAU MULTIDIMENSION DE FLOAT OU DE CHAINE DE CARACTERES
                                ;       Codage d'un tableau en mmoire
                                ;        + WORD   : nom de la variable sur 2 caractres maxi. Le dernier octet du nom
                                ;        aura le bit de poids le plus fort mis  1 quand c'est une chaine
                                ;        + WORD   : taille du tableau
                                ;        + BYTE   : nombre de dimension
                                ;        + nxWORD : taille de dimension + 1 pour les n dimensions constituant le tableau
                                ;           dans l'ordre d'inverse de leur dclaration
                                ;        + stockage des donnes
                                ;       + si float  : stockage du nombre sur 5 octets
                                ;       + si string : WORD : pointeur sur la chane de caractres
                                ; STX : 10 DIM A(4) : DIM B$(5,4)
                                ; OP  : $8B
                                ; IN  : le flot d'interprtration
                                ; OUT : Cration d'un tableau
jmpREAD:
            dc.w romREAD        ; FCT : CMD BASIC READ : lit l'entre pour l'affecter au(x) variable() qui sui(ven)t READ
                                ; STX : READ A[,B[...]]
                                ; OP  : $8C
                                ; ST  : ACTIF
                                ; IN  : le flot  interprter
                                ; OUT : A,B,X modified
jmpLET:
            dc.w romLET         ; FCT : effectue l'affectation d'une expression  une variable
                                ; STX : A=SIN(3.14)
                                ; OP  : $8D
                                ; BUG : OUI ! Ne vrifie pas la  comptabilit de la variable et le rsultat de l'expression !
                                ; IN  : le flot d'interpretation contenant le texte A=expr(B)
                                ; OUT : /
jmpRUN:
            dc.w romRUN         ; FCT : CMD BASIC RUN : permet de lancer un programme au dbut
                                ;       ou  un numro de ligne donne en paramtre
                                ; STX : RUN
                                ;       RUN numro_de_ligne
                                ; OP  : $8E
                                ; ST  : ACTIF
                                ; IN  : le flot  interprter
                                ; OUT : /
jmpRESTORE:
            dc.w romRESTORE     ; FCT : CMD BASIC RESTORE : permet d'initialiser le
                                ;       pointeur des DATA au dbut du programme
                                ; STX : 100 RESTORE
                                ; OP  : $8F
                                ; ST  : ACTIF
                                ; IN  : /
                                ; OUT : /
jmpRETURN:
            dc.w romRETURN      ; FCT : COMMANDE BASIC RETURN : Ramne l'excution du programme  l'instruction qui suit le GOSUB
                                ; STX : RETURN
                                ; OP  : $90
                                ; ST  : ACTIF
                                ; IN  : /
                                ; OUT : A,B,X modified
                                ; ERR : $04 : RETURN sans GOSUB
jmpSTOP:
            dc.w romSTOP        ; FCT : CMD BASIC STOP : permet d'arrter le programme
                                ; STX : STOP
                                ; OP  : $91
                                ; ST  : ACTIF
                                ; IN  : le flot  interprter
                                ; OUT : /
jmpPOKE:
            dc.w romPOKE        ; FCT : CMD BASIC POKE : initialise l'octet  l'adresse A avec B
                                ; STX : POKE A,B
                                ; OP  : $92
                                ; ST  : ACTIF
                                ; IN  : le flot  interprter
								; OUT : A,B,X modified
jmpCONT:
                                ; OUT : /
            dc.w romCONT        ; FCT : CMD BASIC CONT : permet de reprendre le programme aprs un break
                                ; STX : CONT
                                ; OP  : $93
                                ; ST  : ACTIF
                                ; IN  : /
                                ; OUT : /
jmpLIST:
            dc.w romLIST        ; FCT : Imprime le listing du programme sur l'cran
                                ; STX : LIST ou LIST n-m ou LIST -m ou LIST m-
                                ; OP  : $94
                                ; ST  : ACTIF
                                ; IN  : le flot  interpreter
                                ; OUT : A,B,X modified
jmpCLEAR:
            dc.w romCLEAR       ; FCT : CMD BASIC CLEAR : CLEAR : initialise variable et rserve 100 octets  pour les string
                                ; STX : CLEAR nombre : init var et rserve nombre octets pour les string
                                ;       CLEAR N1,N2 avec N1 < N2 et n1 mmoire basse et n2 mmoire haute
                                ; OP  : $95
                                ; ST  : ACTIF
                                ; BUG : /
                                ; IN  : le flot  interpreter
                                ; OUT : A,B,X modified
jmpNEW:
            dc.w romNEW         ; FCT : CMD BASIC NEW : nouveau programme
                                ; STX : NEW
                                ; OP  : $96
                                ; ST  : ACTIF
                                ; IN  : A=Si <> 0  alors l'appel de NEW avait un argument
                                ;       X=Position de la commande NEW
                                ; OUT : A,B,X modified
jmpCLOAD:
            dc.w romCLOAD       ; FCT : TRAITE A LA FOIS CLOAD,CLOAD* (pour tableau) et CLOADM (programme binaire)
                                ; STX : CLOAD "TITI"
                                ;       CLOAD T,"TITI"
                                ;       CLOADM "TITI",offset
                                ; OP  : $97
                                ; ST  : ACTIF
                                ; IN  : le flot  interprter
                                ; OUT : A,B,X modified
jmpCSAVE:
            dc.w romCSAVE       ; FCT : TRAITE A LA FOIS CSAVE,CSAVE*
                                ; STX : CSAVE"TITI"
                                ;       CSAVE* T,"TOTO"
                                ; OP  : $98
                                ; ST  : ACTIF
                                ; IN  : A=le prochain caractre (ou  opcode)
                                ;       Le flot  interprter
                                ; OUT : A,B,X modified
jmpLLIST:
            dc.w romLLIST       ; FCT : Imprime le listing du programme sur l'imprimante
                                ; STX : LLIST ou LLIST n-m ou LLIST -m ou LLIST m-
                                ; OP  : $99
                                ; ST  : ACTIF
                                ; IN  : le flot  interpreter
                                ; OUT : A,B,X modified
jmpLPRINT:
            dc.w romLPRINT      ; FCT : Imprime les expressions sur l'imprimante
                                ; STX : LPRINT A;B
                                ; OP  : $9A
                                ; ST  : ACTIF
                                ; IN  : le flot  interpreter
                                ; OUT : A,B,X modified
jmpSET:
            dc.w romSET         ; FCT : Permet soit d'allumer un point avec une colonne
                                ;       soit de dfinir les  couleurs de la marge, de la couleur 1 et 2 en HIRES
                                ;       1 - allume un point de couleur C  la position (X,Y)
                                ;       2 - fixe les 3 couleurs en HIRES
                                ;       En mode LORES, l'cran est divis en 1 pav
                                ;       de 2x2 qui contient deux couleurs : le noir pour
                                ;       le fond et la couleur de l'avant: Tout changement
                                ;       de couleur d'un des pixels se rpercute sur les
                                ;       autres pixels de ce pav !
                                ; STX : SET (X,Y,C) avec C=couleur de 0  8 en LORES avec C=0 : utilisation de la couleur dj dfinie dans   un pav  de 2x2
                                ;       SET (X,Y,C) avec C=couleur de 0  2 en HIRES
                                ;       SET* C0,C1,C2 avec C0:couleur de la marge,C1:Couleur Encre n1, C2: Couleur Encre n2
                                ; OP  : $9B
                                ; ST  : ACTIF
                                ; IN  : le flot d'interprtation
                                ; OUT : /
                                ; RMQ : A optimiser !
jmpRESET:
            dc.w romRESET       ; FCT : teint un pixel en mode LORES et HIRES
                                ; STX : RESET (X,Y)
                                ; OP  : $9C
                                ; ST  : ACTIF
                                ; IN  : le flot d'interprtation
                                ; OUT : /
jmpCLS:
            dc.w romCLS         ; FCT : Efface l'cran soit
                                ;    - avec la couleur courante
                                ;    - en changeant la rsolution. Dans ce cas, il y a un reset  chaud !
                                ; STX : CLS [0-8] avec [0-8] : couleur du fond d'cran
                                ;   CLS 32 mode 32 colonnes
                                ;   CLS 40 mode 40 colonnes
                                ;   CLS 80 mode hires inversion video
                                ;   CLS 81 mode hires
                                ; OP  : $9D
                                ; ST  : ACTIF
                                ; IN  : /
                                ; OUT : A,B,X : modified
                                ; AMUSANT : CLS avec x > 8 et x <> [32,40,80,81] : efface l'cran affiche microsoft puis OK !
jmpSOUND:
            dc.w romSOUND       ; FCT : Gnre un son de hauteur n1 pendant une priode n2
                                ;       avec n1=[0..255] et n2=[0..255] : unit 7.5/100e de  seconde
                                ;       rend inutilisable le clavier car utilise la broche de
                                ;       dtection d'une touche du clavier pour gnrer
                                ;       le signal carr
                                ; STX : SOUND 10,55
                                ; OP  : $9E
                                ; ST  : ACTIF
                                ; IN  : le flot d'interprtation
                                ; OUT : A,B,X modified
jmpEXEC:
            dc.w romEXEC        ; FCT : Execute un sous programme assembleur
                                ; STX : EXEC :excute de nouveau l'appel au sous-programme assembleur
                                ;       EXEC 25000
                                ; OP  : $9F
                                ; ST  : ACTIF
                                ; DBG : NON
                                ; IN  : le flot d'interprtation
                                ;       A=0 si pas d'argument  interprter
                                ; OUT : /
jmpSKIPF:
            dc.w romSKIPF       ; FCT : K7 : recherche d'un programme sur K7
                                ; STX : SKIPF "FICHIER"
                                ; OP  : $A0
                                ; ST  : ACTIF
                                ; IN  : le flot d'interprtation
                                ; OUT : A,B,X modified
;----------------
stringMSGERREUR:
            dc.b $4E,$46        ; $00 (00) : NF NEXT without FOR
            dc.b $53,$4E        ; $02 (02) : SN syntax error
            dc.b $52,$47        ; $04 (04) : RG
            dc.b $4F,$44        ; $06 (06) : OD 
            dc.b $46,$43        ; $08 (08) : FC function incorrecte
            dc.b $4F,$56        ; $0A (10) : OV overflow
            dc.b $4F,$4D        ; $0C (12) : OM Plus de place disponible en mmoire
            dc.b $55,$4C        ; $0E (14) : TM Type incompatible
            dc.b $42,$53        ; $10 (16) : BS Indice incorrect
            dc.b $44,$44        ; $12 (18) : DD Erreur avec un tableau
            dc.b $2F,$30        ; $14 (20) : /0 Dividsion par zro
            dc.b $49,$44        ; $16 (22) : ID instruction interdite en mode direct
            dc.b $54,$4D        ; $18 (24) : TM
            dc.b $4F,$53        ; $1A (26) : OS 
            dc.b $4C,$53        ; $1C (28) : LS chane trop longue
            dc.b $53,$54        ; $1E (30) : ST Expression trop complique
            dc.b $43,$4E        ; $20 (32) : CN can't continue
            dc.b $49,$4F        ; $22 (34) : IO
            dc.b $46,$4D        ; $24 (36) : FM

;----------------
aERROR:     dc.b " ERROR",0
aIN:        dc.b " IN ",0
aOk:        dc.b $D,"OK",$D,0
aBreak:     dc.b $D,"BREAK",0
; =============== S U B R O U T I N E =======================================

; FCT : Test du type de caractre
; IN  : A=caractre  tester
; OUT : ET CARRY IF NUMERIC - RETURN WITH
;       ZERO FLAG SET IF A = 0 OR 3A(:) - END
;       OF BASIC LINE OR SUB LINE 

subGetNextChar:
            cmpa #cBAS_SEP          ; ':'
            bcc endSubGetNextChar
            cmpa #cOS_SPACE         ; ' '
            bne returnNUM
            jmp CHRGET              ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                    ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                    ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                    ; NOT C= NUMERIC ("0" THRU "9")
                                    ; Z= ":" OR END-OF-LINE (A NULL)
                                    ; [ACCA] = NEW CHAR.
                                    ; [TXTPTR]=[TXTPTR]+1

returnNUM:
            suba #$30 ; '0'
            suba #$D0

endSubGetNextChar:
            rts
; End of function subGetNextChar


; =============== S U B R O U T I N E =======================================

; FCT : RECHERCHE DANS LA PILE SI LE TOKEN FOR EXISTE
; IN  : /
; OUT : A=0 : Token FOR trouv
;       A=2 : Token GOSUB trouv

FNDFOR:
            tsx
            ldab #$04                   ; on enlve l'adresse de retour + RTS
            abx

bclFNDFOR:
            ldab #cBAS_BYTES_PER_FOR    ; Il y a 18 octets de donnes pour coder un FOR :
                                        ; TXTPTR(2)+LINE NUMBER(2)+INITIAL/CURRENT FOR VARIABLE VALUE(5)+STEP SIGN(1)+STEP VALUE(5)+ADDRESS OF FOR VARIABLE IN VARTAB(2)+TOKEN FOR(1)
            stx INDEX                   ; nous stockons l'offset de recherche dans INDEX
            ldaa 0,x
            suba #cBAS_TOKEN_FOR        ; Test si opcode = $80 = FOR
            bne next2GTFORPNT
            ldx 1,x
            stx TMPPTR
            ldx FORPNT
            beq next1GTFORPNT
            cpx TMPPTR
            beq next2GTFORPNT
            bsr addINDEX2TMPPTR
            bra bclFNDFOR

next1GTFORPNT:
            ldx TMPPTR
            stx FORPNT

next2GTFORPNT:
            ldx INDEX
            tsta
            rts
; End of function FNDFOR


; =============== S U B R O U T I N E =======================================

; FCT : move block of memory up + vrification si il y a de la place dans la pile
; IN  : HIGHDS (cible) et HIGHTR (source)  jour
; OUT : A,B,X modified

BLTU:
            bsr nextCHKMEM
; End of function BLTU


; =============== S U B R O U T I N E =======================================

; FCT : move block of memory up
; IN  : HIGHDS (cible) et HIGHTR (source)  jour
; OUT : A,B,X modified

doBLTU:
            tpa
            psha
            sts SAVREGS
            sei
            lds HIGHDS                  ; Cible lors d'une copie de zone mmoire
            ldx HIGHTR
            inx

bclMoveStrToTop:
            dex
            ldaa 0,x
            psha
            cpx LOWTR
            bne bclMoveStrToTop
            ins
            sts PTRTMP2
            lds SAVREGS
            pula
            tap
            rts
; End of function doBLTU


; =============== S U B R O U T I N E =======================================

; FCT : vrifie s'il y a 2*B + $3A octets libres
; IN  : B=Nombre d'octets / 2 ncessaires
; OUT : D=pointeur aprs ajout de 2*B +  $3A octets

CHKMEM:
            clra
            aslb
            addd STREND

nextCHKMEM:
            addd #cBAS_OFS_STK              ; $3A = 2 * NUMLEV + 3*ADDPRC + 13 locs = 23*2 + 3 + 13 = 58
            bcs MEMERR                      ; FCT : Point d'entre secondaire pour la gestion d'erreur
                                            ;       il correspond  "plus de place disponible en mmoire"
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            sts SAVREGS
            subd SAVREGS
            bcc MEMERR                      ; FCT : Point d'entre secondaire pour la gestion d'erreur
                                            ;       il correspond  "plus de place disponible en mmoire"
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            addd SAVREGS
            rts
; End of function CHKMEM


; =============== S U B R O U T I N E =======================================
; FCT : INDEX=X et TMPPTR=X+B
; IN  : B=offset
;       X=pointeur
; OUT : X=D=TMPPTR+offset


addRegBToTMPPTR:
            clra
; End of function addRegBToTMPPTR


; =============== S U B R O U T I N E =======================================

; FCT : Ajoute  TMPTR un offset donn par X
; IN  : X=offset  ajouter  TMPPTR
; OUT : X=D=TMPPTR+offset

addXtoTMPPTR:
            stx INDEX
addINDEX2TMPPTR:
            addd INDEX
            std TMPPTR
            ldx TMPPTR
            rts
; End of function addXtoTMPPTR


; =============== S U B R O U T I N E =======================================

; FCT : Point d'entre secondaire pour la gestion d'erreur
;       il correspond  "plus de place disponible en mmoire"
; IN  : /
; OUT : A,B,X modified

MEMERR:
            ldab #cBAS_ERR_MEMFULL          ; $0C : erreur : OM Plus de place disponible en mmoire

ERROR:
            jsr vHOOK7_ERROR_1
            jsr vHOOK8_ERROR_2
            jsr endRomCSAVE                 ; euh ...
            ldaa CURDVC                     ; CURRENT DEVICE : $00 : SCREEN, $FF : K7
            beq nextERROR
            jsr doRomNEW                    ; FCT : Effectue l'action de la commande BASIC NEW
                                            ; IN  : /
                                            ; OUT : X=TXTTAB+2=dbut du programme + 2

nextERROR:
            jsr reInitPointeur              ; FCT : Initialisation de certains pointeurs, pile et donnes BASIC
                                            ; IN  : /
                                            ; OUT : S=Initialis  sa position de dpart
                                            ;       A=0
                                            ;       OLDTXT=0, SUBFLG=0,CURDVC=0 (SCREEN),TMPPT=$3241
                                            ;       Le retour de l'appelant se fait par popx + jmp x
                                            ;       suite  l'initialisation de la pile (S)
            clr DEVNU                       ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            jsr initParamByDevice           ; FCT : Permet d'initialiser les paramtres de l'cran ou de l'imprimante
                                            ;       selon la variable DEVNU
                                            ; IN  : DEVNU  jour
                                            ; OUT : A,B,X modified

printTypeMsgError:
            jsr OS_printPtInterrogation
            ldx #stringMSGERREUR
            abx
            ldaa 0,x
            jsr j_printCHAR_1               ; FCT : Imprime un caractre sur le dispositif selectionn par DEVNU : Appel indirect  printCHAR_1
                                            ; IN  : A=char to print
                                            ; OUT : A modified
            ldaa 1,x
            jsr j_printCHAR_1               ; FCT : Imprime un caractre sur le dispositif selectionn par DEVNU : Appel indirect  printCHAR_1
                                            ; IN  : A=char to print
                                            ; OUT : A modified

printERROR:
            ldx #(aERROR-1)

printMsgErrorAndWaitInputFromUser:
            jsr OS_OUTTX                    ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                            ; IN : X=pointeur sur une chane de caractres termine par un 0
                                            ; OUT: A,B,X modified
            ldx CURLIN
            inx
            beq INTERPRETATION              ; FCT : INTERPRETATION
                                            ; IN  : /
                                            ; OUT : /
            jsr printIN
; End of function MEMERR


; =============== S U B R O U T I N E =======================================

; FCT : INTERPRETATION
; IN  : /
; OUT : /

INTERPRETATION:
            jsr initParamByDevice           ; FCT : Permet d'initialiser les paramtres de l'cran ou de l'imprimante
                                            ;       selon la variable DEVNU
                                            ; IN  : DEVNU  jour
                                            ; OUT : A,B,X modified

printOK:                                    ; "\rOK\r"
            ldx #aOk
            jsr OS_OUTTX                    ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                            ; IN : X=pointeur sur une chane de caractres termine par un 0
                                            ; OUT: A,B,X modified

MAIN:

            ldx #$FFFF
            stx CURLIN
            jsr INKBD                       ; FCT : Attend une saisie utilisateur
                                            ;       gre les touches spcifiques
                                            ;       BREAK  : sort du programme !
                                            ;       CTRL+A : effacement de la saisie en cours
                                            ;       CTRL+Q : effacement d'un caractre
                                            ;       RETURN : fin de la saisie utilisateur
                                            ; IN  : /
                                            ; OUT : X=pointeur sur la tampon clavier -1 contenant la saisie utilisateur
                                            ;       C=0 : saisie utilisateur
                                            ;       C=1 : saisie d'une touche de contrle
            bcs MAIN
            stx TXTPTR

INTERPRET:
            jsr.w   CHRGET                  ; OJE 13/02/2020
                                            ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                            ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                            ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                            ; NOT C= NUMERIC ("0" THRU "9")
                                            ; Z= ":" OR END-OF-LINE (A NULL)
                                            ; [ACCA] = NEW CHAR.
                                            ; [TXTPTR]=[TXTPTR]+1
            beq MAIN

ParseLine:
            bcs PARSE_LINE                  ; FCT : Transforme une ligne BASIC saisie par utilisateur
                                            ;       en son quivalent "CRUNCHED" (transformation des
                                            ;       mot-clef BASIC en opcode BASIC) et l'insert
                                            ;       dans le programme BASIC en fonction du numro de
                                            ;       ligne
                                            ; IN  : le flot d'interprtation sous forme nnn AAAA[:[BBBB]...]
                                            ; OUT : /

isCmdBasic:
            jmp OS_PRE_PARSE_INPUT_LINE     ; FCT : vrifie si les touches '*', '&' ou '%' ont t actives
                                            ;       * : pour entrer dans l'diteur mode ligne
                                            ;       & : pour entrer dans l'assembleur
                                            ;       % : pour reentrer dans l'assembleur suite  une sortie prmature
                                            ; IN  : A=le caractre courant lu
                                            ; OUT : /
; End of function INTERPRETATION

; =============== S U B R O U T I N E =======================================
; FCT : NE SERT A RIEN !
; ST  : INACTIF
; IN  : /
; OUT : /

j_next1NEWSTT:
            jmp NEWSTT2
; End of function j_next1NEWSTT


; =============== S U B R O U T I N E =======================================

; FCT : Transforme une ligne BASIC saisie par utilisateur
;       en son quivalent "CRUNCHED" (transformation des
;       mot-clef BASIC en opcode BASIC) et l'insert
;       dans le programme BASIC en fonction du numro de
;       ligne
; IN  : le flot d'interprtation sous forme nnn AAAA[:[BBBB]...]
; OUT : /

PARSE_LINE:
            jsr LINGET                  ; FCT : Obtient un numro de ligne dans le flux d'entre
                                        ; IN  : le flot  interprter via CHRGET
                                        ; OUT : LINUM = numro de ligne obtenu en premire position
                                        ;       dans le flot  interprter
            ldx LINUM                   ; sauvegarde le numro de ligne
            stx LINUM_SAV               ; A quoi a sert ?
            jsr CRUNCH                  ; FCT : CRUNCH - Transforme les mots clefs BASIC en leur quivalent code token
                                        ;       venant du flot  interprter
                                        ; IN  : le flot  interprter
                                        ; OUT : X=position de la ligne BASIC convertie
                                        ;       D=Taille de la ligne BASIC convertie
            stab EOLPNTR                ; cela sert  beaucoup de choses : op. binaires, etc.
                                        ; Sauve la taille de la chane convertie
            jsr FNDLIN                  ; FCT : FNDLIN SEARCHES THE PROGRAM TEXT FOR THE LINE
                                        ;       WHOSE NUMBER IS PASSED IN "LINNUM".
                                        ;       THERE ARE TWO POSSIBLE RETURNS:
                                        ;       1) CARRY SET.
                                        ;          LOWTR POINTS TO THE LINK FIELD IN THE LINE
                                        ;          WHICH IS THE ONE SEARCHED FOR.
                                        ;
                                        ;       2) CARRY NOT SET.
                                        ;          LINE NOT FOUND. [LOWTR] POINTS TO THE LINE IN THE
                                        ;          PROGRAM GREATER THAN THE ONE SOUGHT AFTER.
                                        ; IN  : /
                                        ; OUT : C=1 : Ligne trouve
                                        ;       X=Position en mmoire de la ligne trouve
            bcs next1PARESELINE
            ldd LOWTR
            subd 0,x
            addd VARTAB                 ; Fin du programme BASIC / dbut des variables
            std VARTAB                  ; Fin du programme BASIC / dbut des variables
            tpa
            psha
            sts SAVREGS
            sei
            lds 0,x
            des

bclCopy_PARSELINE:
            pula
            staa 0,x
            inx
            cpx VARTAB                  ; Fin du programme BASIC / dbut des variables
            bne bclCopy_PARSELINE
            lds SAVREGS
            pula
            tap

next1PARESELINE:
            ldaa BUFFERKEYB
            beq next3PARESELINE
            ldd VARTAB                  ; Fin du programme BASIC / dbut des variables
            std HIGHTR
            addb EOLPNTR                ; cela sert  beaucoup de choses : op. binaires, etc.
            adca #$00
            std HIGHDS                  ; Cible lors d'une copie de zone mmoire
            jsr BLTU                    ; FCT : move block of memory up + vrification si il y a de la place dans la pile
                                        ; IN  : HIGHDS (cible) et HIGHTR (source)  jour
                                        ; OUT : A,B,X modified
            tpa
            psha
            sts SAVREGS
            sei
            lds #(vHOOK14_FREE+1)       ; TODO

bcl2Copy_PARSELINE:
            pula
            staa 0,x
            inx
            cpx PTRTMP2
            bne bcl2Copy_PARSELINE
            lds SAVREGS
            pula
            tap
            ldx HIGHDS                  ; Cible lors d'une copie de zone mmoire
            stx VARTAB                  ; Fin du programme BASIC / dbut des variables

next3PARESELINE:
            jsr SETPTRS                 ; FCT : Erase all pointers
                                        ; IN  : /
                                        ; OUT : A,X modified
            bsr CHEAD                   ; FCT : Calcule les liens des lignes BASIC
                                        ; IN  : /
                                        ; OUT : /
            jmp MAIN
; End of function PARSE_LINE


; =============== S U B R O U T I N E =======================================

; FCT : Calcule les liens des lignes BASIC
; IN  : /
; OUT : /

CHEAD:
            ldx TXTAB                   ; dbut du programme basic

bclCHEAD:
            ldd 0,x
            bne next1CHEAD
            rts

next1CHEAD:
            pshx
            ldab #$04
            abx

bcl2CHEAD:
            inx
            ldaa 0,x
            bne bcl2CHEAD
            inx
            pshx
            tsx
            ldd 0,x
            ldx 2,x
            std 0,x
            pulx
            ins
            ins
            bra bclCHEAD
; End of function CHEAD


; =============== S U B R O U T I N E =======================================

; FCT : CRUNCH - Transforme les mots clefs BASIC en leur quivalent code token
;       venant du flot  interprter
; IN  : le flot  interprter
; OUT : X=position de la ligne BASIC convertie
;       D=Taille de la ligne BASIC convertie

CRUNCH:
            clr DATAFLG
            ldx TXTPTR
            dex
            stx TXTPTR
            ldx #BUFFERKEYB-1
            stx STRNG2                          ; save begin of buffer to use later
            sts SAVREGS
            tpa
            staa INPUTFLG                       ; =$00:INPUT,=$4F:READ

bclPARSE_INPUT_LINE:
            nop                                 ; pourquoi un nop ?
            sei                                 ; pas d'interruption ... car on va utiliser le registre S 
            lds TXTPTR                          ; LDS pointe maintenant sur le flot  interprter
            pulb                                ; rcupration de la donne avec le pointeur S

isSpace:
            cmpb #cOS_SPACE                     ; ' '
            beq SAVE_B_AND_CONT_PIL
            stab ENDCHR                         ; sert  tout : stockage d'un caractre, de valeur pour opration binaire

isDoubleGuillemet_0:
            cmpb #cBAS_SEP_STR                  ; '"'
            beq manageString_PIL
            ldaa DATAFLG
            bne SAVE_B_AND_CONT_PIL

isPrintReducted:
            cmpb #$3F                           ; '?' ; question mark
            bne ASS_isNUMeric
            ldab #cBAS_TOKEN_PRINT              ; set Opcode = PRINT = 0x86
            bra SAVE_B_AND_CONT_PIL

ASS_isNUMeric:
            cmpb #$30 ; '0'
            bcs isTokenBasic
            cmpb #$3C ; '<'
            bcs SAVE_B_AND_CONT_PIL

isTokenBasic:
            tstb
            bmi loc_E362

doSearchToken_PIL:
            ldx #(aFOR-1)                        ; X pointe sur le tableau des commandes BASIC connues
            lds TXTPTR                           ; S pointe sur le flot  interprter
            clrb

bclIsTokenBasic:
            inx

bcl1IsTokenBasic:
            pula
            cmpa #cOS_SPACE                      ; ' ' ; si c'est un espace lu dans le flot alors on lit le caractre suivant
            beq bcl1IsTokenBasic
            suba 0,x
            beq bclIsTokenBasic                  ; Est-ce que le caractre lu correspond  la commande BASIC  ?
                                                 ; Oui alors on continue de lire le flot et  comparer ...
            cmpa #$80
            bne NotFoundTokenBasic_PIL           ; Est-ce la fin du mot-cl basic en cours de recherche ?
            orab #$80

bcl2IsTokenBasic:
            ldx STRNG2
            SKIP2

loc_E362:
            ldab #cEDT_UNKNOWN                   ; '!'

SAVE_B_AND_CONT_PIL:
            sts TXTPTR
            lds SAVREGS
            ldaa INPUTFLG                        ; =$00:INPUT,=$4F:READ
            tap
            inx
            stx STRNG2                           ; save position on CRUNCHED LINE
            stab $00,x
            beq endPARSE_INPUT_LINE
            subb #cBAS_SEP                       ; ':' ; est-ce l'oprateur(sparateur) : $3A c'est  dire : ?

isSep_PIL:
            beq COLIS_PIL

isTokenDATA_PIL:
            cmpb #(cBAS_TOKEN_DATA-cBAS_SEP)     ; $4B ; 'K' ; it's token DATA=$85=$3A+$4B ?
            bne isTokenREM_PIL

COLIS_PIL:
            stab DATAFLG                         ; setup flag

isTokenREM_PIL:
            subb #(cBAS_TOKEN_REM-cBAS_SEP)      ; $49 ; 'I' ; It's token REM=$83:$3A+$49
            bne bclPARSE_INPUT_LINE

doToken_REM_PIL:
            stab ENDCHR                          ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            sei
            lds TXTPTR

processChar_PIL:
            pulb
            tstb
            beq SAVE_B_AND_CONT_PIL
            cmpb ENDCHR                          ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            beq SAVE_B_AND_CONT_PIL

manageString_PIL:
            inx
            stab $00,x
            bra processChar_PIL

NotFoundTokenBasic_PIL:
            lds TXTPTR
            incb

EscapeCurrentToken_PIL:
            ldaa 0,x
            inx
            bpl EscapeCurrentToken_PIL
            ldaa 0,x
            bne bcl1IsTokenBasic                 ; Est-ce la fin des mots-cls du BASIC ?
                                                 ; Si non alors on continue la recherche ...
            sts TXTPTR
            lds SAVREGS
            jsr vHOOK11_PARSE_INPUT_LINE

getNextCharFromFlow:
            lds TXTPTR
            pulb                                 ; get next char from flow
            bra bcl2IsTokenBasic

endPARSE_INPUT_LINE:
            stab 1,x                             ; to do as end of line  (BASIC LINE)
            stab 2,x
            ldd STRNG2                           ; compute length of crunched line
            subd #(vHOOK14_FREE+1)               ; TODO : ?
            ldx #BUFFERKEYB-1                    ; make TXTPTR point to CRUNCHED LINE
            stx TXTPTR
            rts
; End of function CRUNCH


; =============== S U B R O U T I N E =======================================

; FCT : FNDLIN SEARCHES THE PROGRAM TEXT FOR THE LINE
;   WHOSE NUMBER IS PASSED IN "LINNUM".
;   THERE ARE TWO POSSIBLE RETURNS:
;
;   1) CARRY SET.
;      LOWTR POINTS TO THE LINK FIELD IN THE LINE
;      WHICH IS THE ONE SEARCHED FOR.
;
;   2) CARRY NOT SET.
;      LINE NOT FOUND. [LOWTR] POINTS TO THE LINE IN THE
;      PROGRAM GREATER THAN THE ONE SOUGHT AFTER.
; IN  : /
; OUT : C=1 : Ligne trouve
;       X=Position en mmoire de la ligne trouve

FNDLIN:
            ldx TXTAB                   ; dbut du programme basic

bclFNDLIN:
            ldd 0,x
            beq nextFNDLIN_FOUND
            ldd LINUM
            subd 2,x
            bls endFNDLIN
            ldx 0,x
            bra bclFNDLIN

nextFNDLIN_FOUND:
            sec

endFNDLIN:
            stx LOWTR                   ; LOWTR SAVE MATCH LINE NUMBER OR NUMBER OF LINE JUST AFTER
            rts
; End of function FNDLIN


; =============== S U B R O U T I N E =======================================

; FCT : CMD BASIC NEW : nouveau programme
; STX : NEW
; OP  : $96
; ST  : ACTIF
; IN  : A=Si <> 0  alors l'appel de NEW avait un argument
;       X=Position de la commande NEW
; OUT : A,B,X modified

romNEW:
            bne endFNDLIN
; End of function romNEW


; =============== S U B R O U T I N E =======================================

; FCT : Effectue l'action de la commande BASIC NEW
; IN  : /
; OUT : X=TXTTAB+2=dbut du programme + 2

doRomNEW:
            ldx TXTAB                   ; dbut du programme basic
            clr 0,x
            inx
            clr 0,x
            inx
            stx VARTAB                  ; Fin du programme BASIC / dbut des variables
; End of function doRomNEW


; =============== S U B R O U T I N E =======================================

; FCT : Erase all pointers
; IN  : /
; OUT : A,X modified

SETPTRS:
            ldx TXTAB                   ; dbut du programme basic
            dex
            stx TXTPTR

nextSetPTRS_CLEAR:
            jsr vHOOK4_CLEAR
            ldx MEMSIZ                  ; Adresse - 1 de la fin de la RAM DISPONIBLE
            stx FRETOP
            jsr romRESTORE              ; FCT : CMD BASIC RESTORE : permet d'initialiser le
                                        ;       pointeur des DATA au dbut du programme
                                        ; STX : 100 RESTORE
                                        ; OP  : $8F
                                        ; ST  : ACTIF
                                        ; IN  : /
                                        ; OUT : /
            ldx VARTAB                  ; Fin du programme BASIC / dbut des variables
            stx ARYTAB
            stx STREND
; End of function SETPTRS


; =============== S U B R O U T I N E =======================================

; FCT : Initialisation de certains pointeurs, pile et donnes BASIC
; IN  : /
; OUT : S=Initialis  sa position de dpart
;       A=0
;       OLDTXT=0, SUBFLG=0,CURDVC=0 (SCREEN),TMPPT=$3241
;       Le retour de l'appelant se fait par popx + jmp x
;       suite  l'initialisation de la pile (S)

reInitPointeur:
            ldx #DESC_STK               ; $3241
            stx TMPPT
            pulx                        ; nous rcuprons l'adresse de retour car ...
            lds botSTACK                ; nous reinitialisons le pointeur de pile  sa position initiale
            clra
            psha
            staa OLDTXT
            staa OLDTXT+1
            staa SUBFLG
            staa CURDVC                 ; CURRENT DEVICE : $00 : SCREEN, $FF : K7
            jmp 0,x                     ; retour  l'appelant via X et non pas RTS car nous avons reinitialis le pointeur de pile
; End of function reInitPointeur


; =============== S U B R O U T I N E =======================================

; FCT : Positionne le device  PRINTER(=$FE)
;       Lit le caractre en cours
; IN  : /
; OUT : A=CHRGOT()

setDeviceToPrinter:

            ldab #cOS_DEV_PRINTER_0xFE
            stab DEVNU                  ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante

jmpCHRGOT_0:
            jmp CHRGOT
; End of function setDeviceToPrinter


; =============== S U B R O U T I N E =======================================

; FCT : Imprime le listing du programme sur l'imprimante
; STX : LLIST ou LLIST n-m ou LLIST -m ou LLIST m-
; OP  : $99
; ST  : ACTIF
; IN  : le flot  interpreter
; OUT : A,B,X modified

romLLIST:
            bsr setDeviceToPrinter  ; FCT : Positionne le device  PRINTER(=$FE)
                                    ;       Lit le caractre en cours
                                    ; IN  : /
                                    ; OUT : A=CHRGOT()
; End of function romLLIST

; =============== S U B R O U T I N E =======================================

; FCT : Imprime le listing du programme sur l'cran
; STX : LIST ou LIST n-m ou LIST -m ou LIST m-
; OP  : $94
; ST  : ACTIF
; IN  : le flot  interpreter
; OUT : A,B,X modified

romLIST:
            tpa
            psha
            bsr jmpCHRGOT_0             ; et pourquoi pas jsr CHRGOT ?
            jsr LINGET                  ; FCT : Obtient un numro de ligne dans le flux d'entre
                                        ; IN  : le flot  interprter via CHRGET
                                        ; OUT : LINUM = numro de ligne obtenu en premire position
                                        ;       dans le flot  interprter
            bsr FNDLIN                  ; FCT : FNDLIN SEARCHES THE PROGRAM TEXT FOR THE LINE
                                        ;       WHOSE NUMBER IS PASSED IN "LINNUM".
                                        ;       THERE ARE TWO POSSIBLE RETURNS:
                                        ;
                                        ;       1) CARRY SET.
                                        ;          LOWTR POINTS TO THE LINK FIELD IN THE LINE
                                        ;          WHICH IS THE ONE SEARCHED FOR.
                                        ;
                                        ;       2) CARRY NOT SET.
                                        ;          LINE NOT FOUND. [LOWTR] POINTS TO THE LINE IN THE
                                        ;          PROGRAM GREATER THAN THE ONE SOUGHT AFTER.
                                        ; IN  : /
                                        ; OUT : C=1 : Ligne trouve
                                        ;       X=Position en mmoire de la ligne trouve
            pula
            tap
            pshx
            beq nextRomList
            jsr.w   CHRGOT              ; OJE 13/02/2020
            beq next1RomList

isTiret:
            cmpa #cBAS_TOKEN_MINUS      ; $A8 ; Token MINUS = sparateur entre les deux bornes de  recherche
            bne jmpSetError9x02_SYNTAXERROR
            jsr.w   CHRGET              ; OJE 13/02/2020
                                        ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                        ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                        ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                        ; NOT C= NUMERIC ("0" THRU "9")
                                        ; Z= ":" OR END-OF-LINE (A NULL)
                                        ; [ACCA] = NEW CHAR.
                                        ; [TXTPTR]=[TXTPTR]+1
            beq nextRomList
            jsr LINGET                  ; FCT : Obtient un numro de ligne dans le flux d'entre
                                        ; IN  : le flot  interprter via CHRGET
                                        ; OUT : LINUM = numro de ligne obtenu en premire position
                                        ;       dans le flot  interprter
            beq next1RomList

jmpSetError9x02_SYNTAXERROR:
            jmp setError0x02_SYNTAXERROR

nextRomList:
            ldx #$FFFF
            stx LINUM

next1RomList:
            pulx
            ins
            ins

bcl2RomList:
            jsr initParamByDevice         ; FCT : Permet d'initialiser les paramtres de l'cran ou de l'imprimante
                                        ;       selon la variable DEVNU
                                        ; IN  : DEVNU  jour
                                        ; OUT : A,B,X modified
            jsr ISCNTC                  ; FCT : Test si touche BREAK ou SHIFT+@(PAUSE) presse
                                        ;       Sinon crit  A dans le tampon clavier
                                        ; IN  : /
                                        ; OUT : A=code ASCII de la touche presse
            ldd 0,x
            bne next4RomList

bcl3RomList:
            clr DEVNU                   ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            jmp INTERPRETATION          ; FCT : INTERPRETATION
                                        ; IN  : /
                                        ; OUT : /

next4RomList:
            ldd 2,x
            subd LINUM
            bhi bcl3RomList
            ldd 2,x
            pshx
            jsr LIPTR                   ; FCT : Imprime le chiffre contenu dans D
                                        ; IN  : D : le chiffre  afficher
                                        ; OUT : A,B,X modified
            pulx
            inx
            inx
            inx
            inx
            stx INDEX
            clr fEDITLINE_SEP           ; en mode dition ligne ou LIST, l'opcode lu est un ", un :, un DATA, un REM
            ldaa #cOS_SPACE             ; ' '
            SKIP2

bcl5RomList:
            ldaa #cEDT_UNKNOWN          ; '!'

bcl6RomList:
            ldx INDEX
            anda #$7F

bcl7RomList:

            jsr j_printCHAR_1           ; FCT : Imprime un caractre sur le dispositif selectionn par DEVNU : Appel indirect  printCHAR_1
                                        ; IN  : A=char to print
                                        ; OUT : A modified
            ldaa 0,x
            inx
            tsta
            beq bcl2RomList
            ldab fEDITLINE_SEP          ; en mode dition ligne ou LIST, l'opcode lu est un ", un :, un DATA, un REM

isDoubleGuillemet_RomLIST:
            cmpa #cBAS_SEP_STR          ; '"'
            bne isSepBasic_RomLIST
            eorb #$01
            stab fEDITLINE_SEP          ; en mode dition ligne ou LIST, l'opcode lu est un ", un :, un DATA, un REM

isSepBasic_RomLIST:
            cmpa #cBAS_SEP              ; ':'
            bne next9RomLIST
            bitb #$01
            bne next9RomLIST
            andb #$FD
            stab fEDITLINE_SEP          ; en mode dition ligne ou LIST, l'opcode lu est un ", un :, un DATA, un REM

next9RomLIST:
            tsta
            bpl bcl7RomList
            tstb
            bne bcl7RomList

isDATA_RomLIST:
            cmpa #cBAS_TOKEN_DATA       ; $85
            bne isREM_RomLIST
            orab #$02

isREM_RomLIST:
            cmpa #cBAS_TOKEN_REM        ; $83
            bne next11RomLIST
            orab #$04

next11RomLIST:
            stab fEDITLINE_SEP          ; en mode dition ligne ou LIST, l'opcode lu est un ", un :, un DATA, un REM
            jsr vHOOK12_EDITLINE

isOverFlowOpcode_RomLIST:
            cmpa #cBAS_TOKEN_ALL_MAX    ; $C8 : numro max des opcodes BASIC
            bhi bcl5RomList
            bsr BAS_searchTextBASIC     ; FCT : Recherche la position du nom de la commande
                                        ;       BASIC associe au code BASIC.
                                        ; IN  : A=code de la fonction BASIC A>= $80
                                        ;       X=position dans le source BASIC
                                        ; OUT : X=position en rom du texte du code BASIC recherch

next12RomList:
            ldaa 0,x
            bmi bcl6RomList
            inx
            jsr j_printCHAR_1           ; FCT : Imprime un caractre sur le dispositif selectionn par DEVNU : Appel indirect  printCHAR_1
                                        ; IN  : A=char to print
                                        ; OUT : A modified
            bra next12RomList
; End of function romLIST


; =============== S U B R O U T I N E =======================================

; FCT : Recherche la position du nom de la commande
;       BASIC associe au code BASIC.
; IN  : A=code de la fonction BASIC A>= $80
;       X=position dans le source BASIC
; OUT : X=position en rom du texte du code BASIC recherch

BAS_searchTextBASIC:
            suba #$7F
            stx INDEX
            ldx #aFOR

bclSearchTextBASIC:
            deca
            bne bcl1SearchTextBASIC
            rts

bcl1SearchTextBASIC:
            tst 0,x
            inx
            bpl bcl1SearchTextBASIC
            bra bclSearchTextBASIC
; End of function BAS_searchTextBASIC


; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC FOR
; FOR PUSHES 18 BYTES ON THE STACK:
;  2 -- TXTPTR
;  2 -- LINE NUMBER
;  5 -- INITIAL (CURRENT)  FOR VARIABLE VALUE
;  1 -- STEP SIGN
;  5 -- STEP VALUE
;  2 -- ADDRESS OF FOR VARIABLE IN VARTAB
;  1 -- FOR TOKEN ($81)
; IN  : le flot d'interprtation
; OUT : A,B,X modified

romFOR:
            ldaa #$80
            staa SUBFLG
            jsr romLET                  ; FCT : effectue l'affectation d'une expression  une variable
                                        ; STX : A=SIN(3.14)
                                        ; OP  : $8D
                                        ; BUG : OUI ! Ne vrifie pas la  comptabilit de la variable et le rsultat de l'expression !
                                        ; IN  : le flot d'interpretation contenant le texte A=expr(B)
                                        ; OUT : /
            jsr FNDFOR                  ; FCT : RECHERCHE DANS LA PILE SI LE TOKEN FOR EXISTE
                                        ; IN  : /
                                        ; OUT : A=0 : Token FOR trouv
                                        ;       A=2 : Token GOSUB trouv
            pulx
            bne nextRomFOR
            ldx INDEX
            abx
            txs

nextRomFOR:
            ldab #(cBAS_BYTES_PER_FOR/2); Vrifie qu'il y a bien assez de mmoire pour coder un FOR
            jsr CHKMEM                  ; FCT : vrifie s'il y a 2*B + $3A octets libres
                                        ; IN  : B=Nombre d'octets / 2 ncessaires
                                        ; OUT : D=pointeur aprs ajout de 2*B + $3A octets
            jsr DATAN                   ; FCT : skip to end of statement ":" or null
                                        ; IN  : TXTPTR is set
                                        ; OUT : X=pointer on end of statement ":" or null
            pshx
            ldx CURLIN
            pshx

isOpcodeTO:
            ldab #cBAS_TOKEN_TO         ; $A2 ; opcode TO
            jsr SYNCHR                  ; FCT : UNLESS CHAR AT TXTPTR=(B), SYNTAX ERROR
                                        ; IN  : B=Opcode ou caractre  comparer
                                        ; OUT : X : not modified
                                        ;       A : le caractre suivant l'opcode ou caractre  comparer 
                                        ;           si la comparaison de l'opcode est OK 
            jsr CHKNUM
            jsr FRMNUM                  ; FCT : EVALUATE EXPRESSION, MAKE SURE IT IS NUMERIC
                                        ; IN  : le flot d'interprtation
                                        ; OUT : /

testACC1Sign:
            ldab ACC1+5
            orab #$7F
            andb ACC1+1
            stab ACC1+1
            ldx #STEP
            jmp FRM_STACK3              ; sauvegarde ACC1 dans la pile et se dbranche sur une routine pointe par X
; End of function romFOR


; =============== S U B R O U T I N E =======================================

; FCT : STEP PHRASE FOR NEXT
;       N'a pas sa propre existence !
; STX : FOR I=D TO F STEP P
; ALG : /
; OP  : $A2
; IN  : Pile initialise avec un pas cod en float
; OUT : A,B,X modified

STEP:
            ldx #conONE
            jsr MOVFM              ; FCT : MOVE memory to ACC1
                                   ; IN  : X=FLOAT (5 bytes)
                                   ; OUT : A and X unmodified
            jsr.w   CHRGOT         ; OJE 13/02/2020
            cmpa #cBAS_TOKEN_STEP  ; $A5 : TOKEN STEP
            bne nextSTEP
            jsr.w   CHRGET         ; OJE 13/02/2020
                                   ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                   ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                   ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                   ; NOT C= NUMERIC ("0" THRU "9")
                                   ; Z= ":" OR END-OF-LINE (A NULL)
                                   ; [ACCA] = NEW CHAR.
                                   ; [TXTPTR]=[TXTPTR]+1
            jsr FRMNUM             ; FCT : EVALUATE EXPRESSION, MAKE SURE IT IS NUMERIC
                                   ; IN  : le flot d'interprtation
                                   ; OUT : /

nextSTEP:
            jsr subSIGN            ; FCT : retourne le signe du nombre rel contenu dans ACC1
                                   ; IN  : /
                                   ; OUT : B=$01 si ACC1 > 0
                                   ;       B=$00 si ACC1 = 0
                                   ;       B=$FF si ACC1 < 0
            jsr FRM_STACK2
            ldx FORPNT
            pshx
            ldaa #$80
            psha
; End of function STEP


; =============== S U B R O U T I N E =======================================

; FCT : perform next statement
; IN  : le flot d'interprtation
; OUT : /

NEWSTT:
            bsr ISCNTC              ; FCT : Test si touche BREAK ou SHIFT+@(PAUSE) presse
                                    ;       Sinon crit  A dans le tampon clavier
                                    ; IN  : /
                                    ; OUT : A=code ASCII de la touche presse
            ldx TXTPTR              ; look at current character
            stx TMPTXT              ; SAVE IN CASE OF RESTART BY INPUT

CHKSTT:
            ldaa 0,x
            beq nextNEWSTT

isSEPSTT:
            cmpa #cBAS_SEP          ; est-ce que nous rencontrons le sparateur d'instruction ?; ':'
            beq NEWSTT2

jmpSyntaxError:
            jmp setError0x02_SYNTAXERROR

nextNEWSTT:
            inx
            ldaa 0,x
            inx
            oraa 0,x
            staa ENDSTT             ; Indique si la fin du programme a t rencontr
            beq next1RomEND         ; Si oui alors on reiniatilise certains pointeurs et nous affichons le prompt
            inx

getLineSTT:
            ldd 0,x
            std CURLIN              ; met  jour le numro de ligne suite  une nouvelle instruction
            inx
            stx TXTPTR              ; met  jour le pointeur de texte  interpreter

NEWSTT2:
            jsr.w   CHRGET          ; OJE 13/02/2020
                                    ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                    ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                    ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                    ; NOT C= NUMERIC ("0" THRU "9")
                                    ; Z= ":" OR END-OF-LINE (A NULL)
                                    ; [ACCA] = NEW CHAR.
                                    ; [TXTPTR]=[TXTPTR]+1
            bsr EXECUTE_STATEMENT   ; FCT : excute a statement
                                    ; IN  : A is first char of statement
                                    ;       C is set
                                    ; OUT : A,B,X modified
            bra NEWSTT              ; FCT : perform next statement
                                    ; IN  : le flot d'interprtation
                                    ; OUT : /
; End of function NEWSTT

; =============== S U B R O U T I N E =======================================

; FCT : execute a statement
; IN  : A is first char of statement
;       C is set
; OUT : A,B,X modified

EXECUTE_STATEMENT:
            beq endRomCont

EXEC_STAT1:
            jsr vHOOK10_EXECSTMT
            tsta
            bmi doJmpInstruction
            jmp romLET                  ; FCT : effectue l'affectation d'une expression  une variable
                                        ; STX : A=SIN(3.14)
                                        ; OP  : $8D
                                        ; BUG : OUI ! Ne vrifie pas la  comptabilit de la variable et le rsultat de l'expression !
                                        ; IN  : le flot d'interpretation contenant le texte A=expr(B)
                                        ; OUT : /

doJmpInstruction:
            cmpa #cBAS_TOKEN_CMD_MAX    ; $A0 ; '' ; token SKIPF : nombre maximal de commandes BASIC
            bhi jmpSyntaxError
            asla
            tab
            ldx #jmpINSTRUCTION
            abx
            ldx 0,x
            jsr.w   CHRGET              ; OJE 13/02/2020 / 255B
                                        ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                        ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                        ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                        ; NOT C= NUMERIC ("0" THRU "9")
                                        ; Z= ":" OR END-OF-LINE (A NULL)
                                        ; [ACCA] = NEW CHAR.
                                        ; [TXTPTR]=[TXTPTR]+1
            jmp 0,x
; End of function EXECUTE_STATEMENT


; =============== S U B R O U T I N E =======================================

; FCT : CMD BASIC RESTORE : permet d'initialiser le
;       pointeur des DATA au dbut du programme
; STX : 100 RESTORE
; OP  : $8F
; ST  : ACTIF
; IN  : /
; OUT : /

romRESTORE:
            ldx TXTAB                   ; dbut du programme basic
            dex

endRomRESTORE:
            stx DATPTR                  ; DATA STATEMENT ADDRESS POINTER
            rts
; End of function romRESTORE


; =============== S U B R O U T I N E =======================================

; FCT : Test si touche BREAK ou SHIFT+@(PAUSE) presse
;       Sinon crit A dans le tampon clavier
; IN  : /
; OUT : A=code ASCII de la touche presse

ISCNTC:
            jsr getKeyPressed               ; FCT : dtermine si on a appuy sur les touches de contrles
                                            ;       et une autre touche
                                            ; IN  : /
                                            ; OUT : A=0 : CTRL is pressed
                                            ;       A<>0 : other key pressed
            beq endTestKeyPause

isHITKEY_BREAK:
            cmpa #cKB_BREAK
            beq romSTOP                     ; FCT : CMD BASIC STOP : permet d'arrter le programme
                                            ; STX : STOP
                                            ; OP  : $91
                                            ; ST  : ACTIF
                                            ; IN  : le flot  interprter
                                            ; OUT : /

isHITKEY_SHIFT@:
            cmpa #cKB_SHIFT_ARROBASE
            beq waitHITKEY_LIST
            staa charKEYB

endTestKeyPause:
            rts

waitHITKEY_LIST:
            jsr OS_POLCA                    ; FCT : polling keyboard
                                            ; IN  : /
                                            ; OUT : A=code ascii de la touche
                                            ;       X,B not modified
            beq waitHITKEY_LIST
            bra isHITKEY_BREAK
; End of function ISCNTC


; =============== S U B R O U T I N E =======================================

; FCT : CMD BASIC STOP : permet d'arrter le programme
; STX : STOP
; OP  : $91
; ST  : ACTIF
; IN  : le flot  interprter
; OUT : /

romSTOP:
            sec
; End of function romSTOP


; =============== S U B R O U T I N E =======================================

; FCT : CMD BASIC END : arrte le programme
; STX : 100 END
; OP  : $89
; ST  : ACTIF
; IN  : /
; OUT : /

romEND:
            bne endRomCont
            ldx TXTPTR
            stx TMPTXT

nextRomEND:
            ror ENDSTT                  ; Indique si la fin du programme a t rencontr
            pulx

next1RomEND:
            ldx CURLIN
            inx
            beq next2RomEND
            dex
            stx OLDLIN
            ldx TMPTXT
            stx OLDTXT

next2RomEND:
            clr DEVNU                   ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            ldx #(aBreak-1)             ; "\rBREAK"
            tst ENDSTT                  ; Indique si la fin du programme a t rencontr
            bpl next3RomEND_restart
            jmp printMsgErrorAndWaitInputFromUser

next3RomEND_restart:
            jmp INTERPRETATION          ; FCT : INTERPRETATION
                                        ; IN  : /
                                        ; OUT : /
; End of function romEND

; =============== S U B R O U T I N E =======================================

; FCT : CMD BASIC CONT : permet de reprendre le programme aprs un break
; STX : CONT
; OP  : $93
; ST  : ACTIF
; IN  : /
; OUT : /

romCONT:
            bne endRomCont
            ldab #cBAS_ERR_CANTCONT      ; ' '  ; set error to 0X20 : can't continue
            ldx OLDTXT
            bne nextRomCONT
            jmp ERROR

nextRomCONT:
            stx TXTPTR
            ldx OLDLIN
            stx CURLIN

endRomCont:
            rts
; End of function romCONT


; =============== S U B R O U T I N E =======================================

; FCT : CMD BASIC CLEAR : CLEAR : initialise variable et rserve 100 octets pour les string
; STX : CLEAR nombre : init var et rserve nombre octets pour les string
;       CLEAR N1,N2 avec N1 < N2 et n1 mmoire basse et n2 mmoire haute
; OP  : $95
; ST  : ACTIF
; BUG : /
; IN  : le flot  interpreter
; OUT : A,B,X modified

romCLEAR:
            beq jmpNextSetPTRS_CLEAR

getFirstPrm_RomCLEAR:
            jsr jsrFRNUMAndMKINT        ; FCT : interprtre une expression de type int et retourne une valeur de type word
                                        ; ALG : /
                                        ; STX : /
                                        ; ST  : ACTIF
                                        ; IN  : le flot d'interprtation
                                        ; OUT : D=rsultat de l'interprtation de l'expression
            pshb                        ; sauvegarde le premier paramtre
            psha
            ldx MEMSIZ                  ; Adresse - 1 de la fin de la RAM DISPONIBLE
            stx ACC1+3
            jsr.w   CHRGOT              ; OJE 13/02/2020
            beq nextCLEAR

getSecondPrm_RomClear:
            jsr CHKCOM
            jsr GETARG                  ; FCT : Rcuprer un word dans le flot d'inteprtation
                                        ; IN  : le flot d'interprtation
                                        ; OUT : X=WORD from ARGUMENT
                                        ;       ACC1+3 contient aussi l'expression convertie de type word
            ldx ACC1+3                  ; TODO :  optimiser car si GETARG renvoie dj dans X la valeur ...
            dex
            stx ACC1+3
            ldd ADRENDMEM               ; Adresse de la fin de mmoire
            subd ACC1+3
            bcs jmpMEMERR

nextCLEAR:
            ldd ACC1+3
            pshb
            psha
            tsx
            subd 2,x
            bcs jmpMEMERR
            std 2,x
            subd #$3A                   ; ':' TODO pourquoi cette valeur ?
            bcs jmpMEMERR
            subd VARTAB                 ; Fin du programme BASIC / dbut des variables
            bcs jmpMEMERR
            pulx
            stx MEMSIZ                  ; Adresse - 1 de la fin de la RAM DISPONIBLE
            pulx
            stx botSTACK

jmpNextSetPTRS_CLEAR:
            jmp nextSetPTRS_CLEAR

jmpMEMERR:
            jmp MEMERR                  ; FCT : Point d'entre secondaire pour la gestion d'erreur
                                        ;       il correspond  "plus de place disponible en mmoire"
                                        ; IN  : /
                                        ; OUT : A,B,X modified
; End of function romCLEAR

; =============== S U B R O U T I N E =======================================

; FCT : CMD BASIC RUN : permet de lancer un programme au dbut
;       ou  un numro de ligne  donne en paramtre
; STX : RUN
;       RUN numro_de_ligne
; OP  : $8E
; ST  : ACTIF
; IN  : le flot  interprter
; OUT : /

romRUN:
            bne nextRomRUN
            jmp SETPTRS             ; FCT : Erase all pointers
                                    ; IN  : /
                                    ; OUT : A,X modified
                                    
nextRomRUN:
            jsr nextSetPTRS_CLEAR
            bra nextRomGOSUB
; End of function romRUN


; =============== S U B R O U T I N E =======================================

; FCT :
;  "GOSUB" STATEMENT
;  LEAVES 5 ou 7 BYTES ON STACK
;  2 -- RETURN ADDRESS (NEWSTT)
;  2 -- TXTPTR
;  2 -- LINE #
;  1 -- GOSUB TOKEN
; OP  : $82
; IN  : /
; OUT : /

romGOSUB:
            ldab #3
            jsr CHKMEM              ; FCT : vrifie s'il y a 2*B + $3A octets libres
                                    ; IN  : B=Nombre d'octets / 2 ncessaires
                                    ; OUT : D=pointeur aprs ajout de 2*B + $3A octets
            ldx TXTPTR
            pshx
            ldx CURLIN
            pshx
            ldaa #cBAS_TOKEN_GOSUB  ; $82 ; ''     ; opcode GOSUB
            psha

nextRomGOSUB:
            jsr.w   CHRGOT          ; OJE 13/02/2020 - V2
            bsr romGOTO             ; FCT : Effectue un saut  la ligne L
                                    ; STX : 10 GOTO 100 ==> OK
                                    ;       10 GOTO A   ==> KO
                                    ; OP  : $81
                                    ; IN  : le flot d'interprtation qui doit contenir un numro de ligne
                                    ; OUT : /
            jmp NEWSTT              ; FCT : perform next statement
                                    ; IN  : le flot d'interprtation
                                    ; OUT : /
; End of function romGOSUB

; =============== S U B R O U T I N E =======================================

; FCT : Effectue un saut  la ligne L
; STX : 10 GOTO 100 ==> OK
;       10 GOTO A   ==> KO
; OP  : $81
; IN  : le flot d'interprtation qui doit contenir un numro de ligne
; OUT : /

romGOTO:
            jsr LINGET          ; FCT : Obtient un numro de ligne dans le flux d'entre
                                ; IN  : le flot  interprter via CHRGET
                                ; OUT : LINUM = numro de ligne obtenu en premire position
                                ;       dans le flot  interprter
            bsr REMN            ; FCT : skip to end of line
                                ; IN  : TXTPTR is set
                                ; OUT : X=pointer on end of line
            inx
            ldd LINUM
            subd CURLIN
            bhi nextRomGOTO
            ldx TXTAB           ; dbut du programme basic

nextRomGOTO:
            jsr bclFNDLIN
            bcs jmpERROR_0X0E_UndefLine
            dex
            stx TXTPTR

endRomGOTO:
            rts
; End of function romGOTO

; =============== S U B R O U T I N E =======================================
; FCT : COMMANDE BASIC RETURN : Ramne l'excution du programme  l'instruction qui suit le GOSUB
; STX : RETURN
; OP  : $90
; ST  : ACTIF
; IN  : /
; OUT : A,B,X modified
; ERR : $04 : RETURN sans GOSUB
romRETURN:
            bne endRomGOTO
            ldaa #$FF
            staa FORPNT
            jsr FNDFOR                              ; FCT : RECHERCHE DANS LA PILE SI LE TOKEN FOR EXISTE
                                                    ; IN  : /
                                                    ; OUT : A=0 : Token FOR trouv
                                                    ;       A=2 : Token GOSUB trouv
            txs
            cmpa #(cBAS_TOKEN_GOSUB-cBAS_TOKEN_FOR) ; $02 ; As-ton trouv l'opcode GOSUB (A contient un delta de code de token)
            beq doRETURN

jmpERROR_0X04_RETURNWITHOUTGOSUB:
            ldab #cBAS_ERR_NOGOSUB
            SKIP2

jmpERROR_0X0E_UndefLine:
            ldab #cBAS_ERR_UNDEFSTAT        ; TODO EST-ce BON ? contient la valeur 0X0E et pas une autre car j'ai not UndefLine et non pas UndefStatement !?
            jmp ERROR

jmpPrintErrorMSg0x02_SyntaxErr:
            jmp setError0x02_SYNTAXERROR

doRETURN:
            pula
            pulx
            stx CURLIN
            pulx
            stx TXTPTR

; =============== S U B R O U T I N E =======================================

; FCT : Instruction BASIC pour enregistrer des donnes squentielles
; OP  : $85
; BUG : 10 DATA 10,"TITI,12 : PRINT 34 ne pose pas de problme au BASIC
; IN  : le flot d'interprtation contenant les donnes squentielles
; OUT : en mode interprtation ignore la ligne contenant les data

romDATA:
            bsr DATAN       ; FCT : skip to end of statement ":" or null
                            ; IN  : TXTPTR is set
                            ; OUT : X=pointer on end of statement ":" or null
            stx TXTPTR

endRomDATA:

            rts
; End of function romDATA


; =============== S U B R O U T I N E =======================================

; FCT : skip to end of statement ":" or null
; IN  : TXTPTR is set
; OUT : X=pointer on end of statement ":" or null

DATAN:
            ldab #cBAS_SEP ; ':'
            SKIP_BYTE      ; dc.b $86
; End of function DATAN


; =============== S U B R O U T I N E =======================================

; FCT : skip to end of line
; IN  : TXTPTR is set
; OUT : X=pointer on end of line

REMN:

            clrb
            stab CHARAC                 ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            clrb
            ldx TXTPTR

bclREMN:
            tba
            ldab CHARAC                 ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            staa CHARAC                 ; sert  tout : stockage d'un caractre, de valeur pour opration binaire

bcl1REMN:
            ldaa 0,x
            beq endRomDATA
            cba
            beq endRomDATA
            inx
            cmpa #cBAS_SEP_STR          ; '"'
            beq bclREMN
            bra bcl1REMN
; End of function REMN


; =============== S U B R O U T I N E =======================================

; FCT : Commande BASIC IF
; STX : IF A THEN 10
;       IF A THEN GOTO 10
; OP  : $84
; BUG : IF A THEN A=A-2 GOTO 20 ne drange pas le basic  ...
;       Par contre IF A=1 THEN A=A-2 GOTO 20 le drange  !!
; IN  : le flot  interprter suivant le IF
; OUT : /

romIF:
            jsr FRMNUM                  ; FCT : EVALUATE EXPRESSION, MAKE SURE IT IS NUMERIC
                                        ; IN  : le flot d'interprtation
                                        ; OUT : /
            jsr.w   CHRGOT              ; OJE 13/02/2020 - V2

isOpcodeGOTO:
            cmpa #cBAS_TOKEN_GOTO       ; $81 ; Opcode GOTO
            beq endRomIF

isOpcodeTHEN:
            ldab #cBAS_TOKEN_THEN       ; Opcode THEN
            jsr SYNCHR                  ; FCT : UNLESS CHAR AT TXTPTR=(B), SYNTAX ERROR
                                        ; IN  : B=Opcode ou caractre  comparer
                                        ; OUT : X : not modified
                                        ;       A : le caractre suivant l'opcode ou caractre  comparer 
                                        ;           si la comparaison de l'opcode est OK

endRomIF:
            ldaa ACC1
            bne statementRom_IF         ; FCT : gestion spcifique de la squence suivant le IF
                                        ; IN  : le flot d'interprtation 
                                        ; OUT : /
; End of function romIF

; =============== S U B R O U T I N E =======================================

; FCT : Instruction BASIC pour mettre en commentaire
; STX : REM mon commentaire
; OP  : $83
; IN  : le flot d'interprtation
; OUT : TXTPTR pointe sur la prochaine instruction

romREM:
            bsr REMN                    ; FCT : skip to end of line
                                        ; IN  : TXTPTR is set
                                        ; OUT : X=pointer on end of line
            stx TXTPTR
            rts
; End of function romREM


; =============== S U B R O U T I N E =======================================

; FCT : gestion spcifique de la squence suivant le IF
; IN  : le flot d'interprtation 
; OUT : /

statementRom_IF:
            jsr.w   CHRGOT              ; OJE 13/02/2020 - V2
            bcs romGOTO                 ; FCT : Effectue un saut  la ligne L
                                        ; STX : 10 GOTO 100 ==> OK
                                        ;       10 GOTO A   ==> KO
                                        ; OP  : $81
                                        ; IN  : le flot d'interprtation qui doit contenir un numro de ligne
                                        ; OUT : /
            jmp EXECUTE_STATEMENT       ; FCT : excute a statement
                                        ; IN  : A is first char of statement
                                        ;       C is set
                                        ; OUT : A,B,X modified
; End of function statementRom_IF

; =============== S U B R O U T I N E =======================================

; FCT : Branche vers un numro de ligne selon la valeur "variable"
; STX : ON variable GOTO n1,n2,...
;       ON variable GOSUB n1,n2,...
; OP  : $87
; BUG : /
; IN  : le flot d'interprtation contenant le reste de l'instruction (variable GOTO n1,...)
; OUT : /

romON:
            jsr GETBYT                  ; FCT : EVALUATE EXPRESSION AT TXTPTR, AND
                                        ;       CONVERT IT TO SINGLE BYTE IN B-REG
                                        ; ERR : FC : fonction incorrecte
                                        ; IN  : le flot d'interprtation
                                        ; OUT : B=la partie haute de la conversion (ACC1+3,ACC1+4)
            psha
            cmpa #cBAS_TOKEN_GOSUB      ; $82 ; TOKEN GOSUB
            beq bcl1NextRomOn
            cmpa #cBAS_TOKEN_GOTO       ; $81 ; TOKEN GOTO

nextRomON:
            bne jmpPrintErrorMSg0x02_SyntaxErr

bcl1NextRomOn:

            dec ACC1+4
            bne next2RomON
            pula
            jmp EXEC_STAT1

next2RomON:
            jsr.w   CHRGET              ; OJE 14/02/2020 V3
                                        ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                        ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                        ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                        ; NOT C= NUMERIC ("0" THRU "9")
                                        ; Z= ":" OR END-OF-LINE (A NULL)
                                        ; [ACCA] = NEW CHAR.
                                        ; [TXTPTR]=[TXTPTR]+1
            bsr LINGET                  ; FCT : Obtient un numro de ligne dans le flux d'entre
                                        ; IN  : le flot  interprter via CHRGET
                                        ; OUT : LINUM = numro de ligne obtenu en premire position
                                        ;       dans le flot  interprter
            cmpa #cBAS_SEP_ARG          ; ','
            beq bcl1NextRomOn
            ins

endRomON:
            rts
; End of function romON


; =============== S U B R O U T I N E =======================================

; FCT : Obtient un numro de ligne dans le flux d'entre
; IN  : le flot  interprter via CHRGET
; OUT : LINUM = numro de ligne obtenu en premire position
;       dans le flot  interprter

LINGET:
            ldx #$0000
            stx LINUM

bclLINGET:
            bcc endRomON
            suba #$30 ; '0'
            staa CHARAC                 ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            ldd LINUM
            cmpa #$18                   ; TODO : ?
            bhi nextRomON
            lsld
            lsld
            addd LINUM
            lsld
            addb CHARAC                 ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            adca #$00
            std LINUM
            jsr.w   CHRGET              ; OJE 14/02/2020 V3
                                        ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                        ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                        ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                        ; NOT C= NUMERIC ("0" THRU "9")
                                        ; Z= ":" OR END-OF-LINE (A NULL)
                                        ; [ACCA] = NEW CHAR.
                                        ; [TXTPTR]=[TXTPTR]+1
            bra bclLINGET
; End of function LINGET


; =============== S U B R O U T I N E =======================================

; FCT : effectue l'affectation d'une expression  une variable
; STX : A=SIN(3.14)
; OP  : $8D
; BUG : OUI ! Ne vrifie pas la comptabilit de la variable et le rsultat de l'expression !
; IN  : le flot d'interpretation contenant le texte A=expr(B)
; OUT : /

romLET:
            jsr PTRGET                  ; FCT : Lit un nom de variable  l'aide de CHRGOT
                                        ;       et le trouve en mmoire
                                        ; IN  : TXTPTR pointe sur le premier caractre du nom
                                        ; OUT : X=VARPNT=ADRESSE DE LA VARIABLE
                                        ;       (si non trouv alors cration d'une variable simple ou d'un
                                        ;       tableau de dim(10) initialis  0)
            stx FORPNT                  ; stocke le pointeur sur la variable pour plus tard
            ldab #cBAS_TOKEN_egal       ; $AF : token EQUAL
            jsr SYNCHR                  ; FCT : UNLESS CHAR AT TXTPTR=(B), SYNTAX ERROR
                                        ; IN  : B=Opcode ou caractre  comparer
                                        ; OUT : X : not modified
                                        ;       A : le caractre suivant l'opcode ou caractre  comparer 
                                        ;           si la comparaison de l'opcode est OK
            ldaa VALTYP                 ; Type de valeur en cours de traitement : $00 : num, $FF = str
            psha
            jsr FRMEVL                  ; FCT : effectue l'valuation du flux d'entre
                                        ; IN  : le flux d'entre
                                        ; OUT : ACC1=result of expression (pointeur if string or value if numeric)
            pula
            rora
            jsr CHKVAL                  ; FCT : Le rsultat de l'interprtation est-il une chane de caractres ?
                                        ; ERR : Type incompatible
                                        ; IN  : VALTYP  jour
                                        ; OUT : /
            beq saveFloatRomLET

nextRomLET_STRING:
            ldx ACC1+3
            ldd botSTACK
            subd 2,x
            bcc next1RomLET
            ldd VARTAB                  ; Fin du programme BASIC / dbut des variables
            subd ACC1+3
            bhi next1RomLET
            ldab 0,x
            jsr STRINI                  ; FCT : GET SPACE AND MAKE DESCRIPTOR FOR STRING WHOSE ADDRESS IS IN X
                                        ;       AND WHOSE LENGTH IS IN B-REG
                                        ; IN  : X=pointer on string
										;       B=taille de la chane  rserver
                                        ; OUT : ACC3[0-4]
            ldx DSCPTR
            jsr MOVSTR_IND              ; FCT : Dplace une zone mmoire dont la source est donne
                                        ;       indirectement par X et la cible par le pointeur contenu
                                        ;       dans FREESPC
                                        ; IN  : X=source de la zone  copier
                                        ;       B=nombre d'octet  copier
                                        ; OUT : A, X,B modified
            ldx #$00D0                  ; TODO ; ''

next1RomLET:
            stx DSCPTR
            jsr FRETMS                  ; FCT : RELEASE TEMPORARY DESCRIPTOR IF X = LASTPT
                                        ; IN  : X=pointeur
                                        ; OUT : si X=LASTPT alors
                                        ;         TMPPT=X et LASTP=X-5
                                        ;         A=0
                                        ;       sinon rien
            ldx DSCPTR
            ldaa 0,x
            psha
            ldd 2,x
            ldx FORPNT
            std 2,x
            pula
            staa 0,x
            rts

saveFloatRomLET:
            jmp saveACC1toFORPNT
; End of function romLET


; =============== S U B R O U T I N E =======================================

; FCT : Imprime les expressions sur l'imprimante
; STX : LPRINT A;B
; OP  : $9A
; ST  : ACTIF
; IN  : le flot  interpreter
; OUT : A,B,X modified

romLPRINT:
            jsr setDeviceToPrinter      ; FCT : Positionne le device  PRINTER(=$FE)
                                        ;       Lit le caractre en cours
                                        ; IN  : /
                                        ; OUT : A=CHRGOT()
; End of function romLPRINT

; =============== S U B R O U T I N E =======================================

; FCT : Imprime les expressions sur l'cran
; STX : PRINT A;B
; OP  : $86
; ST  : ACTIF
; IN  : le flot  interpreter
; OUT : A,B,X modified

romPRINT:
            bsr doRomPRINT              ; FCT : COMMANDE BASIC D'AFFICHAGE
                                        ;       PRINT A ; "TITI", 2*A ; @10,TITI
                                        ; IN  : A=le caractre suivant le PRINT
                                        ; OUT : /
            clr DEVNU                   ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            rts
; End of function romPRINT


; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC D'AFFICHAGE
;       PRINT A ; "TITI", 2*A ; @10,TITI
; IN  : A=le caractre suivant le PRINT
; OUT : /

doRomPRINT:

            beq printCR                 ; FCT : effectue un retour  la ligne
                                        ; IN  : /
                                        ; OUT : A modified
            cmpa #$40                   ; '@' : positionnement  l'cran
            bne nextDoRomPRINT

doRomPrint_AT:
            jsr getPARAM_AT             ; FCT : rcupre le paramtre numrique suivant le @ de PRINT @
                                        ;       vrifie que le paramtre est bien dans l'intervalle
                                        ;       en nombre de caractres de l'cran.
                                        ;       Et oui ! on ne donne pas X et Y directement !
                                        ; IN  ; /
                                        ; OUT : D=CURAD_YX=nouvelle position impose par D
            jsr.w   CHRGOT              ; OJE 13/02/2020 - V2
            beq printCR                 ; FCT : effectue un retour  la ligne
                                        ; IN  : /
                                        ; OUT : A modified
            jsr CHKCOM

nextDoRomPRINT:

            beq endinitParamByDevice

bcl1DoRomPRINT:
            cmpa #cBAS_TOKEN_TAB        ; $A1
            beq doPRINT_TAB
            cmpa #cBAS_SEP_ARG          ; ','
            beq doPRINT_COMMA
            cmpa #cBAS_SEP_VAR          ; ';'
            beq doPRINT_SEMICOMMA

EVAL_PRINT:
            jsr FRMEVL                  ; FCT : effectue l'valuation du flux d'entre
                                        ; IN  : le flux d'entre
                                        ; OUT : ACC1=result of expression (pointeur if string or value if numeric)
            ldaa VALTYP                 ; Type de valeur en cours de traitement : $00 : num, $FF = str
            psha
            bne next2DoRomPRINT
            jsr FOUT                    ; FCT : CONVERT (ACC1) TO STRING STARTING AT STACK
                                        ; IN  : /
                                        ; OUT : X=Pointeur sur le tampon de conversion Float -> String
            jsr DECXbeforeSTRLIT        ; FCT : DEC X AND BUILD A DESCRIPTOR FOR STRING STARTING AT X
                                        ;       AND TERMINATED BY $00 OR QUOTATION MARK
                                        ;       RETURN WITH DESCRIPTOR IN A TEMPORARY
                                        ;       AND ADDRESS OF DESCRIPTOR IN ACC1+3,4
                                        ; ST  : ACTIF
                                        ; IN  : X=string to create an descriptor
                                        ; OUT : A,B,X modified

next2DoRomPRINT:
            bsr nextOUTTX
            pulb
            tstb
            bne next3DoRomPRINT
            jsr.w   CHRGOT              ; OJE 13/02/2020 - V2
            cmpa #cBAS_SEP_ARG          ; ','
            beq doPRINT_COMMA
            bsr OS_printESPACE

next3DoRomPRINT:
            jsr.w   CHRGOT              ; OJE 13/02/2020 - V2
            bne bcl1DoRomPRINT
; End of function doRomPRINT


; =============== S U B R O U T I N E =======================================

; FCT : effectue un retour  la ligne
; IN  : /
; OUT : A modified

printCR:
            ldaa #cOS_CR
            bra j_printCHAR_1           ; FCT : Imprime un caractre sur le dispositif selectionn par DEVNU : Appel indirect  printCHAR_1
                                        ; IN  : A=char to print
                                        ; OUT : A modified
; End of function printCR

; =============== S U B R O U T I N E =======================================

; FCT : Permet d'initialiser les paramtres de l'cran ou de l'imprimante
;       selon la variable DEVNU
; IN  : DEVNU  jour
; OUT : A,B,X modified

initParamByDevice:
            jsr doinitParamByDevice     ; FCT : Initialise le paramtrage des abscisses pour le device (DEVNU=0: cran sinon imprimante)
                                        ; IN  : DEVNU Initialis : =$00 cran sinon printer
                                        ; OUT : A,B,X unmodified
            beq printCR                 ; FCT : effectue un retour  la ligne
                                        ; IN  : /
                                        ; OUT : A modified
            ldaa DEVXCURR               ; vaut $00  l'init
            bne printCR                 ; FCT : effectue un retour  la ligne
                                        ; IN  : /
                                        ; OUT : A modified
endinitParamByDevice:
            rts
; End of function initParamByDevice

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR doRomPRINT

doPRINT_COMMA:

            jsr doinitParamByDevice     ; FCT : Initialise le paramtrage des abscisses pour le device (DEVNU=0: cran sinon imprimante)
                                        ; IN  : DEVNU Initialis : =$00 cran sinon printer
                                        ; OUT : A,B,X unmodified
            beq nextDOPRINT_COMMA
            ldab DEVXCURR               ; vaut $00  l'init
            cmpb DEVXMARGIN+1           ; Marge GAUCHE/DROITE pour les tabulations
                                        ; CLS 81 : $10,$40
                                        ; CLS 40 : $10,$10
                                        ; CLS 32 : $10,$10
                                        ;
            bcs bcl1DOPRINT_COMMA
            bsr printCR                 ; FCT : effectue un retour  la ligne
                                        ; IN  : /
                                        ; OUT : A modified
            bra doPRINT_SEMICOMMA

nextDOPRINT_COMMA:
            ldab DEVXCURR               ; vaut $00  l'init

bcl1DOPRINT_COMMA:

            subb DEVXMARGIN             ; Marge GAUCHE/DROITE pour les tabulations
                                        ; CLS 81 : $10,$40
                                        ; CLS 40 : $10,$10
                                        ; CLS 32 : $10,$10
                                        ;
            bcc bcl1DOPRINT_COMMA
            negb
            bra bcl1DoPRINT_TAB

doPRINT_TAB:
            jsr GETBYTC                 ; FCT: SCAN TO NEXT CHARACTER AND CONVERT EXPRESSION
                                        ;      TO SINGLE BYTE IN B-REG
                                        ; IN : Le flot d'interprtation
                                        ; OUT: B=byte converted from expression
                                        ;      A=next char after expression
            cmpa #cBAS_FCT_CLOSE        ; ')'
            beq nextDoPRINT_TAB
            jmp setError0x02_SYNTAXERROR

nextDoPRINT_TAB:
            jsr doinitParamByDevice     ; FCT : Initialise le paramtrage des abscisses pour le device (DEVNU=0: cran sinon imprimante)
                                        ; IN  : DEVNU Initialis : =$00 cran sinon printer
                                        ; OUT : A,B,X unmodified
            subb DEVXCURR               ; vaut $00  l'init
            bls doPRINT_SEMICOMMA

bcl1DoPRINT_TAB:
            bsr OS_printESPACE          ; Imprime autant d'espace qu'il faut pour le tab
            decb
            bne bcl1DoPRINT_TAB

doPRINT_SEMICOMMA:

            jsr.w   CHRGET              ; OJE 14/02/2020 V3
                                        ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                        ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                        ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                        ; NOT C= NUMERIC ("0" THRU "9")
                                        ; Z= ":" OR END-OF-LINE (A NULL)
                                        ; [ACCA] = NEW CHAR.
                                        ; [TXTPTR]=[TXTPTR]+1
            jmp nextDoRomPRINT
; END OF FUNCTION CHUNK FOR doRomPRINT

; =============== S U B R O U T I N E =======================================

; FCT: OUTTX mission d'une chane de caractres termine par 0
; IN : X=pointeur sur une chane de caractres termine par un 0
; OUT: A,B,X modified
; OPT: A optimiser

OS_OUTTX:
            jsr STRLIT                  ; FCT : BUILD A DESCRIPTOR FOR STRING STARTING AT X
                                        ;       AND TERMINATED BY $00 OR QUOTATION MARK
                                        ;       RETURN WITH DESCRIPTOR IN A TEMPORARY
                                        ;       AND ADDRESS OF DESCRIPTOR IN ACC1+3,4
                                        ; ST  : ACTIF
                                        ; IN  : X=string to create an descriptor
                                        ; OUT : A,B,X modified

nextOUTTX:
            jsr FREFAC                  ; FCT : Libre la zone rserve par descripteur (chane de caractres)
                                        ; IN  : ACC1+3 et ACC1+4 : contient le descripteur
                                        ; OUT : X=pointer
            incb                        ; TODO : la valeur de b provient d'o ?

bcl1OUTTX:
            decb
            beq endinitParamByDevice
            ldaa 0,x
            inx
            bsr j_printCHAR_1           ; FCT : Imprime un caractre sur le dispositif selectionn par DEVNU : Appel indirect  printCHAR_1
                                        ; IN  : A=char to print
                                        ; OUT : A modified
            bra bcl1OUTTX
; End of function OS_OUTTX


; =============== S U B R O U T I N E =======================================

OS_printESPACE:
            ldaa #cOS_SPACE             ; ' '
            SKIP2
; End of function OS_printESPACE

; =============== S U B R O U T I N E =======================================

OS_printPtInterrogation:
            ldaa #$3F                   ; '?'
; End of function OS_printPtInterrogation


; =============== S U B R O U T I N E =======================================

; FCT : Imprime un caractre sur le dispositif selectionn par DEVNU : Appel indirect  printCHAR_1
; IN  : A=char to print
; OUT : A modified

j_printCHAR_1:
            jmp printCHAR_1             ; FCT : Imprime un caractre sur le dispositif selectionn par DEVNU
                                        ; IN  : A=char to print
                                        ; OUT : A modified
; End of function j_printCHAR_1

; ---------------------------------------------------------------------------
aptinterrogationREDO:dc.b   "?REDO",$D,0

; =============== S U B R O U T I N E =======================================

; FCT : Gestion erreur de la partie READ
; IN  : INPUTFLG
; OUT : /

setErrINPUT_READ:
            ldaa INPUTFLG                   ; =$00:INPUT,=$4F:READ
            beq printMsgError_REDO
            ldx DATTXT                      ; DATA STATEMENT LINE NUMBER POINTER
            stx CURLIN
            jmp setError0x02_SYNTAXERROR

printMsgError_REDO:
            ldx #(aptinterrogationREDO-1)   ; "?REDO\r"
            jsr OS_OUTTX                    ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                            ; IN : X=pointeur sur une chane de caractres termine par un 0
                                            ; OUT: A,B,X modified
            ldx TMPTXT
            stx TXTPTR

endSetErrINPUT_READ:
            rts
; End of function setErrINPUT_READ


; =============== S U B R O U T I N E =======================================

; FCT : CMD BASIC INPUT : permet  l'utilisateur de saisir des donnes
; STX : 100 INPUT A$
;       110 INPUT B
; OP  : $88
; ST  : ACTIF
; IN  : le flot  interprter
; OUT : /

romINPUT:
            ldab #cBAS_ERR_ILLDIR       ; set message to $16 : instruction interdite en mode direct
            ldx CURLIN
            inx
            bne isStr_RomInput
            jmp ERROR

isStr_RomInput:
            cmpa #cBAS_SEP_STR          ; '"'
            bne next1RomINPUT
            jsr next2EVAL

waitPtVirg_ROMINPUT:
            ldab #cBAS_SEP_VAR          ; ';'
            jsr SYNCHR                  ; FCT : UNLESS CHAR AT TXTPTR=(B), SYNTAX ERROR
                                        ; IN  : B=Opcode ou caractre  comparer
                                        ; OUT : X : not modified
                                        ;       A : le caractre suivant l'opcode ou caractre  comparer 
                                        ;           si la comparaison de l'opcode est OK
            jsr nextOUTTX

next1RomINPUT:
            bsr OUTQUES                 ; FCT : Affiche un point d'interrogation et attend une saise utilisateur
                                        ; ST  : ACTIF
                                        ; IN  : /
                                        ; OUT : X=pointeur sur la tampon clavier -1 contenant la saisie utilisateur
            ldab #cBAS_SEP_ARG          ; ','
            stab $00,x
            bra nextRomRead
; End of function romINPUT


; =============== S U B R O U T I N E =======================================

; FCT : Affiche un point d'interrogation et attend une saise utilisateur
; ST  : ACTIF
; IN  : /
; OUT : X=pointeur sur la tampon clavier -1 contenant la saisie utilisateur

OUTQUES:
            jsr OS_printPtInterrogation
            jsr OS_printESPACE
            jsr INKBD                   ; FCT : Attend une saisie utilisateur
                                        ;       gre les touches spcifiques
                                        ;       BREAK  : sort du programme !
                                        ;       CTRL+A : effacement de la saisie en cours
                                        ;       CTRL+Q : effacement d'un caractre
                                        ;       RETURN : fin de la saisie utilisateur
                                        ; IN  : /
                                        ; OUT : X=pointeur sur la tampon clavier -1 contenant la saisie utilisateur
                                        ;       C=0 : saisie utilisateur
                                        ;       C=1 : saisie d'une touche de contrle
            bcc endSetErrINPUT_READ
            pulx
            jmp nextRomEND
; End of function OUTQUES


; =============== S U B R O U T I N E =======================================

; FCT : CMD BASIC READ : lit l'entre pour l'affecter au(x) variable() qui sui(ven)t READ
; STX : READ A[,B[...]]
; OP  : $8C
; ST  : ACTIF
; IN  : le flot  interprter
; OUT : A,B,X modified

romREAD:
            ldx DATPTR                  ; DATA STATEMENT ADDRESS POINTER
            SKIP_BYTE                   ; dc.b $86 : Si le point d'entre est romRead alors A=$4F

nextRomRead:
            clra
            staa INPUTFLG               ; =$00:INPUT,=$4F:READ
            stx INPTR

bcl1RomREAD:
            jsr PTRGET                  ; FCT : Lit un nom de variable  l'aide de CHRGOT
                                        ;       et le trouve en mmoire
                                        ; IN  : TXTPTR pointe sur le premier caractre du nom
                                        ; OUT : X=VARPNT=ADRESSE DE LA VARIABLE
                                        ;       (si non trouv alors cration d'une variable simple ou d'un
                                        ;       tableau de dim(10) initialis  0)
            stx FORPNT
            ldx TXTPTR
            stx LINUM
            ldx INPTR
            ldaa 0,x
            bne bcl2RomREAD
            ldaa INPUTFLG               ; =$00:INPUT,=$4F:READ
            bne bcl7RomREAD
            jsr OS_printPtInterrogation ; Y-a-t-il un bug ? Car le point d'interrogation est imprim deux fois !
            bsr OUTQUES                 ; FCT : Affiche un point d'interrogation et attend une saise utilisateur
                                        ; ST  : ACTIF
                                        ; IN  : /
                                        ; OUT : X=pointeur sur la tampon clavier -1 contenant la saisie utilisateur

bcl2RomREAD:
            stx TXTPTR
            jsr.w   CHRGET              ; OJE 14/02/2020 V3
                                        ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                        ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                        ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                        ; NOT C= NUMERIC ("0" THRU "9")
                                        ; Z= ":" OR END-OF-LINE (A NULL)
                                        ; [ACCA] = NEW CHAR.
                                        ; [TXTPTR]=[TXTPTR]+1
            ldab VALTYP                 ; Type de valeur en cours de traitement : $00 : num, $FF = str
            beq next4RomREAD
            ldx TXTPTR
            staa CHARAC                 ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            cmpa #cBAS_SEP_STR          ; '"'
            beq next3RomREAD
            dex
            ldaa #cBAS_SEP              ; ':'
            staa CHARAC                 ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            ldaa #cBAS_SEP_ARG          ; ','

next3RomREAD:
            staa ENDCHR                 ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            jsr STRLT2                  ; FCT : BUILD A DESCRIPTOR FOR STRING STARTING AT Y,A
                                        ;       AND TERMINATED BY $00, (CHARAC), OR (ENDCHR)
                                        ;       RETURN WITH DESCRIPTOR IN A TEMPORARY
                                        ;       AND ADDRESS OF DESCRIPTOR IN ACC1+3,4
            jsr POINT_next1RomVal       ; COPY STRNG2 INTO TXTPTR
            jsr nextRomLET_STRING
            bra next5RomREAD

next4RomREAD:
            jsr FIN                     ; FCT : Float IN : parse a number
                                        ;       NUMBER INPUT IS LEFT IN FAC.
                                        ;       AT ENTRY [TXTPTR] POINTS TO THE FIRST CHARACTER IN A TEXT BUFFER.
                                        ;       THE FIRST CHARACTER IS ALSO IN ACCA. FIN PACKS THE DIGITS
                                        ;       INTO THE FAC AS AN INTEGER AND KEEPS TRACK OF WHERE THE
                                        ;       DECIMAL POINT IS. [DPTFLG] TELL WHETHER A DP HAS BEEN
                                        ;       SEEN. [DECCNT] IS THE NUMBER OF DIGITS AFTER THE DP.
                                        ;       AT THE END [DECCNT] AND THE EXPONENT ARE USED TO
                                        ;       DETERMINE HOW MANY TIMES TO MULTIPLY OR DIVIDE BY TEN
                                        ;       TO GET THE CORRECT NUMBER.
                                        ; IN  : C=1 : The first character is numeric
                                        ;       C=0 : The first character is not numeric
                                        ; OUT : ACC1
            jsr saveACC1toFORPNT

next5RomREAD:
            jsr.w   CHRGOT              ; OJE 13/02/2020 - V2
            beq next6RomREAD
            cmpa #cBAS_SEP_ARG          ; ','
            beq next6RomREAD
            jmp setErrINPUT_READ        ; FCT : Gestion erreur de la partie READ
                                        ; IN  : INPUTFLG
                                        ; OUT : /

next6RomREAD:
            ldx TXTPTR
            stx INPTR
            ldx LINUM
            stx TXTPTR
            jsr.w   CHRGOT              ; OJE 13/02/2020 - V2
            beq next9RomREAD            ; NO MORE INPUT REQUESTED
            jsr CHKCOM
            bra bcl1RomREAD

bcl7RomREAD:
            stx TXTPTR
            jsr DATAN                   ; FCT : skip to end of statement ":" or null
                                        ; IN  : TXTPTR is set
                                        ; OUT : X=pointer on end of statement ":" or null
            inx
            tsta
            bne next8RomREAD
            ldab #cBAS_ERR_NODATA       ; set ERROR at OD : Overflow DATA
            ldaa 0,x
            oraa 1,x
            beq braPrintErrorMsg
            ldd 2,x                     ; get BASIC LINE NUMBER AND
            std DATTXT                  ; save it in DATTXT
            ldab #$04
            abx

next8RomREAD:
            ldaa 0,x

isOpcodeDATA:
            cmpa #cBAS_TOKEN_DATA       ; $85
            bne bcl7RomREAD
            bra bcl2RomREAD

next9RomREAD:
            ldx INPTR                   ; NO MORE INPUT REQUESTED
            ldab INPUTFLG               ; =$00:INPUT,=$4F:READ
            beq next10RomREAD
            jmp endRomRESTORE

next10RomREAD:
            ldaa 0,x
            beq endINPDONE
            ldx #(aptintextraIgnored-1) ; "?EXTRA IGNORED\r"
            jmp OS_OUTTX                ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                        ; IN : X=pointeur sur une chane de caractres termine par un 0
                                        ; OUT: A,B,X modified
; End of function romREAD

endINPDONE:

            rts

aptintextraIgnored: dc.b "?EXTRA IGNORED",$D,0

; =============== S U B R O U T I N E =======================================

; FCT : CMD BASIC NEXT : Le retour pour le FOR associ
; STX : 100 FOR I=1 TO 10:PRINT I: NEXT I
; OP  : $8A
; ST  : ACTIF
; IN  : le flot d'interprtation
; OUT : /

romNEXT:
            bne nextRomNext
            ldx #$0000
            bra next2RomNext

nextRomNext:
            jsr PTRGET                  ; FCT : Lit un nom de variable  l'aide de CHRGOT
                                        ;       et le trouve en mmoire
                                        ; IN  : TXTPTR pointe sur le premier caractre du nom
                                        ; OUT : X=VARPNT=ADRESSE DE LA VARIABLE
                                        ;       (si non trouv alors cration d'une variable simple ou d'un
                                        ;       tableau de dim(10) initialis  0)

next2RomNext:
            stx FORPNT
            jsr FNDFOR                  ; FCT : RECHERCHE DANS LA PILE SI LE TOKEN FOR EXISTE
                                        ; IN  : /
                                        ; OUT : A=0 : Token FOR trouv
                                        ;       A=2 : Token GOSUB trouv
            beq next3RomNext

setErrorTo0x00_NextWithoutFor:
            ldab #cBAS_ERR_NOFOR

braPrintErrorMsg:
            bra printErrorMsg

next3RomNext:
            txs
            inx
            inx
            inx
            jsr MOVFM                   ; FCT : MOVE memory to ACC1
                                        ; IN  : X=FLOAT (5 bytes)
                                        ; OUT : A and X unmodified
            tsx
            ldaa 8,x
            staa ACC1+5
            ldx FORPNT
            jsr FADD                    ; FCT : Add constant to ACC1
                                        ; STX : /
                                        ; ALG : /
                                        ; ST  : ACTIF
                                        ; IN  : X=pointer on constant
                                        ; OUT : ACC1=ACC1 + constant given by X
            jsr saveACC1toFORPNT
            tsx
            ldab #$09                   ; POINT (X) TO TERMINAL VALUE OF INDEX
            abx
            jsr FCOMP2                  ; FCT : COMPARE A PACKED FLOATING POINT NUMBER POINTED TO BY (X) 
                                        ;       TO AN UNPACKED FP NUMBER IN ACC1. 
                                        ; IN  : X=Adresse d'un float
                                        ; OUT : ZERO FLAG SET AND B = 0, IF EQUAL
                                        ;       ACCB = 1   IF ACC1 > (X)
                                        ;       ACCB = $FF IF ACC1 < (X)
            tsx
            subb 8,x
            beq next4RomNext
            ldx $0E,x                   ; GET LINE NUMBER
            stx CURLIN
            tsx
            ldx $10,x
            stx TXTPTR

jmpNewSTT_romNEXT:
            jmp NEWSTT                  ; FCT : perform next statement
                                        ; IN  : le flot d'interprtation
                                        ; OUT : /

next4RomNext:
            ldab #cBAS_BYTES_PER_FOR    ; $12 : un FOR est dcrit par 18 octets dans la pile
            abx
            txs
            jsr.w   CHRGOT              ; OJE 13/02/2020 - V2
            cmpa #cBAS_SEP_ARG          ; ','
            bne jmpNewSTT_romNEXT
            jsr.w   CHRGET              ; OJE 14/02/2020 V3
                                        ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                        ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                        ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                        ; NOT C= NUMERIC ("0" THRU "9")
                                        ; Z= ":" OR END-OF-LINE (A NULL)
                                        ; [ACCA] = NEW CHAR.
                                        ; [TXTPTR]=[TXTPTR]+1
            bsr nextRomNext
; End of function romNEXT


; =============== S U B R O U T I N E =======================================

; FCT : EVALUATE EXPRESSION, MAKE SURE IT IS NUMERIC
; IN  : le flot d'interprtation
; OUT : /

FRMNUM:
            bsr FRMEVL                  ; FCT : effectue l'valuation du flux d'entre
                                        ; IN  : le flux d'entre
                                        ; OUT : ACC1=result of expression (pointeur if string or value if numeric)
; End of function FRMNUM

; =============== S U B R O U T I N E =======================================

CHKNUM:     dc.b $6D

; =============== S U B R O U T I N E =======================================

CHKSTR:
            sec
; End of function CHKSTR


; =============== S U B R O U T I N E =======================================

; FCT : Le rsultat de l'interprtation est-il une chane de caractres ?
; ERR : Type incompatible
; IN  : VALTYP  jour
; OUT : /

CHKVAL:
            ror VALTYP              ; Type de valeur en cours de traitement : $00 : num, $FF = str
            bvc endINPDONE

serErrorTo$18_TypeIncompatibe:
            ldab #cBAS_ERR_BADTYPE

printErrorMsg:
            jmp ERROR
; End of function CHKVAL

; =============== S U B R O U T I N E =======================================

; FCT : EVALUATE THE EXPRESSION AT TXTPTR, LEAVING THE RESULT IN ACC1.
;       WORKS FOR BOTH STRING AND NUMERIC EXPRESSIONS.
; IN  : TXTPR : pointe sur l'expression  valuer
; OUT : /

FRMEVL:
            ldx TXTPTR
            dex
            stx TXTPTR
            clra
            dc.b $C6                ; $C6 = SIMULE B=$37

; =============== S U B R O U T I N E =======================================

; FCT : EVALUATE THE EXPRESSION AT TXTPTR, LEAVING THE RESULT IN ACC1
; IN  : A=precedence of previous operator
;       B=precedence of current operator
; OUT : /

LPOPER_FRMEVL:
            pshb                    ; save low precedence
            psha                    ; save high precedence
            ldab #$01
            jsr CHKMEM              ; FCT : vrifie s'il y a 2*B + $3A octets libres
                                    ; IN  : B=Nombre d'octets / 2 ncessaires
                                    ; OUT : D=pointeur aprs ajout de 2*B + $3A octets
            jsr EVAL                ; FCT : GET ELEMENT IN EXPRESSION
                                    ;       GET VALUE OF VARIABLE OR NUMBER AT TXTPNT, OR POINT
                                    ;       TO STRING DESCRIPTOR IF A STRING, AND PUT IN FAC.
                                    ; IN  : le flot d'interprtation
                                    ; OUT : ACC1=resultat
            clr OPMASK

TSTOP_FRMEVL:
            jsr.w   CHRGOT          ; OJE 13/02/2020 - V2 ; get again last character

LOPREL_FRMEVL:
            suba #(cBAS_TOKEN_sup)  ; $AE ; is current character a relation ?
            bcs ENDREL_FRMEVL
            cmpa #cBAS_NB_OP        ; $03 ; Le nombre d'oprateur de comparaison est 3 (<,=,>)
            bcc ENDREL_FRMEVL
            cmpa #$01
            rola
            eora OPMASK
            cmpa OPMASK
            bcs jmpPrintErrorMSg0x02_SyntaxErr_01
            staa OPMASK
            jsr.w   CHRGET          ; OJE 14/02/2020 V3
                                    ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                    ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                    ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                    ; NOT C= NUMERIC ("0" THRU "9")
                                    ; Z= ":" OR END-OF-LINE (A NULL)
                                    ; [ACCA] = NEW CHAR.
                                    ; [TXTPTR]=[TXTPTR]+1
            bra LOPREL_FRMEVL

ENDREL_FRMEVL:
            ldab OPMASK
            bne FINREL_FRMEVL
            bcc QOP
            adda #$07               ; TODO : cBAS_LEN_VAR_FLOAT ?
            bcc QOP
            adca VALTYP             ; Ajoute 1 car C=1
            bne OP_FRMEVL
            jmp CAT                 ; only IF A=0 AND VALTYP=-1(A string)

OP_FRMEVL:
            adca #$FF               ; get back original
            tab
            asla                    ; opcode=opcode*2
            aba                     ; opcode=opcode*3
            tab                     ; B=A*3 : index dans le tableau de saut des op
            ldx #aOperator
            abx

QPREC_FRMEVL:
            pula                    ; get previous precedence
            cmpa $00,x              ; is OLD PRECEDENCE GREATER OR EQUAL ?
            bcc QCHNUM
            bsr CHKNUM

                                    ; OPERATION BEING PROCESSED IS OF HIGHER PRECEDENCE THAN THE PREVIOUS OPERATION.
DOPREC_FRMEVL:
            psha                    ; save old PRECEDENCE
            bsr DOPRE1_FRMEVL       ; FCT : PUSH OPERATOR ROUTINE ADDRESS AND FPA0 ONTO STACK
                                    ; IN  : X=ADDRESS OF OPERATOR ROUTINE
                                    ; OUT : B=value of OPMASK
            ldx LASTOP
            pula
            bne QPREC1_FRMEVL
            tsta
            beq QOPRTS
            bra PULSTK

FINREL_FRMEVL:
            asl VALTYP              ; Type de valeur en cours de traitement : $00 : num, $FF = str
            rolb
            ldx TXTPTR
            dex
            stx TXTPTR
            ldx #MATHTBL
            stab OPMASK
            bra QPREC_FRMEVL

; --------------------------------------------------
MATHTBL:                            ; TODO : Dplacer le tableau aprs QPREC1_FRMEVL
            dc.b $64
            dc.w RELOPS             ; FCT : PERFORM RELATIONAL OPERATIONS
                                    ; ST  : ACTIF
                                    ; IN  : le flot d'interprtation
                                    ; OUT : A,B,X modified
; --------------------------------------------------

QPREC1_FRMEVL:
            cmpa $00,x
            bcc PULSTK
            bra DOPREC_FRMEVL
; End of function LPOPER_FRMEVL


; =============== S U B R O U T I N E =======================================

; FCT : PUSH OPERATOR ROUTINE ADDRESS AND FPA0 ONTO STACK
; IN  : X=ADDRESS OF OPERATOR ROUTINE
; OUT : B=value of OPMASK

DOPRE1_FRMEVL:
            ldd 1,x
            pshb
            psha
            bsr PUSHF1                  ; FCT : Sauvegarde ACC1 dans la pile
                                        ;       Puis excute l'oprateur indiqu par X
                                        ; IN  : X=adresse vers un tableau contenant precdence + saut
                                        ;       PILE=adresse vers un tableau contenant precdence + saut
                                        ;       suivant les points d'entres on utilise ou pas
                                        ; OUT : A=precdence de l'oprateur mathmatique courant
                                        ;       B modified
                                        ;       PILE : ACC1 sauvegard en pile
            ldab OPMASK
            bra LPOPER_FRMEVL           ; FCT : EVALUATE THE EXPRESSION AT TXTPTR, LEAVING THE RESULT IN ACC1
                                        ; IN  : A=precedence of previous operator
                                        ;       B=precedence of current operator
                                        ; OUT : /

; End of function DOPRE1_FRMEVL

; --------------------------------------------------
jmpPrintErrorMSg0x02_SyntaxErr_01:
            jmp setError0x02_SYNTAXERROR ; TODO Dplacer ce jmp
; --------------------------------------------------

; =============== S U B R O U T I N E =======================================

; FCT : Sauvegarde ACC1 dans la pile
;       Puis excute l'oprateur indiqu par X
; IN  : X=adresse vers un tableau contenant precdence + saut
;       PILE=adresse vers un tableau contenant precdence + saut
;       suivant les points d'entres on utilise ou pas
; OUT : A=precdence de l'oprateur mathmatique courant
;       B modified
;       PILE : ACC1 sauvegard en pile

PUSHF1:
            ldab ACC1+5             ; get ACC1 sign
            ldaa 0,x                ; get precedence of current operator
FRM_STACK2:
            pulx
            pshb                    ; push sign of ACC1
FRM_STACK3:
            ldab ACC1+4             ; sauvegarde ACC1 dans la pile et se dbranche sur une routine pointe par X
            pshb
            ldab ACC1+3
            pshb
            ldab ACC1+2
            pshb
            ldab ACC1+1
            pshb
            ldab ACC1
            pshb
            jmp 0,x
; End of function PUSHF1

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR LPOPER_FRMEVL

QOP:
            ldx #$0000
            pula
            tsta
            beq QOPRTS
QCHNUM:
            cmpa #$64 ; 'd'
            beq UNPSTK
            jsr CHKNUM
UNPSTK:
            stx LASTOP
PULSTK:
            pulb
            cmpa #$5A ; 'Z'
            beq UNPRTS
            cmpa #$7D ; '}'
            beq UNPRTS
            lsrb
            stab CPRMASK                ; Masque de comparaison
            pula
            pulb
            std ACC2
            pulx
            stx ACC2+2
            pulb
            stab ACC2+4
            pulb
            stab ACC2+5
            eorb ACC1+5
            stab PRODSIGN
QOPRTS:
            ldab ACC1
UNPRTS:
            rts
; END OF FUNCTION CHUNK FOR LPOPER_FRMEVL

; =============== S U B R O U T I N E =======================================

; FCT : GET ELEMENT IN EXPRESSION
;       GET VALUE OF VARIABLE OR NUMBER AT TXTPNT, OR POINT
;       TO STRING DESCRIPTOR IF A STRING, AND PUT IN ACC1.
; IN  : le flot d'interprtation
; OUT : ACC1=resultat

EVAL:
            jsr vHOOK6_EVAL
            clr VALTYP                      ; assume value will be numeric
            bsr j_CHRGET                    ; pourquoi pas un appel direct ?
            bcc isVariable_EVAL

ASS_isNUMber_EVAL:
            jmp FIN                         ; FCT : Float IN : parse a number
                                            ;       NUMBER INPUT IS LEFT IN FAC.
                                            ;       AT ENTRY [TXTPTR] POINTS TO THE FIRST CHARACTER IN A TEXT BUFFER.
                                            ;       THE FIRST CHARACTER IS ALSO IN ACCA. FIN PACKS THE DIGITS
                                            ;       INTO THE FAC AS AN INTEGER AND KEEPS TRACK OF WHERE THE
                                            ;       DECIMAL POINT IS. [DPTFLG] TELL WHETHER A DP HAS BEEN
                                            ;       SEEN. [DECCNT] IS THE NUMBER OF DIGITS AFTER THE DP.
                                            ;       AT THE END [DECCNT] AND THE EXPONENT ARE USED TO
                                            ;       DETERMINE HOW MANY TIMES TO MULTIPLY OR DIVIDE BY TEN
                                            ;       TO GET THE CORRECT NUMBER.
                                            ; IN  : C=1 : The first character is numeric
                                            ;       C=0 : The first character is not numeric
                                            ; OUT : ACC1

isVariable_EVAL:
            jsr ISLETC                      ; FCT : teste si A est une lettre ASCII
                                            ; IN  : A
                                            ; OUT : C=0 si lettre sinon 1
                                            ;       A modified
            bcc FRM_VARIABLE
            cmpa #cMATH_SEP_FLT             ; '.'
            beq ASS_isNUMber_EVAL

isOpMinus:
            cmpa #cBAS_TOKEN_MINUS          ; $A8  ; compare token MINUS
            beq DOMIN_EVAL

isOpPlus:
            cmpa #cBAS_TOKEN_PLUS           ; $A7 ; compare token PLUS
            beq EVAL                        ; FCT : GET ELEMENT IN EXPRESSION
                                            ;       GET VALUE OF VARIABLE OR NUMBER AT TXTPNT, OR POINT
                                            ;       TO STRING DESCRIPTOR IF A STRING, AND PUT IN FAC.
                                            ; IN  : le flot d'interprtation
                                            ; OUT : ACC1=resultat
isQuote_EVAL:
            cmpa #cBAS_SEP_STR              ; '"'
            bne isOpNot_EVAL

next2EVAL:
            ldx TXTPTR
            jsr STRLIT                      ; FCT : BUILD A DESCRIPTOR FOR STRING STARTING AT X
                                            ;       AND TERMINATED BY $00 OR QUOTATION MARK
                                            ;       RETURN WITH DESCRIPTOR IN A TEMPORARY
                                            ;       AND ADDRESS OF DESCRIPTOR IN ACC1+3,4
                                            ; ST  : ACTIF
                                            ; IN  : X=string to create an descriptor
                                            ; OUT : A,B,X modified
            jmp POINT_next1RomVal           ; COPY STRNG2 INTO TXTPTR

isOpNot_EVAL:
            cmpa #cBAS_TOKEN_NOT            ; $A4  ; check for "NOT" operator
            bne isOp
; Peut-on faire plus efficace pour faire le not sur un float ?

setPrecedenceNot_EVAL:
            ldaa #$5A ; 'Z'
            jsr LPOPER_FRMEVL               ; FCT : EVALUATE THE EXPRESSION AT TXTPTR, LEAVING THE RESULT IN ACC1
                                            ; IN  : A=precedence of previous operator
                                            ;       B=precedence of current operator
                                            ; OUT : /
            jsr convACC1toWord              ; FCT : conversion d'un float (ACC1) en un mot
                                            ;       D=INT(ACC1)
                                            ; ERR : Fonction incorrect
                                            ; IN  : ACC1 set
                                            ; OUT : D=rsultat de la conversion float->WORD
            coma                            ; nous effectuons le not ...
            comb
            jmp convWordToACC1              ; FCT : Convert Word to Float
                                            ; IN  : D=number to convert
                                            ; OUT : ACC1=float(D)

isOp:
            suba #cBAS_OFS_FCT              ; $B1
            bcc UNARY_EVAL                  ; A=Opcode-$B1
; End of function EVAL


; =============== S U B R O U T I N E =======================================

; FCT : evaluate expression du type (expression)
; IN  : le flot d'interprtation
; OUT : ACC1=resultat de l'valuation

PARCHK:
            bsr CHKOPN
            jsr FRMEVL                      ; FCT : effectue l'valuation du flux d'entre
                                            ; IN  : le flot d'interprtation
                                            ; OUT : ACC1=result of expression (pointeur if string or value if numeric)
; End of function PARCHK

; =============== S U B R O U T I N E =======================================

; FCT : check close parenthesis and get next char
; IN  : TXTPTR mise  jour
; OUT : X modified, A et B modified

CHKCLS:
            ldab #cBAS_FCT_CLOSE ; ')'
            SKIP2
; End of function CHKCLS

; =============== S U B R O U T I N E =======================================

; FCT : check open parenthesis and get next char
; IN  : TXTPTR mise  jour
; OUT : X modified, A et B modified

CHKOPN:
            ldab #cBAS_FCT_OPEN ; '('
            SKIP2
; End of function CHKOPN

; =============== S U B R O U T I N E =======================================
; FCT : check comma and get next char
; IN  : TXTPTR mise  jour
; OUT : X modified, A et B modified

CHKCOM:
            ldab #cBAS_SEP_ARG    ; ','
; End of function CHKCOM


; =============== S U B R O U T I N E =======================================

; FCT : UNLESS CHAR AT TXTPTR=(B), SYNTAX ERROR
; IN  : B=Opcode ou caractre  comparer
; OUT : X : not modified
;       A : le caractre suivant l'opcode ou caractre  comparer 
;           si la comparaison de l'opcode est OK 

SYNCHR:
            pshx
            ldx TXTPTR
            cmpb 0,x
            pulx
            bne setError0x02_SYNTAXERROR
; End of function SYNCHR


; =============== S U B R O U T I N E =======================================

j_CHRGET:
            jmp CHRGET          ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                ; NOT C= NUMERIC ("0" THRU "9")
                                ; Z= ":" OR END-OF-LINE (A NULL)
                                ; [ACCA] = NEW CHAR.
                                ; [TXTPTR]=[TXTPTR]+1
; End of function j_CHRGET
; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR CHKMEM

setError0x02_SYNTAXERROR:
            ldab #cBAS_ERR_SYNTAX
            jmp ERROR
; END OF FUNCTION CHUNK FOR CHKMEM

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR EVAL

DOMIN_EVAL:
            ldaa #$7D ; '}'                                 ; set precedence of Minus operator
            jsr LPOPER_FRMEVL                               ; FCT : EVALUATE THE EXPRESSION AT TXTPTR, LEAVING THE RESULT IN ACC1
                                                            ; IN  : A=precedence of previous operator
                                                            ;       B=precedence of current operator
                                                            ; OUT : /
            jmp ROM_NEG                                     ; FCT : routine NEG(X) : retourne l'oppos de ACC1
                                                            ; STX : /
                                                            ; OP  : /
                                                            ; ST  : ACTIF
                                                            ; IN  : /
                                                            ; OUT : ACC1=NEG(ACC1)

FRM_VARIABLE:
            jsr PTRGET                                      ; FCT : Lit un nom de variable  l'aide de CHRGOT
                                                            ;       et le trouve en mmoire
                                                            ; IN  : TXTPTR pointe sur le premier caractre du nom
                                                            ; OUT : X=VARPNT=ADRESSE DE LA VARIABLE
                                                            ;       (si non trouv alors cration d'une variable simple ou d'un
                                                            ;       tableau de dim(10) initialis  0)

CALL_FRM_VARIABLE:
            stx ACC1+3
            ldaa VALTYP                                     ; Type de valeur en cours de traitement : $00 : num, $FF = str
            bne UNPRTS
            jmp MOVFM                                       ; FCT : MOVE memory to ACC1
                                                            ; IN  : X=FLOAT (5 bytes)
                                                            ; OUT : A and X unmodified

UNARY_EVAL:
            tab                                             ; a is opcode d'une fonction (SGN, ...) - $B1
            aslb                                            ; $B1-$D? -> 0x00 - 0x22
            bsr j_CHRGET
            pshb                                            ; sauvegarde de (opcode - $B1)*2

isInfOpcodeLEFTdollar:
            cmpb #(cBAS_TOKEN_LEFTdollar-cBAS_OFS_FCT)*2    ; $22 '"'
            bcs eval_simple_fct

isOpcodeINKEYdollar:
            cmpb #(cBAS_TOKEN_INKEYdollar-cBAS_OFS_FCT)*2   ; $2C ; ','
            bcc eval_no_param_fct                           ; exemple (le seul) de fonction sans param : MEM

eval_double_fct:                                            ; permet de trairer les fonctions  deux paramtres
            bsr CHKOPN
            pulb
            cmpb #$28 ; '('
            bcc getjmpFONCTION
            pshb
            jsr FRMEVL                                      ; FCT : effectue l'valuation du flux d'entre
                                                            ; IN  : le flot d'interprtation
                                                            ; OUT : ACC1=result of expression (pointeur if string or value if numeric)
            bsr CHKCOM
            jsr CHKSTR
            pula
            ldx ACC1+3
            pshx
            psha
            jsr GETBYT                                      ; FCT : EVALUATE EXPRESSION AT TXTPTR, AND
                                                            ;       CONVERT IT TO SINGLE BYTE IN B-REG
                                                            ; ERR : FC : fonction incorrecte
                                                            ; IN  : le flot d'interprtation
                                                            ; OUT : B=la partie haute de la conversion (ACC1+3,ACC1+4)
            pula
            pshb
            tab
            bra getjmpFONCTION

eval_simple_fct:
            bsr PARCHK                                      ; FCT : evaluate expression du type (expression)
                                                            ; IN  : le flot d'interprtation
                                                            ; OUT : ACC1=resultat de l'valuation

eval_no_param_fct:
            pulb

getjmpFONCTION:
            ldx #jmpFONCTION
            abx
            ldx 0,x
            jsr 0,x
            jmp CHKNUM
; END OF FUNCTION CHUNK FOR EVAL
; ---------------------------------------------------------------------------

; =============== S U B R O U T I N E =======================================

; FCT : do OR ACC1 with ACC2
; STX : IF A OR B THEN PRINT "A OR B"
; ALG : /
; OP  : $AD
; ST  : ACTIF
; IN  : ACC1 and ACC2 set
; OUT : ACC1=ACC1 AND ACC2
doOP_OR:    SKIP_BYTE                   ; dc.b $86 : quivalent au code "Charge $4F dans A" !

; =============== S U B R O U T I N E =======================================

; FCT : do "AND" ACC1 with ACC2
; STX : IF A AND B THEN PRINT "A AND B"
; ALG : /
; OP  ! $AC
; ST  : ACTIF
; IN  : ACC1 and ACC2 set
; OUT : ACC1=ACC1 AND ACC2
;

doOP_AND:
            clra
            staa EOLPNTR                ; cela sert  beaucoup de choses : op. binaires, etc.
; End of function doOP_AND


; =============== S U B R O U T I N E =======================================

; FCT : permet d'effectuer soit le AND soit le OR entre ACC1 et ACC2
; ST  : ACTIF
; IN  : A=0 : AND sinon OR
; OUT : ACC1=ACC1 (and/or) ACC2

doOpBinary:
            jsr convACC1toWord          ; FCT : conversion d'un float (ACC1) en un mot
                                        ;       D=INT(ACC1)
                                        ; ERR : Fonction incorrect
                                        ; IN  : ACC1 set
                                        ; OUT : D=rsultat de la conversion float->WORD
            std CHARAC                  ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            jsr MOVA2A1ext              ; FCT : Recopie ACC2 tendu dans ACC1
                                        ; ST  : ACTIF
                                        ; IN  : ACC2 set
                                        ; OUT : ACC1=ACC2
            jsr convACC1toWord          ; FCT : conversion d'un float (ACC1) en un mot
                                        ;       D=INT(ACC1)
                                        ; ERR : Fonction incorrect
                                        ; IN  : ACC1 set
                                        ; OUT : D=rsultat de la conversion float->WORD
            tst EOLPNTR                 ; cela sert  beaucoup de choses : op. binaires, etc.
            bne nextDoOpBinary
            anda CHARAC                 ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            andb ENDCHR                 ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            bra endDoOpBinary

nextDoOpBinary:
            oraa    CHARAC              ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            orab    ENDCHR              ; sert  tout : stockage d'un caractre, de valeur pour opration binaire

endDoOpBinary:
            jmp convWordToACC1          ; FCT : Convert Word to Float
                                        ; IN  : D=number to convert
                                        ; OUT : ACC1=float(D)
; End of function doOpBinary

; =============== S U B R O U T I N E =======================================

; FCT : PERFORM RELATIONAL OPERATIONS
; ST  : ACTIF
; IN  : le flot d'interprtation
; OUT : A,B,X modified

RELOPS:
            jsr CHKVAL                  ; FCT : Le rsultat de l'interprtation est-il une chane de caractres ?
                                        ; ERR : Type incompatible
                                        ; IN  : VALTYP  jour
                                        ; OUT : /
            bne STRCOMP
            ldaa ACC2+5
            oraa #$7F
            anda ACC2+1
            staa ACC2+1
            ldx #ACC2
            jsr FCOMP2                  ; FCT : COMPARE A PACKED FLOATING POINT NUMBER POINTED TO BY (X) 
                                        ;       TO AN UNPACKED FP NUMBER IN ACC1. 
                                        ; IN  : X=Adresse d'un float
                                        ; OUT : ZERO FLAG SET AND B = 0, IF EQUAL
                                        ;       ACCB = 1   IF ACC1 > (X)
                                        ;       ACCB = $FF IF ACC1 < (X)
            bra NUMCMP

STRCOMP:
            clr VALTYP                  ; Type de valeur en cours de traitement : $00 : num, $FF = str
            dec OPMASK
            jsr FREFAC                  ; FCT : Libre la zone rserve par descripteur (chane de caractres)
                                        ; IN  : ACC1+3 et ACC1+4 : contient le descripteur
                                        ; OUT : X=pointer
            stab ACC3
            stx ACC3+2
            ldx ACC2+3
            jsr FRETMP                  ; FCT : IF STRING DESCRIPTOR WHOSE ADDRESS IS IN X IS
                                        ;       A TEMPORARY STRING, RELEASE IT.
                                        ; IN  : X=Address of string descriptor
                                        ; OUT : X=pointer
                                        ;       B=longueur de la chane de caractres rserve
            ldaa ACC3
            sba
            beq nextSTRCMP
            ldaa #$01
            bcc nextSTRCMP
            ldab ACC3
            nega

nextSTRCMP:
            staa ACC1+5
            tpa
            psha
            sts SAVREGS
            sei
            txs
            ldx ACC3+2
            incb
            dex

bcl1tSTRCMP:
            decb
            bne next2STRCMP
            ldab ACC1+5
            bra next3STRCMP

next2STRCMP:
            pula
            inx
            cmpa $00,x
            beq bcl1tSTRCMP
            ldab #$FF
            bcc next3STRCMP
            negb

next3STRCMP:
            lds SAVREGS
            pula
            tap

NUMCMP:
            addb #$01
            rolb
            andb CPRMASK                ; Masque de comparaison
            beq jmpFLOAT
            ldab #$FF

jmpFLOAT:
            jmp FLOAT                   ; CONVERT (B) INTO ACC1, AS SIGNED VALUE -128 TO +127
; End of function RELOPS

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR romDIM

NXDIM:
            jsr CHKCOM
; END OF FUNCTION CHUNK FOR romDIM

; =============== S U B R O U T I N E =======================================

; FCT : CREATION D'UN TABLEAU MULTIDIMENSION DE FLOAT OU DE CHAINE DE CARACTERES
;       Codage d'un tableau en mmoire
;         + WORD   : nom de la variable sur 2 caractres  maxi. Le dernier octet du nom
;                    aura le bit de poids le plus fort mis  1 quand c'est une chaine
;         + WORD   : taille du tableau
;         + BYTE   : nombre de dimension
;         + nxWORD : taille de dimension + 1 pour les n dimensions constituant le tableau
;                    dans l'ordre d'inverse de leur dclaration
;         + stockage des donnes
;           + si float  : stockage du nombre sur 5 octets
;           + si string : WORD : pointeur sur la chane de caractres
; STX : 10 DIM A(4) : DIM B$(5,4)
; OP  : $8B
; IN  : le flot d'interprtration
; OUT : Cration d'un tableau

romDIM:
            tab
            bsr nextPTRGET
            jsr.w   CHRGOT  ; OJE 13/02/2020 - V2
            bne NXDIM
            rts
; End of function romDIM


; =============== S U B R O U T I N E =======================================

; FCT : Lit un nom de variable  l'aide de CHRGOT
;       et le trouve en mmoire
; IN  : TXTPTR pointe sur le premier caractre du nom
; OUT : X=VARPNT=ADRESSE DE LA VARIABLE
;       (si non trouv alors cration d'une variable simple ou d'un
;       tableau de dim(10) Initialis   0)

PTRGET:
            clrb
            jsr.w   CHRGOT              ; OJE 13/02/2020 - V2 ; retrieve last character

nextPTRGET:
            stab DIMFLG
            staa VARNAM                 ; Temporary storage for a variable name
            jsr.w   CHRGOT              ; OJE 13/02/2020 - V2                   ; get current character
            bsr ISLETC                  ; FCT : teste si A est une lettre ASCII
                                        ; IN  : A
                                        ; OUT : C=0 si lettre sinon 1
                                        ;       A modified
            bcc NAMOKnext1PTRGET
            jmp setError0x02_SYNTAXERROR

NAMOKnext1PTRGET:
            clrb                        ; B est dj  0, non ?
            stab VALTYP                 ; Type de valeur en cours de traitement : $00 : num, $FF = str
            jsr.w   CHRGET              ; OJE 14/02/2020 V3
                                        ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                        ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                        ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                        ; NOT C= NUMERIC ("0" THRU "9")
                                        ; Z= ":" OR END-OF-LINE (A NULL)
                                        ; [ACCA] = NEW CHAR.
                                        ; [TXTPTR]=[TXTPTR]+1
            bcs next2PTRGET
            bsr ISLETC                  ; FCT : teste si A est une lettre ASCII
                                        ; IN  : A
                                        ; OUT : C=0 si lettre sinon 1
                                        ;       A modified
            bcs next4PTRGET_NOSEC       ; Y-a-t-il une seconde lettre (nom avec deux lettres significatifs au maximum) ? non alors saut

next2PTRGET:
            tab

bcl3PTRGET:

            jsr.w   CHRGET              ; OJE 14/02/2020 V3
                                        ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                        ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                        ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                        ; NOT C= NUMERIC ("0" THRU "9")
                                        ; Z= ":" OR END-OF-LINE (A NULL)
                                        ; [ACCA] = NEW CHAR.
                                        ; [TXTPTR]=[TXTPTR]+1
            bcs bcl3PTRGET
            bsr ISLETC                  ; FCT : teste si A est une lettre ASCII
                                        ; IN  : A
                                        ; OUT : C=0 si lettre sinon 1
                                        ;       A modified
            bcc bcl3PTRGET

next4PTRGET_NOSEC:
            cmpa #cBAS_ID_STR           ; '$'
            bne next5PTRGET
            com VALTYP
            addb #$80                   ; Turn on MSB of second character
            jsr.w   CHRGET              ; OJE 14/02/2020 V3
                                        ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                        ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                        ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                        ; NOT C= NUMERIC ("0" THRU "9")
                                        ; Z= ":" OR END-OF-LINE (A NULL)
                                        ; [ACCA] = NEW CHAR.
                                        ; [TXTPTR]=[TXTPTR]+1

next5PTRGET:
            stab VARNAM+1               ; Temporary storage for a variable name
            ldab SUBFLG
            decb
            bne next6PTRGET
            jmp nextIsARY

next6PTRGET:
            adda SUBFLG
            suba #$28 ; '('
            bne next7PTRGET
            jmp ISARY                   ; FCT : traite la partie tableau de la recherche d'une variable
                                        ;       et de sa cration si il n'existe pas
                                        ; IN  : le flot d'interprtation
                                        ; OUT : Variable  jour

next7PTRGET:
            clr SUBFLG
            ldx VARTAB                  ; Fin du programme BASIC / dbut des variables

bcl8PTRGET:
            cpx ARYTAB
            beq NAMENOTFOUND            ; variable inexistante alors cration de cette variable !
            ldd VARNAM                  ; Temporary storage for a variable name
            subd 0,x                    ; ajoute la taille du tableau pour trouver la prochaine variable de type tableau
            beq endPTRGET
            ldab #cBAS_LEN_VAR_FLOAT    ; $07 : Taille de la zone de stockage d'une variable de type float
            abx
            bra bcl8PTRGET
; End of function PTRGET


; =============== S U B R O U T I N E =======================================

; FCT : teste si A est une lettre ASCII
; IN  : A
; OUT : C=0 si lettre sinon 1
;   A modified

ISLETC:
            cmpa #$41 ; 'A'
            bcs F_ISLETC
            suba #$5B ; '['
            suba #$A5

F_ISLETC:
            rts
; End of function ISLETC

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR PTRGET

NAMENOTFOUND:
            pulx                    ; rcupre l'adresse de l'appelant
            pshx
            cpx #CALL_FRM_VARIABLE
            bne MAKENEWVARIABLE
            ldx #C_ZERO
            rts

MAKENEWVARIABLE:
            ldd STREND
            std HIGHTR
            addd #cBAS_LEN_VAR_FLOAT; $07 : TODO taille d'une cellule de tableau ou de l'entte d'un tableau
            std HIGHDS              ; Cible lors d'une copie de zone mmoire
            ldx ARYTAB
            stx LOWTR
            jsr BLTU                ; FCT : move block of memory up + vrification si il y a de la place dans la pile
                                    ; IN  : HIGHDS (cible) et HIGHTR (source)  jour
                                    ; OUT : A,B,X modified
            ldx HIGHDS              ; Cible lors d'une copie de zone mmoire
            stx STREND
            ldx PTRTMP2
            stx ARYTAB
            ldx LOWTR
            ldd VARNAM              ; Temporary storage for a variable name

initARRAY:
            std 0,x                 ; stockage du nom de la variable
            clra
            clrb
            std 2,x                 ; initialisation  0 de la taille du tableau
            std 4,x                 ; initialisation  0 du nombre de dimension et de l'octet de poids fort de la dimension
            staa 6,x                ; initialisation  0 de l'octet de poids faible de la dimension

endPTRGET:
            inx
            inx
            stx VARPNT              ; mise  jour du pointeur de variable courant
            rts
; END OF FUNCTION CHUNK FOR PTRGET

; ---------------------------------------------------------------------------
cminus32768:        dc.b $90
                    dc.b $80
C_ZERO:             dc.b $00
                    dc.b $00
                    dc.b $00

; =============== S U B R O U T I N E =======================================

; FCT : Evaluate INDICE INTO ACC1
; IN  : le flot d'interprtation
; OUT : D=rsultat de l'interprtation de l'expression

CHRGETandFRMNUM:
            jsr.w   CHRGET          ; OJE 14/02/2020 V3
                                    ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                    ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                    ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                    ; NOT C= NUMERIC ("0" THRU "9")
                                    ; Z= ":" OR END-OF-LINE (A NULL)
                                    ; [ACCA] = NEW CHAR.
                                    ; [TXTPTR]=[TXTPTR]+1
; End of function CHRGETandFRMNUM

; =============== S U B R O U T I N E =======================================

; FCT : interprtre une expression de type int et retourne une valeur de type word
; ALG : /
; STX : /
; ST  : ACTIF
; IN  : le flot d'interprtation
; OUT : D=rsultat de l'interprtation de l'expression

jsrFRNUMAndMKINT:
            jsr FRMNUM              ; FCT : EVALUATE EXPRESSION, MAKE SURE IT IS NUMERIC
                                    ; IN  : le flot d'interprtation
                                    ; OUT : /
; End of function jsrFRNUMAndMKINT

; =============== S U B R O U T I N E =======================================

; FCT : Evalue une expression du flot d'interprtration comme un octet
;       ==> Pas optimale cette fonction : nous effectuons deux fois CHKNUM lorsque nous sommes dans le cas favorable ...
; ERR : FC : Fonction Incorrecte
; IN  : le rsultat d'une interprtation :
;       ACC1 doit contenir une valeur
;       VALTYP doit contenir le flag du type du rsultat de l'interprtration
; OUT : D=ACC1 contenant le rsultat de l'valuation

MKINT:
            jsr CHKNUM
            ldaa ACC1+5
            bmi printErrorMSG_0x08_FC_FctIncorrect
; End of function MKINT


; =============== S U B R O U T I N E =======================================

; FCT : conversion d'un float (ACC1) en un mot
;       D=INT(ACC1)
; ERR : Fonction incorrect
; IN  : ACC1 set
; OUT : D=rsultat de la conversion float->WORD

convACC1toWord:
            jsr CHKNUM
            ldaa ACC1
            cmpa #$90
            bcs nextConvACC1toWord
            ldx #cminus32768
            jsr FCOMP2                  ; FCT : COMPARE A PACKED FLOATING POINT NUMBER POINTED TO BY (X) 
                                        ;       TO AN UNPACKED FP NUMBER IN ACC1. 
                                        ; IN  : X=Adresse d'un float
                                        ; OUT : ZERO FLAG SET AND B = 0, IF EQUAL
                                        ;       ACCB = 1   IF ACC1 > (X)
                                        ;       ACCB = $FF IF ACC1 < (X)
            bne printErrorMSG_0x08_FC_FctIncorrect

nextConvACC1toWord:
            jsr QUICK_INT               ; FCT : effectue la fonction int sur ACC1
                                        ; IN  : ACC1 mise  jour
                                        ; OUT : ACC1=INT(ACC1)
            ldd ACC1+3

endConvACC1toWord:
            rts
; End of function convACC1toWord


; =============== S U B R O U T I N E =======================================

; FCT : traite la partie tableau de la recherche d'une variable
;       et de sa cration si il n'existe pas
; IN  : le flot d'interprtation
; OUT : Variable  jour

ISARY:
            ldx DIMFLG
            pshx
            clrb                        ; set number of dimension to 0

bclIsARY:
            pshb
            ldx VARNAM                  ; Temporary storage for a variable name
            pshx
            bsr CHRGETandFRMNUM         ; FCT : Evaluate INDICE INTO ACC1
                                        ; IN  : le flot d'interprtation
                                        ; OUT : D=rsultat de l'interprtation de l'expression
            pulx
            stx VARNAM                  ; Temporary storage for a variable name
            pulb
            incb
            stab EOLPNTR                ; cela sert  beaucoup de choses : op. binaires, etc.
            pula
            pulb
            ldx ACC1+3
            pshx
            pshb
            psha
            ldab EOLPNTR                ; cela sert  beaucoup de choses : op. binaires, etc.
            jsr.w   CHRGOT              ; OJE 13/02/2020
            cmpa #cBAS_SEP_ARG          ; ','
            beq bclIsARY
            jsr CHKCLS                  ; FCT : check close parenthesis and get next char
                                        ; IN  : TXTPTR mise  jour
                                        ; OUT : X modified, A et B modified
            pulx
            stx DIMFLG
            ldab #$FF

nextIsARY:
            pshb
            ldx ARYTAB

bcl2IsARY:
            cpx STREND
            beq createARRAY             ; FCT : Cration de l'entte du tableau
                                        ;       00:01 : nom du tableau
                                        ;       04:04 : nombre de dimension
                                        ;       05:.. : la taille de chaque dimension +1
                                        ; IN  : X=position du futur tableau
                                        ; OUT : /
            ldd VARNAM                  ; Temporary storage for a variable name
            subd 0,x
            beq DIMARRAY_isError
            ldd 2,x
            jsr addXtoTMPPTR            ; FCT : Ajoute  TMPTR un offset donn par X
                                        ; IN  : X=offset  ajouter  TMPPTR
                                        ; OUT : X=D=TMPPTR+offset
            bra bcl2IsARY

DIMARRAY_isError:
            ldab #cBAS_ERR_REDIMD       ; set code error to $12 : DD : Erreur tableau
            pula
            tsta
            beq endConvACC1toWord
            ldaa DIMFLG
            bne jmpERROR_0
            ldab EOLPNTR                ; cela sert  beaucoup de choses : op. binaires, etc.
            cmpb 4,x
            beq getDimBeforCreateDimForArray

printErrorMSG_0x10_BS_IndiceIncorrect:
            ldab #cBAS_ERR_BADSUBS
            SKIP2
; End of function ISARY

; =============== S U B R O U T I N E =======================================


printErrorMSG_0x08_FC_FctIncorrect:
            ldab #cBAS_ERR_ILLQTY
jmpERROR_0:
            jmp ERROR
; End of function printErrorMSG_0x08_FC_FctIncorrect


; =============== S U B R O U T I N E =======================================

; FCT : Cration de l'entte du tableau
;       00:01 : nom du tableau
;       04:04 : nombre de dimension
;       05:.. : la taille de chaque dimension +1
; IN  : X=position du futur tableau
; OUT : /

createARRAY:
            pula
            tsta
            beq printErrorMSG_0x08_FC_FctIncorrect
            ldd #cBAS_BYTES_PER_VARIABLE                ; $0005  ; TODO ...
            std STRNG2                                  ; Initialise la taille du tableau  5 octets car c'est
                                                        ; la taille d'une cellule contenant un float
            ldd VARNAM                                  ; Temporary storage for a variable name
            std 0,x                                     ; save NAME
            ldab EOLPNTR                                ; cela sert  beaucoup de choses : op. binaires, etc.
            stab 4,x                                    ; save dimension of array
            jsr CHKMEM                                  ; FCT : vrifie s'il y a 2*B + $3A octets libres
                                                        ; IN  : B=Nombre d'octets / 2 ncessaires
                                                        ; OUT : D=pointeur aprs ajout de 2*B + $3A octets
            stx HIGHDS                                  ; Cible lors d'une copie de zone mmoire

initAllDimofARRAY:
            ldab #cBAS_ARY_DIM_DEFAULT+1                ; $0B ; init one dimension to 10 + 1 by default
            clra
            tst DIMFLG
            beq nextInitAllDimofARRAY                   ; si la dimension est dfinie alors on rcupre via la pile
            pula
            pulb
            addd #$0001

nextInitAllDimofARRAY:
            std 5,x                                     ; store dimension of array
            bsr UMULTARY
            std STRNG2                                  ; ajuste  chaque itration la taille du tableau
            inx
            inx                                         ; Passage  la dimension suivante
            dec EOLPNTR                                 ; cela sert  beaucoup de choses : op. binaires, etc.
            bne initAllDimofARRAY
            jsr addXtoTMPPTR                            ; FCT : Ajoute  TMPTR un offset donn par X
                                                        ; IN  : X=offset  ajouter  TMPPTR
                                                        ; OUT : X=D=TMPPTR+offset
            bcc testOutOfMeMBeforeCreateArray
            jmp MEMERR                                  ; FCT : Point d'entre secondaire pour la gestion d'erreur
                                                        ;       il correspond  "plus de place disponible en mmoire"
                                                        ; IN  : /
                                                        ; OUT : A,B,X modified

testOutOfMeMBeforeCreateArray:
            jsr nextCHKMEM                              ; D=D+$3A
            subd #cBAS_OFS_STK-cBAS_BYTES_PER_VARIABLE  ; $35 : comme nextCHKMEM ajoute $3A  D alors que nous voulons soustraire
			                                            ;       que la taille d'une cellule de type float = 5
            std STREND
            clra

storeTermAtEndOfArrayDesc:
            dex
            staa 5,x
            cpx INDEX
            bne storeTermAtEndOfArrayDesc
            ldx HIGHDS                                  ; Cible lors d'une copie de zone mmoire
            ldaa STREND
            subd HIGHDS                                 ; Cible lors d'une copie de zone mmoire
            std 2,x
            ldaa DIMFLG
            bne DIMRTS

getDimBeforCreateDimForArray:
            ldab 4,x
            stab EOLPNTR                                ; cela sert  beaucoup de choses : op. binaires, etc.
            clra
            clrb

repeatCreateDimForArray:
            std STRNG2
            pula
            pulb
            std ACC1+3
            pshb
            psha
            subd 5,x
            bcc jmpPrintErrMsg_0x010_BS_IndiceIncorrect
            ldd STRNG2
            pula
            pulb
            beq untilCreateDimForArray
            bsr UMULTARY
            addd ACC1+3

untilCreateDimForArray:
            inx
            inx
            dec EOLPNTR                                 ; cela sert  beaucoup de choses : op. binaires, etc.
            bne repeatCreateDimForArray

mulBy5:
            std INDEX
            lsld
            lsld
            addd INDEX
            addd #$0005
            jsr addXtoTMPPTR                            ; FCT : Ajoute  TMPTR un offset donn par X
                                                        ; IN  : X=offset  ajouter  TMPPTR
                                                        ; OUT : X=D=TMPPTR+offset
            stx VARPNT                                  ; Pointer used in array building

DIMRTS:
            rts
; End of function createARRAY


; =============== S U B R O U T I N E =======================================

; FCT : calcule la taille d'un tableau de dimension N
;       RESULTAT=STRNG2*X[5]
; IN  : X     =pointeur sur le descripteur d'un tableau (pour obtenir le multiplier)
;       STRNG2=offset de dpart contenant le multiplicande
; OUT : D=taille du tableau pour la dimension du tableau en cours de traitement
; RMQ : Pourquoi ne pas utiliser l'opcode mul ?
;       Dans l'absolu multiplicande et multiplieur font 16 bits donc le rsultat est sur 32 bits
;       ==> pas possible car nous sommes limits  2^16  octets de mmoire
;       but : STRNG2 = STRNG2* le nombre de cellules
;             Nous devons dtecter le dpassement de capacit
;             via C=1 lors du dcalage de D ou par l'ajout de la taille d'une cellule en cours
;       Note : multiplication 16bits * 16 bits = 32 bits
;       Impossible vu la capacit mmoire !
;       A*B = 65536 *(AH*BH)+256*(AH*BL+AL*BH)+AL*BL
;       Pas la peine de calculer 65536*(AH*BH) car >  la capacit mmoire
;       donc A*B = 256*(AH*BL+AL*BH)+AL*BL
;        PSEUDO-CODE :
;           T  = AL * BL
;           T1 = AH * BL
;           T2 = AH * BL
;           T2 = T2 + T1
;           T2 = 256 * T2
;           T  = T + T2
;          En sachant si AL=0 alors A*B=256*AH*BL
;                     si BL=0 alors A*B=256*AL*BH
;                     si AL=0 et BL=0 alors dpassement de capacit
;                     du fait que nous avons limit la taille du rsultat sur 16 bits
;
;           code
;           CLR T          ; 6
;           CLR T1         ; 6
;           LDAA AL        ; 4
;           BEQ SUITE1     ; 3
;           LDAB BL        ; 4
;           BEQ SUITE      ; 3
;           MUL            ; 10 cycles
;           BEQ OVERFLOW   ; 3
;           STD T          ; 5
;  SUITE    LDAA AL        ; 4
;           LDAB BH        ; 4
;           MUL            ; 10 cycles
;           STD T1         ;  3
;  SUITE1   LDAA AH        ;  4
;           LDAB BL        ;  4
;           MUL            ;  10
;           ADDD T1        ;  6
;           LDX #$8        ;  3
; BOUCLE
;           ASLD           ;  3
;           BCS OVERFLOW   ;  3
;           DEX            ;  3
;           BNE BOUCLE     ;  3
;           ADDD T         ;  6
;
; ===> 110 + 8* (12) = 206 cycles sans dpassement de capacit
;   ==> 110 + 48 = 158 cycles sans dpassement de capacit si la boucle est droule et on perd 18 octets
;    ===> version initiale : 24*16=384 cycles sans dpassement de capacit

UMULTARY:
            ldaa #$10
            staa PTRTMP2
            ldd 5,x                 ; taille de la dimension traite
            std SAVREGS
            clra
            clrb

bclUMULTARY:
            lsld
            bcs jmpPrintErrMsg_0x010_BS_IndiceIncorrect
            asl STRNG2+1
            rol STRNG2
            bcc endUMULTARY
            addd SAVREGS
            bcs jmpPrintErrMsg_0x010_BS_IndiceIncorrect

endUMULTARY:
            dec PTRTMP2
            bne bclUMULTARY
            rts

jmpPrintErrMsg_0x010_BS_IndiceIncorrect:
            jmp printErrorMSG_0x10_BS_IndiceIncorrect
; End of function UMULTARY


; =============== S U B R O U T I N E =======================================

; FCT : Donne la taille mmoire disponible - COMMANDE BASIC MEM
; OP  : $C8
; ST  : ACTIF
; IN  : /
; OUT : ACC1=taille mmoire disponible

romMEM:
            sts SAVREGS
            ldd SAVREGS
            subd STREND
			SKIP1
; End of function romMEM


; =============== S U B R O U T I N E =======================================

; FCT : conversion d'un octet en float
; IN  : B=octet  convertir
; OUT : ACC1=float(B)

SGNFLT:
            clra
; End of function SGNFLT


; =============== S U B R O U T I N E =======================================

; FCT : Convert Word to Float
; IN  : D=number to convert
; OUT : ACC1=float(D)

convWordToACC1:
            clr VALTYP                  ; set variable as float
            std ACC1+1                  ; convert word to float !
            ldab #$90
            jmp FLOAT1                  ; FLOAT UNSIGNED VALUE IN ACC1+1,2
; End of function convWordToACC1


; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC CHR$(A) : retourne l'quivalent en string de l'expression numrique A
; STX : A$=CHR$(100)
; BUG : Q=STR$(100) ne retourne pas d'erreur !
; ALG  : /
; OP  : $BE
; ST  : ACTIF
; IN  : le flot d'interprtation
; OUT : une chane de caractres

romSTRdollar:
            jsr CHKNUM                  ; check arg (has to be numeric)
            ldx #FTAMPON                ; Tampon pour conversion float -> STRING
            jsr FOUT1                   ; FCT : "STR$" FUNCTION ENTERS HERE,
                                        ; IN  : X=Pointeur sur le tampon de conversion Float -> String
                                        ; OUT : X=Pointeur sur le tampon de conversion Float -> String
                                        ;       A et B modified
            pulx
            ldx #FTAMPON-1              ; Tampon pour conversion float -> STRING
            bra STRLIT                  ; FCT : BUILD A DESCRIPTOR FOR STRING STARTING AT X
                                        ;       AND TERMINATED BY $00 OR QUOTATION MARK
                                        ;       RETURN WITH DESCRIPTOR IN A TEMPORARY
                                        ;       AND ADDRESS OF DESCRIPTOR IN ACC1+3,4
                                        ; ST  : ACTIF
                                        ; IN  : X=string to create an descriptor
                                        ; OUT : A,B,X modified
; End of function romSTRdollar

; =============== S U B R O U T I N E =======================================

; FCT : GET SPACE AND MAKE DESCRIPTOR FOR STRING WHOSE ADDRESS IS IN X
;       AND WHOSE LENGTH IS IN B-REG
; IN  : X=pointer on string
;       B=taille de la chane  rserver
; OUT : ACC3[0-4]

STRINI:
            stx DSCPTR

STRSPA:
            bsr GETSPA                  ; FCT : Rserve B octets dans l'espace des chanes de caractres
                                        ;       Effectue un garbage collector si l'espace manque
                                        ; ERR : $1A : OVERFLOW STRING
                                        ; IN  : B=nombre d'octet  rserver
                                        ; OUT : B unmodified
                                        ;       X pointeur sur le dbut de la zone rserve

STACC3_STRSPA:
            stx ACC3+2
            stab ACC3
            rts
; End of function STRINI


; =============== S U B R O U T I N E =======================================

; FCT : DEC X AND BUILD A DESCRIPTOR FOR STRING STARTING AT X
;       AND TERMINATED BY $00 OR QUOTATION MARK
;       RETURN WITH DESCRIPTOR IN A TEMPORARY
;       AND ADDRESS OF DESCRIPTOR IN ACC1+3,4
; ST  : ACTIF
; IN  : X=string to create an descriptor
; OUT : A,B,X modified

DECXbeforeSTRLIT:
            dex
; End of function DECXbeforeSTRLIT


; =============== S U B R O U T I N E =======================================

; FCT : BUILD A DESCRIPTOR FOR STRING STARTING AT X
;       AND TERMINATED BY $00 OR QUOTATION MARK
;       RETURN WITH DESCRIPTOR IN A TEMPORARY
;       AND ADDRESS OF DESCRIPTOR IN ACC1+3,4
; ST  : ACTIF
; IN  : X=string to create an descriptor
; OUT : A,B,X modified

STRLIT:
            ldaa #cBAS_SEP_STR          ; '"'
            staa CHARAC                 ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            staa ENDCHR                 ; sert  tout : stockage d'un caractre, de valeur pour opration binaire

STRLT2:
            inx                         ; FCT : BUILD A DESCRIPTOR FOR STRING STARTING AT Y,A
                                        ;       AND TERMINATED BY $00, (CHARAC), OR (ENDCHR)
                                        ;       RETURN WITH DESCRIPTOR IN A TEMPORARY
                                        ;       AND ADDRESS OF DESCRIPTOR IN ACC1+3,4
            stx PRODSIGN
            stx ACC3+2
            ldab #$FF

bclSTRLIT:
            incb
            ldaa 0,x
            beq next2STRLIT
            inx
            cmpa CHARAC                 ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            beq next1STRLIT
            cmpa ENDCHR                 ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            bne bclSTRLIT

next1STRLIT:
            cmpa #cBAS_SEP_STR          ; '"'
            beq next2STRLIT
            dex

next2STRLIT:
            stx STRNG2
            stab ACC3
            pshb
            ldd PRODSIGN
            subd #FTAMPON               ; Tampon pour conversion float -> STRING
            pulb

next3STRLIT:
            bhi PUTNEW                  ; FCT : STORE DESCRIPTOR IN TEMPORARY DESCRIPTOR STACK
                                        ; THE DESCRIPTOR IS NOW IN ACC3, ACC3+1, ACC3+2
                                        ; PUT ADDRESS OF TEMP DESCRIPTOR IN ACC1+3,4
                                        ; ERR : $1E : TOO COMPLEX
                                        ; IN  : ACC3 mise  jour
                                        ; OUT : LASTPT=TMPPT   [OLD TMPPT]
                                        ;       TMPPT=TMPT+5   [NEW TMPPT]
            bsr STRINI                  ; FCT : GET SPACE AND MAKE DESCRIPTOR FOR STRING WHOSE ADDRESS IS IN X
                                        ;       AND WHOSE LENGTH IS IN B-REG
                                        ; IN  : X=pointer on string
										;       B=taille de la chane  rserver
                                        ; OUT : ACC3[0-4]
            ldx PRODSIGN
            jsr MOVSTR                  ; FCT : Dplace une zone mmoire dont la source est donne par X
                                        ;       et la cible par le pointeur contenu dans FREESPC
                                        ; IN  : X=source de la zone  copier
                                        ;       B=nombre d'octet  copier
                                        ; OUT : A, X,B modified
; End of function STRLIT

; =============== S U B R O U T I N E =======================================

; FCT : STORE DESCRIPTOR IN TEMPORARY DESCRIPTOR STACK
;       THE DESCRIPTOR IS NOW IN ACC3, ACC3+1, ACC3+2
;       PUT ADDRESS OF TEMP DESCRIPTOR IN ACC1+3,4
; ERR : $1E : TOO COMPLEX
; IN  : ACC3 mise  jour
; OUT : LASTPT=TMPPT   [OLD TMPPT]
;       TMPPT=TMPT+5   [NEW TMPPT]

PUTNEW:
            ldx TMPPT                       ; obtient le descripteur du prochain "STRING"
            cpx #DESC_STK+15                ; ADRENDMEM
            bne nextPUTNEW

setErrorTo0x1E_STATEMENT_TOOCOMPLEX:
            ldab #cBAS_ERR_FRMCPX

jmpERROR:
            jmp ERROR

nextPUTNEW:
            ldaa ACC3
            staa 0,x
            ldd ACC3+2
            std 2,x
            ldaa #$FF                       ; le type de retour est "STRING"
            staa VALTYP                     ; Type de valeur en cours de traitement : $00 : num, $FF = str
            stx LASTPT
            stx ACC1+3                      ; TODO : Pourquoi ?
            ldab #cBAS_BYTES_PER_VARIABLE   ; $05 ; 5 octets de plus ...
            abx
            stx TMPPT                       ; Met  jour le prochain descripteur de "STRING"
            rts
; End of function PUTNEW


; =============== S U B R O U T I N E =======================================

; FCT : Rserve B octets dans l'espace des chanes de caractres
;       Effectue un garbage collector si l'espace manque
; ERR : $1A : OVERFLOW STRING
; IN  : B=nombre d'octet  rserver
; OUT : B unmodified
;       X pointeur sur le dbut de la zone rserve

GETSPA:
            clr DATAFLG

bclGETSPA:
            pshb
            clra
            std INDEX
            ldd FRETOP
            subd INDEX
            subd botSTACK
            bcs nextGETSPA
            addd botSTACK
            std FRETOP
            ldx FRETOP
            inx
            stx FREESPC
            pulb
            rts

nextGETSPA:
            ldab #cBAS_ERR_STRFULL      ; $1A : erreur OS : overflow string
            com DATAFLG
            beq jmpERROR
            bsr GARBAG                  ; FCT : SHOVE ALL REFERENCED STRINGS AS HIGH AS POSSIBLE
                                        ;       IN MEMORY (AGAINST HIMEM), FREEING UP SPACE
                                        ;       BELOW STRING AREA DOWN TO STREND
                                        ; IN  : /
                                        ; OUT : /
            pulb
            bra bclGETSPA
; End of function GETSPA


; =============== S U B R O U T I N E =======================================

; FCT : SHOVE ALL REFERENCED STRINGS AS HIGH AS POSSIBLE
;       IN MEMORY (AGAINST HIMEM), FREEING UP SPACE
;       BELOW STRING AREA DOWN TO STREND
; IN  : /
; OUT : /

GARBAG:
            ldx MEMSIZ                      ; Adresse - 1 de la fin de la RAM DISPONIBLE

bclGARBAG:
            stx FRETOP
            clra
            clrb
            std PTRTMP4
            ldx botSTACK
            stx LOWTR
            ldx #DESC_STK                   ; $3241

bcl1GARBAG:
            cpx TMPPT
            beq next2GARBAG
            bsr CHKVAR_GARBAG
            bra bcl1GARBAG

next2GARBAG:
            ldx VARTAB                      ; Fin du programme BASIC / dbut des variables

bcl3GARBAG:
            cpx ARYTAB
            beq next4GARBAG
            bsr CHKSIMPLEVAR_GARBAG
            bra bcl3GARBAG

next4GARBAG:
            stx HIGHDS                      ; Cible lors d'une copie de zone mmoire

bcl5GARBAG:
            ldx HIGHDS                      ; Cible lors d'une copie de zone mmoire

bcl6GARBAG:
            cpx STREND
            beq MOVE_HIGHEST_STR_TO_TOP
            ldd 2,x
            addd HIGHDS                     ; Cible lors d'une copie de zone mmoire
            std HIGHDS                      ; Cible lors d'une copie de zone mmoire
            ldaa 1,x
            bpl bcl5GARBAG
            ldab 4,x
            aslb
            addb #cBAS_BYTES_PER_VARIABLE   ; $05
            abx

bcl7GARBAG:
            cpx HIGHDS                      ; Cible lors d'une copie de zone mmoire
            beq bcl6GARBAG
            bsr CHKVAR_GARBAG
            bra bcl7GARBAG
; End of function GARBAG


; =============== S U B R O U T I N E =======================================


CHKSIMPLEVAR_GARBAG:
            ldaa 1,x
            inx
            inx
            bpl CHKBUMP_GARBAG
; End of function CHKSIMPLEVAR_GARBAG


; =============== S U B R O U T I N E =======================================
; FCT : Nettoyage des variables
; IN  : X=pointeur sur les variables  nettoyer
; OUT : A,B,X modified

CHKVAR_GARBAG:
            ldab 0,x
            beq CHKBUMP_GARBAG
            ldd 2,x
            subd FRETOP
            bhi CHKBUMP_GARBAG
            ldd 2,x
            subd LOWTR
            bls CHKBUMP_GARBAG
            stx PTRTMP4
            ldd 2,x
            std LOWTR

CHKBUMP_GARBAG:
            ldab #cBAS_BYTES_PER_VARIABLE   ; $05 ; longueur du descripteur ...
            abx

endGARBAG:
            rts
; End of function CHKVAR_GARBAG

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR GARBAG

MOVE_HIGHEST_STR_TO_TOP:
            ldx PTRTMP4
            beq endGARBAG
            clra
            ldab 0,x
            decb
            addd LOWTR
            std HIGHTR
            ldx FRETOP
            stx HIGHDS                      ; Cible lors d'une copie de zone mmoire
            jsr doBLTU                      ; FCT : move block of memory up
                                            ; IN  : HIGHDS (cible) et HIGHTR (source)  jour
                                            ; OUT : A,B,X modified
            ldx PTRTMP4
            ldd PTRTMP2
            std 2,x
            ldx PTRTMP2
            dex
            jmp bclGARBAG
; END OF FUNCTION CHUNK FOR GARBAG

; =============== S U B R O U T I N E =======================================

; FCT : Concatenate two strings
; IN  : ACC1(3:4) : pointer on string
; OUT : pointer

CAT:
            ldx ACC1+3
            pshx
            jsr EVAL                    ; FCT : GET ELEMENT IN EXPRESSION
                                        ;       GET VALUE OF VARIABLE OR NUMBER AT TXTPNT, OR POINT
                                        ;       TO STRING DESCRIPTOR IF A STRING, AND PUT IN FAC.
                                        ; IN  : le flot d'interprtation
                                        ; OUT : ACC1=resultat
            jsr CHKSTR
            pulx
            stx PRODSIGN
            ldab 0,x
            ldx ACC1+3
            addb 0,x
            bcc nextCAT

setErrorTo0x1C_StringTooLong:
            ldab #cBAS_ERR_STRLONG
            jmp ERROR

nextCAT:
            jsr STRINI                  ; FCT : GET SPACE AND MAKE DESCRIPTOR FOR STRING WHOSE ADDRESS IS IN X
                                        ;       AND WHOSE LENGTH IS IN B-REG
                                        ; IN  : X=pointer on string
										;       B=taille de la chane  rserver
                                        ; OUT : ACC3[0-4]
            ldx PRODSIGN
            ldab 0,x
            bsr MOVSTR_IND              ; FCT : Dplace une zone mmoire dont la source est donne
                                        ;       indirectement par X et la cible par le pointeur contenu
                                        ;       dans FREESPC
                                        ; IN  : X=source de la zone  copier
                                        ;       B=nombre d'octet  copier
                                        ; OUT : A, X,B modified
            ldx DSCPTR
            bsr FRETMP                  ; FCT : IF STRING DESCRIPTOR WHOSE ADDRESS IS IN X IS
                                        ; ;     A TEMPORARY STRING, RELEASE IT.
                                        ; IN  : X=Address of string descriptor
                                        ; OUT : X=pointer
                                        ;       B=longueur de la chane de caractres rserve
            bsr MOVSTR                  ; FCT : Dplace une zone mmoire dont la source est donne par X
                                        ;       et la cible par le pointeur contenu dans FREESPC
                                        ; IN  : X=source de la zone  copier
                                        ;       B=nombre d'octet  copier
                                        ; OUT : A, X,B modified
            ldx PRODSIGN
            bsr FRETMP                  ; FCT : IF STRING DESCRIPTOR WHOSE ADDRESS IS IN X IS
                                        ; ;     A TEMPORARY STRING, RELEASE IT.
                                        ; IN  : X=Address of string descriptor
                                        ; OUT : X=pointer
                                        ;       B=longueur de la chane de caractres rserve
            jsr PUTNEW                  ; FCT : STORE DESCRIPTOR IN TEMPORARY DESCRIPTOR STACK
                                        ; THE DESCRIPTOR IS NOW IN ACC3, ACC3+1, ACC3+2
                                        ; PUT ADDRESS OF TEMP DESCRIPTOR IN ACC1+3,4
                                        ; ERR : $1E : TOO COMPLEX
                                        ; IN  : ACC3 mise  jour
                                        ; OUT : LASTPT=TMPPT   [OLD TMPPT]
                                        ;       TMPPT=TMPT+5   [NEW TMPPT]
            jmp TSTOP_FRMEVL
; End of function CAT


; =============== S U B R O U T I N E =======================================

; FCT : Dplace une zone mmoire dont la source est donne
;       indirectement par X et la cible par le pointeur contenu
;       dans FREESPC
; IN  : X=source de la zone  copier
;       B=nombre d'octet  copier
; OUT : A, X,B modified

MOVSTR_IND:

            ldx 2,x
; End of function MOVSTR_IND


; =============== S U B R O U T I N E =======================================

; FCT : Dplace  une zone mmoire dont la source est donne par X
;       et la cible par le pointeur contenu dans FREESPC
; IN  : X=source de la zone  copier
;       B=nombre d'octet  copier
; OUT : A, X,B modified

MOVSTR:
            tpa
            psha
            sts SAVREGS
            sei
            txs
            ldx FREESPC
            incb
            bra nextMOVSTR

bclMOVSTR:
            pula
            staa 0,x
            inx

nextMOVSTR:
            decb
            bne bclMOVSTR
            stx FREESPC
            lds SAVREGS
            pula
            tap
            rts
; End of function MOVSTR


; =============== S U B R O U T I N E =======================================

; FCT : Libre la zone rserve pour une chane de caractres
;       lors de l'interprtation du flux d'entre
; OUT : X=pointeur sur la chane de caractres
;       B=longueur de la chane de caractre										

FRESTR:
            jsr CHKSTR
; End of function FRESTR


; =============== S U B R O U T I N E =======================================

; FCT : Libre la zone rserve par descripteur (chane de caractres)
; IN  : ACC1+3 et ACC1+4 : contient le descripteur
; OUT : X=pointer

FREFAC:
            ldx ACC1+3
; End of function FREFAC


; =============== S U B R O U T I N E =======================================

; FCT : IF STRING DESCRIPTOR WHOSE ADDRESS IS IN X IS
;       A TEMPORARY STRING, RELEASE IT.
; IN  : X=Address of string descriptor
; OUT : X=pointer
;       B=longueur de la chane de caractres rserve

FRETMP:
            ldab 0,x                    ; rcupre la longueur de la chane rserve
            bsr FRETMS                  ; FCT : RELEASE TEMPORARY DESCRIPTOR IF X = LASTPT
                                        ; IN  : X=pointeur
                                        ; OUT : si X=LASTPT alors
                                        ;         TMPPT=X et LASTP=X-5
                                        ;         A=0
                                        ;       sinon rien
            bne end1FREETMP
            ldx $07,x
            dex
            cpx FRETOP
            bne endFREETMP
            pshb
            addd FRETOP
            std FRETOP
            pulb

endFREETMP:
            inx
            rts

end1FREETMP:
            ldx $02,x
            rts
; End of function FRETMP


; =============== S U B R O U T I N E =======================================

; FCT : RELEASE TEMPORARY DESCRIPTOR IF X = LASTPT
; IN  : X=pointeur
; OUT : si X=LASTPT alors
;       TMPPT=X et LASTP=X-5
;       A=0
;       sinon rien

FRETMS:
            cpx LASTPT
            bne endFREETMPS
            stx TMPPT
            dex
            dex
            dex
            dex
            dex
            stx LASTPT
            clra

endFREETMPS:
            rts
; End of function FRETMS


; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC LEN(A$) : rcupre la longueur de la chane A$
; STX : A=LEN(A$)
; BUG : B=LEN(A) donne B=255 !!
; ALG : /
; OP  : $BD
; ST  : ACTIF
; IN  : le flot d'interprtation
; OUT : ACC1=la longueur de la chane A$ > 0

romLEN:
            bsr GETSTR                  ; FCT : POINT X TO STRING ADDRESS LOAD LENGTH INTO ACCB. 
                                        ;       ENTER WITH THE STRING DESCRIPTOR IN BOTTOM TWO BYTES OF ACC1
                                        ; IN  : ACC1 : descripteur de la chane
                                        ; OUT : X=ACC1
                                        ;       B : length of string

jmpSGNFLT_endRomLen:
            jmp SGNFLT
; End of function romLEN


; =============== S U B R O U T I N E =======================================

; FCT : POINT X TO STRING ADDRESS LOAD LENGTH INTO ACCB. 
;       ENTER WITH THE STRING DESCRIPTOR IN BOTTOM TWO BYTES OF ACC1
; IN  : ACC1 : descripteur de la chane
; OUT : X=ACC1
;       B : length of string

GETSTR:
            bsr FRESTR                  ; FCT : Libre la zone rserve pour une chane de caractres
                                        ;       lors de l'interprtation du flux d'entre
                                        ; OUT : X=pointeur sur la chane de caractres
                                        ;       B=longueur de la chane de caractre										
            clr VALTYP                  ; Type de valeur en cours de traitement : $00 : num, $FF = str
            tstb                        ; Set flags according to length
            rts
; End of function GETSTR


; =============== S U B R O U T I N E =======================================

; FCT : Commande BASIC CHR$ : Renvoie le caractre ou
;       la commande correpondant  N
; STX : PRINT CHR$(65)
; BUG : /
; ALG : /
; OP  : $C1
; ST  : ACTIF
; IN  : le flot d'interprtation
; OUT:  /

romCHRdollar:
            jsr CONINT                  ; conversion d'une expression parenthse de type byte

nextRomCHRdollar:
            ldab #$01
            jsr GETSPA                  ; FCT : Rserve B octets dans l'espace des chanes de caractres
                                        ;       Effectue un garbage collector si l'espace manque
                                        ; ERR : $1A : OVERFLOW STRING
                                        ; IN  : B=nombre d'octet  rserver
                                        ; OUT : B unmodified
                                        ;       X pointeur sur le dbut de la zone rserve
            ldaa ACC1+4
            jsr STACC3_STRSPA           ; Sauvegarde le pointeur X sur la nouvelle chane et la longueur B dans ACC2
            staa 0,x                    ; Sauve la valeur de l'expression dans la nouvelle chane

next1RomCHRdollar:
            ins
            ins                         ; supprime l'adresse de retour

endRomCHRdollar:
            jmp PUTNEW                  ; FCT : STORE DESCRIPTOR IN TEMPORARY DESCRIPTOR STACK
                                        ; THE DESCRIPTOR IS NOW IN ACC3, ACC3+1, ACC3+2
                                        ; PUT ADDRESS OF TEMP DESCRIPTOR IN ACC1+3,4
                                        ; ERR : $1E : TOO COMPLEX
                                        ; IN  : ACC3 mise  jour
                                        ; OUT : LASTPT=TMPPT   [OLD TMPPT]
                                        ;       TMPPT=TMPT+5   [NEW TMPPT]
; End of function romCHRdollar

; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC ASC("TEST") : retourne le code ASCII du premier caractre du paramtre
;       retourne l'erreur FC si chane vide
; STX : A=ASC("100") retourne 49 (=ASCII de 1)
; BUG : A$=ASC("45") ne retourne pas d'erreur !
; ALG : /
; OP  : $C0
; ST  : ACTIF
; IN  : le flot d'interprtation
; OUT : ACC1 : code ASCII du premier caractre

romASC:
            bsr nextRomASC
            bra jmpSGNFLT_endRomLen

nextRomASC:
            bsr GETSTR                      ; FCT : POINT X TO STRING ADDRESS LOAD LENGTH INTO ACCB. 
                                            ;       ENTER WITH THE STRING DESCRIPTOR IN BOTTOM TWO BYTES OF ACC1
                                            ; IN  : ACC1 : descripteur de la chane
                                            ; OUT : X=ACC1
                                            ;       B : length of string
            beq jmpPrintErrorMSg0x08_01
            ldab $00,x
            rts
; End of function romASC


; =============== S U B R O U T I N E =======================================

; FCT : Extrait les n premiers caractres d'une chane de caractres
; STX : A$=LEFT$(B$,3)
; ALG : /
; ST  : ACTIF
; OP  : $C2
; IN  : le flot d'interprtation
; OUT : un descripteur de chane de caractres

romLEFTdollar:
            bsr SUBSTRING_SETUP             ; FCT : COMMON SETUP ROUTINE FOR LEFT$, RIGHT$, MID$:
                                            ;       REQUIRE ")"; POP RETURN ADRS, GET DESCRIPTOR
                                            ;       ADDRESS, GET 1ST PARAMETER OF COMMAND
                                            ; IN  : le flot d'interprtation
                                            ; OUT : X=DSCPTR
            clra

nextRomLEFTdollar:
            cmpb $00,x
            bls next1RomLEFTdollar
            ldab $00,x
            clra

next1RomLEFTdollar:
            pshb
            psha
            jsr STRSPA
            ldx DSCPTR
            bsr FRETMP                      ; FCT : IF STRING DESCRIPTOR WHOSE ADDRESS IS IN X IS
                                            ;       A TEMPORARY STRING, RELEASE IT.
                                            ; IN  : X=Address of string descriptor
                                            ; OUT : X=pointer
                                            ;       B=longueur de la chane de caractres rserve
            pulb
            abx
            pulb
            jsr MOVSTR                      ; FCT : Dplace une zone mmoire dont la source est donne par X
                                            ;       et la cible par le pointeur contenu dans FREESPC
                                            ; IN  : X=source de la zone  copier
                                            ;       B=nombre d'octet  copier
                                            ; OUT : A, X,B modified
            bra endRomCHRdollar
; End of function romLEFTdollar


; =============== S U B R O U T I N E =======================================

; FCT : Extrait les n dernires  caractres d'une chane
; STX : A$=RIGHT$(B$,3)
; ALG : /
; ST  : ACTIF
; OP  : $C3
; IN  : le flot d'interprtation
; OUT : un descripteur de chane de caractres

romRIGHTdollar:
            bsr SUBSTRING_SETUP             ; FCT : COMMON SETUP ROUTINE FOR LEFT$, RIGHT$, MID$:
                                            ;       REQUIRE ")"; POP RETURN ADRS, GET DESCRIPTOR
                                            ;       ADDRESS, GET 1ST PARAMETER OF COMMAND
                                            ; IN  : le flot d'interprtation
                                            ; OUT : X=DSCPTR
            ldaa $00,x
            sba
            bra nextRomLEFTdollar
; End of function romRIGHTdollar


; =============== S U B R O U T I N E =======================================

; FCT : Extrait de la chaine c, partir de la position n1, n2 caractres
; STX : A$=MID$(c,N1,N2)
; ALG : /
; ST  : ACTIF
; OP  : $C4
; IN  : le flot d'interprtation
; OUT : un descripteur de chane de caractres

romMIDdollar:
            ldab #$FF
            stab ACC1+4
            bsr jmpCHRGOT                   ; bon ... jsr chrgot trop simple  faire ...
            cmpa #cBAS_FCT_CLOSE            ; ')'
            beq nextRomMIDdollar
            jsr getByteAfterComma           ; FCT : Retourne la valeur de l'expression aprs la
                                            ;       virgule contenue dans le flot d'interprtation
                                            ; IN  : /
                                            ; OUT : B=la valeur en octet de l'expression

nextRomMIDdollar:
            bsr SUBSTRING_SETUP             ; FCT : COMMON SETUP ROUTINE FOR LEFT$, RIGHT$, MID$:
                                            ;       REQUIRE ")"; POP RETURN ADRS, GET DESCRIPTOR
                                            ;       ADDRESS, GET 1ST PARAMETER OF COMMAND
                                            ; IN  : le flot d'interprtation
                                            ; OUT : X=DSCPTR
            beq jmpPrintErrorMSg0x08_01
            clrb
            deca
            cmpa $00,x
            bcc next1RomLEFTdollar
            tab
            subb 0,x
            negb
            cmpb ACC1+4
            bls next1RomLEFTdollar
            ldab ACC1+4
            bra next1RomLEFTdollar
; End of function romMIDdollar


; =============== S U B R O U T I N E =======================================

; FCT : COMMON SETUP ROUTINE FOR LEFT$, RIGHT$, MID$:
;       REQUIRE ")"; POP RETURN ADRS, GET DESCRIPTOR
;       ADDRESS, GET 1ST PARAMETER OF COMMAND
; IN  : le flot d'interprtation
; OUT : X=DSCPTR

SUBSTRING_SETUP:
            jsr CHKCLS                  ; FCT : check close parenthesis and get next char
                                        ; IN  : TXTPTR mise  jour
                                        ; OUT : X modified, A et B modified
            tsx
            ldd 5,x
            std DSCPTR
            ldd 0,x
            std 5,x
            ins
            ins
            ins
            ins
            pula
            ldx DSCPTR
            tab
            rts
; End of function SUBSTRING_SETUP

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR GETBYT

jmpPrintErrorMSg0x08_01:
            jmp printErrorMSG_0x08_FC_FctIncorrect
; END OF FUNCTION CHUNK FOR GETBYT

; =============== S U B R O U T I N E =======================================

; FCT: SCAN TO NEXT CHARACTER AND CONVERT EXPRESSION
;      TO SINGLE BYTE IN B-REG
; IN : Le flot d'interprtation
; OUT: B=byte converted from expression
;      A=next char after expression

GETBYTC:
            jsr.w   CHRGET      ; OJE 14/02/2020 V3
                                ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                ; NOT C= NUMERIC ("0" THRU "9")
                                ; Z= ":" OR END-OF-LINE (A NULL)
                                ; [ACCA] = NEW CHAR.
                                ; [TXTPTR]=[TXTPTR]+1
; End of function GETBYTC

; =============== S U B R O U T I N E =======================================

; FCT : EVALUATE EXPRESSION AT TXTPTR, AND
;       CONVERT IT TO SINGLE BYTE IN B-REG
; ERR : FC : fonction incorrecte
; IN  : le flot d'interprtation
; OUT : B=la partie haute de la conversion (ACC1+3,ACC1+4)

GETBYT:
            jsr FRMNUM                  ; FCT : EVALUATE EXPRESSION, MAKE SURE IT IS NUMERIC
                                        ; IN  : le flot d'interprtation
                                        ; OUT : /

CONINT:
            jsr MKINT                   ; FCT : Evalue une expression du flot d'interprtration comme un octet
                                        ;       ==> Pas optimale cette fonction : nous effectuons deux fois CHKNUM lorsque nous sommes dans le cas favorable ...
                                        ; ERR : FC : Fonction Incorrecte
                                        ; IN  : le rsultat d'une interprtation :
                                        ;       ACC1 doit contenir une valeur
                                        ;       VALTYP doit contenir le flag du type du rsultat de l'interprtration
                                        ; OUT : D=ACC1 contenant le rsultat de l'valuation
            ldaa ACC1+3
            bne jmpPrintErrorMSg0x08_01
            ldab ACC1+4

jmpCHRGOT:
            jmp.w   CHRGOT              ; OJE 13/02/2020 - V2
; End of function GETBYT


; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC VAL("X") : retourne l'quivalent numrique d'un string
; STX : A=VAL("100")
; BUG : A$=STR$("45")) ne retourne pas d'erreur !
; ALG : /
; OP  : $BF
; ST  : ACTIF
; IN  : le flot d'interprtation
; OUT : ACC1 : reprsentation numrique de l'entre

romVAL:
            jsr GETSTR              ; FCT : POINT X TO STRING ADDRESS LOAD LENGTH INTO ACCB. 
                                    ;       ENTER WITH THE STRING DESCRIPTOR IN BOTTOM TWO BYTES OF ACC1
                                    ; IN  : ACC1 : descripteur de la chane
                                    ; OUT : X=ACC1
                                    ;       B : length of string
            bne nextRomVal
            jmp ZEROFAC

nextRomVal:
            jsr addRegBToTMPPTR
            ldaa 0,x
            psha
            clr 0,x
            ldx TXTPTR
            stx STRNG2
            ldx INDEX
            stx TXTPTR
            bsr jmpCHRGOT
            jsr FIN                 ; FCT : Float IN : parse a number
                                    ;       NUMBER INPUT IS LEFT IN FAC.
                                    ;       AT ENTRY [TXTPTR] POINTS TO THE FIRST CHARACTER IN A TEXT BUFFER.
                                    ;       THE FIRST CHARACTER IS ALSO IN ACCA. FIN PACKS THE DIGITS
                                    ;       INTO THE FAC AS AN INTEGER AND KEEPS TRACK OF WHERE THE
                                    ;       DECIMAL POINT IS. [DPTFLG] TELL WHETHER A DP HAS BEEN
                                    ;       SEEN. [DECCNT] IS THE NUMBER OF DIGITS AFTER THE DP.
                                    ;       AT THE END [DECCNT] AND THE EXPONENT ARE USED TO
                                    ;       DETERMINE HOW MANY TIMES TO MULTIPLY OR DIVIDE BY TEN
                                    ;       TO GET THE CORRECT NUMBER.
                                    ; IN  : C=1 : The first character is numeric
                                    ;       C=0 : The first character is not numeric
                                    ; OUT : ACC1
            pula
            ldx TMPPTR
            staa 0,x

POINT_next1RomVal:

            ldx STRNG2              ; COPY STRNG2 INTO TXTPTR
            stx TXTPTR
            rts
; End of function romVAL


; =============== S U B R O U T I N E =======================================

; FCT : parse 2 arguments spars par une virgule
;       1 er argument : word 2 eme Arg : byte
; IN  : /
; OUT : LINNUM contient la valeur du premier argument
;       B : contient la valeur du deuxime argument

get2params:
            bsr GETARG                  ; FCT : Rcuprer un word dans le flot d'inteprtation
                                        ; IN  : le flot d'interprtation
                                        ; OUT : X=WORD from ARGUMENT
                                        ;       ACC1+3 contient aussi l'expression convertie de type word
            stx LINUM
; End of function get2params


; =============== S U B R O U T I N E =======================================

; FCT : Retourne la valeur de l'expression aprs la
;       virgule contenue dans le flot d'interprtation
; IN  : /
; OUT : B=la valeur en octet de l'expression

getByteAfterComma:
            jsr CHKCOM
            bra GETBYT                  ; FCT : EVALUATE EXPRESSION AT TXTPTR, AND
                                        ;       CONVERT IT TO SINGLE BYTE IN B-REG
                                        ; ERR : FC : fonction incorrecte
                                        ; IN  : le flot d'interprtation
                                        ; OUT : B=la partie haute de la conversion (ACC1+3,ACC1+4)
; End of function getByteAfterComma

; =============== S U B R O U T I N E =======================================

; FCT : Rcuprer un word dans le flot d'inteprtation
; IN  : le flot d'interprtation
; OUT : X=WORD from ARGUMENT
;       ACC1+3 contient aussi l'expression convertie de type word

GETARG:
            jsr FRMNUM                  ; FCT : EVALUATE EXPRESSION, MAKE SURE IT IS NUMERIC
                                        ; IN  : le flot d'interprtation
                                        ; OUT : /
getArgument:
            ldaa ACC1+5
            bmi jmpPrintErrorMSg0x08_01
            ldaa ACC1
            cmpa #$90
            bhi jmpPrintErrorMSg0x08_01
            jsr QUICK_INT               ; FCT : effectue la fonction int sur ACC1
                                        ; IN  : ACC1 mise  jour
                                        ; OUT : ACC1=INT(ACC1)
            ldx ACC1+3
            rts
; End of function GETARG


; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC PEEK(X) : rcupre la valeur de l'octet  l'adresse X
; STX : A=PEEK(12000)
; ALG  : /
; OP  : $BC
; ST  : ACTIF
; IN  : le flot d'interprtation
; OUT : ACC1=la valeur pointe par X

romPEEK:
            bsr getArgument
            ldab 0,x
            jmp SGNFLT
; End of function romPEEK


; =============== S U B R O U T I N E =======================================

; FCT : CMD BASIC POKE : initialise l'octet  l'adresse A avec B
; STX : POKE A,B
; OP  : $92
; ST  : ACTIF
; IN  : le flot  interprter
; OUT : A,B,X modified

romPOKE:
            bsr get2params              ; FCT : parse 2 arguments spars par une virgule
                                        ;       1 er argument : word 2 eme Arg : byte
                                        ; IN  : /
                                        ; OUT : LINNUM contient la valeur du premier argument
                                        ;       B : contient la valeur du deuxime argument
            ldx LINUM
            stab $00,x
            rts
; End of function romPOKE


; =============== S U B R O U T I N E =======================================

; FCT : additionne 0.5  ACC1
; STX : /
; IN  : ACC1  jour
; OUT : ACC1=ACC1+0.5

add1div2toACC1:
            ldx #aCst1div2
            bra FADD                    ; FCT : Add constant to ACC1
                                        ; STX : /
                                        ; ALG : /
                                        ; ST  : ACTIF
                                        ; IN  : X=pointer on constant
                                        ; OUT : ACC1=ACC1 + constant given by X
; End of function add1div2toACC1

; =============== S U B R O U T I N E =======================================

; FCT : Soustrait de ACC1 le nombre rel point   par X
; STX : /
; ST  : ACTIF
; IN  : ACC1  jour
;   X=pointeur sur un rel
; OUT : ACC1=FLOAT(PTR X) - ACC1

FSUB:
            jsr CONUPK                  ; FONCTION CONUPK
                                        ; FCT : Recopie le nombre point par X dans ACC2
                                        ; IN  : X: pointeur sur une constante
                                        ; OUT : ACC2 contient la constante pointe par (X)
                                        ;       B = Exposant du nombre
; End of function FSUB

; =============== S U B R O U T I N E =======================================

; FCT : Subtract ACC2 to ACC1
; STX : /
; ALG : /
; ST  : ACTIF
; IN  : ACC1 and ACC2 set
; OUT : ACC1=ACC1-ACC2

romMINUS:

            com ACC1+5
            com PRODSIGN
            bra romPLUS                 ; FCT : Add ACC2 to ACC1
                                        ; STX : /
                                        ; ALG : /
                                        ; ST  : ACTIF
                                        ; IN  : ACC1 and ACC2 set
                                        ;       B <> 0 : est une opration
                                        ; OUT : ACC1=ACC1+ACC2
                                        ;
; End of function romMINUS

; =============== S U B R O U T I N E =======================================

; FCT : Add constant to ACC1
; STX : /
; ALG : /
; ST  : ACTIF
; IN  : X=pointer on constant
; OUT : ACC1=ACC1 + constant given by X
;

FADD:
            jsr CONUPK                   ; FONCTION CONUPK
                                         ; FCT : Recopie le nombre point par X dans ACC2
                                         ; IN  : X: pointeur sur une constante
                                         ; OUT : ACC2 contient la constante pointe par (X)
                                         ;       B = Exposant du nombre
; End of function FADD

; =============== S U B R O U T I N E =======================================

; FCT : Add ACC2 to ACC1
; STX : /
; ALG : /
; ST  : ACTIF
; IN  : ACC1 and ACC2 set
;       B <> 0 : est une opration
; OUT : ACC1=ACC1+ACC2

romPLUS:

            tstb
            bne nextRomPlus
            jmp MOVA2A1ext              ; FCT : Recopie ACC2 tendu dans ACC1
                                        ; ST  : ACTIF
                                        ; IN  : ACC2 set
                                        ; OUT : ACC1=ACC2

nextRomPlus:
            ldx #ACC2                   ; X=pointer on 2nd argument

next2RomPlus:
            tab
            beq endRomPlus
            subb ACC1
            beq next10RomPlus
            bmi next3RomPlus
            staa ACC1
            ldaa ACC2+5
            staa ACC1+5
            ldx #ACC1
            negb

next3RomPlus:
            cmpb #$F8
            ble next10RomPlus
            clra
            lsr 1,x
            jsr FADD_ROLSHF             ; FCT : Effectue un rolling shift sur le float point par X
                                        ; IN  : X=pointe sur une zone contenant un float
                                        ; OUT : X, A,B modified

bcl4RomPlus:
            ldab PRODSIGN
            bpl next5RomPlus

NEGFAC:
            com 1,x
            com 2,x
            com 3,x
            com 4,x
            coma
            adca #$00

next5RomPlus:
            staa ACC1EXT
            ldaa ACC1+4
            adca ACC2+4
            staa ACC1+4
            ldaa ACC1+3
            adca ACC2+3
            staa ACC1+3
            ldaa ACC1+2
            adca ACC2+2
            staa ACC1+2
            ldaa ACC1+1
            adca ACC2+1
            staa ACC1+1
            tba
            bpl loc_F019

next6RomPlus:
            bcs bcl7RomPlus             ; NORMALIZE FAC1
            bsr sub_F03C

bcl7RomPlus:
            clrb

bcl8RomPlus:
            ldaa ACC1+1
            bne loc_F00F
            ldaa ACC1+2
            staa ACC1+1
            ldaa ACC1+3
            staa ACC1+2
            ldaa ACC1+4
            staa ACC1+3
            ldaa ACC1EXT
            staa ACC1+4
            clr ACC1EXT
            addb #$08
            cmpb #$28 ; '('
            blt bcl8RomPlus

ZEROFAC:
            clra

ZEROFAC1:
            staa ACC1                   ; EXP of float

ZEROFAC2:
            staa ACC1+5                 ; SIGN of float

endRomPlus:
            rts

next10RomPlus:
            bsr SHIFTR
            clc
            bra bcl4RomPlus
; End of function romPLUS

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR FMULT

loc_EFFF:
            incb
            asl ACC1EXT
            rol ACC1+4
            rol ACC1+3
            rol ACC1+2
            rol ACC1+1

loc_F00F:
            bpl loc_EFFF
            ldaa ACC1
            sba
            staa ACC1
            bls ZEROFAC
            SKIP2

loc_F019:
            bcs loc_F024
            asl ACC1EXT
            ldaa #$00
            staa ACC1EXT
            bra loc_F035

loc_F024:
            inc ACC1
            beq jmpPrintErrorMSg0x0A_OVERFLOW
            ror ACC1+1
            ror ACC1+2
            ror ACC1+3
            ror ACC1+4

loc_F035:
            bcc locret_F03B
            bsr sub_F04B
            beq loc_F024

locret_F03B:
            rts
; END OF FUNCTION CHUNK FOR FMULT

; =============== S U B R O U T I N E =======================================


sub_F03C:
            com ACC1+5
; End of function sub_F03C


; =============== S U B R O U T I N E =======================================

sub_F03F:
            com ACC1+1
            com ACC1+2
            com ACC1+3
            com ACC1+4
; End of function sub_F03F


; =============== S U B R O U T I N E =======================================


sub_F04B:
            ldx ACC1+3
            inx
            stx ACC1+3
            bne locret_F057
            ldx ACC1+1
            inx
            stx ACC1+1

locret_F057:
            rts
; End of function sub_F04B

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR FMULT

jmpPrintErrorMSg0x0A_OVERFLOW:
            ldab #cBAS_ERR_OVERFLOW
            jmp ERROR
; END OF FUNCTION CHUNK FOR FMULT

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR MLTPLY

SHIFT_TMPFT:
            ldx #TMPFLT-1
; END OF FUNCTION CHUNK FOR MLTPLY
; START OF FUNCTION CHUNK FOR SHIFTR

SHIFT_X:
            ldaa 4,x
            staa ACC1EXT
            ldaa 3,x
            staa 4,x
            ldaa 2,x
            staa 3,x
            ldaa 1,x
            staa 2,x
            ldaa ACC3+5
            staa 1,x
; END OF FUNCTION CHUNK FOR SHIFTR

; =============== S U B R O U T I N E =======================================

; FCT : Effectue un dcalage sur octet puis sur bit
; IN  : B
; OUT : A,B,X modified

SHIFTR:
            addb #$08
            ble SHIFT_X
            ldaa ACC1EXT
            subb #$08
            beq endFADD_ROLSHF

nextSHIFTR:
            asr 1,x
; End of function SHIFTR


; =============== S U B R O U T I N E =======================================

; FCT : Effectue un rolling shift sur le float point par X
; IN  : X=pointe sur une zone contenant un float
; OUT : X, A,B modified

FADD_ROLSHF:
            ror 2,x
            ror 3,x
            ror 4,x
            rora
            incb
            bne nextSHIFTR
endFADD_ROLSHF:
            rts
; End of function FADD_ROLSHF

; ---------------------------------------------------------------------------
conONE:     dc.b $81,$00,$00,$00,$00

;----------------
tabParamLOG:dc.b 3
            dc.b $7F,$5E,$56,$CB,$79            ; 0
            dc.b $80,$13,$9B, $B,$64            ; 5
            dc.b $80,$76,$38,$93,$16            ; 10
            dc.b $82,$38,$AA,$3B,$20            ; 15
;----------------
SQRHLF:     dc.b $80,$35,$04,$F3,$34            ; SQR(0.5)
SQRTWO:     dc.b $81,$35,$04,$F3,$34            ; SQR(2)
NEGHLF:     dc.b $80,$80,$00,$00,$00            ; -0.5
LOG2:       dc.b $80,$31,$72,$17,$F8            ; LOG(2) = LN(2) ! Terminologie anglosaxonne vs franaise

; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC LOG(X) : retourne le logarithme NATUREL (ou NEPERIEN) de X
; ALG : LN(F*2^N)=(N+LOG2(F))*LN(2)
;   approximation par polynome sur l'intervalle [0;1]
;   Si N=1/2 alors LN(F*2^N) = LN (F*SQR(2))
;                = (-0.5+LOG2(F))*LN(2)
; STX : A=LOG(10) : retourne 2.30258509
; OP  : $B7
; ST  : ACTIF
; IN  : ACC1 > 0
; OUT : ACC1=LOG(ACC1)

romLOG:

            jsr subSIGN                     ; FCT : retourne le signe du nombre rel contenu dans ACC1
                                            ; IN  : /
                                            ; OUT : B=$01 si ACC1 > 0
                                            ;       B=$00 si ACC1 = 0
                                            ;       B=$FF si ACC1 < 0
            bgt nextRomLOG
            jmp printErrorMSG_0x08_FC_FctIncorrect
; ---------------------------------------------------------------------------
; CALCULATE (F-SQR(.5))/(F+SQR(.5))
; ((F + SQR(1/2))/SQR(2)) - 1
;
;F - SQR(1/2)   F + SQR(1/2)
;------------ = ------------ - 1
;F + SQR(1/2)     SQR(2)
;
;Soit t =  (X+SRQ(1/2))/(SQR(2))    - 1
;(poly_log(t) - 0.5) * ln(2)
;
nextRomLOG:
            ldx #SQRHLF                 ; Pointer on SQR(0,5)
            ldaa ACC1
            suba #$80                   ; remove BIAS
            psha                        ; save
            ldaa #$80                   ; Result is ACC1 in range[0.5,1]
            staa ACC1
            jsr FADD                    ; FCT : Add constant to ACC1
                                        ; STX : /
                                        ; ALG : /
                                        ; ST  : ACTIF
                                        ; IN  : X=pointer on constant
                                        ; OUT : ACC1=ACC1 + constant given by X
            ldx #SQRTWO                 ; SQR(2)
            jsr FDIV_ACC1_BY_MEM
            ldx #conONE
            jsr FSUB                    ; FCT : Soustrait de ACC1 le nombre rel point par   X
                                        ; STX : /
                                        ; ST  : ACTIF
                                        ; IN  : ACC1  jour
                                        ;       X=pointeur sur un rel
                                        ; OUT : ACC1=FLOAT(PTR X) - ACC1
            ldx #tabParamLOG
            jsr subMapApproximation     ; FCT : applique la serie de taylor pointe  par X
                                        ; IN  : X=pointeur sur les paramtres de la  srie de taylor
                                        ; OUT : ACC1=POLY(ACC1)
            ldx #NEGHLF                 ; Ajoute -0,5
            jsr FADD                    ; FCT : Add constant to ACC1
                                        ; STX : /
                                        ; ALG : /
                                        ; ST  : ACTIF
                                        ; IN  : X=pointer on constant
                                        ; OUT : ACC1=ACC1 + constant given by X
                                        ;
            pulb
            jsr ADDACC
            ldx #LOG2                   ; LOG(2) = LN(2) ! Terminologie anglosaxonne vs franaise
; End of function romLOG


; =============== S U B R O U T I N E =======================================

; FCT : set ACC2 with constant pointed by X and multiply ACC1 by ACC2
; IN  : X=pointer of constant
; OUT : ACC1=ACC1*ACC2
;

FMULT:

            bsr CONUPK                  ; FONCTION CONUPK
                                        ; FCT : Recopie le nombre point par X dans ACC2
                                        ; IN  : X: pointeur sur une constante
                                        ; OUT : ACC2 contient la constante pointe par (X)
                                        ;       B = Exposant du nombre
; End of function FMULT

; =============== S U B R O U T I N E =======================================

; FCT : multiply ACC1 by ACC2
; ALG : /
; ST  : ACTIF
; IN  : ACC1 set
; OUT : ACC1=ACC1*ACC2

romMULT:
            beq endromMULT
            jsr MULDIV                 ; FCT : FIX UP THE EXPONENTS
                                       ; IN  : A=Exposant du nombre flottant
                                       ; OUT : Si A=$00 alors retourne ACC1=0
                                       ;       sinon fixe le signe de la mantisse du rsultat
                                       ; ERR : $0A : overflow error

nextRomMult:
            ldaa #$00                   ; initialise  0 le rsultat
            staa TMPFLT
            staa TMPFLT+1
            staa TMPFLT+2
            staa TMPFLT+3

MULT_FACOV:
            ldab ACC1+4
            bsr MLTPLY                  ; FCT : Multiply ACC2 by B and save result in TMPFLT
                                        ; IN  : B=nombre  multiplier
                                        ; OUT : TMPFLT = TMPFLT + ACC2 * B
            ldab ACC1EXT
            stab TMPFLT1+3

MULT_FACLO:
            ldab ACC1+3
            bsr MLTPLY                  ; FCT : Multiply ACC2 by B and save result in TMPFLT
                                        ; IN  : B=nombre  multiplier
                                        ; OUT : TMPFLT = TMPFLT + ACC2 * B
            ldab ACC1EXT
            stab TMPFLT1+2

MULT_FACMO:
            ldab ACC1+2
            bsr MLTPLY                  ; FCT : Multiply ACC2 by B and save result in TMPFLT
                                        ; IN  : B=nombre  multiplier
                                        ; OUT : TMPFLT = TMPFLT + ACC2 * B
            ldab ACC1EXT
            stab TMPFLT1+1

MULT_1:
            ldab ACC1+1
            bsr nextMLTPLY              ; FCT : do Multiply ACC2 by B and save result in TMPFLT
                                        ; IN  : B=nombre  multiplier
                                        ; OUT : TMPFLT = TMPFLT + ACC2 * B
            ldab ACC1EXT
            stab TMPFLT1
            jsr MVTFACC1                ; FCT : sauve TMPFLT dans ACC1
                                        ; IN  : TMPLT is set
                                        ; OUT : ACC1=TMPFLT
            jmp bcl7RomPlus
; End of function romMULT


; =============== S U B R O U T I N E =======================================

; FCT : Multiply ACC2 by B and save result in TMPFLT
; IN  : B=nombre  multiplier
; OUT : TMPFLT = TMPFLT + ACC2 * B

MLTPLY:
            bne nextMLTPLY              ; SHIFT FPA2 ONE BYTE TO RIGHT
            jmp SHIFT_TMPFT
; End of function MLTPLY


; =============== S U B R O U T I N E =======================================

; FCT : do Multiply ACC2 by B and save result in TMPFLT
; IN  : B=nombre  multiplier
; OUT : TMPFLT = TMPFLT + ACC2 * B

nextMLTPLY:
            sec

bcl1MLTPLY:
            ldaa TMPFLT
            rorb
            beq endromMULT
            bcc loc_F14D
            ldaa TMPFLT+3
            adda ACC2+4
            staa TMPFLT+3
            ldaa TMPFLT+2
            adca ACC2+3
            staa TMPFLT+2
            ldaa TMPFLT+1
            adca ACC2+2
            staa TMPFLT+1
            ldaa TMPFLT
            adca ACC2+1

loc_F14D:
            rora
            staa TMPFLT
            ror TMPFLT+1
            ror TMPFLT+2
            ror TMPFLT+3
            ror ACC1EXT
            clc
            bra bcl1MLTPLY

endromMULT:
            rts
; End of function nextMLTPLY


; =============== S U B R O U T I N E =======================================

; FONCTION CONUPK
; FCT : Recopie le nombre point par X dans ACC2
; IN  : X: pointeur sur une constante
; OUT : ACC2 contient la constante pointe par (X)
;       B = Exposant du nombre

CONUPK:
            ldd 1,x
            staa ACC2+5
            oraa #$80
            std ACC2+1
            ldab ACC2+5
            eorb ACC1+5
            stab PRODSIGN
            ldd 3,x
            std ACC2+3
            ldaa 0,x
            staa ACC2
            ldab ACC1
            rts
; End of function CONUPK


; =============== S U B R O U T I N E =======================================

; FCT : FIX UP THE EXPONENTS
; IN  : A=Exposant du nombre flottant
; OUT : Si A=$00 alors retourne ACC1=0
;       sinon fixe le signe de la mantisse du rsultat
; ERR : $0A : overflow error

MULDIV:
            tsta
            beq popReturnStackMULDIV
            adda ACC1
            rora
            rola
            bvc popReturnStackMULDIV        ; BRANCH IF EXPONENT TOO LARGE OR SMAL
            adda #$80
            staa ACC1
            bne saveResMantissaSignMULDIV
            jmp ZEROFAC2

saveResMantissaSignMULDIV:                         
            ldaa PRODSIGN
            staa ACC1+5
            rts

; IF sign(mantissa of ACC1) = POSITIVE THEN 'OV'erflow ERROR IF sign(mantissa of ACC1) = IS NEGATIVE THEN ACCA1 = 0
testSignMULDIV:
            ldaa ACC1+5
            coma
            bra setZeroOrErr0x0A_OverFlow

popReturnStackMULDIV:
            pula
            pula

setZeroOrErr0x0A_OverFlow:
            bmi jmpPrintErr0x0A_OVERFLOW
            jmp ZEROFAC

jmpPrintErr0x0A_OVERFLOW:
            jmp jmpPrintErrorMSg0x0A_OVERFLOW
; End of function MULDIV


; =============== S U B R O U T I N E =======================================

; FCT : Multiplie ACC1 par 10
; ALG : ACC2=ACC1 puis ACC1 * 4 puis ACC1=ACC1*4+ACC2 = 5* ACC1 puis (5*ACC1)*2
; IN  : ACC1 est  jour
; OUT : ACC1=ACC1*10

MUL10:
            jsr moveACC1toACC2              ; FCT : move ACC1 to ACC2
                                            ; IN  : /
                                            ; OUT : X,D modified
                                            ;       D=ACC1 et ACC1+1
                                            ;       P modified
            beq endMUL10
            adda #$02                       ; EXP de ACC1 +2 = ACC1 * 4 !
            bcs jmpPrintErr0x0A_OVERFLOW
            clr PRODSIGN
            jsr next2RomPlus
            inc ACC1                        ; multiplication par 2
            beq jmpPrintErr0x0A_OVERFLOW

endMUL10:
            rts
; End of function MUL10

; ---------------------------------------------------------------------------
CST_10:     dc.b $84,$20,$00,$00,$00

; =============== S U B R O U T I N E =======================================

; FCT : effectue une division par 10
; IN  :
; OUT : ACC1=ACC1/10

divBy10:
            jsr moveACC1toACC2              ; FCT : move ACC1 to ACC2
                                            ; IN  : /
                                            ; OUT : X,D modified
                                            ;       D=ACC1 et ACC1+1
                                            ;       P modified
            ldx #CST_10
            clrb
next1DivByX:
            stab PRODSIGN
            jsr MOVFM                       ; FCT : MOVE memory to ACC1
                                            ; IN  : X=FLOAT (5 bytes)
                                            ; OUT : A and X unmodified
            SKIP2

FDIV_ACC1_BY_MEM:
            bsr CONUPK                      ; FONCTION CONUPK
                                            ; FCT : Recopie le nombre point par X dans ACC2
                                            ; IN  : X: pointeur sur une constante
                                            ; OUT : ACC2 contient la constante pointe par (X)
                                            ;       B = Exposant du nombre
; End of function divBy10

; =============== S U B R O U T I N E =======================================

; FCT : divide ACC1 by ACC2
; STX : /
; ALG : /
; ST  : ACTIF
; IN  : ACC1 and ACC2 set
; OUT : ACC1=ACC1/ACC2
;

romDIV:
            beq errorDivideByZero
            neg ACC1
            bsr MULDIV                  ; FCT : FIX UP THE EXPONENTS
                                        ; IN  : A=Exposant du nombre flottant
                                        ; OUT : Si A=$00 alors retourne ACC1=0
                                        ;       sinon fixe le signe de la mantisse du rsultat
                                        ; ERR : $0A : overflow error
            inc ACC1
            beq jmpPrintErr0x0A_OVERFLOW
            ldx #TMPFLT
            ldab #$04
            stab EOLPNTR                ; cela sert  beaucoup de choses : op. binaires, etc.
            ldab #$01
bclromDIV:
            ldaa ACC1+1
            cmpa ACC2+1
            bne bcl2romDIV
            ldaa ACC1+2
            cmpa ACC2+2
            bne bcl2romDIV
            ldaa ACC1+3
            cmpa ACC2+3
            bne bcl2romDIV
            ldaa ACC1+4
            cmpa ACC2+4
            bne bcl2romDIV
            sec
bcl2romDIV:
            tpa
            rolb
            bcc next3romDIV
            stab $00,x
            inx
            dec EOLPNTR                 ; cela sert  beaucoup de choses : op. binaires, etc.
            bmi next7romDIV
            beq next6romDIV
            ldab #$01
next3romDIV:
            tap
            bcs next5romDIV
bcl4romDIV:
            asl ACC2+4
            rol ACC2+3
            rol ACC2+2
            rol ACC2+1
            bcs bcl2romDIV
            bmi bclromDIV
            bra bcl2romDIV

next5romDIV:
            ldaa ACC2+4
            suba ACC1+4
            staa ACC2+4
            ldaa ACC2+3
            sbca ACC1+3
            staa ACC2+3
            ldaa ACC2+2
            sbca ACC1+2
            staa ACC2+2
            ldaa ACC2+1
            sbca ACC1+1
            staa ACC2+1
            bra bcl4romDIV

next6romDIV:
            ldab #$40 ; '@'
            bra next3romDIV

next7romDIV:
            rorb
            rorb
            rorb
            stab ACC1EXT
            bsr MVTFACC1                ; FCT : sauve TMPFLT dans ACC1
                                        ; IN  : TMPLT is set
                                        ; OUT : ACC1=TMPFLT;
            jmp bcl7RomPlus

errorDivideByZero:
            ldab #cBAS_ERR_ZERODIV
            jmp ERROR
; End of function romDIV


; =============== S U B R O U T I N E =======================================

; FCT : sauve TMPFLT dans ACC1
; IN  : TMPLT is set
; OUT : ACC1=TMPFLT

MVTFACC1:
            ldx TMPFLT
            stx ACC1+1
            ldx TMPFLT+2
            stx ACC1+3
            rts
; End of function MVTFACC1


; =============== S U B R O U T I N E =======================================

; FCT : MOVE memory to ACC1
; IN  : X=FLOAT (5 bytes)
; OUT : A and X unmodified

MOVFM:
            psha
            ldd 1,x
            staa ACC1+5
            oraa #$80
            std ACC1+1
            clr ACC1EXT
            ldab 0,x
            ldx 3,x
            stx ACC1+3
            stab ACC1
            pula
            rts
; End of function MOVFM


; =============== S U B R O U T I N E =======================================


SAVEACC1toPTRTMP2:
            ldx #PTRTMP2
            bra MOVMF                   ; move ACC1 to memory (by X)
; End of function SAVEACC1toPTRTMP2

; =============== S U B R O U T I N E =======================================

SAVEACC1toPTRTMP1:
            ldx #PTRTMP1                ; TODO : Vraiment ? faire un bra MOVMF ? car le bra est plus rapide et prend moins de place ...
            SKIP2
; End of function SAVEACC1toPTRTMP1


; =============== S U B R O U T I N E =======================================

saveACC1toFORPNT:
            ldx FORPNT
MOVMF:
            ldaa ACC1                   ; move ACC1 to memory (by X)
            staa 0,x
            ldaa ACC1+5
            oraa #$7F
            anda ACC1+1
            staa 1,x
            ldaa ACC1+2
            staa 2,x
            ldaa ACC1+3
            staa 3,x
            ldaa ACC1+4
            staa 4,x
            rts
; End of function saveACC1toFORPNT


; =============== S U B R O U T I N E =======================================

; FCT : Recopie ACC2 tendu dans ACC1
; ST  : ACTIF
; IN  : ACC2 set
; OUT : ACC1=ACC2

MOVA2A1ext:
            ldaa ACC2+5
; End of function MOVA2A1ext


; =============== S U B R O U T I N E =======================================

; FCT : recopie ACC2 dans ACC1
; OP  : /
; ST  : ACTIF
; IN  : A = SIGNE de ACC1
; OUT : X modified

MOVA2A1:
            staa ACC1+5
            ldx ACC2
            stx ACC1
            clr ACC1EXT
            ldx ACC2+2
            stx ACC1+2
            ldx ACC2+3
            stx ACC1+3
            rts
; End of function MOVA2A1


; =============== S U B R O U T I N E =======================================

; FCT : move ACC1 to ACC2
; IN  : /
; OUT : X,D modified
;       D=ACC1 et ACC1+1
;       P modified

moveACC1toACC2:
            ldd ACC1
            std ACC2
            ldx ACC1+2
            stx ACC2+2
            ldx ACC1+4
            stx ACC2+4
            tsta
            rts
; End of function moveACC1toACC2


; =============== S U B R O U T I N E =======================================

; FCT : retourne le signe du nombre rel contenu dans ACC1
; IN  : /
; OUT : B=$01 si ACC1 > 0
;       B=$00 si ACC1 = 0
;       B=$FF si ACC1 < 0

subSIGN:
            ldab ACC1
            beq endSubSIGN

nextSubSIGN:
            ldab ACC1+5

next1SubSIGN:
            rolb
            ldab #$FF
            bcs endSubSIGN
            negb

endSubSIGN:
            rts
; End of function subSIGN


; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC SGN : retourne le signe de l'expression
; STX : A=SGN(-12)  : retourne -1
;       B=SGN(0)    : retourne 0
;       C=SGN(14.3) : retourne 1
; OP  : $B1
; ST  : ACTIF
; IN  : le flot  interprter
; OUT : ACC1 avec le signe de l'expression

romSGN:
            bsr subSIGN                     ; FCT : retourne le signe du nombre rel contenu dans ACC1
                                            ; IN  : /
                                            ; OUT : B=$01 si ACC1 > 0
                                            ;       B=$00 si ACC1 = 0
                                            ;       B=$FF si ACC1 < 0
FLOAT:
            stab ACC1+1                     ; CONVERT (B) INTO ACC1, AS SIGNED VALUE -128 TO +127
            clr ACC1+2
            ldab #$88 ; ''
FLOAT1:
            ldaa ACC1+1                     ; FLOAT UNSIGNED VALUE IN ACC1+1,2
            suba #$80
FLOAT2:
            stab ACC1                       ; FLOAT UNSIGNED VALUE IN ACC1+1,2
                                            ; (B) = EXPONENT
                                            ; C=0 TO MAKE VALUE NEGATIVE
                                            ; C=1 TO MAKE VALUE POSITIVE
            ldaa #$00
            tab
            std ACC1+3
            staa ACC1EXT
            staa ACC1+5
            jmp next6RomPlus                ; NORMALIZE FAC1
; End of function romSGN


; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC ABS(X) : retourne la valeur absolue d'un nombre de type float
; STX : A=ABS(-5.4) retourne 5.4
; OP  : $B3
; ST  : ACTIF
; IN  : /
; OUT : ACC1=ABS(ACC1)

romABS:
            clr ACC1+5
            rts
; End of function romABS


; =============== S U B R O U T I N E =======================================

; FCT : COMPARE A PACKED FLOATING POINT NUMBER POINTED TO BY (X) 
;       TO AN UNPACKED FP NUMBER IN ACC1. 
; IN  : X=Adresse d'un float
; OUT : ZERO FLAG SET AND B = 0, IF EQUAL
;       ACCB = 1   IF ACC1 > (X)
;       ACCB = $FF IF ACC1 < (X)

FCOMP2:
            ldab 0,x
            beq subSIGN                     ; FCT : retourne le signe du nombre rel contenu dans ACC1
                                            ; IN  : /
                                            ; OUT : B=$01 si ACC1 > 0
                                            ;       B=$00 si ACC1 = 0
                                            ;       B=$FF si ACC1 < 0
            ldab 1,x
            eorb ACC1+5
            bmi nextSubSIGN
; End of function FCOMP2


; =============== S U B R O U T I N E =======================================


SUB_FCOMP:
            ldab ACC1
            cmpb 0,x
            bne loc_F306
            ldab 1,x
            orab #$7F
            andb ACC1+1
            cmpb 1,x
            bne loc_F306
            ldab ACC1+2
            cmpb 2,x
            bne loc_F306
            ldab ACC1+3
            cmpb 3,x
            bne loc_F306
            ldab ACC1+4
            subb 4,x
            bne loc_F306
            rts

loc_F306:
            rorb
            eorb ACC1+5
            bra next1SubSIGN
; End of function SUB_FCOMP


; =============== S U B R O U T I N E =======================================

; FCT : effectue la fonction int sur ACC1
; IN  : ACC1 mise  jour
; OUT : ACC1=INT(ACC1)

QUICK_INT:
            ldab ACC1
            beq clearACC1                   ; FCT : met  jour ACC1 avec B
                                            ; IN  : B=valeur  stocker dans ACC1
                                            ; OUT : ACC1[1..4]=B
            subb #$A0 ; ''
            ldaa ACC1+5
            bpl nextQUICK_INT
            com ACC3+5
            jsr sub_F03F

nextQUICK_INT:
            ldx #$00C9
            cmpb #$F8
            bgt next1QUICK_INT
            jsr SHIFTR 
            clr ACC3+5
            rts

next1QUICK_INT:
            clr ACC3+5
            ldaa ACC1+5
            rola
            ror ACC1+1
            jmp FADD_ROLSHF                 ; FCT : Effectue un rolling shift sur le float point par X
                                            ; IN  : X=pointe sur une zone contenant un float
                                            ; OUT : X, A,B modified
; End of function QUICK_INT

; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC INT : retourne la partie entire de l'expression
; STX : A=INT(5.25)  : retourne 5
; OP  : $B2
; ST  : ACTIF
; IN  : le flot  interprter
; OUT : ACC1 avec la partie entire de l'expression

romINT:
            ldab ACC1
            cmpb #$A0 ; ''
            bcc endClearACC1
            bsr QUICK_INT               ; FCT : effectue la fonction int sur ACC1
                                        ; IN  : ACC1 mise  jour
                                        ; OUT : ACC1=INT(ACC1)
            stab ACC1EXT
            ldaa ACC1+5
            stab ACC1+5
            suba #$80
            ldaa #$A0 ; ''
            staa ACC1
            ldaa ACC1+4
            staa CHARAC                 ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            jmp next6RomPlus            ; NORMALIZE FAC1
; End of function romINT


; =============== S U B R O U T I N E =======================================

; FCT : met  jour ACC1 avec B
; IN  : B=valeur  stocker dans ACC1
; OUT : ACC1[1..4]=B

clearACC1:
            stab ACC1+1
            stab ACC1+2
            stab ACC1+3
            stab ACC1+4

endClearACC1:
            rts
; End of function clearACC1


; =============== S U B R O U T I N E =======================================

; FCT : Float IN : parse a number
;       NUMBER INPUT IS LEFT IN ACC1.
;       AT ENTRY [TXTPTR] POINTS TO THE FIRST CHARACTER IN A TEXT BUFFER.
;       THE FIRST CHARACTER IS ALSO IN ACCA. FIN PACKS THE DIGITS
;       INTO THE FAC AS AN INTEGER AND KEEPS TRACK OF WHERE THE
;       DECIMAL POINT IS. [DPTFLG] TELL WHETHER A DP HAS BEEN
;       SEEN. [DECCNT] IS THE NUMBER OF DIGITS AFTER THE DP.
;       AT THE END [DECCNT] AND THE EXPONENT ARE USED TO
;       DETERMINE HOW MANY TIMES TO MULTIPLY OR DIVIDE BY TEN
;       TO GET THE CORRECT NUMBER.
; IN  : C=1 : The first character is numeric
;       C=0 : The first character is not numeric
; OUT : ACC1

FIN:
            jsr vHOOK9_PARSENUMBER
init_PN:
            ldx #$0000
            stx ACC1+5
            stx ACC1
            stx ACC1+2
            stx ACC1+3
            stx LOWTR
            stx PTRTMP2
            bcs FINDG1

isMinus_FIN:
            cmpa #cMATH_MINUS                   ; '-'
            bne isPlus_FIN
            com NBLOOP
            bra getNextChar_FIN

isPlus_FIN:
            cmpa #cMATH_PLUS                    ; '+'
            bne isDot_FIN

getNextChar_FIN:
            jsr.w   CHRGET                      ; OJE 14/02/2020 V3
                                                ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                                ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                                ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                                ; NOT C= NUMERIC ("0" THRU "9")
                                                ; Z= ":" OR END-OF-LINE (A NULL)
                                                ; [ACCA] = NEW CHAR.
                                                ; [TXTPTR]=[TXTPTR]+1
            bcs FINDG1

isDot_FIN:
            cmpa #cMATH_SEP_FLT                 ; '.'
            beq loc_F3B0

isExp_FIN:
            cmpa #$45                           ; 'E'
            bne FINE

getSignExp_FIN:
            jsr.W   CHRGET                      ; OJE 14/02/2020 V3
                                                ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                                ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                                ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                                ; NOT C= NUMERIC ("0" THRU "9")
                                                ; Z= ":" OR END-OF-LINE (A NULL)
                                                ; [ACCA] = NEW CHAR.
                                                ; [TXTPTR]=[TXTPTR]+1
            bcs addDigitToNumber
            cmpa #cBAS_TOKEN_MINUS
            beq setSignExp_GetNextDigit_FIN
            cmpa #cMATH_MINUS                   ; '-'
            beq setSignExp_GetNextDigit_FIN
            cmpa #cBAS_TOKEN_PLUS
            beq getNextNumber_FIN
            cmpa #cMATH_PLUS                    ; '+'
            beq getNextNumber_FIN
            bra loc_F3A6

setSignExp_GetNextDigit_FIN:
            com LOWTR+1

getNextNumber_FIN:
            jsr.w   CHRGET                      ; OJE 14/02/2020 V3
                                                ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                                ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                                ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                                ; NOT C= NUMERIC ("0" THRU "9")
                                                ; Z= ":" OR END-OF-LINE (A NULL)
                                                ; [ACCA] = NEW CHAR.
                                                ; [TXTPTR]=[TXTPTR]+1
            bcs addDigitToNumber

loc_F3A6:
            tst LOWTR+1
            beq FINE
            neg LOWTR
            bra FINE

loc_F3B0:
            com PTRTMP2+1
            bne getNextChar_FIN

FINE:
            ldaa LOWTR
            suba PTRTMP2
            staa LOWTR
            beq FINQNG                          ; NEGATE ?
            bpl FINMUL                          ; Positive so multiply

FINDIV:
            jsr divBy10                         ; FCT : effectue une division par 10
                                                ; IN  :
                                                ; OUT : ACC1=ACC1/10
            inc LOWTR
            bne FINDIV
            bra FINQNG

FINMUL:
            jsr MUL10                           ; FCT : Multiplie ACC1 par 10
                                                ; ALG : ACC2=ACC1 puis ACC1 * 4 puis ACC1=ACC1*4+ACC2 = 5* ACC1 puis (5*ACC1)*2
                                                ; IN  : ACC1 est  jour
                                                ; OUT : ACC1=ACC1*10
            dec LOWTR
            bne FINMUL

FINQNG:
            ldaa NBLOOP
            bpl endClearACC1
            jmp ROM_NEG                         ; FCT : routine NEG(X) : retourne l'oppos de ACC1
                                                ; STX : /
                                                ; OP  : /
                                                ; ST  : ACTIF
                                                ; IN  : /
                                                ; OUT : ACC1=NEG(ACC1)

FINDG1:

            ldab PTRTMP2
            subb PTRTMP2+1
            stab PTRTMP2
            psha
            jsr MUL10                           ; FCT : Multiplie ACC1 par 10
                                                ; ALG : ACC2=ACC1 puis ACC1 * 4 puis ACC1=ACC1*4+ACC2 = 5* ACC1 puis (5*ACC1)*2
                                                ; IN  : ACC1 est  jour
                                                ; OUT : ACC1=ACC1*10
            pulb
            subb #$30                           ; '0'
            bsr ADDACC 
            bra getNextChar_FIN
; End of function FIN


; =============== S U B R O U T I N E =======================================

ADDACC:

            jsr SAVEACC1toPTRTMP1
            jsr FLOAT                   ; CONVERT (B) INTO ACC1, AS SIGNED VALUE -128 TO +127
            ldx #PTRTMP1
            jmp FADD                    ; FCT : Add constant to ACC1
                                        ; STX : /
                                        ; ALG : /
                                        ; ST  : ACTIF
                                        ; IN  : X=pointer on constant
                                        ; OUT : ACC1=ACC1 + constant given by X
; End of function ADDACC

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR FIN

addDigitToNumber:
            ldab LOWTR                  ; effectue NUMBER=NUMBER*10+A
            aslb
            aslb
            addb LOWTR
            aslb
            suba #$30 ; '0'
            aba
            staa LOWTR
            bra getNextNumber_FIN
; END OF FUNCTION CHUNK FOR FIN
; ---------------------------------------------------------------------------
CENT_MILLIONS:      dc.b $9B,$3E,$BC,$1F,$FD
UN_MILLIARD_MOINS_1:dc.b $9E,$6E,$6B,$27,$FD
UN_MILLIARD:        dc.b $9E,$6E,$6B,$28,$00

; =============== S U B R O U T I N E =======================================
; FCT : Imprime IN puis le numro de ligne
; IN  : CURLIN  jour
; OUT : /
printIN:
            ldx #(aIN-1)
            bsr jmpOUTX_LIPTR
            ldd CURLIN
; End of function printIN


; =============== S U B R O U T I N E =======================================

; FCT : Imprime le chiffre contenu dans D
; IN  : D : le chiffre  afficher
; OUT : A,B,X modified

LIPTR:
            std ACC1+1
            ldab #$90
            sec
            jsr FLOAT2                  ; FLOAT UNSIGNED VALUE IN ACC1+1,2
                                        ; (B) = EXPONENT
                                        ; C=0 TO MAKE VALUE NEGATIVE
                                        ; C=1 TO MAKE VALUE POSITIVE
            bsr FOUT                    ; FCT : CONVERT (ACC1) TO STRING STARTING AT STACK
                                        ; IN  : /
                                        ; OUT : X=Pointeur sur le tampon de conversion Float -> String

jmpOUTX_LIPTR:
            jmp OS_OUTTX                ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                        ; IN : X=pointeur sur une chane de caractres termine par un 0
                                        ; OUT: A,B,X modified
; End of function LIPTR

; =============== S U B R O U T I N E =======================================

; FCT : CONVERT (ACC1) TO STRING STARTING AT STACK
; IN  : /
; OUT : X=Pointeur sur le tampon de conversion Float -> String

FOUT:

            ldx #(FTAMPON+1)                ; Tampon pour conversion float -> STRING
; End of function FOUT


; =============== S U B R O U T I N E =======================================

; FCT : "STR$" FUNCTION ENTERS HERE,
; IN  : X=Pointeur sur le tampon de conversion Float -> String
; OUT : X=Pointeur sur le tampon de conversion Float -> String
;       A et B modified

FOUT1:
            ldaa #cOS_SPACE                 ; ' ' ; fixe le signe de la conversion (blanc ou -)
            ldab ACC1+5
            bpl nextFOUT1
            ldaa #cMATH_MINUS               ; '-'

nextFOUT1:
            staa 0,x
            staa ACC1+5
            stx STRNG2
            inx
            ldaa #$30 ; '0'

isZERO:
            ldab ACC1
            bne next1FOUT1
            jmp STORE_LAST_CAR_FOUT1

next1FOUT1:
            clra
            cmpb #$80
            bhi next2FOUT1
            ldx #UN_MILLIARD                ; multiplication par 1 milliard
            jsr FMULT                       ; FCT : set ACC2 with constant pointed by X and multiply ACC1 by ACC2
                                            ; IN  : X=pointer of constant
                                            ; OUT : ACC1=ACC1*ACC2
            ldaa #$F7 ; ''

next2FOUT1:
            staa PTRTMP2

bcl3FOUT1:
            ldx #UN_MILLIARD_MOINS_1        ; compare avec 1 MILLIARD - 1
            jsr SUB_FCOMP
            bgt DIV_BY_10_FOUT1

bcl4FOUT1:
            ldx #CENT_MILLIONS
            jsr SUB_FCOMP
            bgt next6FOUT1

MUL_BY_10_FOUT1:
            jsr MUL10                       ; FCT : Multiplie ACC1 par 10
                                            ; ALG : ACC2=ACC1 puis ACC1 * 4 puis ACC1=ACC1*4+ACC2 = 5* ACC1 puis (5*ACC1)*2
                                            ; IN  : ACC1 est  jour
                                            ; OUT : ACC1=ACC1*10
            dec PTRTMP2
            bra bcl4FOUT1

DIV_BY_10_FOUT1:
            jsr divBy10                     ; FCT : effectue une division par 10
                                            ; IN  :
                                            ; OUT : ACC1=ACC1/10
            inc PTRTMP2
            bra bcl3FOUT1

next6FOUT1:
            jsr add1div2toACC1              ; FCT : additionne 0.5  ACC1
                                            ; STX : /
                                            ; IN  : ACC1  jour
                                            ; OUT : ACC1=ACC1+0.5
            jsr QUICK_INT                   ; FCT : effectue la fonction int sur ACC1
                                            ; IN  : ACC1 mise  jour
                                            ; OUT : ACC1=INT(ACC1)
            ldab #$01
            ldaa PTRTMP2
            adda #$0A
            bmi next7FOUT1
            cmpa #$0B
            bcc next7FOUT1
            deca
            tab
            ldaa #$02

next7FOUT1:
            deca
            deca
            staa LOWTR
            stab PTRTMP2
            bgt next9FOUT1
            ldx STRNG2
            ldaa #cMATH_SEP_FLT             ; '.'
            inx
            staa 0,x
            tstb
            beq next8FOUT
            ldaa #$30 ; '0'
            inx
            staa 0,x

next8FOUT:
            stx STRNG2

next9FOUT1:
            ldx #tabPuiss10
            ldab #$80

bcl10FOUT1:
            ldaa ACC1+4
            adda 3,x
            staa ACC1+4
            ldaa ACC1+3
            adca 2,x
            staa ACC1+3
            ldaa ACC1+2
            adca 1,x
            staa ACC1+2
            ldaa ACC1+1
            adca 0,x
            staa ACC1+1
            incb
            rorb
            rolb
            bvc bcl10FOUT1
            bcc next11FOUT1
            subb #$B
            negb

next11FOUT1:
            addb #$2F ; '/'
            inx
            inx
            inx
            inx
            stx VARPNT                  ; Pointer used in array building
            ldx STRNG2
            inx
            tba
            anda #$7F
            staa 0,x
            dec PTRTMP2
            bne next12FOUT1
            ldaa #cMATH_SEP_FLT         ; '.'
            inx
            staa 0,x

next12FOUT1:
            stx STRNG2
            ldx VARPNT                  ; Pointer used in array building
            comb
            andb #$80
            cpx #(tabPuiss10+9*4)       ; Pointer sur l'octet suivant la fin du tableau tabPuiss10
            bne bcl10FOUT1
            ldx STRNG2

bcl13FOUT1:
            ldaa 0,x
            dex
            cmpa #$30 ; '0'
            beq bcl13FOUT1
            cmpa #cMATH_SEP_FLT         ; '.'
            beq next14FOUT1
            inx

next14FOUT1:
            ldaa #cMATH_PLUS            ; '+'
            ldab LOWTR
            beq END_STRING_BY_0_FOUT1
            bpl next15FOUT1
            ldaa #cMATH_MINUS           ; '-'
            negb

next15FOUT1:
            staa 2,x
            ldaa #$45 ; 'E'
            staa 1,x
            ldaa #$2F ; '/'

bcl16FOUT1:
            inca
            subb #$0A
            bcc bcl16FOUT1
            addb #$3A ; ':'
            staa 3,x
            stab 4,x
            clr 5,x
            bra returnPtrStr_FOUT1

STORE_LAST_CAR_FOUT1:
            staa 0,x

END_STRING_BY_0_FOUT1:
            clr 1,x

returnPtrStr_FOUT1:
            ldx #(FTAMPON+1)                ; Tampon pour conversion float -> STRING

endFOUT1:
            rts
; End of function FOUT1

; ---------------------------------------------------------------------------
aCst1div2:  dc.b $80,$00,$00,$00,$00

;----------------
tabPuiss10: dc.b $FA,$0A,$1F,$00            ; 0
            dc.b $00,$98,$96,$80            ; 4
            dc.b $FF,$F0,$BD,$C0            ; 8
            dc.b $00,$01,$86,$A0            ; 12
            dc.b $FF,$FF,$D8,$F0            ; 16
            dc.b $00,$00,$03,$E8            ; 20
            dc.b $FF,$FF,$FF,$9C            ; 24
            dc.b $00,$00,$00,$0A            ; 28
            dc.b $FF,$FF,$FF,$FF            ; 32

; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC SQR(X) : retourne la racine carre de X
; STX : A=SQR(4) : retourne 2
; OP  : $B6
; ST  : ACTIF
; IN  : /
; OUT : ACC1=SQR(X)

romSQR:
            jsr moveACC1toACC2              ; FCT : move ACC1 to ACC2
                                            ; IN  : /
                                            ; OUT : X,D modified
                                            ;       D=ACC1 et ACC1+1
                                            ;       P modified
            ldx #aCst1div2
            jsr MOVFM                       ; FCT : MOVE memory to ACC1
                                            ; IN  : X=FLOAT (5 bytes)
                                            ; OUT : A and X unmodified
; End of function romSQR

; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC ^ : retourne X^Y
; ALG : N.B. 0^0=1
;   FIRST CHECK IF Y=0. IF SO, THE RESULT IS 1.
;   NEXT CHECK IF X=0. IF SO THE RESULT IS 0.
;   THEN CHECK IF X.GT.0. IF NOT CHECK THAT Y IS AN INTEGER.
;   IF SO, NEGATE X, SO THAT LOG DOESN'T GIVE FCERR.
;   IF X IS NEGATIVE AND Y IS ODD, NEGATE THE RESULT
;   RETURNED BY EXP.
;   TO COMPUTE THE RESULT USE X^Y=EXP((Y*LOG(X)).
; STX : A=2^3: retourne 8
; OP  : $B1
; ST  : ACTIF
; IN  : /
; OUT : ACC1=ACC2^ACC1

FPWRT:
            beq romEXP                  ; FCT : COMMANDE BASIC EXP(X) : retourne l'exponentiel de X
                                        ; ALG : FIRST SAVE THE ORIGINAL ARGUMENT AND MULTIPLY THE FAC BY
                                        ;       LOG2(E). THE RESULT IS USED TO DETERMINE IF OVERFLOW
                                        ;       WILL OCCUR SINCE EXP(X)=2^(X*LOG2(E)) WHERE
                                        ;       LOG2(E)=LOG(E) BASE 2. THEN SAVE THE INTEGER PART OF
                                        ;       THIS TO SCALE THE ANSWER AT THE END. SINCE
                                        ;       2^Y=2^INT(Y)*2^(Y-INT(Y)) AND 2^INT(Y) IS EASY TO COMPUTE.
                                        ;       NOW COMPUTE 2^(X*LOG2(E)-INT(X*LOG2(E)) BY
                                        ;       P(LN(2)*(INT(X*LOG2(E))+1)-X) WHERE P IS AN APPROXIMATION
                                        ;       POLYNOMIAL. THE RESULT IS THEN SCALED BY THE POWER OF 2
                                        ;       PREVIOUSLY SAVED.
                                        ; STX : A=EXP(10) : retourne 22026.4658
                                        ; OP  : $B8
                                        ; ST  : ACTIF
                                        ; IN  : ACC1
                                        ; OUT : ACC1=EXP(ACC1)
            tsta
            bne FPWRT1
            ldaa ACC1+5
            bpl FPWRT0                  ; Si X=0 alors ACC1=0
            jmp errorDivideByZero

FPWRT0:
            jmp ZEROFAC1

FPWRT1:
            ldx #PTRTMP3
            jsr MOVMF                   ; move ACC1 to memory (by X)
            clrb
            ldaa ACC2+5                 ; A=SGN(ACC1)
            bpl FPWRT2
            jsr romINT                  ; FCT : COMMANDE BASIC INT : retourne la partie entire de l'expression
                                        ; STX : A=INT(5.25)  : retourne 5
                                        ; OP  : $B2
                                        ; ST  : ACTIF
                                        ; IN  : le flot  interprter
                                        ; OUT : ACC1 avec la partie entire  de l'expression
            ldx #PTRTMP3
            ldaa ACC2+5
            jsr SUB_FCOMP
            bne FPWRT2
            coma
            ldab CHARAC                 ; sert  tout : stockage d'un caractre, de valeur pour opration binaire

FPWRT2:

            jsr MOVA2A1                 ; FCT : recopie ACC2 dans ACC1
                                        ; OP  : /
                                        ; ST  : ACTIF
                                        ; IN  : A = SIGNE de ACC1
                                        ; OUT : X modified
            pshb
            jsr romLOG                  ; FCT : COMMANDE BASIC LOG(X) : retourne le logarithme NATUREL (ou NEPERIEN) de X
                                        ; ALG : LN(F*2^N)=(N+LOG2(F))*LN(2)
                                        ;       approximation par polynome sur l'intervalle [0;1]
                                        ;       Si N=1/2 alors LN(F*2^N) = LN (F*SQR(2))
                                        ;                    = (-0.5+LOG2(F))*LN(2)
                                        ; STX : A=LOG(10) : retourne 2.30258509
                                        ; OP  : $B7
                                        ; ST  : ACTIF
                                        ; IN  : ACC1 > 0
                                        ; OUT : ACC1=LOG(ACC1)
            ldx #PTRTMP3
            jsr FMULT                   ; multiply ACC1 times LOG(X)
            bsr romEXP                  ; FCT : COMMANDE BASIC EXP(X) : retourne l'exponentiel de X
                                        ; ALG : FIRST SAVE THE ORIGINAL ARGUMENT AND MULTIPLY THE FAC BY
                                        ;       LOG2(E). THE RESULT IS USED TO DETERMINE IF OVERFLOW
                                        ;       WILL OCCUR SINCE EXP(X)=2^(X*LOG2(E)) WHERE
                                        ;       LOG2(E)=LOG(E) BASE 2. THEN SAVE THE INTEGER PART OF
                                        ;       THIS TO SCALE THE ANSWER AT THE END. SINCE
                                        ;       2^Y=2^INT(Y)*2^(Y-INT(Y)) AND 2^INT(Y) IS EASY TO COMPUTE.
                                        ;       NOW COMPUTE 2^(X*LOG2(E)-INT(X*LOG2(E)) BY
                                        ;       P(LN(2)*(INT(X*LOG2(E))+1)-X) WHERE P IS AN APPROXIMATION
                                        ;       POLYNOMIAL. THE RESULT IS THEN SCALED BY THE POWER OF 2
                                        ;       PREVIOUSLY SAVED.
                                        ; STX : A=EXP(10) : retourne 22026.4658
                                        ; OP  : $B8
                                        ; ST  : ACTIF
                                        ; IN  : ACC1
                                        ; OUT : ACC1=EXP(ACC1)
            pula                        ; est-ce pair ?
            rora
            bcc endFOUT1
; End of function FPWRT


; =============== S U B R O U T I N E =======================================

; FCT : routine NEG(X) : retourne l'oppos de ACC1
; STX : /
; OP  : /
; ST  : ACTIF
; IN  : /
; OUT : ACC1=NEG(ACC1)

ROM_NEG:
            ldaa ACC1
            beq END_ROM_NEG
            com ACC1+5

END_ROM_NEG:
            rts
; End of function ROM_NEG

; ---------------------------------------------------------------------------
aCst1DivLn2:dc.b $81,$38,$AA,$3B,$29
;----------------
tabEXP:     dc.b 7
            dc.b $71,$34,$58,$3E,$56            ; 0
            dc.b $74,$16,$7E,$B3,$1B            ; 5
            dc.b $77,$2F,$EE,$E3,$85            ; 10
            dc.b $7A,$1D,$84,$1C,$2A            ; 15
            dc.b $7C,$63,$59,$58,$0A            ; 20
            dc.b $7E,$75,$FD,$E7,$C6            ; 25
            dc.b $80,$31,$72,$18,$10            ; 30
            dc.b $81,$00,$00,$00,$00            ; 35

; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC EXP(X) : retourne l'exponentiel de X
; ALG : FIRST SAVE THE ORIGINAL ARGUMENT AND MULTIPLY THE FAC BY
;   LOG2(E). THE RESULT IS USED TO DETERMINE IF OVERFLOW
;   WILL OCCUR SINCE EXP(X)=2^(X*LOG2(E)) WHERE
;   LOG2(E)=LOG(E) BASE 2. THEN SAVE THE INTEGER PART OF
;   THIS TO SCALE THE ANSWER AT THE END. SINCE
;   2^Y=2^INT(Y)*2^(Y-INT(Y)) AND 2^INT(Y) IS EASY TO COMPUTE.
;   NOW COMPUTE 2^(X*LOG2(E)-INT(X*LOG2(E)) BY
;   P(LN(2)*(INT(X*LOG2(E))+1)-X) WHERE P IS AN APPROXIMATION
;   POLYNOMIAL. THE RESULT IS THEN SCALED BY THE POWER OF 2
;   PREVIOUSLY SAVED.
; STX : A=EXP(10) : retourne 22026.4658
; OP  : $B8
; ST  : ACTIF
; IN  : ACC1
; OUT : ACC1=EXP(ACC1)

romEXP:
            ldx #aCst1DivLn2
            bsr jmpFMULT_SubMapApproximxation
            jsr SAVEACC1toPTRTMP1
            ldaa ACC1
            cmpa #$88 ; ''
            bcs next1RomEXP

nextRomEXP:
            jmp testSignMULDIV

next1RomEXP:
            jsr romINT                  ; FCT : COMMANDE BASIC INT : retourne la partie entire de l'expression
                                        ; STX : A=INT(5.25)  : retourne 5
                                        ; OP  : $B2
                                        ; ST  : ACTIF
                                        ; IN  : le flot  interprter
                                        ; OUT : ACC1 avec la partie entire  de l'expression
            ldaa CHARAC                 ; sert  tout : stockage d'un caractre, de valeur pour opration binaire
            adda #$81
            beq nextRomEXP
            deca
            psha
            ldx #PTRTMP1
            jsr FSUB                    ; FCT : Soustrait de ACC1 le nombre rel point par   X
                                        ; STX : /
                                        ; ST  : ACTIF
                                        ; IN  : ACC1  jour
                                        ;       X=pointeur sur un rel
                                        ; OUT : ACC1=FLOAT(PTR X) - ACC1
            ldx #tabEXP
            bsr saveXBeforeDoPOLYNOMIAL
            clr PRODSIGN
            pula
            jsr MULDIV                  ; FCT : FIX UP THE EXPONENTS
                                        ; IN  : A=Exposant du nombre flottant
                                        ; OUT : Si A=$00 alors retourne ACC1=0
                                        ;       sinon fixe le signe de la mantisse du rsultat
                                        ; ERR : $0A : overflow error
            rts
; End of function romEXP


; =============== S U B R O U T I N E =======================================

; FCT : applique la serie de taylor pointe par X
; IN  : X=pointeur sur les paramtres de la srie de taylor
; OUT : ACC1=POLY(ACC1)

subMapApproximation:
            stx STRNG2
            jsr SAVEACC1toPTRTMP1
            bsr jmpFMULT_SubMapApproximxation
            bsr doPOLYNOMIAL                ; FCT : Calcule la srie de taylor
                                            ; IN  : X=pointeur sur les paramtres de la srie de taylor
                                            ; OUT : ACC1=POLY(ACC1)
            ldx #PTRTMP1
jmpFMULT_SubMapApproximxation:
            jmp FMULT                       ; FCT : set ACC2 with constant pointed by X and multiply ACC1 by ACC2
                                            ; IN  : X=pointer of constant
                                            ; OUT : ACC1=ACC1*ACC2
; End of function subMapApproximation

; =============== S U B R O U T I N E =======================================


saveXBeforeDoPOLYNOMIAL:
            stx STRNG2
; End of function saveXBeforeDoPOLYNOMIAL


; =============== S U B R O U T I N E =======================================

; FCT : Calcule la srie de taylor
; IN  : X=pointeur sur les paramtres de la srie de taylor
; OUT : ACC1=POLY(ACC1)

doPOLYNOMIAL:
            jsr SAVEACC1toPTRTMP2
            ldx STRNG2
            ldab 0,x
            stab NBLOOP
            inx
            stx STRNG2

bclDoPOLYNOMIAL:
            bsr jmpFMULT_SubMapApproximxation
            ldx STRNG2
            ldab #cBAS_BYTES_PER_VARIABLE   ; $05
            abx
            stx STRNG2
            jsr FADD                        ; FCT : Add constant to ACC1
                                            ; STX : /
                                            ; ALG : /
                                            ; ST  : ACTIF
                                            ; IN  : X=pointer on constant
                                            ; OUT : ACC1=ACC1 + constant given by X
            ldx #PTRTMP2
            dec NBLOOP
            bne bclDoPOLYNOMIAL
            rts
; End of function doPOLYNOMIAL


; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC RND : retourne une valeur pseudo-alatoire entre 1 et n
; STX : PRINT RND(15) retourne 5.4
; OP  : $B5
; ST  : ACTIF
; IN  : /
; OUT : ACC1=nombre pseudo-alatoire entre 1 et n

romRND:
            jsr subSIGN                     ; FCT : retourne le signe du nombre rel contenu dans ACC1
                                            ; IN  : /
                                            ; OUT : B=$01 si ACC1 > 0
                                            ;       B=$00 si ACC1 = 0
                                            ;       B=$FF si ACC1 < 0
            bmi doRND
            beq getENTROPYbeforDoRND
            bsr j_romINT_RomRND
            jsr SAVEACC1toPTRTMP1
            bsr getENTROPYbeforDoRND
            ldx #PTRTMP1
            bsr jmpFMULT_SubMapApproximxation
            ldx #conONE
            jsr FADD                        ; FCT : Add constant to ACC1
                                            ; STX : /
                                            ; ALG : /
                                            ; ST  : ACTIF
                                            ; IN  : X=pointer on constant
                                            ; OUT : ACC1=ACC1 + constant given by X

j_romINT_RomRND:
            jmp romINT                      ; FCT : COMMANDE BASIC INT : retourne la partie entire de l'expression
                                            ; STX : A=INT(5.25)  : retourne 5
                                            ; OP  : $B2
                                            ; ST  : ACTIF
                                            ; IN  : le flot  interprter
                                            ; OUT : ACC1 avec la partie entire  de l'expression
; End of function romRND

; =============== S U B R O U T I N E =======================================

getENTROPYbeforDoRND:
            ldx ENTROPY
            stx ACC1+1
            ldx ENTROPY+2
            stx ACC1+3

doRND:
            ldx RNDSEED
            stx ACC2+1
            ldx RNDSEED+2
            stx ACC2+3
            jsr nextRomMult
            ldd TMPFLT1+2
            addd #$658B
            std ENTROPY+2
            std ACC1+3
            ldd TMPFLT1
            adcb #$B0
            adca #$05
            std ENTROPY
            std ACC1+1
            clr ACC1+5
            ldaa #$80
            staa ACC1
            ldaa TMPFLT+2
            staa ACC1EXT
            jmp bcl7RomPlus
; End of function getENTROPYbeforDoRND

; ---------------------------------------------------------------------------
RNDSEED:        dc.b $40,$E6,$4D,$AB

; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC SIN(X) : retourne le sinus de X
; ALG : COS(X)=SIN(X+PI/2)
; STX : A=COS(3.14) : retourne -0.999998732
; OP  : $BA
; ST  : ACTIF
; IN  : ACC1
; OUT : ACC1=COS(ACC1)

romCOS:
            ldx #aCSTPIdiv2
            jsr FADD                    ; FCT : Add constant to ACC1
                                        ; STX : /
                                        ; ALG : /
                                        ; ST  : ACTIF
                                        ; IN  : X=pointer on constant
                                        ; OUT : ACC1=ACC1 + constant given by X
; End of function romCOS

; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC SIN(X) : retourne le sinus de X
; ALG : approximation
; STX : A=SIN(3.14/2) : retourne 0.999999683
; OP  : $B9
; ST  : ACTIF
; IN  : ACC1
; OUT : ACC1=SIN(ACC1)

romSIN:

            jsr moveACC1toACC2              ; FCT : move ACC1 to ACC2
                                            ; IN  : /
                                            ; OUT : X,D modified
                                            ;       D=ACC1 et ACC1+1
                                            ;       P modified
            ldx #aCst2PI
            ldab ACC2+5
            jsr next1DivByX
            jsr moveACC1toACC2              ; FCT : move ACC1 to ACC2
                                            ; IN  : /
                                            ; OUT : X,D modified
                                            ;       D=ACC1 et ACC1+1
                                            ;       P modified
            jsr romINT                      ; FCT : COMMANDE BASIC INT : retourne la partie entire de l'expression
                                            ; STX : A=INT(5.25)  : retourne 5
                                            ; OP  : $B2
                                            ; ST  : ACTIF
                                            ; IN  : le flot  interprter
                                            ; OUT : ACC1 avec la partie entire  de l'expression
            clr PRODSIGN
            ldaa ACC2
            ldab ACC1
            jsr romMINUS                    ; FCT : Subtract ACC2 to ACC1
                                            ; STX : /
                                            ; ALG : ?
                                            ; ST  : ACTIF
                                            ; IN  : ACC1 and ACC2 set
                                            ; OUT : ACC1=ACC1-ACC2
            ldx #aCst1div4
            jsr FSUB                        ; FCT : Soustrait de ACC1 le nombre rel point par   X
                                            ; STX : /
                                            ; ST  : ACTIF
                                            ; IN  : ACC1  jour
                                            ;       X=pointeur sur un rel
                                            ; OUT : ACC1=FLOAT(PTR X) - ACC1
            ldaa ACC1+5
            psha
            bpl bclRomSIN
            jsr add1div2toACC1              ; FCT : additionne 0.5  ACC1
                                            ; STX : /
                                            ; IN  : ACC1  jour
                                            ; OUT : ACC1=ACC1+0.5
            ldaa ACC1+5
            bmi next1RomSIN
            com CPRMASK
bclRomSIN:

            jsr ROM_NEG                     ; FCT : routine NEG(X) : retourne l'oppos de ACC1
                                            ; STX : /
                                            ; OP  : /
                                            ; ST  : ACTIF
                                            ; IN  : /
                                            ; OUT : ACC1=NEG(ACC1)
next1RomSIN:
            ldx #aCst1div4
            jsr FADD                        ; FCT : Add constant to ACC1
                                            ; STX : /
                                            ; ALG : /
                                            ; ST  : ACTIF
                                            ; IN  : X=pointer on constant
                                            ; OUT : ACC1=ACC1 + constant given by X
            pula
            tsta
            bpl next2RomSIN
            jsr ROM_NEG                     ; FCT : routine NEG(X) : retourne l'oppos de ACC1
                                            ; STX : /
                                            ; OP  : /
                                            ; ST  : ACTIF
                                            ; IN  : /
                                            ; OUT : ACC1=NEG(ACC1)
next2RomSIN:
            ldx #paramSIN
            jmp subMapApproximation         ; FCT : applique la serie de taylor pointe par X
                                            ; IN  : X=pointeur sur les paramtres de la  srie de taylor
                                            ; OUT : ACC1=POLY(ACC1)
; End of function romSIN

; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC TAN(X) : retourne la tangente de X
; ALG : TAN(X)=SIN(X)/COS(X)
; STX : A=TAN(3.14/3) : retourne 1.72992922
; OP  : $BB
; ST  : ACTIF
; IN  : ACC1
; OUT : ACC1=TAN(ACC1)

romTAN:
            jsr SAVEACC1toPTRTMP1
            clr CPRMASK                 ; CLEAR THE MASK OF COMPARISON (<=>)
            bsr romSIN                  ; FCT : COMMANDE BASIC SIN(X) : retourne le sinus de X
                                        ; ALG : approximation
                                        ; STX : A=SIN(3.14/2) : retourne 0.999999683
                                        ; OP  : $B9
                                        ; ST  : ACTIF
                                        ; IN  : ACC1
                                        ; OUT : ACC1=SIN(ACC1)
            ldx #PTRTMP3
            jsr MOVMF                   ; move ACC1 to memory (by X)
            ldx #PTRTMP1
            jsr MOVFM                   ; FCT : MOVE memory to ACC1
                                        ; IN  : X=FLOAT (5 bytes)
                                        ; OUT : A and X unmodified
            clr ACC1+5
            ldaa CPRMASK                ; Masque de comparaison
            bsr doBclRomSIN
            ldx #PTRTMP3
            jmp FDIV_ACC1_BY_MEM
; End of function romTAN


; =============== S U B R O U T I N E =======================================

doBclRomSIN:
            psha
            bra bclRomSIN
; End of function doBclRomSIN

; ---------------------------------------------------------------------------
aCSTPIdiv2: dc.b $81,$49,$0F,$DA,$A2
aCst2PI:    dc.b $83,$49,$0F,$DA,$A2
aCst1div4:  dc.b $7F,$00,$00,$00,$00
;----------------
paramSIN:   dc.b 5
            dc.b $84,$E6,$1A,$2D,$1B          ; 0
            dc.b $86,$28,$07,$FB,$F8          ; 5
            dc.b $87,$99,$68,$89,$01          ; 10
            dc.b $87,$23,$35,$DF,$E1          ; 15
            dc.b $86,$A5,$5D,$E7,$28          ; 20
            dc.b $83,$49,$0F,$DA,$A2          ; 25
;----------------
tabEasterEgg:
            dc.b $A1,$54,$46,$8F,$13          ; 0 ; EasterEgg microsoft
            dc.b $8F,$52,$43,$89,$CD          ; 5

; =============== S U B R O U T I N E =======================================

; FCT : Point d'entre pour la rinitialisation
; ST  : ACTIF
; IN  : /
; OUT : /

doRESET:
            ldaa #$FF
            staa DDR1                   ; Port 1 en sortie
            ldaa #$01
            staa DDR2                   ; Port 2, bit 0 en sortie les autres en entre
            ldaa #$01
            staa PORT2                  ; Port I/O soit pour RS232 soit pour K7
            ldaa fCOLDWARN
            cmpa #cOS_WARN              ; 'U'
            bne jmpHardReset

doColdWarn:
            ldx pCOLD
            ldaa 0,x
            deca
            bne jmpHardReset
            jmp 0,x

jmpHardReset:

            jmp OS_HardReset            ; FCT : effectue le reset "hard" de l'ordinateur
                                        ; IN  : /
                                        ; OUT : /
; End of function doRESET

; =============== S U B R O U T I N E =======================================

; FCT : Effectue diverses initialisations systmes :
;   - la zone mmoire entre X et $100
;   - la zone vecteur CPU
;   - pile systme
;   - saisie utilisateur
;   - Hook
;   - Basic
;   - Ecran
;   Puis imprime la bannire MICROSOFT
;   ENFIN entre dans la boucle d'interprtation du BASIC
; IN  : X=dbut de la zone mmoire  initialiser
; OUT : A,X modified

OS_CLRMEM:
            clr 0,x                     ; met  zro la zone du MC6803 de $80  $FF
            inx
            cpx #$0100
            bne OS_CLRMEM               ; FCT : Effectue diverses initialisations systmes :
                                        ;       - la zone mmoire entre X et $100
                                        ;       - la zone vecteur CPU
                                        ;       - pile systme
                                        ;       - saisie utilisateur
                                        ;       - Hook
                                        ;       - Basic
                                        ;       - Ecran
                                        ;       Puis imprime la bannire MICROSOFT
                                        ;       ENFIN entre dans la boucle d'interprtation du BASIC
                                        ; IN  : X=dbut de la zone mmoire  initialiser
                                        ; OUT : A,X modified
            ldx #vectTODO               ; TODO : Vraiment le point de dpart ?

bcl_CLRMEM:
            inx                         ; TODO : un lger problme de mise  jour : par rapport au nombre
                                        ; de vecteurs, l'init effectu plus bas ne correspond pas ...
            ldaa 2,x
            com 2,x
            ldab 2,x
            clr 2,x
            coma
            cba
            beq bcl_CLRMEM
            stx ADRENDMEM               ; Adresse de la fin de mmoire
            stx MEMSIZ                  ; Adresse - 1 de la fin de la RAM DISPONIBLE
            stx FRETOP

allocString:
            ldd FRETOP
            subd #cBAS_AREA_STR_DEFAULT ; $64
            std botSTACK

initStack:
            lds botSTACK

copyRoutineGetChar:
            ldx #lgRoutineGetChar
            ldd #CHRGET                 ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                        ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                        ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                        ; NOT C= NUMERIC ("0" THRU "9")
                                        ; Z= ":" OR END-OF-LINE (A NULL)
                                        ; [ACCA] = NEW CHAR.
                                        ; [TXTPTR]=[TXTPTR]+1
            bsr OS_copyMEM              ; FCT : Copie la zone mmoire pointe par X
                                        ;       (le premier octet contient le nombre d'octets
                                        ;        copier) dans celle pointe par D
                                        ; IN  : X=SOURCE
                                        ;       D=CIBLE
                                        ; OUT : A,B,X modified

InitVectorAndRam:
            ldx #lgTabInitVector        ; initialise la zone $3200  $321F
            ldd #vectSCI
            bsr OS_copyMEM              ; FCT : Copie la zone mmoire pointe par X
                                        ;       (le premier octet contient le nombre d'octets
                                        ;        copier) dans celle pointe par D
                                        ; IN  : X=SOURCE
                                        ;       D=CIBLE
                                        ; OUT : A,B,X modified

initVectorHOOK:
            ldaa #$39                   ; '9' ; Initialisation  RTS pour les sauts aux hooks.
            ldx #vHOOK1_KBD

bclInitVectorHOOK:
            staa 0,x
            inx
            cpx #varUNKNOWN
            bne bclInitVectorHOOK
            com varUNKNOWN

setBeginPrg:
            ldx #beginPrg
            stx TXTAB                   ; dbut du programme basic

initPTRBASIC:
            jsr doRomNEW                ; FCT : Effectue l'action de la commande BASIC NEW
                                        ; IN  : /
                                        ; OUT : X=TXTTAB+2=dbut du programme + 2

clearSCREEN:
            jsr doInitGraphAndKbd       ; FCT : Mode text 32x16, efface l'cran, autorepeat non autoris,
                                        ;       Initialise le pointeur sur les tableaux de conversions ASCII du clavier
                                        ;       Initialise les couleurs du fond et d'encre de l'cran
                                        ; IN  : /
                                        ; OUT : A,B,X modified

printBAN:
            ldx #aMicrocolorBasic-1     ; "MICROCOLOR BASIC 1.0\rCOPYRIGHT 1982"
            jsr OS_OUTTX                ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                        ; IN : X=pointeur sur une chane de caractres termine par un 0
                                        ; OUT: A,B,X modified

initWARM:
            ldaa #cOS_WARN              ; 'U'
            staa fCOLDWARN

jmpINTERPRET:
            jmp INTERPRETATION          ; FCT : INTERPRETATION
                                        ; IN  : /
                                        ; OUT : /
; End of function OS_CLRMEM

; =============== S U B R O U T I N E =======================================

; FCT : Copie la zone mmoire pointe par X
;       (le premier octet contient le nombre d'octets
;        copier) dans celle pointe par D
; IN  : X=SOURCE
;       D=CIBLE
; OUT : A,B,X modified

OS_copyMEM:
            std PTRTMP2
            ldab 0,x                ; rcupration de la longueur de la copie  effectuer

bclOS_CopyMEM:
            inx

next1OS_CopyMEM:
            ldaa 0,x                ; Recopie une zone mmoire de la zone X dans la zone pointe par PTRTMP2
                                    ; X=pointeur sur la zone de dpart
                                    ; B=longueur  copier
            stx LOWTR
            ldx PTRTMP2
            staa 0,x
            inx
            stx PTRTMP2
            ldx LOWTR
            decb
            bne bclOS_CopyMEM
            rts
; End of function OS_copyMEM


; =============== S U B R O U T I N E =======================================

; FCT : point d'entre par dfaut du redmarrage  froid

OS_entryCOLD:
            nop
; End of function OS_entryCOLD


; =============== S U B R O U T I N E =======================================
; FCT : effectue le travail :
;       1 - intialisation divers pointeurs
;       2 - effacement de l'cran
;       3 - entre dans la boucle d'interprtation BASIC
; STX : /
; ALG : /
; OP  : /
; ST  : ACTIF
; IN  : /
; OUT : /

OS_initCOLD:
            clr DEVNU                       ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            jsr reInitPointeur              ; FCT : Initialisation de certains pointeurs, pile et donnes BASIC
                                            ; IN  : /
                                            ; OUT : S=Initialis  sa position de dpart
                                            ;       A=0
                                            ;       OLDTXT=0, SUBFLG=0,CURDVC=0 (SCREEN),TMPPT=$3241
                                            ;       Le retour de l'appelant se fait par popx + jmp x
                                            ;       suite  l'initialisation de la pile (S)
            jsr nextDoRomCLS
            bra jmpINTERPRET
; End of function OS_initCOLD

;----------------
lgRoutineGetChar:   dc.b (lgTabInitVector-getChar)  ; $E

; =============== S U B R O U T I N E =======================================
getChar:
            inc byte_F5
            bne nextGetChar
            inc TXTPTR
nextGetChar:
            ldaa.w DDR1                     ; OJE 14/02/2020 V3
            jmp subGetNextChar              ; FCT : Test du type de caractre
                                            ; IN  : A=caractre  tester
                                            ; OUT : ET CARRY IF NUMERIC - RETURN WITH
                                            ;       ZERO FLAG SET IF A = 0 OR 3A(:) - END
                                            ;       OF BASIC LINE OR SUB LINE
                                            ; End of function getChar
; ---------------------------------------------------------------------------
lgTabInitVector:    dc.b $31
; ---------------------------------------------------------------------------

tabInitVector:
            rti
; ---------------------------------------------------------------------------
            dc.b     0
            dc.b     0
; ---------------------------------------------------------------------------
            rti
; ---------------------------------------------------------------------------
            dc.b     0
            dc.b     0
; ---------------------------------------------------------------------------
            rti
; ---------------------------------------------------------------------------
            dc.b     0
            dc.b     0
; ---------------------------------------------------------------------------
            rti
; ---------------------------------------------------------------------------
            dc.b     0
            dc.b     0
; ---------------------------------------------------------------------------
            rti
; ---------------------------------------------------------------------------
            dc.b     0
            dc.b     0
; ---------------------------------------------------------------------------
            rti
; ---------------------------------------------------------------------------
            dc.b     0
            dc.b     0
; ---------------------------------------------------------------------------
            rti
; ---------------------------------------------------------------------------
            dc.b     0
            dc.b     0
;----------------

; =============== S U B R O U T I N E =======================================

; Code par dfaut pour le vecteur doUSER et pEXEC

j_printErrorMSG_0x08_FctIncorrecte:
            jmp printErrorMSG_0x08_FC_FctIncorrect
; End of function j_printErrorMSG_0x08_FctIncorrecte

; ---------------------------------------------------------------------------
VAL_ENTROPY_RND:    dc.b $4F,$C7,$52,$59        ; Valeur utilise pour initialiser la squence de gnration de nombre pseudo alatoire
;----------------
VAL_DEFAULT_DIVERS: dc.b $FF                    ; Valeur d'initialisation par dfaut de certaines zones mmoires
                                                ; situes entre $321C et $3231
                    dc.b $04
                    dc.b $5E
                    dc.w printErrorMSG_0x08_FC_FctIncorrect   ; valeur par dfaut pour pEXEC
                    dc.w OS_entryCOLD           ; valeur par dfaut pour pCOLD
                    dc.b $00
                    dc.b $81
                    dc.b $00
                    dc.b $01
                    dc.b $10
                    dc.b $70
                    dc.b $84
                    dc.b $00
                    dc.b $01
                    dc.b $18                    ; valeur par dfaut pour K7
                    dc.b $1A                    ; valeur par dfaut pour K7
                    dc.b $0B                    ; valeur par dfaut pour K7
                    dc.w $80                    ; valeur par dfaut pour K7 (pour synchronisation)
;----------------
aMicrocolorBasic:   dc.b "MICROCOLOR BASIC 1.0",$D,"COPYRIGHT 1982"
aMicrosoft:         dc.b " MICROSOFT",$D,0

; =============== S U B R O U T I N E =======================================

; FCT : Gre le clignotement du curseur
; IN  : /
; OUT : A,B,X modified

manageCURCLIGNOTEMENT:
            dec CURWAITCLIGNOTEMENT
            bne OS_doTempo0x45E             ; FCT : une tempo fixe de $45E x K microsecondes
                                            ; ST  : ACTIF
                                            ; IN  : /
                                            ; OUT : X modified
            ldaa COLOR_CARGRA               ; Code couleur cyclique pour les caractres graphiques via CTRL+0
            eora #$0F
            staa COLOR_CARGRA               ; Code couleur cyclique pour les caractres graphiques via CTRL+0
            oraa #$80
            jsr GR_printCHARAtCurrentPos    ; FCT : Imprime le caractre A
                                            ; IN  : A=char to print
                                            ; OUT : A unmodified
            nop
            nop
            ldab #$16
            anda #$0F
            beq nextanageCURCLIGNOTEMENT
            ldab #$58

nextanageCURCLIGNOTEMENT:
            stab CURWAITCLIGNOTEMENT
; End of function manageCURCLIGNOTEMENT


; =============== S U B R O U T I N E =======================================

; FCT : une tempo fixe de $45E x K microsecondes
; ST  : ACTIF
; IN  : /
; OUT : X modified

OS_doTempo0x45E:
            ldx #$45E

bclTempo:
            dex
            bne bclTempo
            rts
; End of function OS_doTempo0x45E


; =============== S U B R O U T I N E =======================================

; FCT : Attend qu'une touche soit presse et l'affiche
;       gre le clignotement
;       Si espace alors imprime un espace
; HOOK: OUI
; IN  : /
; OUT : A=code ascii de la touche presse
;       B, X unmodified

OS_getKeyWithHook:
            jsr vHOOK1_KBD

OS_getKey:
            pshx
            pshb

waitGetKEY_OS:
            bsr manageCURCLIGNOTEMENT       ; FCT : Gre le clignotement du curseur
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            bsr OS_POLCA                    ; FCT : polling keyboard
                                            ; IN  : /
                                            ; OUT : A=code ascii de la touche
                                            ;       X,B not modified
            beq waitGetKEY_OS
            ldab #cOS_SPACE                 ; ' '  ; TODO Et pourquoi pas utiliser printCHARAtCURARD_YX en mettant A=$20 ?
            jsr GR_printCHARfromBAtCURAD_YX ; FCT : Imprime le caractre stock en B
                                            ; IN  : B=caractre  imprimer
                                            ; OUT : A not modified
            pulb
            pulx
            rts
; End of function OS_getKeyWithHook

; ---------------------------------------------------------------------------
            dc.b     1

; =============== S U B R O U T I N E =======================================

; FCT : dtermine si on a appuy sur les touches de contrles
;       et une autre touche
; IN  : /
; OUT : A=0 : CTRL is pressed
;       A<>0 : other key pressed

getKeyPressed:
            clra
            bsr isKeyPressedCTRL            ; FCT : Est-ce que la touche CTRL est actionne ?
                                            ; IN  : /
                                            ; OUT : A=$00 : non A=$FF : oui
            bne OS_POLCA                    ; FCT : polling keyboard
                                            ; IN  : /
                                            ; OUT : A=code ascii de la touche
                                            ;       X,B not modified
            bsr isKeypressed_getColKBD      ; FCT : Est-ce qu'une touche normal (hors shift/ctrl) est actionne ?
                                            ; IN  : B=range du clavier  activer
                                            ; OUT : A=Colonne active quand une touche est presse
            inca
            beq endPOLCA
; End of function getKeyPressed


; =============== S U B R O U T I N E =======================================
; FCT : polling keyboard
; IN  : /
; OUT : A=code ascii de la touche
;       X,B not modified

OS_POLCA:
            pshx
            pshb
            jsr initKBD                     ; FCT : initialise l'autorepeat et le tampon de
                                            ;       caractre  $FF
                                            ; IN  : /
                                            ; OUT : A modified
            bsr KBD_polling                 ; FCT : scanne le clavier  la recherche de touche actionne
                                            ;       Un mcanisme d'anti rebond est programm
                                            ; IN  : /
                                            ; OUT : A=0 : aucune touche actionne
                                            ;       A<>0 : la derniere touche dtecte
                                            ;       B= : touche CTRL ou SHIFT actionne
            tsta
            beq nextPOLCA
            jsr KBD_CONV_MATRIX_TO_ASCII    ; FCT : Permet de donner le code quivalent ASCII (ou pas) de la touche actionne
                                            ;        partir d'un des tableaux de conversion choisi par le registre B
                                            ; IN  : B=0: TOUCHE
                                            ;       B=1: CTRL+TOUCHE
                                            ;       B=2: SHIFT+TOUCHE
                                            ;       B=3: CTRL+TOUCHE
                                            ; OUT : Le code fonction du tableau de conversion

nextPOLCA:
            tsta
            pulb
            pulx

endPOLCA:
            rts
; End of function OS_POLCA


; =============== S U B R O U T I N E =======================================
; FCT : scanne le clavier  la recherche de touche actionne
;       Un mcanisme d'anti rebond est programm
; IN  : /
; OUT : A=0  : aucune touche actionne
;       A<>0 : la derniere touche dtecte
;       B=   : touche CTRL ou SHIFT actionne

KBD_polling:
            ldx #ROLTB-1
            clrb
            decb
            stab $09,x                      ; initialise NUMRGKBD  $FF

bclPollingKEYB:
            rolb
            bcc end1PollingKEYB
            inc NUMRGKBD                    ; numro de ligne en cas de scanning : 0->7
            bsr isKeypressed_setColKBD      ; FCT : obtient la colonne du clavier lors d'une frappe
                                            ;       pour une colonne/range du clavier donne
                                            ; IN  : B=numro de  range du clavier active
                                            ; OUT : A=colonne active quand une touche est presse
            pshb
            tab
            inx                             ; obtient l'adresse de la prochaine zone de stockage du caractre
            eora $00,x                        ; A=A XOR FF
                                            ; A=A AND FF
                                            ; MEM(X) = COL
                                            ; 0000 0001 XOR 1111 1111 = 1111 1110
                                            ; 1111 1110 AND 1111 1111 = 1111 1110
            anda $00,x
            stab $00,x
            pulb
            tsta
            sec
            beq bclPollingKEYB
            psha

antiREBOND:
            bsr KBD_TEMPO_0X45E             ; FCT : Effectue une tempo de $45E x X secondes
                                            ; IN  : /
                                            ; OUT : /
            bsr isKeypressed_getColKBD      ; FCT : Est-ce qu'une touche normal (hors shift/ctrl) est actionne ?
                                            ; IN  : B=range du clavier  activer
                                            ; OUT : A=Colonne active quand une touche est presse
            cmpa $00,x
            pula
            bne end1PollingKEYB
            ldab #$F8

bcl1PollingKEYB:
            addb #$08
            lsra
            bcc bcl1PollingKEYB
            addb NUMRGKBD                   ; numro de ligne en cas de scanning : 0->7
            incb
            pshb
            clrb

isCTRLSHIFTPressed:
            ldaa #$FE
            bsr isKeyPressedCTRL            ; FCT : Est-ce que la touche CTRL est actionne ?
                                            ; IN  : /
                                            ; OUT : A=$00 : non A=$FF : oui
            beq nextPollingKEYB
            incb

nextPollingKEYB:
            bsr isKeyPressedSHIFT           ; FCT : Est-ce que la touche SHIFT est actionne ?
                                            ; IN  : /
                                            ; OUT : A=$00 : non A=$FF : oui

            beq endPollingKEYB
            incb
            incb

endPollingKEYB:
            pula
            rts

end1PollingKEYB:
            clra
            rts
; End of function KBD_polling


; =============== S U B R O U T I N E =======================================
; FCT : Est-ce que la touche SHIFT est actionne ?
; IN  : /
; OUT : A=$00 : non A=$FF : oui

isKeyPressedSHIFT:
            ldaa #$7F
; End of function isKeyPressedSHIFT


; =============== S U B R O U T I N E =======================================
; FCT : Est-ce que la touche CTRL est actionne ?
; IN  : /
; OUT : A=$00 : non A=$FF : oui

isKeyPressedCTRL:
            staa.w PORT1 ; OJE 14/02/2020 V3
            ldaa.w PORT2 ; OJE 14/02/2020 V3 ; Port I/O soit pour RS232 soit pour K7
            coma
            anda #$02
            beq endIsKeyPressedCTRL
            ldaa #$FF

endIsKeyPressedCTRL:
            rts
; End of function isKeyPressedCTRL


; =============== S U B R O U T I N E =======================================

; FCT : obtient la colonne du clavier lors d'une frappe
;       pour une colonne/range du clavier donne
; IN  : B=numro de range du clavier active
; OUT : A=colonne active quand une touche est presse

isKeypressed_setColKBD:
            stab.w PORT1 ; OJE 14/02/2020 V3 stab PORT1
; End of function isKeypressed_setColKBD


; =============== S U B R O U T I N E =======================================
; FCT : Est-ce qu'une touche normal (hors shift/ctrl) est actionne ?
; IN  : B=range du clavier  activer
; OUT : A=Colonne active quand une touche est presse

isKeypressed_getColKBD:
            ldaa IO_COL_KBD     ; pour une range active du clavier, indique par un 0 la touche du clavier active
                                ; est utilis aussi pour le son !
            oraa #$C0           ; $C0:1100 0000
            pshb
            comb                ; $7C : 0111 1100
                                ; B=$7F : 0111 1111 : 1000 0000
                                ; B=$FE : 1111 1110 : 0000 0001
            bitb #$7C
            beq endISKeyPressed_getColKBD
            ldab.w PORT2        ; OJE 14/02/2020 V3 ldab PORT2 ; Bien mysterieux
            bitb #$02
            bne endISKeyPressed_getColKBD
            adda #$40

endISKeyPressed_getColKBD:
            pulb
            rts
; End of function isKeypressed_getColKBD


; =============== S U B R O U T I N E =======================================
; FCT : initialise l'autorepeat et le tampon de
;       caractre  $FF
; IN  : /
; OUT : A modified

initKBD:
            tst fAUTOREPEAT             ; =0:no autorepat;<>0:AUTOREPAT ON et est dcremente
                                        ; d'1 unit  chaque rptition
            beq endManageAUTOREPEAT
            ldaa fAUTOREPEAT            ; =0:no autorepat;<>0:AUTOREPAT ON et est dcremente
                                        ; d'1 unit  chaque rptition
            deca
            staa fAUTOREPEAT            ; =0:no autorepat;<>0:AUTOREPAT ON et est dcremente
                                        ; d'1 unit  chaque rptition
            cmpa #$B0 ; ''
            bne endManageAUTOREPEAT
            ldaa #$FF
            staa fAUTOREPEAT            ; =0:no autorepat;<>0:AUTOREPAT ON et est dcremente
                                        ; d'1 unit  chaque rptition
            ldx #ROLTB                  ; Mmorisation de la dernire touche entre
            ldab #$08
            ldaa #$FF

bclManageAUTOREPEAT:
            staa 0,x
            inx
            decb
            bne bclManageAUTOREPEAT

endManageAUTOREPEAT:
            rts
; End of function initKBD


; =============== S U B R O U T I N E =======================================
; FCT : Effectue une tempo de $45E x X secondes
; IN  : /
; OUT : /

KBD_TEMPO_0X45E:
            pshx
            ldx #$45E

bclKBD_TEMPO_0X45E:
            dex
            bne bclKBD_TEMPO_0X45E
            pulx
            rts
; End of function KBD_TEMPO_0X45E


; =============== S U B R O U T I N E =======================================
; FCT : Permet de donner le code quivalent ASCII (ou pas) de la touche actionne
;        partir d'un des tableaux de conversion choisi par le registre B
; IN  : B=0: TOUCHE
;       B=1: CTRL+TOUCHE
;       B=2: SHIFT+TOUCHE
;       B=3: CTRL+TOUCHE
; OUT : Le code fonction du tableau de conversion

KBD_CONV_MATRIX_TO_ASCII:
            pshb
            asrb
            ldab #$00
            bcc nextKBD_CONV_MATRIX_TO_ASCII
            decb

nextKBD_CONV_MATRIX_TO_ASCII:
            stab TMPKBD
            pulb
            pshb
            ldx TABAD                      ; pointeur sur les tableaux de conversion KEYB -> ASCII
            aslb
            abx
            ldx 0,x
            tab
            abx
            ldaa 0,x
            pulb
            pshb
            tstb
            bne next1KBD_CONV_MATRIX_TO_ASCII
            psha
            adda #$BF
            cmpa #$1A
            pula
            bcc next1KBD_CONV_MATRIX_TO_ASCII
            tst KEYB_INVVIDEO               ; Indicateur pour INVERSE VIDEO pour l'cran et
                                            ; majuscule/minuscule pour imprimante (toggle entre $00 et $FF)
            bne next1KBD_CONV_MATRIX_TO_ASCII
            adda #$20 ; ' '

next1KBD_CONV_MATRIX_TO_ASCII:
            pulb
            pshb
            bitb #$02
            beq next2KBD_CONV_MATRIX_TO_ASCII
            psha
            adda #$80
            cmpa #$20 ; ' '
            pula
            bcc next2KBD_CONV_MATRIX_TO_ASCII
            ldab COLOR_CARGRA               ; Code couleur cyclique pour les caractres graphiques via CTRL+0
            andb #$70
            aba

next2KBD_CONV_MATRIX_TO_ASCII:
            cmpa #$30 ; '0'
            pulb
            bne rtsKBD_CONV_MATRIX_TO_ASCII
            asrb
            bcc next3KBD_CONV_MATRIX_TO_ASCII
            ldaa COLOR_CARGRA               ; Code couleur cyclique pour les caractres graphiques via CTRL+0
            adda #$10
            staa COLOR_CARGRA               ; Code couleur cyclique pour les caractres graphiques via CTRL+0
            clra

next3KBD_CONV_MATRIX_TO_ASCII:
            tstb
            beq rtsKBD_CONV_MATRIX_TO_ASCII
            com KEYB_INVVIDEO
            clra

rtsKBD_CONV_MATRIX_TO_ASCII:
            rts
; End of function KBD_CONV_MATRIX_TO_ASCII

; ---------------------------------------------------------------------------
TABNOR:
             dc.b cKB_NULL     ,cKB_AROBASE,cKB_Q      ,cKB_B      ,cKB_C      ,cKB_D      ,cKB_E      ,cKB_F
             dc.b cKB_G        ,cKB_H      ,cKB_I      ,cKB_J      ,cKB_K      ,cKB_L      ,cKB_DIVIDE ,cKB_N
             dc.b cKB_O        ,cKB_P      ,cKB_A      ,cKB_R      ,cKB_S      ,cKB_T      ,cKB_U      ,cKB_V
             dc.b cKB_Z        ,cKB_X      ,cKB_Y      ,cKB_W      ,cKB_NULL   ,cKB_NULL   ,cKB_NULL   ,cKB_ENTER
             dc.b cKB_ESPACE   ,cKB_0      ,cKB_1      ,cKB_2      ,cKB_3      ,cKB_4      ,cKB_5      ,cKB_6
             dc.b cKB_7        ,cKB_8      ,cKB_9      ,cKB_2POINT ,cKB_M      ,cKB_comma  ,cKB_minus  ,cKB_dot
             dc.b cKB_SEMICOLON,cKB_NULL   ,cKB_NULL   ,cKB_BREAK  ,cKB_LEFT   ,cKB_DOWN   ,cKB_RIGHT  ,cKB_UP
;----------------
TABDUMMY:   dc.b $38 ; 8
            dc.b $39 ; 9
            dc.b $3A ; :
            dc.b $6D ; m
            dc.b $2C ; ,
            dc.b $2D ; -
            dc.b $2E ; .
            dc.b $3B ; ;

; =============== S U B R O U T I N E =======================================

; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
; IN  : A=caractre  imprimer
;       DEVNU mise  jour
; OUT : B, X unmodified

OS_printCHAR:
            jsr vHOOK2_PRINTCHAR
            pshx
            pshb
            psha
            ldab DEVNU                      ;  0 : affichage sur l'cran <>0 affichage sur l'imprimante
            beq printCHAR_TEXT

doPrintChar_PRINTER:
            tab
            tpa
            psha
            sei
            tba

waitDoPrintChar_PRINTER:
            ldab PORT2                      ; Port I/O soit pour RS232 soit pour K7
            andb #$04
            bne waitDoPrintChar_PRINTER
            bsr OS_send0x01toPrinter        ; FCT : Envoie un 1 sur le port imprimante
                                            ; IN  : B=1 to send printer
                                            ; OUT : X modified
            clrb
            bsr OS_send0xXXtoPrinter        ; FCT : Envoie un bit sur le port2
                                            ; IN  : B=bit (O or 1) to send printer
                                            ; OUT : /
            ldab #$08

bclDoPrintChar_PRINTER:
            pshb
            clrb
            lsra
            rolb
            bsr OS_send0xXXtoPrinter        ; FCT : Envoie un bit sur le port2
                                            ; IN  : B=bit (O or 1) to send printer
                                            ; OUT : /
            pulb
            decb
            bne bclDoPrintChar_PRINTER
            bsr OS_send0x01toPrinter        ; FCT : Envoie un 1 sur le port imprimante
                                            ; IN  : B=1 to send printer
                                            ; OUT : X modified
            pula
            tap
            pula
            cmpa #cOS_CR                    ; $0D
            beq next1DoPrintChar_PRINTER
            inc XMaxPRT
            ldab XMaxPRT
            cmpb CurXPRT                    ; WORD :
                                            ; Position X for cursor on PRINTER
                                            ; Max X for cursor on PRINTER
            bcs endDoPrintChar_PRINTER

next1DoPrintChar_PRINTER:
            clr XMaxPRT
            bsr doTEMPO                     ; FCT : effectue une tempo de X secondes
            bsr doTEMPO                     ; FCT : effectue une tempo de X secondes

endDoPrintChar_PRINTER:
            pulb
            pulx
            rts
; End of function OS_printCHAR


; =============== S U B R O U T I N E =======================================
; FCT : Envoie un 1 sur le port imprimante
; IN  : B=1 to send printer
; OUT : X modified

OS_send0x01toPrinter:
            ldab #$01
; End of function OS_send0x01toPrinter


; =============== S U B R O U T I N E =======================================

; FCT : Envoie un bit sur le port2
; IN  : B=bit (O or 1) to send printer
; OUT : X modified

OS_send0xXXtoPrinter:
            stab PORT2                  ; Port I/O soit pour RS232 soit pour K7
            bsr .+2
            ldx PR_BAUDRATE
            bra jmpBclTempo
; End of function OS_send0xXXtoPrinter


; =============== S U B R O U T I N E =======================================

; FCT : effectue une tempo de X secondes
; IN  : CRT_TEMPO doit tre  jour
; OUT : /

doTEMPO:
            ldx CRT_TEMPO
jmpBclTempo:
            jmp bclTempo
; End of function doTEMPO

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR OS_printCHAR

printCHAR_TEXT:
            ldx CURAD_YX

isCHR0X08_BackSpace:
            cmpa #cOS_BS                    ; $08 : backspace
            bne isCR

doCHR0X08_BS:                               ; Position de l'cran en haut  gauche =(0,0)
            cpx HOME_YX
            beq endPrintCHAR
            jsr GR_decCursor                ; FCT : dcremente de 1 la position  X,Y donne par le registre X
                                            ; IN  : X=La position (X,Y)
                                            ; OUT : X=X-1 en position (X,Y)
                                            ;       A et B not modified
            ldaa #cOS_SPACE                 ; ' '
            jsr vectorOS_PRINT              ; FCT : Stocke  la position X(Y,X) le caractre A
                                            ; IN  : A=caractre  afficher
                                            ;       X=POS (Y,X) du caractre  afficher
                                            ; OUT : A,B,X modified
            bra storeCurADPrintCHAR

isCR:
            cmpa #cOS_CR
            bne isSPACE

bclIsCR:
            ldaa #cOS_SPACE                 ; ' '
            jsr vectorOS_PRINT              ; FCT : Stocke  la position X(Y,X) le caractre A
                                            ; IN  : A=caractre  afficher
                                            ;       X=POS (Y,X) du caractre  afficher
                                            ; OUT : A,B,X modified
            jsr GR_doincX_AND_SCROLLUP      ; FCT : Incrmente de 1 la position du curseur  l'cran
                                            ;       et effectue un dfilement vers le haut si ncessaire
                                            ; IN  : X=pos(Y,X)
                                            ; OUT : X=pos(Y,X+1) + scrollup si ncessaire
            pshx
            pula
            pulb
            cmpb HOME_YX+1                  ; Position de l'cran en haut  gauche =(0,0)
            bne bclIsCR
            bra storeCurADPrintCHAR

isSPACE:
            cmpa #cOS_SPACE                 ; ' '
            bcs endPrintCHAR
            jsr vectorOS_PRINT              ; FCT : Stocke  la position X(Y,X) le caractre A
                                            ; IN  : A=caractre  afficher
                                            ;       X=POS (Y,X) du caractre  afficher
                                            ; OUT : A,B,X modified
            jsr GR_doincX_AND_SCROLLUP      ; FCT : Incrmente de 1 la position du curseur  l'cran
                                            ;       et effectue un dfilement vers le haut si ncessaire
                                            ; IN  : X=pos(Y,X)
                                            ; OUT : X=pos(Y,X+1) + scrollup si ncessaire

storeCurADPrintCHAR:
            stx CURAD_YX

endPrintCHAR:
            pula
            pulb
            pulx
            rts
; END OF FUNCTION CHUNK FOR OS_printCHAR

; =============== S U B R O U T I N E =======================================

; FCT : PAS DE POINT D'ENTREE DONC SERT A QUELQUE CHOSE ?
; STX : /
; ALG : /
; OP  : /
; ST  : NON ACTIF
; IN  : A=/
;       X=/
; OUT : /

NE_SERT_A_RIEN:
            nega
            staa 0,x
            inx
            stx CURAD_YX
            cpx #$3200
            bne endNE_SERT_A_RIEN
            ldx #$3000

BCL_NE_SERT_A_RIEN:
            ldd $20,x
            std 0,x
            inx
            inx
            cpx #$31E0
            bne BCL_NE_SERT_A_RIEN
            ldab #$60 ; '`'
            jsr setCURAD_YXbeforCLRSCR

endNE_SERT_A_RIEN:
            pula
            pulb
            pulx
            rts
; End of function NE_SERT_A_RIEN


; =============== S U B R O U T I N E =======================================

; FCT : Initialise le paramtrage des abscisses pour le device (DEVNU=0: cran sinon imprimante)
; IN  : DEVNU Initialis : =$00  cran sinon printer
; OUT : A,B,X unmodified

doinitParamByDevice:
            jsr vHOOK3_INITPRMSCCR
            pshx
            pshb
            psha
            ldaa DEVNU                  ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            beq nextDoinitParamByDevice

doInitPrinter:
            ldx MARGIN_PRT              ; CLS 81 : DEFAUT : MARGE GAUCHE : $10 MARGE DROITE :$40
            ldd CurXPRT                 ; WORD :
                                        ; Position X for cursor on PRINTER
                                        ; Max X for cursor on PRINTER
            bra next1DoinitParamByDevice

nextDoinitParamByDevice:
            ldab CURAD_YX+1
            ldx MARGIN_SCR              ; dfaut pour 32x16:$10=16:80x25:$10=16
            ldaa XMAX_SCR               ; longueur d'un cran
            nop

next1DoinitParamByDevice:
            stx DEVXMARGIN              ; Marge GAUCHE/DROITE pour les tabulations
                                        ; CLS 81 : $10,$40
                                        ; CLS 40 : $10,$10
                                        ; CLS 32 : $10,$10
            stab DEVXCURR               ; vaut $00  l'init
            staa DEVXMAX                ; vaut 32,40 ou 80
            pula
            pulb
            pulx
            rts
; End of function doinitParamByDevice

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR INKBD

jsrClearScreen:
            jsr GRNCH                   ; FCT : GRNCH : efface l'cran selon le mode donn par TECRAN
                                        ; IN  : /
                                        ; OUT : /
; END OF FUNCTION CHUNK FOR INKBD

; =============== S U B R O U T I N E =======================================

; FCT : Attend une saisie utilisateur
;       gre les touches spcifiques
;       BREAK  : sort du programme !
;       CTRL+A : effacement de la saisie en cours
;       CTRL+Q : effacement d'un caractre
;       RETURN : fin de la saisie utilisateur
; IN  : /
; OUT : X=pointeur sur la tampon clavier -1 contenant la saisie utilisateur
;       C=0 : saisie utilisateur
;       C=1 : saisie d'une touche de contrle

INKBD:
            jsr vHOOK5_KBD

bclINKBD:
            clr charKEYB
            ldx #BUFFERKEYB
            ldab #$01

bcl1INKBD:
            jsr OS_getKeyWithHook           ; FCT : Attend qu'une touche soit presse et l'affiche
                                            ;       gre le clignotement
                                            ;       Si espace alors imprime un espace
                                            ; HOOK: OUI
                                            ; IN  : /
                                            ; OUT : A=code ascii de la touche presse
                                            ;       B, X unmodified
            tst fDONTCARE                   ; flag qui ne sert  rien actuellement Toujours gal  0
            bne doCR_INKBD
            tst DEVNU                       ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            bne isCR_INKBD
            tsta
            bpl isCTRLL_INKBD
            tst TMPKBD
            beq isCTRLL_INKBD
            jsr BAS_searchTextBASIC         ; FCT : Recherche la position du nom de la commande
                                            ;       BASIC associe au code BASIC.
                                            ; IN  : A=code de la fonction BASIC A>= $80
                                            ;       X=position dans le source BASIC
                                            ; OUT : X=position en rom du texte du code BASIC recherch

bcl2INKBD:
            ldaa 0,x
            inx
            pshx
            psha
            anda #$7F
            ldx INDEX
            bsr INKBD_echoInput             ; FCT : vrifie que nous n'avons pas dpass la taille du tampon clavier ($80)
                                            ;       et stocke le caractre lu dans le tampon et l'imprime sur le device en cours
                                            ; IN  : B=positions dans le tampon clavier
                                            ;       A=caractre lu du clavier (ASCII)
                                            ;       X=pointeur sur le tampon clavier
                                            ; OUT : B=B+1
                                            ;       X=X+1
            stx INDEX
            pula
            pulx
            tsta
            bpl bcl2INKBD
            ldx INDEX
            bra bcl1INKBD

isCTRLL_INKBD:
            cmpa #$0C                       ; normalement c'est CTRL-L pour l'effacement de l'cran
                                            ; Le code $0C n'existe pas dans les tables de transcodage clavier -> ASCII
            beq jsrClearScreen

isCTRLQ_INKBD:
            cmpa #cOS_BS                    ; $08 : est-ce Back SPACE ?
            bne isCTRLA_INKBD

doCTRLQ_INKBD:
            decb
            beq bclINKBD
            dex
            bsr j_printCHAR
            bra bcl1INKBD

isCTRLA_INKBD:
            cmpa #cKB_CTRL_A                ; $15 ; est-ce une demande de nettoyage complet de la saisie utilisateur ?
            bne isBRK_INKBD

doCTRLA_INKBD:
            decb
            beq bclINKBD
            ldaa #cOS_BS                    ; $08 : backspace
            jsr OS_printCHAR                ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                            ; IN  : A=caractre  imprimer
                                            ;       DEVNU mise  jour
                                            ; OUT : B, X unmodified
            bra doCTRLA_INKBD

isBRK_INKBD:
            cmpa #cKB_BREAK
            sec
            beq next10INKBD

isCR_INKBD:
            cmpa #cOS_CR
            bne next11INKBD

doCR_INKBD:
            clra

next10INKBD:
            tpa
            psha
            jsr printCR                     ; FCT : effectue un retour  la ligne
                                            ; IN  : /
                                            ; OUT : A modified
            clr 0,x
            ldx #BUFFERKEYB-1
            pula
            tap

endINKBD:
            rts

next11INKBD:
            cmpa #$20 ; ' '
            bcs bcl1INKBD
            bsr INKBD_echoInput             ; FCT : vrifie que  nous n'avons pas dpass la taille du tampon clavier ($80)
                                            ;       et stocke le caractre lu dans le tampon et  l'imprime sur le device en cours
                                            ; IN  : B=positions dans le tampon clavier
                                            ;       A=caractre lu du clavier (ASCII)
                                            ;       X=pointeur sur le tampon clavier
                                            ; OUT : B=B+1
                                            ;       X=X+1
            bra bcl1INKBD
; End of function INKBD


; =============== S U B R O U T I N E =======================================

; FCT : vrifie que nous n'avons pas dpass la taille du tampon clavier ($80)
;       et stocke le caractre lu dans le tampon et l'imprime sur le device en cours
; IN  : B=positions dans le tampon clavier
;       A=caractre lu du clavier (ASCII)
;       X=pointeur sur le tampon clavier
; OUT : B=B+1
;       X=X+1

INKBD_echoInput:
            cmpb #$80
            bcc endINKBD
            staa 0,x
            inx
            incb
; End of function INKBD_echoInput

; =============== S U B R O U T I N E =======================================

j_printCHAR:
            jmp OS_printCHAR                ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                            ; IN  : A=caractre  imprimer
                                            ;       DEVNU mise  jour
                                            ; OUT : B, X unmodified
; End of function j_printCHAR

; =============== S U B R O U T I N E =======================================

; FCT : Permet soit d'allumer un point avec une colonne
;       soit de dfinir les couleurs de la marge, de la couleur 1 et 2 en HIRES
;       1 - allume un point de couleur C  la position (X,Y)
;       2 - fixe les 3 couleurs en HIRES
;       En mode LORES, l'cran est divis en 1 pav
;       de 2x2 qui contient deux couleurs : le noir pour
;       le fond et la couleur de l'avant: Tout changement
;       de couleur d'un des pixels se rpercute sur les
;       autres pixels de ce pav !
; STX : SET (X,Y,C) avec C=couleur de 0  8 en LORES avec C=0 : utilisation de la couleur dj dfinie dans un pav de 2x2
;       SET (X,Y,C) avec C=couleur de 0  2 en HIRES
;       SET* C0,C1,C2 avec C0:couleur de la marge,C1:Couleur Encre n1, C2: Couleur Encre n2
; OP  : $9B
; ST  : ACTIF
; IN  : le flot d'interprtation
; OUT : /
; RMQ : A optimiser !

romSET:
            jmp doRomSET                ; FCT : COMMANDE BASIC SET
                                        ;       2 utilisations
                                        ;       1re : LORES
                                        ;       CLS0:SET(X,Y,C) avec X=[0;63 ou 79] si mode 32 ou 40 colonnes
                                        ;       2me : HIRES
                                        ;       CLS80:
                                        ;       SET* C0,C1,C2 avec C0: couleur marge [0;7],
                                        ;                  C1: couleur intensit [0..7],
                                        ;                  C2: couleur demi-intensit [0..7]
                                        ;       SET (X,Y,C) avec C=[0,1,2] (marge, intensit, demi-intensit)
                                        ; OP  : $9B
                                        ; IN  : le flot d'interprtation
                                        ; OUT : A,B,X modified
; End of function romSET

; =============== S U B R O U T I N E =======================================

; FCT : Effectue l'opration SET (X,Y,C) pour le mode basse rsolution
; ALG : Rcupre le paramtre C (C=[0..8]) dans le flot d'interprtation
; ST  : ACTIF
; IN  : Flot d'intrerprtation
;       S->POS(X,Y)
;       adrMEM_XY : mise  jour
; OUT : /

doRomSET_LORES:
            jsr getByteAfterComma       ; FCT : Retourne la valeur de l'expression aprs la
                                        ;       virgule contenue dans le flot d'interprtation
                                        ; IN  : /
                                        ; OUT : B=la valeur en octet de l'expression
            pulx                        ; rcupre POS(Y,X)
            cmpb #$08                   ; Est-ce que B=code couleur > 8 ?

isInf0x09:                              ; Oui alors Erreur !
            bhi jmpprintErrorMsg_0x08_FctIncorrect
            decb

isEq0x00:
            bmi nextDoRomSET_LORES
            ldaa #$10                   ; D=B*16 : euh ... 4 * LSL = 8 cycles / LDA + MUL : 12 cycles
            mul                         ; permet de calculer le code couleur  ajouter
                                        ; au caractre semi graphique pour simuler le pixel
                                        ; en LORES
            bra next1DoRomSET_LORES
; ---------------------------------------------------------------------------
; entres : B=$FF si code couleur = 0
;       B=$00  $60 pas pas de $10 si code couleur =[1;7]
;
; Pourquoi lire deux fois la mme zone mmoire ?
; Afin de grer le code couleur = $00 qui est une
; recopie de l'attribut en position (X mod 2, Y Mod 2)
; le mode semi-graphique fait chuter la rsolution de moiti
; Donc :
; X=[0..63],Y:[0..40] devient un cran de 32x20 contenant des pavs de 2x2 pixels avec 2 couleurs dfinissables

nextDoRomSET_LORES:
            jsr GR_getBackColor             ; FCT : Obtient le code couleur du fond du caractre
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : A=unmodified
                                            ;       B=0 si caractre lu est un attribut ou un caractre
                                            ;       sinon le code caractre AND $70 (0111 0000)
            nop                             ; Pourquoi des NOP ?
            nop
            nop
            nop
            nop

next1DoRomSET_LORES:
            stab EOLPNTR                    ; cela sert  beaucoup de choses : op. binaires, etc.
            bsr jmpIsRightParen             ; FCT : vrifie que le prochain caractre est une ')'
                                            ;       sort en erreur si ce n'est pas le cas
                                            ; IN  : le flot d'interprtation
                                            ; OUT : /
            jsr GR_getCharSemiGraphFromXY   ; FCT : Lit la zone mmoire  pointe  par X pour rcuprer
                                            ;       la couleur, l'attribut et le caractre
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : A=0 si code ASCII lu sinon valeur du caractre semi-graphique
            nop                             ; Bon le code n'tait pas stable ...
            nop
                                            ;Calcule le caractre semi-graphiquer ainsi que  sa couleur
                                            ;Au final A = 1 CCC cccc avec 1    pour indiquer caractre semi-graphique
                                            ;                 CCC  code couleur de(s) pixel(s)  allumer
                                            ;                 cccc code du caractre semi graphique reprsentant
                                            ;                  les pixels allums et teints dans un pav de 2x2pixels

computeCharAndColorSemiGraph:
            anda #$0F                       ; nous gardons que le caractre graphique
            oraa adrMEM_XY                  ; nous ajoutons le pixel  allumer
            oraa EOLPNTR                    ; cela sert  beaucoup de choses : op. binaires, etc.
                                            ; nous ajoutons la couleur

endDoRomSET_LORES:
            oraa #$80                       ; bit7=1 : caractre semi-graphique
            jmp jsrjsrPRINT_EF9345          ; FCT : Stocke  la position X=POS(Y,X) le caractre A
                                            ; IN  : A=caractre  afficher
                                            ;       X=POS (Y,X) du caractre  afficher
                                            ; OUT : A,B,X modified
; End of function doRomSET_LORES

; =============== S U B R O U T I N E =======================================

; FCT : teint un pixel en mode LORES et HIRES
; STX : RESET (X,Y)
; OP  : $9C
; ST  : ACTIF
; IN  : le flot d'interprtation
; OUT : /

romRESET:
            jmp doRomRESET                  ; FCT : teint un pixel en mode LORES et HIRES
                                            ; IN  : le flot d'interprtation
                                            ; OUT : /
; End of function romRESET

; ---------------------------------------------------------------------------
            dc.b $5B ; [

; =============== S U B R O U T I N E =======================================

; FCT : Effectue l'action d'teindre un pixel
;       Si  la position X,Y, nous avons un caractre ASCII
;       alors on teint tous les pixels du caractre ASCII !
; IN  : X=POS(Y,X)
; OUT : A,X,Y : modified

doDoRomRESET_LORES:
            jsr GR_getCharFromX_RESET       ; FCT : rcupre la valeur du caractre situ  la position X
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : A=0
                                            ;       B=$20=ATTRIBUT        si valeur lue <$20
                                            ;       B=CODE ASCII          si valeur lue >$20 et <=$7F
                                            ;       B=CODE SEMI GRAPHIQUE si valeur lue >= $80
                                            ; OPT : jsr vREAD_ASCII_EF9345
                                            ;       tab
                                            ;       clra
                                            ;       rts
                                            ;       et on change le code suivant l'appel ...
                                            ;       ===> c'est mieux non ?
            bpl endDoRomSET_LORES           ; si c'est un caractre autre que semi-graphique alors on teint tout car A=0 !
            com adrMEM_XY                   ; sinon on teint le pixel demand !
            andb adrMEM_XY
            jmp moveBtoABeforeJ_WRITE_EF9345; FCT :  Stocke  la position X=POS(Y,X) le caractre B
                                            ; IN  : B=caractre  afficher
                                            ;       X=POS (Y,X) du caractre  afficher
                                            ; OUT : A,B,X modified
; End of function doDoRomRESET_LORES
; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR getParamXY_PPWP

jmpprintErrorMsg_0x08_FctIncorrect:

            jmp printErrorMSG_0x08_FC_FctIncorrect
; END OF FUNCTION CHUNK FOR getParamXY_PPWP

; =============== S U B R O U T I N E =======================================

; FCT : parse l'expression de type (X,Y dans le flot d'interprtation
; STX : /
; ALG : /
; ST  : ACTIF
; IN  : le flot d'interprtation
; OUT : adrMEM_XY=(X,Y) en mode LORES
;       X=POS(Y,X)

parsePRM_GR:
            jsr CHKOPN
; End of function parsePRM_GR


; =============== S U B R O U T I N E =======================================

; FCT : Parse l'expression du type X,Y dans le flot d'interprtation
; ALG : /
; STX : /
; ST  : ACTIF
; IN  : le flot d'interprtation
; OUT : adrMEM_XY a jour
;       A,B,X modified

getParamXY_PPWP:
            jsr GETBYT                      ; FCT : EVALUATE EXPRESSION AT TXTPTR, AND
                                            ;       CONVERT IT TO SINGLE BYTE IN B-REG
                                            ; ERR : FC : fonction incorrecte
                                            ; IN  : le flot d'interprtation
                                            ; OUT : B=la partie haute de la conversion (ACC1+3,ACC1+4)
            nop
            cmpb SCRPIX_XMAX                ; Taille max en pixel pour X
            bcc jmpprintErrorMsg_0x08_FctIncorrect
            pshb                            ; sauve le premier paramtre (X)

getY_PPWP:                                  ; FCT : Retourne la valeur de l'expression aprs la
            jsr getByteAfterComma           ;       virgule contenue dans le flot d'interprtation
                                            ; IN  : /
                                            ; OUT : B=la valeur en octet de l'expression
            cmpb SCRPIX_YMAX                ; Taille max en pixel pour Y
            bcc jmpprintErrorMsg_0x08_FctIncorrect
            pshb                            ; sauve le deuxime paramtre (Y)
            pula                            ; A=POS(Y)
            pulb                            ; B=POS(X)
            pshb                            ; S->Y,X
            psha
            asra                            ; A=POS(Y)/2
            asrb                            ; B=POS(X)/2
            addd HOME_YX                    ; Position de l'cran en haut  gauche =(0,0)
            pshb                            ; S-> X/2,Y,X
            psha                            ; S-> Y/2,X/2,Y,X
            pulx                            ; X=Y/2,X/2
            pula                            ; A=POS(Y)
            pulb                            ; B=POX(X)
            anda #$01                       ; 0:Colonne paire;1:Colonne impaire
            rorb                            ; B=X/2 AND C=bit 0 of X
            rola                            ; A=Parite(Y)*2+(parit de X)
            ldab #$10                       ; B=$10

bclGetParamXY_PPWP:
            lsrb
            deca
            bpl bclGetParamXY_PPWP
            stab adrMEM_XY
            rts
; End of function getParamXY_PPWP


; =============== S U B R O U T I N E =======================================

; FCT : COMMANDE BASIC POINT(X,Y) : retourne l'tat du pixel aux coordonnes (X,Y)
; STX : A=POINT(10,10)
; BUG : /
; ALG : /
; ST  : ACTIF
; OP  : $C5
; IN  : le flot d'interprtation
; OUT : ACC1 : tat du pixel aux coordonnes (X,Y)
;       -1 si il y a un caractre
;       0  si il est teint
;       Si LORES : 1  8 selon la couleur si allum
;       Si HIRES : 1  2 si allum

romPOINT:
            jmp doRomPOINT      ; FCT : retourne la couleur du pixel en position (X,Y) en mode HIRES ou LOWRES
                                ; IN  : le flot d'interprtation contenant les paramtres sous forme (X,Y)
                                ; OUT : retourne
                                ;       en HIRES :-1 (caractre),0 (teint),1 (couleur 1) ou 2 (couleur 2) sous forme de word
                                ;       en LORES :-1 (caractre),0 (teint),1  8 code couleur si allum
; End of function romPOINT

; =============== S U B R O U T I N E =======================================

; FCT : retourne la couleur du pixel en position (X,Y) en mode LOWRES
; IN  : X=POS(Y,X)
; OUT : D=code couleur de la position (Y,X)

doRomPOINT_LOWRES:
            jsr subREAD_EF9345              ; FCT : Lecture de la donne  la position X=POS(Y,X)
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : B=$FF
                                            ;       A=Code ASCII ou ATTRIBUT
            bpl next1DoRomPoint_LOWRES
            anda adrMEM_XY
            beq nextDoRomPoint_LOWRES
            jsr subREAD_EF9345_TODO         ; FCT : Lit le code ASCII  la position (Y,X)
                                            ; IN  : X=POS(Y,X)
                                            ; OUT : B=le code ascii / 2 lu  la position (Y,X)
                                            ;       A=le code ascii lu  la position (Y,X)
            lsrb
            lsrb
            lsrb
            andb #$07

nextDoRomPoint_LOWRES:
            incb

next1DoRomPoint_LOWRES:
            bsr returnWordFromB             ; FCT : Retourne un mot issu de B
                                            ;       range : $00 - $7F => 0000 007F
                                            ;               $80 - $FF => FF80 FFFF
                                            ; IN  : B=byte to convert to signed word
                                            ; OUT : D=convInt2Word(B)
; End of function doRomPOINT_LOWRES

; =============== S U B R O U T I N E =======================================

; FCT : vrifie que le prochain caractre est une ')'
;       sort en erreur si ce n'est pas le cas
; IN  : le flot d'interprtation
; OUT : /
; TODO: pourquoi ne pas enlever ce jmp directement dans le code ?

jmpIsRightParen:
            jmp CHKCLS                  ; FCT : check close parenthesis and get next char
                                        ; IN  : TXTPTR mise  jour
                                        ; OUT : X modified, A et B modified
; End of function jmpIsRightParen

; =============== S U B R O U T I N E =======================================

; FCT : Retourne un mot issu de B
;       range : $00 - $7F => 0000 007F
;               $80 - $FF => FF80 FFFF
; IN  : B=byte to convert to signed word
; OUT : D=convInt2Word(B)

returnWordFromB:
            clra
            tstb
            bpl jmpReturnWord
            coma

jmpReturnWord:
            jmp convWordToACC1              ; FCT : Convert Word to Float
                                            ; IN  : D=number to convert
                                            ; OUT : ACC1=float(D)
; End of function returnWordFromB

; ---------------------------------------------------------------------------
; FCT : Efface l'cran soit
;       - avec la couleur courante
;       - en changeant la rsolution. Dans ce cas, il y a un reset  chaud !
; STX : CLS [0-8] avec [0-8] : couleur du fond d'cran
;       CLS 32 mode 32 colonnes
;       CLS 40 mode 40 colonnes
;       CLS 80 mode hires inversion video
;       CLS 81 mode hires
; OP  : $9D
; ST  : ACTIF
; IN  : /
; OUT : A,B,X : modified
; AMUSANT : CLS avec x > 8 et x <> [32,40,80,81] : efface l'cran affiche microsoft puis OK !

romCLS:
            beq GRNCH                   ; FCT : GRNCH : efface l'cran selon le mode donn par TECRAN
                                        ; IN  : /
                                        ; OUT : /

getParamAndSetMode:
            jsr GR_getParamCLS          ; FCT : lit un paramtre suivant la commande basic CLS
                                        ;       Change le paramtre TECRAN si paramtre = [32,40,80,81]
                                        ;       paramtre autoris 0  7 : pour fixer la couleur du fond
                                        ;       paramtre autoris 32 : mode 32 caractres
                                        ;       paramtre autoris 40 : mode 40 caractres
                                        ;       paramtre autoris 80 : mode 80 caractres
                                        ;       paramtre autoris 81 : mode 80 caractres et inversion
                                        ; IN  : flux  interprter
                                        ; OUT : B = valeur du paramtre
                                        ;       A = 0
            cmpb #$08
            bhi clsWithWarning          ; Si B > 8 alors on efface avec la couleur par dfaut + affichage de microsoft et OK

computeColor:
            tstb
            beq nextRomCLS
            decb
            ldaa #$10
            mul
            orab #$0F

nextRomCLS:
            orab #$80
            SKIP2

; =============== S U B R O U T I N E =======================================

; FCT : GRNCH : efface l'cran selon le mode donn par TECRAN
; IN  : /
; OUT : /

GRNCH:
            ldab ColorCLS
            ldx HOME_YX                 ; Position de l'cran en haut  gauche =(0,0)

setCURAD_YXbeforCLRSCR:
            stx CURAD_YX

jmpVectorCLRSCR:
            jmp vectorCLRSCR            ; FCT : Efface l'cran
                                        ; IN  : B=code couleur du fond de l'cran
                                        ; OUT : A,B,X modified
; End of function GRNCH

; =============== S U B R O U T I N E =======================================

; FCT : Compare X avec l'adresse du vectSCI. Si <> alors on efface l'cran !
; ST  : NON ACTIF
; DBG : OUI
; IN  : X=vecteur
; OUT : /

dbgSCI:
            cpx #vectSCI
            bne jmpVectorCLRSCR
            rts
; End of function dbgSCI


; =============== S U B R O U T I N E =======================================

; FCT : Efface l'cran selon le mode dfini par TECRAN
;       Imprime MICROSOFT  la fin pour indiquer que
;       le paramtre donn  CLS est incorrect (ou un easteregg ?)
; ST  : ACTIF
; DBG : NON
; IN  : /
; OUT : /

clsWithWarning:
            bsr GRNCH                   ; FCT : GRNCH : efface l'cran selon le mode donn par TECRAN
                                        ; IN  : /
                                        ; OUT : /
            ldx #aMicrosoft             ; " MICROSOFT\r"
            jmp OS_OUTTX                ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                        ; IN : X=pointeur sur une chane de caractres termine par un 0
                                        ; OUT: A,B,X modified
; End of function clsWithWarning

; =============== S U B R O U T I N E =======================================

; FCT : Lit un caractre provenant du clavier
; OP  : $C7
; ST  : ACTIF
; IN  : /
; OUT : Retourne une chane de caractre

romINKEYdollar:
            ldaa charKEYB                   ; WAS A KEY DOWN IN THE BREAK CHECK ?
            bne nextRomINKEYdollar
            jsr OS_POLCA                    ; FCT : polling keyboard
                                            ; IN  : /
                                            ; OUT : A=code ascii de la touche
                                            ;       X,B not modified

nextRomINKEYdollar:
            clr charKEYB
            staa ACC1+4
            beq next1RomINKEYdollar
            jmp nextRomCHRdollar

next1RomINKEYdollar:
            staa ACC3
            jmp next1RomCHRdollar
; End of function romINKEYdollar


; =============== S U B R O U T I N E =======================================

; FCT : Execute un sous programme assembleur
; STX : EXEC : excute de nouveau l'appel au sous-programme assembleur
;       EXEC 25000
; OP  : $9F
; ST  : ACTIF
; DBG : NON
; IN  : le flot d'interprtation
;       A=0 si pas d'argument  interprter
; OUT : /

romEXEC:
            beq doRomEXEC
            jsr GETARG                      ; FCT : Rcuprer un word dans le flot d'inteprtation
                                            ; IN  : le flot d'interprtation
                                            ; OUT : X=WORD from ARGUMENT
                                            ;       ACC1+3 contient aussi l'expression convertie de type word
            stx pEXEC

doRomEXEC:
            ldx pEXEC
            jmp 0,x
; End of function romEXEC


; =============== S U B R O U T I N E =======================================

; FCT : Donne le pointeur sur la variable donne en paramtre
;       Il faut que la variable existe sinon message d'erreur
; STX : B=VARPTR(A)
; OP  : $C6
; ST  : ACTIF
; IN  : le flot d'interprtation contenant (A[$])
; OUT : ACC1=Le pointeur sur la variable

romVARPTR:
            ldx STREND
            pshx
            jsr PTRGET                      ; FCT : Lit un nom de variable  l'aide de CHRGOT
                                            ;       et le trouve en mmoire
                                            ; IN  : TXTPTR pointe sur le premier caractre du nom
                                            ; OUT : X=VARPNT=ADRESSE DE LA VARIABLE
                                            ;       (si non trouv alors cration d'une variable simple ou d'un
                                            ;       tableau de dim(10) initialis  0)
            jsr CHKCLS                      ; FCT : check close parenthesis and get next char
                                            ; IN  : TXTPTR mise  jour
                                            ; OUT : X modified, A et B modified
            stx INDEX
            pulx
            ldd INDEX
            cpx STREND
            beq endRomVARPTR
            jmp printErrorMSG_0x08_FC_FctIncorrect

endRomVARPTR:
            jmp convWordToACC1              ; FCT : Convert Word to Float
                                            ; IN  : D=number to convert
                                            ; OUT : ACC1=float(D)
; End of function romVARPTR

; =============== S U B R O U T I N E =======================================

; FCT : rcupre le paramtre numrique suivant le @ de PRINT @
;       vrifie que le paramtre est bien dans l'intervalle
;       en nombre de caractres de l'cran.
;       Et oui ! on ne donne pas X et Y directement !
; IN  ; /
; OUT : D=CURAD_YX=nouvelle position impose par D

getPARAM_AT:
            jsr CHRGETandFRMNUM             ; FCT : Evaluate INDICE INTO ACC1
                                            ; IN  : le flot d'interprtation
                                            ; OUT : D=rsultat de l'interprtation de l'expression
            jmp OS_verifyParam_AT           ; FCT : vrifie que D est bien contenu dans l'intervalle
                                            ;       d'un affichage via PRINT @
                                            ;       au minimum : 0
                                            ;       au maximum : dpend de l'cran 32*16 ou 40*25 ou 80*25
                                            ; IN  : D=Position du curseur en nombre de caractre
                                            ;       et non pas en position (X,Y)
                                            ; OUT : Met  jour CURAD_YX
                                            ;       D=CURAD_YX=nouvelle position impose par D
; End of function getPARAM_AT

; =============== S U B R O U T I N E =======================================

; FCT : Un reliquat de la version prcdente d'ALICE ?
; STX : /
; ST  : NON ACTIF
; IN  : /
; OUT : /

sub_FC2F:
            bls loc_FC34
            jmp printErrorMSG_0x08_FC_FctIncorrect

loc_FC34:
            addd #$31FF
            std CURAD_YX
            rts
; End of function sub_FC2F


; =============== S U B R O U T I N E =======================================

; FCT : TRAITE A LA FOIS CSAVE,CSAVE*
; STX : CSAVE"TITI"
;       CSAVE* T,"TOTO"
; OP  : $98
; ST  : ACTIF
; IN  : A=le prochain caractre (ou opcode)
;       Le flot  interprter
; OUT : A,B,X modified

romCSAVE:
            ldx TXTAB                   ; dbut du programme basic
            stx pMEMBEGIN_K7
            ldx VARTAB                  ; Fin du programme BASIC / dbut des variables
            stx pMEMEND_K7
            clrb                        ; B=0: fichier basic  sauvegarder

romCSAVSE_ARRAY:
            cmpa #cBAS_TOKEN_mult       ; $A9 is star (=ARRAY) ?
            bne nextRomCSAVE

doromCSAVE_ARRAY:                       ; FCT : Traite le paramtrage de CLOAD* : chargement d'un tableau
            jsr K7_getPRMARRAY          ; IN  : le flot d'interprtation
                                        ; OUT : /
            ldab #cK7_TYP_PRG_ARRAY

nextRomCSAVE:
            stab fFICTYP_K7             ; Type du fichier k7 : $00:BASIC,$01 ou $04 selon la rom ?:ARRAY,$02:LANGAGE MACHINE,$05:FICHIER TEXTE DE L'EDITEUR
            ldd pMEMEND_K7
            subd pMEMBEGIN_K7
            std wSAVEorLOAD_K7          ; Nombre d'octets  sauvegarder ou  lire
            bsr K7_writeBlockFileName   ; FCT : Ecrit le bloc de type FILENAME
                                        ; ST  : ACTIF
                                        ; IN  : le flot d'interprtation
                                        ; OUT : A,B,X modified

next1RomCSAVE:
            ldx pMEMBEGIN_K7

bcl2RomCSAVE:
            stx pTMP_K7                 ; pointeur servant  tout ... FILENAME,CLOAD,CSAVE...
            ldaa #$FF
            staa bK7_LG_BLK             ; Longueur du bloc lu ou crit
            ldd pMEMEND_K7
            subd pTMP_K7                ; pointeur servant  tout ... FILENAME,CLOAD,CSAVE...
            bls next4RomCSAVE
            tsta
            bne next3RomCSAVE
            cmpb #$FF
            beq next3RomCSAVE
            stab bK7_LG_BLK             ; Longueur du bloc lu ou crit

next3RomCSAVE:
            bsr K7_writeBlock           ; FCT : envoie un bloc de donnes de n'importe quel type sur le port K7
                                        ;       BLOC :
                                        ;         octet $55 : synchronisation
                                        ;         octet $3C : synchronisation
                                        ;         octet type de bloc : $00 pour le nom de fichier
                                        ;         octet longueur de donnes : $0F pour le nom de fichier
                                        ;         les donnes
                                        ;         octet de vrification : CHECKSUM
                                        ;         octet de fin $55      : synchronisation
                                        ; IN  : pTMP_K7  jour
                                        ; OUT : A,B,X modified
            bra bcl2RomCSAVE

next4RomCSAVE:
            neg BLKTY_K7                ; type de bloc : $00 nom du fichier,$01 bloc de donnes,$FF bloc de fin
            clr bK7_LG_BLK              ; Longueur du bloc lu ou crit
            bsr K7_writeBlock           ; FCT : envoie un bloc de donnes de n'importe quel type sur le port K7
                                        ;       BLOC :
                                        ;         octet $55 : synchronisation
                                        ;         octet $3C : synchronisation
                                        ;         octet type de bloc : $00 pour le nom de fichier
                                        ;         octet longueur de donnes : $0F pour le nom de fichier
                                        ;         les donnes
                                        ;         octet de vrification : CHECKSUM
                                        ;         octet de fin $55      : sychronisation
                                        ; IN  : pTMP_K7  jour
                                        ; OUT : A,B,X modified

endRomCSAVE:
            ldaa #$01
            staa PORT2                  ; Port I/O soit pour RS232 soit pour K7
            rts
; End of function romCSAVE


; =============== S U B R O U T I N E =======================================

; FCT : Ecrit le bloc de type FILENAME
; ST  : ACTIF
; IN  : le flot d'interprtation
; OUT : A,B,X modified

K7_writeBlockFileName:
            jsr K7_getFileName          ; FCT : rcupre le nom du fichier dans le flot d'interprtation
                                        ;       sort en erreur s'il y a une expression aprs le nom du fichier
                                        ; ALG : /
                                        ; STX : /
                                        ; ST  : ACTIF
                                        ; BUG : Ne vrifie pas que la chane de caractres fait 8 de long au maximum !
                                        ; IN  : le flot d'interprtation
                                        ; OUT : stockage dans une zone temporaire du nom du fichier

cpFileName_K7:
            ldx #zTMPFICNM_K7
            stx pTMP_K7                 ; pointeur servant  tout ... FILENAME,CLOAD,CSAVE...
            stx PTRTMP2                 ; utiliser pour copier le nom du fichier

initAREAUNKNOWN_K7:
            clr $09,x                   ; initialise la donne UNKNOWN_1_K7
            clr $0A,x                   ; initialise la donne UNKNOWN_2_K7

doCpFileName_K7:
            ldx #(sTMPBUFK7+1)          ; stocke :
			                            ;  - la longueur du nom du fichier (maxi 8 caractres)
                                        ;  - le nom du fichier
            ldab #$08
            jsr next1OS_CopyMEM         ; Recopie une zone mmoire de la zone X dans la zone pointe par PTRTMP2
                                        ; X=pointeur sur la zone de dpart
                                        ; B=longueur  copier

doWriteBLOCKFILENAME:
            clr BLKTY_K7                ; type de bloc : $00 nom du fichier,$01 bloc de donnes,$FF bloc de fin
            ldaa #$0F
            staa bK7_LG_BLK             ; Longueur du bloc lu ou crit

writeSynchroK7:
            bsr K7_writeHeaderSynchro   ; FCT : Envoi sur le port K7 $0080 fois le caractre de synchro $55
                                        ; ST  : ACTIF
                                        ; IN  : /
                                        ; OUT : X,B modified

writeBLKFILENAME:
            bsr K7_writeBlock           ; FCT : envoie un bloc de donnes de n'importe quel type sur le port K7
                                        ;       BLOC :
                                        ;         octet $55 : synchronisation
                                        ;         octet $3C : synchronisation
                                        ;         octet type de bloc : $00 pour le nom de fichier
                                        ;         octet longueur de donnes : $0F pour le nom de fichier
                                        ;         les donnes
                                        ;         octet de vrification : CHECKSUM
                                        ;         octet de fin $55      : synchronisation
                                        ; IN  : pTMP_K7  jour
                                        ; OUT : A,B,X modified
            inc BLKTY_K7                ; type de bloc : $00 nom du fichier,$01 bloc de donnes,$FF bloc de fin

waitBLKFILENAME:
            ldx #$0000
            jsr bclTempo
; End of function K7_writeBlockFileName


; =============== S U B R O U T I N E =======================================

; FCT : Envoi sur le port K7 $0080 fois le caractre de synchro $55
; ST  : ACTIF
; IN  : /
; OUT : X,B modified

K7_writeHeaderSynchro:

            ldx NBBYTSYNCHRO_K7         ; dfaut : $0080 : nombre d'octets  $55  envoyer sur K7 pour la synchronisation

bclWriteHeaderSynchro_K7:
            bsr K7_WRBYTE_SYNCHRO       ; FCT : Envoie le caractre  $55 de synchronisation sur le port K7
                                        ; ST  : ACTIF
                                        ; IN  : /
                                        ; OUT : X and A not modified
                                        ;       B modified
            dex
            bne bclWriteHeaderSynchro_K7
            rts
; End of function K7_writeHeaderSynchro


; =============== S U B R O U T I N E =======================================

; FCT : envoie un bloc de donnes de n'importe quel type sur le port K7
;   Un bloc est constitu de :
;     octet $55                 : synchronisation
;     octet $3C                 : synchronisation
;     octet type de bloc        : $00 pour le nom de fichier
;     octet longueur de donnes : $0F pour le nom de fichier
;     les donnes               :
;     octet de vrification     : CHECKSUM
;     octet de fin $55          ; synchronisation
; IN  : pTMP_K7  jour
; OUT : A,B,X modified

K7_writeBlock:
            nop
            sei
            ldab bK7_LG_BLK             ; Longueur du bloc lu ou crit
            stab bNB_READ_K7            ; compteur du nombre de donnes  lire : est dcrement de 1  chaque lecture d'octet de la K7
            ldaa bK7_LG_BLK             ; Longueur du bloc lu ou crit
            beq computeByteVerifBlock
            ldx pTMP_K7                 ; pointeur servant  tout ... FILENAME,CLOAD,CSAVE...

bclComputeByteVerifBlock:
            adda 0,x
            inx
            decb
            bne bclComputeByteVerifBlock

computeByteVerifBlock:
            adda BLKTY_K7               ; type de bloc : $00 nom du fichier,$01 bloc de donnes,$FF bloc de fin
            staa bREALL_K7              ; doit tre gal  0 pour effectuer la lecture

setXtoFilename:
            ldx pTMP_K7                 ; pointeur servant  tout ... FILENAME,CLOAD,CSAVE...

WriteVerifBlock_0x55:
            bsr K7_WRBYTE_SYNCHRO       ; FCT : Envoie le caractre $55 de synchronisation sur le port K7
                                        ; ST  : ACTIF
                                        ; IN  : /
                                        ; OUT : X and A not modified
                                        ;       B modified

WriteByteSynchro:
            ldaa #cK7_SYNCHRO_02
            bsr K7_WRBYTE               ; FCT : Ecrit un octet donn par A sur la K7
                                        ; IN  : A=octet  envoyer sur K7
                                        ; OUT : X and A not modified
                                        ;       B modified

WriteTypBlock:
            ldaa BLKTY_K7               ; type de bloc : $00 nom du fichier,$01 bloc de donnes,$FF bloc de fin
            bsr K7_WRBYTE               ; FCT : Ecrit un octet donn par A sur la K7
                                        ; IN  : A=octet  envoyer sur K7
                                        ; OUT : X and A not modified
                                        ;       B modified

WriteLenBlock:
            ldaa bK7_LG_BLK             ; Longueur du bloc lu ou crit
            bsr K7_WRBYTE               ; FCT : Ecrit un octet donn par A sur la K7
                                        ; IN  : A=octet  envoyer sur K7
                                        ; OUT : X and A not modified
                                        ;       B modified
            tsta
            beq WriteVerifBlock

WriteByteForBlock:
            ldaa 0,x
            inx
            bsr K7_WRBYTE               ; FCT : Ecrit un octet donn par A sur la K7
                                        ; IN  : A=octet  envoyer sur K7
                                        ; OUT : X and A not modified
                                        ;       B modified
            dec bNB_READ_K7             ; compteur du nombre de donnes  lire : est dcrement de 1  chaque lecture d'octet de la K7
            bne WriteByteForBlock

WriteVerifBlock:
            ldaa bREALL_K7              ; doit tre gal  0 pour effectuer la lecture
            bsr K7_WRBYTE               ; FCT : Ecrit un octet donn par A sur la K7
                                        ; IN  : A=octet  envoyer sur K7
                                        ; OUT : X and A not modified
                                        ;       B modified
; End of function K7_writeBlock

; =============== S U B R O U T I N E =======================================

; FCT : Envoie le caractre $55 de synchronisation sur le port K7
; ST  : ACTIF
; IN  : /
; OUT : X and A not modified
;       B modified

K7_WRBYTE_SYNCHRO:
            ldaa #cK7_SYNCHRO       ; $55 = 'U'
; End of function K7_WRBYTE_SYNCHRO


; =============== S U B R O U T I N E =======================================

; FCT : Ecrit un octet donn par A sur la K7
; IN  : A=octet  envoyer sur K7
; OUT : X and A not modified
;       B modified

K7_WRBYTE:
            pshx                        ; sauvegarde de X
            psha
            psha
            ldab #$08                   ; nb de bits  envoyer sur K7

bclK7_WRBYTE:
            tsx                         ; nous jouons avec la pile ...
            lsr 0,x                     ; on rcupre un bit  envoyer sur K7
            ldx #cK7_DURATE_BIT_LOW     ; on fixe la dure d'un bit  0 (=$23) ou  1 (=$46)
            bcs next1K7_WRBYTE
            ldx #cK7_DURATE_BIT_HIGH

next1K7_WRBYTE:
            pshx
            ldaa #$01
            staa PORT2                  ; Port I/O soit pour RS232 soit pour K7

bcl2K7_WRBYTE:
            dex
            bne bcl2K7_WRBYTE
            clra
            staa PORT2                  ; Port I/O soit pour RS232 soit pour K7
            pulx

bcl3K7_WRBYTE:
            dex
            bne bcl3K7_WRBYTE
            decb                        ; dcremente le nombre de bits restants  envoyer au lecteur de K7
            bne bclK7_WRBYTE
            pula
            pula
            pulx                        ; Au final A et X ne sont pas modifis

endK7_WRBYTE:
            rts
; End of function K7_WRBYTE


; =============== S U B R O U T I N E =======================================

; FCT : rcupre le nom du fichier dans le flot d'interprtation
;       sort en erreur s'il y a une expression aprs le nom du fichier
; ALG : /
; STX : /
; ST  : ACTIF
; BUG : Ne vrifie pas que la chane de caractres fait 8 de long au maximum !
; IN  : le flot d'interprtation
; OUT : stockage dans une zone temporaire du nom du fichier

K7_getFileName:
            bsr K7_getFilenameFromInput ; FCT : rcupre le nom du fichier dans le flot d'interprtation
                                        ; ST  : ACTIF
                                        ; BUG : Ne vrifie que la chane de caractres fait 8 de long  au maximum !
                                        ; IN  : le flot d'interprtation
                                        ; OUT : zTMPFICNM_K7 est initialise avec le nom du  fichier obtenu  partir du flux d'interprtation
            jsr.w   CHRGOT              ; OJE 13/02/2020
            beq endK7_WRBYTE
            jmp setError0x02_SYNTAXERROR
; End of function K7_getFileName


; =============== S U B R O U T I N E =======================================

; FCT : rcupre le nom du fichier dans le flot d'interprtation
; ST  : ACTIF
; BUG : Ne vrifie que la chane de caractres fait 8 de long  au maximum !
; IN  : le flot d'interprtation
; OUT : zTMPFICNM_K7 est initialise avec le nom du fichier obtenu  partir du flux d'interprtation

K7_getFilenameFromInput:
            ldx #sTMPBUFK7              ; stocke :
                                        ;  - la longueur du nom du fichier (maxi 8 caractres)
                                        ;  - le nom du fichier
            clr 0,x
            ldaa #cOS_SPACE             ; ' '

initK7FILENAMETMP:
            inx
            staa 0,x
            cpx #sTMPBUFK7+9            ; stocke :
                                        ;  - la longueur du nom du fichier (maxi 8 caractres)
                                        ;  - le nom du fichier
            bne initK7FILENAMETMP

;--- ATTENTION pour les futurs optimisations :
;-- X pointe sur la zone zTMPFICNM_K7
;-- donc pb si les zones sTMPBUFK7 et zTMPFICNM_K7
;-- ne sont pas contigues

getFileName_GFK7:
            jsr.w   CHRGOT  ; OJE 13/02/2020 - V2
            beq endK7_WRBYTE
            jsr FRMEVL                  ; FCT : effectue l'valuation du flux d'entre
                                        ; IN  : le flot d'interprtation
                                        ; OUT : ACC1=result of expression (pointeur if string or value if numeric)
            jsr FRESTR                  ; FCT : Libre la zone rserve pour une chane de caractres
                                        ;       lors de l'interprtation du flux d'entre
                                        ; OUT : X=pointeur sur la chane de caractres
                                        ;       B=longueur de la chane de caractre										


setLenFileNme:
            stab sTMPBUFK7              ; stocke :
                                        ;  - la longueur du nom du fichier (maxi 8 caractres)
                                        ;  - le nom du fichier
            beq endK7_WRBYTE
            pshb                        ; sauvegarde de la longueur du nom du fichier

getptrToTmpBufK7:
            ldd #(sTMPBUFK7+1)          ; stocke :
                                        ;  - la longueur du nom du fichier (maxi 8 caractres)
                                        ;  - le nom du fichier
            std PTRTMP2
            pulb                        ; rcupre la longueur du nom de fichier
            jmp next1OS_CopyMEM         ; Recopie une zone mmoire de la zone X dans la zone pointe par PTRTMP2
                                        ; X=pointeur sur la zone de dpart
                                        ; B=longueur  copier
; End of function K7_getFilenameFromInput

; =============== S U B R O U T I N E =======================================

; FCT : TRAITE A LA FOIS CLOAD,CLOAD* (pour tableau) et CLOADM (programme binaire)
; STX : CLOAD "TITI"
;       CLOAD T,"TITI"
;       CLOADM "TITI",offset
; OP  : $97
; ST  : ACTIF
; IN  : le flot  interprter
; OUT : A,B,X modified

romCLOAD:
            cmpa #cBAS_TOKEN_mult       ; $A9 is star ?
            bne isCLOADM
            jmp getARRAY_CLOAD          ; FCT : Charge des donnes de type tableau en provenance d'1 K7
                                        ; ST  : ACTIF
                                        ; IN  : le flot d'interprtation contenant le nom du tableau et celui du fichier
                                        ; OUT : A,B,X modified

isCLOADM:
            cmpa #$4D ; 'M'
            bne doCLOAD
            jmp doCLOADM

doCLOAD:
            clra                        ; on veut un bloc de type nom de fichier
            bsr readAndVerifyBlock      ; FCT : Lit un bloc sur K7 et compare le type de bloc reu avec A
                                        ;       Si non gal  alors message d'erreur
                                        ;       Le nom du fichier est rcupr dans le flux d'entre utilisateur
                                        ; IN  : A=Type de bloc  comparer
                                        ;       le flot d'interprtation contenant le nom du fichier
                                        ; OUT : A,B,X modified
            jsr doRomNEW                ; FCT : Effectue l'action de la commande BASIC NEW
                                        ; IN  : /
                                        ; OUT : X=TXTTAB+2=dbut du programme + 2
            com CURDVC                  ; CURRENT DEVICE : $00 : SCREEN, $FF : K7
            ldd wSAVEorLOAD_K7          ; Nombre d'octets  sauvegarder ou  lire
            addd TXTAB                  ; dbut du programme basic
            jsr nextCHKMEM
            ldx TXTAB                   ; dbut du programme basic

bclDoCLOAD:
            stx pTMP_K7                 ; pointeur servant  tout ... FILENAME,CLOAD,CSAVE...
            bsr K7_readBLOCKDATA        ; FCT : Lit un bloc de donnes en provenance d'une K7
                                        ; IN  : X=pointeur sur la zone de stockage des donnes en provenance de la K7
                                        ; OUT : A=type de dernier bloc lu
            bpl bclDoCLOAD
            stx VARTAB                  ; Fin du programme BASIC / dbut des variables
            ldx #(aOk-1)                ; "\rOK\r"
            jsr OS_OUTTX                ; FCT: OUTTX mission d'une chane de caractres termine par 0
                                        ; IN : X=pointeur sur une chane de caractres termine par un 0
                                        ; OUT: A,B,X modified
            jmp next3PARESELINE
; End of function romCLOAD


; =============== S U B R O U T I N E =======================================

; FCT : Lit un bloc sur K7 et compare le type de bloc reu avec A
;       Si non gal alors message d'erreur
;       Le nom du fichier est rcupr dans le flux d'entre utilisateur
; IN  : A=Type de bloc  comparer
;       le flot d'interprtation contenant le nom du fichier
; OUT : A,B,X modified

readAndVerifyBlock:
            psha
            bsr K7_getFileNameAndSearchIt   ; FCT : Lit un bloc de type nom de l'interface K7.
                                            ;       Si le bloc n'est pas trouv alors erreur
                                            ;       Le nom du fichier est rcupr dans le flux d'entre utilisateur
                                            ; BUG : Une foultitude ...
                                            ;       Pas de vrification  du type de donnes comme nom du fichier !
                                            ;       CLOAD 3 fait partir le BASIC dans les lymbes de l'informatique
                                            ; IN  : le flot d'interprtation
                                            ; OUT : /
            pula
            tst DUMMY_K7                    ; A quoi cela sert-il car il n'y a pas de modif. explicite de cette variable !
            bne endGetARRAYBLOCK_CLOAD
            cmpa fFICTYP_K7                 ; Type du fichier k7 : $00:BASIC,$01 ou $04 selon la rom ?:ARRAY,$02:LANGAGE MACHINE,$05:FICHIER TEXTE DE L'EDITEUR
            beq endGetARRAYBLOCK_CLOAD

printErrMSG_0X24_FM:                        ; Erreur avec un fichier !
            ldab #cBAS_ERR_K7               ; $24 : '$'
            jmp ERROR
; End of function readAndVerifyBlock


; =============== S U B R O U T I N E =======================================

; FCT : Lit un bloc de type nom de l'interface K7.
;       Si le bloc n'est pas trouv alors erreur
;       Le nom du fichier est rcupr dans le flux d'entre utilisateur
; BUG : Une foultitude ...
;       Pas de vrification du type de donnes comme nom du fichier !
;       CLOAD 3 fait partir le BASIC dans les lymbes de l'informatique
; IN  : le flot d'interprtation
; OUT : /

K7_getFileNameAndSearchIt:
            bsr K7_getFilenameFromInput         ; FCT : rcupre le nom du fichier dans le flot d'interprtation
                                                ; ST  : ACTIF
                                                ; BUG : Ne vrifie que la chane de caractres fait 8 de long  au maximum !
                                                ; IN  : le flot d'interprtation
                                                ; OUT : zTMPFICNM_K7 est initialise avec le nom du  fichier obtenu  partir du flux d'interprtation
            jsr K7_searchBlockFilenameFromK7    ; FCT : Cherche le bloc de type FILENAME
                                                ;       2 points d'entre utiliss :
                                                ;       le 1er crit S puis F quand trouv
                                                ;       le 2eme ecrit F quand trouv
                                                ; NAME: CMPNA
                                                ; ST  : ACTIF
                                                ; IN  : la zone zTMPFICNM_K7 (ou sTMPBUFK7 ?) doit tre initialise   avec le nom du fichier
                                                ; OUT : A=$00 si trouv
            bne printErrMSG_IO                  ; Input/Output ERROR !
            jmp K7_skipSYNCHRO                  ; FCT : Permet d'ignorer la squence de synchronisation d'un programme K7
                                                ;       Celle-ci est constitue de :
                                                ;        1 - 128 octets gaux  $55=01010101b
                                                ;        2 - espace blanc de 0,5s
                                                ;        3 - 128 octets gaux  $55=01010101b
                                                ; IN  : /
                                                ; OUT : A,B,X modified

printErrMSG_IO:
            ldab #cBAS_ERR_IO                   ; '"'  ; Input/Output ERROR !
            jmp ERROR
; End of function K7_getFileNameAndSearchIt


; =============== S U B R O U T I N E =======================================

; FCT : Charge des donnes de type tableau en provenance d'1 K7
; ST  : ACTIF
; IN  : le flot d'interprtation contenant le nom du tableau et celui du fichier
; OUT : A,B,X modified

getARRAY_CLOAD:
            bsr K7_getPRMARRAY              ; FCT : Traite le paramtrage de CLOAD* : chargement d'un tableau
                                            ; IN  : le flot d'interprtation
                                            ; OUT : /

getARRAYBLOCK_CLOAD:                        ; Le block  lire doit tre  du type TABLEAU
            ldaa #cK7_TYP_PRG_ARRAY
            bsr readAndVerifyBlock          ; FCT : Lit un bloc sur K7 et compare le type de bloc reu avec A
                                            ;       Si non gal  alors message d'erreur
                                            ;       Le nom du fichier est rcupr dans le flux d'entre utilisateur
                                            ; IN  : A=Type de bloc  comparer
                                            ;       le flot d'interprtation contenant le nom du fichier
                                            ; OUT : A,B,X modified
            ldd pMEMEND_K7
            subd pMEMBEGIN_K7
            subd wSAVEorLOAD_K7             ; Nombre d'octets  sauvegarder ou  lire
            bcc nextGetARRAYBLOCK_CLOAD
            jmp MEMERR                      ; FCT : Point d'entre secondaire pour la gestion d'erreur
                                            ;       il correspond  "plus de place disponible en mmoire"
                                            ; IN  : /
                                            ; OUT : A,B,X modified

nextGetARRAYBLOCK_CLOAD:
            ldx pMEMBEGIN_K7

bclReadBLKDT_K7:
            stx pTMP_K7                     ; pointeur servant  tout ... FILENAME,CLOAD,CSAVE...
            bsr K7_readBLOCKDATA            ; FCT : Lit un bloc de donnes en provenance d'une K7
                                            ; IN  : X=pointeur sur la zone de stockage des donnes en provenance de la K7
                                            ; OUT : A=type de dernier bloc lu
            bpl bclReadBLKDT_K7

endGetARRAYBLOCK_CLOAD:
            rts
; End of function getARRAY_CLOAD


; =============== S U B R O U T I N E =======================================

; FCT : Lit un bloc de donnes en provenance d'une K7
; IN  : X=pointeur sur la zone de stockage des donnes en provenance de la K7
; OUT : A=type de dernier bloc lu

K7_readBLOCKDATA:
            jsr K7_getBlockData             ; FCT : Lit un bloc et vrifie que le type de bloc est DATA
                                            ; IN  : X=endroit o on stocke les donnees en provenance de la K7
                                            ; OUT : A=$03:Erreur code bloc inattendu
                                            ;       A=$02:Erreur problme mmoire
                                            ;       A=$01:Erreur suite  la comparaison avec l'octet de vrification
                                            ;       A=$00:pas d'erreur
                                            ;       X=pointeur sur le dernier octet stock (si demande via B)

errorReadBLOCKDATA_K7:
            bne printErrMSG_IO              ; Input/Output ERROR !
            ldaa BLKTY_K7                   ; type de bloc : $00 nom du fichier,$01 bloc de donnes,$FF bloc de fin
            beq printErrMSG_IO              ; Input/Output ERROR !
            rts
; End of function K7_readBLOCKDATA


; =============== S U B R O U T I N E =======================================

; FCT : Traite le paramtrage de CLOAD* : chargement d'un tableau
; IN  : le flot d'interprtation
; OUT : /

K7_getPRMARRAY:
            jsr.w   CHRGET                  ; OJE 14/02/2020 V3
                                            ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                            ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                            ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                            ; NOT C= NUMERIC ("0" THRU "9")
                                            ; Z= ":" OR END-OF-LINE (A NULL)
                                            ; [ACCA] = NEW CHAR.
                                            ; [TXTPTR]=[TXTPTR]+1
            ldab #$01                       ; on cherche un tableau
            stab SUBFLG
            jsr PTRGET                      ; FCT : Lit un nom de variable  l'aide de CHRGOT
                                            ;       et le trouve en mmoire
                                            ; IN  : TXTPTR pointe sur le premier caractre du nom
                                            ; OUT : X=VARPNT=ADRESSE DE LA VARIABLE
                                            ;       (si non trouv alors cration d'une variable simple ou d'un
                                            ;       tableau de dim(10) initialis  0)
            clr SUBFLG
            jsr CHKNUM
            ldd 2,x
            jsr addXtoTMPPTR                ; FCT : Ajoute  TMPTR un offset donn par X
                                            ; IN  : X=offset  ajouter  TMPPTR
                                            ; OUT : X=D=TMPPTR+offset
            stx pMEMEND_K7
            ldx INDEX
            ldab 4,x
            aslb
            addb #cASS_LG_NAME_SYMB
            abx
            stx pMEMBEGIN_K7
            jsr.w   CHRGOT                  ; OJE 13/02/2020
            beq endGetARRAYBLOCK_CLOAD
            jmp CHKCOM
; End of function K7_getPRMARRAY

; ---------------------------------------------------------------------------
;----------------------
; CLOADM "TITI",20000
;----------------------
; START OF FUNCTION CHUNK FOR romCLOAD

doCLOADM:
            jsr.w   CHRGET
                                            ; "CHRGET" USING [TXTPTR] AS THE CURRENT TEXT PNTR
                                            ; FETCHES A NEW CHARACTER INTO ACCA AFTER INCREMENTING [TXTPTR]
                                            ; AND SETS CONDITION CODES ACCORDING TO WHAT'S IN ACCA.
                                            ; NOT C= NUMERIC ("0" THRU "9")
                                            ; Z= ":" OR END-OF-LINE (A NULL)
                                            ; [ACCA] = NEW CHAR.
                                            ; [TXTPTR]=[TXTPTR]+1

readFileNameBlock_CLOADM:                   ; 2 : on veut un bloc de type langage machine
            ldaa #cK7_TYP_PRG_ASS
            bsr readAndVerifyBlock          ; FCT : Lit un bloc sur K7 et compare le type de bloc reu avec A
                                            ;       Si non gal  alors message d'erreur
                                            ;       Le nom du fichier est rcupr dans le flux d'entre utilisateur
                                            ; IN  : A=Type de bloc  comparer
                                            ;       le flot d'interprtation contenant le nom du fichier
                                            ; OUT : A,B,X modified

getOffset_CLOADM:                           ; Obtient l'offset de chargement si existant
            ldx #$0000                      ; initialise l'offset  0
            jsr.w   CHRGOT                  ; OJE 13/02/2020
            beq nextDoCLOADM
            jsr CHKCOM                      ; une virgule doit exister ...
            jsr GETARG                      ; FCT : Rcuprer un word dans le flot d'inteprtation
                                            ; IN  : le flot d'interprtation
                                            ; OUT : X=WORD from ARGUMENT
                                            ;       ACC1+3 contient aussi l'expression convertie de type word

nextDoCLOADM:
            stx INDEX                       ; stocke l'offset dans l'INDEX
                                            ; aprs le code ...  je suis perplexe
            ldd wOFSLOAD_K7                 ; offset de chargement du programme, $0000 par dfaut
            addd INDEX
            std pEXEC                       ; des fois le code est bizarre ... ldd add std !
                                            ; pas si bizarre si on stocke un offset ! voir la doc ...
            ldd wSAVEorLOAD_K7              ; Super bizarre ce code, ils l'ont ecrit  3 ?
            addd INDEX
            pshb
            psha
            pulx
            bra bclReadBLKDT_K7
; END OF FUNCTION CHUNK FOR romCLOAD

; =============== S U B R O U T I N E =======================================
; FCT : K7 : recherche d'un programme sur K7
; STX : SKIPF "FICHIER"
; OP  : $A0
; ST  : ACTIF
; IN  : le flot d'interprtation
; OUT : A,B,X modified

romSKIPF:
            jsr K7_getFileNameAndSearchIt   ; FCT : Lit un bloc de type nom de l'interface K7.
                                            ;       Si le bloc n'est pas trouv alors erreur
                                            ;       Le nom du fichier est rcupr dans le flux d'entre utilisateur
                                            ; BUG : Une foultitude ...
                                            ;       Pas de vrification  du type de donnes comme nom du fichier !
                                            ;       CLOAD 3 fait partir le BASIC dans les lymbes de l'informatique
                                            ; IN  : le flot d'interprtation
                                            ; OUT : /
            bsr K7_searchNextBlockFileName_bcl
            bne errorReadBLOCKDATA_K7
            rts
; End of function romSKIPF


; =============== S U B R O U T I N E =======================================

; FCT : Cherche le bloc de type FILENAME
;       2 points d'entre utiliss :
;       le 1er crit S puis F quand trouv
;       le 2eme ecrit F quand trouv
; NAME: CMPNA
; ST  : ACTIF
; IN  : la zone zTMPFICNM_K7 (ou sTMPBUFK7 ?) doit tre initialise avec le nom  du fichier
; OUT : A=$00 si trouv

K7_searchBlockFilenameFromK7:
            ldaa CURLIN                         ; Sommes nous en mode diteur (=$FFFF) ou en mode excution   (<>$FFFF)
            inca
            bne nextSearchHeaderFromK7          ; efface l'cran si on est en mode editeur
            jsr GRNCH                           ; FCT : GRNCH : efface l'cran selon le mode donn par TECRAN
                                                ; IN  : /
                                                ; OUT : /

printSAtHome:
            ldaa #$53                           ; 'S' ; imprime 'S'  la position(0,0)
            bsr K7_printCharOnScreen            ; FCT : Imprime obligatoirement le caractre sur l'cran
                                                ; IN  : A= caractre  imprimer
                                                ; OUT : A,B,X unmodified
            jsr OS_printESPACE

nextSearchHeaderFromK7:
            bsr K7_getBlockFileName             ; FCT : Lit un bloc et vrifie que le type de bloc est FILENAME
                                                ; IN  : /
                                                ; OUT : A=Type de bloc lu
            oraa BLKTY_K7                       ; type de bloc : $00 nom du fichier,$01 bloc de donnes,$FF bloc de fin
            bne endSearchHeaderFromK7
            clrb
            pshb

bcl1SearchHeaderFromK7:
            ldx #zTMPFICNM_K7
            abx
            ldaa 0,x
            ldx CURLIN
            inx
            bne next2SearchHeaderFromK7
            bsr K7_printCharOnScreen            ; FCT : Imprime obligatoirement le caractre sur l'cran
                                                ; IN  : A= caractre  imprimer
                                                ; OUT : A,B,X unmodified

next2SearchHeaderFromK7:
            ldx #(sTMPBUFK7+1)                  ; stocke :
                                                ;  - la longueur du nom du fichier (maxi 8 caractres)
                                                ;  - le nom du fichier
            abx
            suba 0,x
            tsx
            oraa 0,x
            staa 0,x
            incb
            cmpb #$08
            bne bcl1SearchHeaderFromK7
            pula
            tsta
            beq next3SearchHeaderFromK7_WriteF
            tst sTMPBUFK7                       ; stocke :
                                                ;  - la longueur du nom du fichier (maxi 8 caractres)
                                                ;  - le nom du fichier

isFound:
            beq next3SearchHeaderFromK7_WriteF  ; Si = 0 alors trouv donc on affiche 'F'  la position (0,0) puis on sort
            bsr K7_searchBlockFileName          ; FCT : Cherche un bloc de type FileName
                                                ;       2 point d'entres
                                                ; IN  : /
                                                ; OUT : A=code erreur
                                                ;       $00 : trouv
            bne endSearchHeaderFromK7
            bra K7_searchBlockFilenameFromK7    ; FCT : Cherche le bloc de type FILENAME
                                                ;       2 points d'entres utiliss :
                                                ;        le 1er crit S puis F quand trouv
                                                ;        le 2eme ecrit F quand trouv
                                                ; NAME: CMPNA
                                                ; ST  : ACTIF
                                                ; IN  : la zone zTMPFICNM_K7 (ou sTMPBUFK7 ?) doit tre initialise   avec le nom du fichier
                                                ; OUT : A=$00 si trouv

next3SearchHeaderFromK7_WriteF:
            ldaa #$46                           ; 'F' ; crit 'F'  la position (0,0) de l'cran
            bsr K7_printCHARatHOME              ; FCT : Imprime le caractre A  la position (0,0) de l'cran vido
                                                ; IN  : A=code ASCII du caractre   afficher
                                                ; OUT : A,B,X modified
            clra

endSearchHeaderFromK7:
            rts
; End of function K7_searchBlockFilenameFromK7


; =============== S U B R O U T I N E =======================================

; FCT : Imprime obligatoirement le caractre sur l'cran
; IN  : A= caractre  imprimer
; OUT : A,B,X unmodified

K7_printCharOnScreen:
            clr DEVNU                       ; 0 : affichage sur l'cran <>0 affichage sur l'imprimante
            jmp OS_printCHAR                ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                            ; IN  : A=caractre  imprimer
                                            ;       DEVNU mise  jour
                                            ; OUT : B, X unmodified
; End of function K7_printCharOnScreen

; =============== S U B R O U T I N E =======================================

; FCT : Cherche un bloc de type FileName
;       2 points d'entre
; IN  : /
; OUT : A=code erreur
;       $00 : trouv

K7_searchBlockFileName:
            jsr K7_skipSYNCHRO              ; FCT : Permet d'ignorer la squence de synchronisation d'un programme K7
                                            ;       Celle-ci est constitue de :
                                            ;        1 - 128 octets gaux  $55=01010101b
                                            ;        2 - espace blanc de 0,5s
                                            ;        3 - 128 octets gaux  $55=01010101b
                                            ; IN  : /
                                            ; OUT : A,B,X modified

K7_searchNextBlockFileName_bcl:
            ldaa #$FF
            tab
            bsr K7LEC                       ; FCT : lit un programme sur K7
                                            ; ALG : 1 - synchronisation avec le caractre $3C
                                            ;       2 - Lit le type de bloc
                                            ;       3 - Lit la longueur du bloc
                                            ;       4 - itre sur la longueur de bloc pour rcuprer les donnes si ncessaire
                                            ;       5 - Lit un octet de vrification = somme des donnes + type  de bloc + longueur du bloc
                                            ; ST  : ACTIF
                                            ; IN  : A:longueur du bloc  lire
                                            ;       B=0 crit les donnes lues en mmoire <>0 ne les crit pas
                                            ;       X=pointeur sur la zone de stockage des donnes (si la demande est faite par B)
                                            ; OUT : A=$03:Erreur code bloc inattendu
                                            ;       A=$02:Erreur problme mmoire
                                            ;       A=$01:Erreur suite  la comparaison avec l'octet de vrification
                                            ;       A=$00:pas d'erreur
                                            ;       X=pointeur sur le dernier octet stock (si demande via B)
            bne K7_searchBlockFileName_end
            ldaa BLKTY_K7                   ; type de bloc : $00 nom du fichier,$01 bloc de donnes,$FF bloc de fin
            nega
            bmi K7_searchNextBlockFileName_bcl
            deca

K7_searchBlockFileName_end:
            staa bNB_READ_K7                ; compteur du nombre de donnes  lire : est dcrement de 1  chaque lecture d'octet de la K7
            rts
; End of function K7_searchBlockFileName


; =============== S U B R O U T I N E =======================================

; FCT : Inverse l'affichage du caractre  la position (0,0) de l'cran vido
;       Si c'est un attribut alors on imprime un espace
; IN  : /
; OUT : A,B,X modified

invCHARatHome:
            jsr GR_readASCII_HOME           ; FCT : Lit le caractre en mmoire vido  la position (0,0)
                                            ; IN  : /
                                            ; ST  : ACTIF
                                            ; OUT : X unmodified
                                            ;       A=$20 si attribut sinon code ASCII du caractre lu
            eora #$20 ; ' '
; End of function invCHARatHome


; =============== S U B R O U T I N E =======================================

; FCT : Imprime le caractre A  la position (0,0) de l'cran vido
; IN  : A=code ASCII du caractre  afficher
; OUT : A,B,X modified

K7_printCHARatHOME:
            ldab CURLIN
            incb
            bne endPrintCHARatHOME
            jsr GR_printCarAtHome           ; FCT : Imprime le caractre A  la position (0,0) de l'cran
                                            ; IN  : A=caractre  imprimer
                                            ; OUT : A,B modified
                                            ;       X unmodified

endPrintCHARatHOME:
            rts
; End of function K7_printCHARatHOME


; =============== S U B R O U T I N E =======================================

; FCT : Lit un bloc et vrifie que le type de bloc est FILENAME
; IN  : /
; OUT : A=Type de bloc lu

K7_getBlockFileName:
            jsr K7_skipSYNCHRO              ; FCT : Permet d'ignorer la squence de synchronisation d'un programme K7
                                            ;       Celle-ci est constitue de :
                                            ;        1 - 128 octets gaux  $55=01010101b
                                            ;        2 - espace blanc de 0,5s
                                            ;        3 - 128 octets gaux  $55=01010101b
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            ldx #zTMPFICNM_K7
            stx pTMP_K7                     ; pointeur servant  tout ... FILENAME,CLOAD,CSAVE...
            ldaa #$0F                       ; Bloc de type FileName XXXXXX
            SKIP2
; End of function K7_getBlockFileName

; =============== S U B R O U T I N E =======================================

; FCT : Lit un bloc et vrifie que le type de bloc est DATA
; IN  : X=endroit o on stocke les donnees en provenance de la K7
; OUT : A=$03:Erreur code bloc inattendu
;       A=$02:Erreur problme mmoire
;       A=$01:Erreur suite  la comparaison avec l'octet de vrification
;       A=$00:pas d'erreur
;       X=pointeur sur le dernier octet stock (si demande via B)


K7_getBlockData:
            ldaa #$FF
            clrb
; End of function K7_getBlockData


; =============== S U B R O U T I N E =======================================

; FCT : lit un programme sur K7
; ALG : 1 - synchronisation avec le caractre $3C
;       2 - Lit le type de bloc
;       3 - Lit la longueur du bloc
;       4 - itre sur la longueur de bloc pour rcuprer les donnes si ncessaire
;       5 - Lit un octet de vrification = somme des donnes + type de bloc + longueur du bloc
; ST  : ACTIF
; IN  : A:longueur du bloc  lire
;       B=0 crit les donnes lues en mmoire <>0 ne les crit pas
;       X=pointeur sur la zone de stockage des donnes (si la demande est faite par B)
; OUT : A=$03:Erreur code bloc inattendu
;       A=$02:Erreur problme mmoire
;       A=$01:Erreur suite  la comparaison avec l'octet de vrification
;       A=$00:pas d'erreur
;       X=pointeur sur le dernier octet stock (si demande via B)

K7LEC:
            psha                        ; sauvegarde la longueur du bloc  lire
            stab fSAVEDATA_K7           ; =$00:sauve les donnes K7 en mmoire sinon ne les sauve pas
            nop
            sei
            bsr invCHARatHome           ; FCT : Inverse l'affichage du caractre  la position (0,0) de l'cran vido
                                        ;       Si c'est un attribut alors on imprime un espace
                                        ; IN  : /
                                        ; OUT : A,B,X modified
            ldx pTMP_K7                 ; pointeur servant  tout ... FILENAME,CLOAD,CSAVE...
            clra                        ; RESET ACCA

bclK7LEC_SYNCHRO:
            bsr K7_readBit              ; FCT : Lit un bit en provenance du magntophone
                                        ; IN  : /
                                        ; OUT : C=value of bit read from K7
                                        ;       B modified
                                        ;       A unmodified
            rora
            cmpa #cK7_SYNCHRO_02        ; est-ce l'octet de synchronisation ($3C) ?
            bne bclK7LEC_SYNCHRO

K7LEC_TYPBLK:
            bsr K7_readByte             ; FCT : Lit 8bits de donnes de la K7
			                            ; IN  : /
                                        ; OUT : A=octet lu lors de la lecture des donnes K7
                                        ;       B modified
            staa BLKTY_K7               ; type de bloc : $00 nom du fichier, $01 bloc de donnes, $FF bloc de fin

K7LEC_LGDATA:
            bsr K7_readByte             ; FCT : Lit 8bits de donnes de la K7
			                            ; IN  : /
                                        ; OUT : A=octet lu lors de la lecture des donnes K7
                                        ;       B modified
            staa bK7_LG_BLK             ; Longueur du bloc lu ou crit
            pulb                        ; rcupre la longueur du bloc  lire
            cba
            bhi next4K7LEC
            adda BLKTY_K7               ; type de bloc : $00 nom du fichier, $01 bloc de donnes ,$FF bloc de fin
            staa bREALL_K7              ; doit tre gal  0 pour effectuer la lecture
            ldaa bK7_LG_BLK             ; Longueur du bloc lu ou crit
            staa bNB_READ_K7            ; compteur du nombre de donnes  lire : est dcrement de 1  chaque lecture d'octet de la K7
            beq next3K7LEC_verify

bcl1K7LEC:
            bsr K7_readByte             ; FCT : Lit 8bits de donnes de la K7
                                        ; IN  : /
                                        ; OUT : A=octet lu lors de la lecture des donnes K7
                                        ;       B modified

issaveData:
            tst fSAVEDATA_K7            ; =$00:sauve les donnes K7 en mmoire sinon ne les sauve pas
            bne next2K7LEC
            staa 0,x
            cmpa $00,x
            bne next5K7LEC
            inx

next2K7LEC:
            adda bREALL_K7              ; doit tre gal  0 pour effectuer la lecture
            staa bREALL_K7              ; doit tre gal  0 pour effectuer la lecture
            dec bNB_READ_K7             ; compteur du nombre de donnes  lire : est dcrement de 1  chaque lecture d'octet de la K7
            bne bcl1K7LEC

next3K7LEC_verify:
            bsr K7_readByte             ; FCT : Lit 8bits de donnes de la K7
                                        ; IN  : /
                                        ; OUT : A=octet lu lors de la lecture des donnes K7
                                        ;       B modified
            suba bREALL_K7              ; doit tre gal  0 pour effectuer la lecture
            beq endK7LEC
            ldaa #$01
            SKIP2

next4K7LEC:
            ldaa #$03
            SKIP2

next5K7LEC:
            ldaa #$02

endK7LEC:
            staa bNB_READ_K7             ; compteur du nombre de donnes  lire : est dcrement de 1  chaque lecture d'octet de la K7
            rts
; End of function K7LEC


; =============== S U B R O U T I N E =======================================

; FCT : Lit 8bits de donnes de la K7
; IN  : /
; OUT : A=octet lu lors de la lecture des donnes K7
;       B modified

K7_readByte:
            ldaa #$08
            staa bNbBitsToRDWR_K7

bclReaddByteFromK7:
            bsr K7_readBit              ; FCT : Lit un bit en provenance du magntophone
                                        ; IN  : /
                                        ; OUT : C=value of bit read from K7
                                        ;       B modified
                                        ;       A unmodified
            rora
            dec bNbBitsToRDWR_K7
            bne bclReaddByteFromK7
            rts
; End of function K7_readByte


; =============== S U B R O U T I N E =======================================

; FCT : Lit un bit en provenance du magntophone
; IN  : /
; OUT : C=value of bit read from K7
;       B modified
;       A unmodified

K7_readBit:
            bsr K7_getTimeBetweenTransition ; FCT : Permet de dterminer la valeur du bit lu en
                                            ;       se basant sur les dures de  transition bas vers haut
                                            ; IN  : /
                                            ; OUT : /
            ldab CPERTM_K7                  ; longueur (quivalent  un temps) d'un bit lu en provenance du port K7
            decb                            ; Si B < CMMID_K7 alors le bit lu est un 1 sinon un 0
            cmpb CMPMID_K7                  ; $18 par dfaut ;  valeur de comparaison pour dterminer si c'est un bit  1 ou  0
            rts
; End of function K7_readBit


; =============== S U B R O U T I N E =======================================

; FCT : Permet de dterminer la valeur du bit lu en
;       se basant sur les dures de transition bas vers haut
; IN  : /
; OUT : /

K7_getTimeBetweenTransition:
            clr CPERTM_K7               ; longueur (quivalent  un temps) d'un bit lu en provenance du port K7
            tst CBTPHA_K7               ; flag indiquant la phase de lecture du port K7 (quelle transition HI-LO or LO-HI)
            bne K7_waitTransitionHigh_Low
; End of function K7_getTimeBetweenTransition


; =============== S U B R O U T I N E =======================================

; FCT : attend une transition du bas vers le haut en provenance du port K7
; IN  : /
; OUT : /

K7_waitTransitionLowHigh:
            bsr K7_readInput                ; FCT : Lit l'tat du port d'entre de la K7
                                            ; IN  : /
                                            ; OUT : B=0   : bit  0
                                            ;       B<> 0 : bit  1
            bne K7_waitTransitionLowHigh    ; FCT : attend une transition du bas vers le haut en provenance du port K7
                                            ; IN  : /
                                            ; OUT : /
; End of function K7_waitTransitionLowHigh

; =============== S U B R O U T I N E =======================================

; FCT : Attend une transition haute sur le port K7
; IN  : /
; OUT : B<>0

K7_waitTransitionHigh:
            bsr K7_readInput                ; FCT : Lit l'tat du port d'entre de la K7
                                            ; IN  : /
                                            ; OUT : B=0   : bit  0
                                            ;       B<> 0 : bit  1
            beq K7_waitTransitionHigh       ; FCT : Attend une transition haute sur le port K7
                                            ; IN  : /
                                            ; OUT : B<>0
            rts
; End of function K7_waitTransitionHigh


; =============== S U B R O U T I N E =======================================

; FCT : Lit l'tat du port d'entre de la K7
; IN  : /
; OUT : B=0   : bit  0
;       B<> 0 : bit  1

K7_readInput:
            inc CPERTM_K7                   ; longueur (quivalent  un temps) d'un bit lu en provenance du port K7
            ldab PORT2                      ; Port I/O soit pour RS232 soit pour K7
            andb #$10                       ; 0x10=0001 0000
            rts
; End of function K7_readInput

; ---------------------------------------------------------------------------
; START OF FUNCTION CHUNK FOR K7_getTimeBetweenTransition

K7_waitTransitionHigh_Low:
            bsr K7_readInput                ; FCT : Lit l'tat du port d'entre de la K7
                                            ; IN  : /
                                            ; OUT : B=0   : bit  0
                                            ;       B<> 0 : bit  1
            beq K7_waitTransitionHigh_Low
; END OF FUNCTION CHUNK FOR K7_getTimeBetweenTransition

; =============== S U B R O U T I N E =======================================

; FCT : Attend une transition basse sur le port K7
; IN  : /
; OUT : B=0

K7_waitTransitionLow:
            bsr K7_readInput                ; FCT : Lit l'tat du port d'entre de la K7
                                            ; IN  : /
                                            ; OUT : B=0   : bit  0
                                            ;       B<> 0 : bit  1
            bne K7_waitTransitionLow        ; FCT : Attend une transition basse sur le port K7
                                            ; IN  : /
                                            ; OUT : B=0
            rts
; End of function K7_waitTransitionLow


; =============== S U B R O U T I N E =======================================

; FCT : Permet d'ignorer la squence de synchronisation d'un programme K7
;       Celle-ci est constitue de :
;       1 - 128 octets gaux  $55=01010101b
;       2 - espace blanc de 0,5s
;       3 - 128 octets gaux  $55=01010101b
; IN  : /
; OUT : A,B,X modified

K7_skipSYNCHRO:
            nop
            sei
            clr bNbBitsToRDWR_K7

bclReadByteFromK7:
            bsr K7_waitTransitionLowHigh    ; FCT : attend une transition du bas vers le haut en provenance du port K7
                                            ; IN  : /
                                            ; OUT : /

bcl1ReadByteFromK7:
            bsr K7_waitTransitionLow_0      ; FCT : Attend une transition basse
                                            ;       2 point d'entres
                                            ; IN  : /
                                            ; OUT : B=0
                                            ;       bLenBit_K7=0
            bhi next4ReadByteFromK7

bcl2ReadByteFromK7:
            bsr K7_waitTransitionHigh_0     ; FCT : Attend une transition haute vers basse
                                            ; IN  : /
                                            ; OUT : B=0
                                            ;       bLenBit_K7=0
            bcs next5ReadByteFromK7
            dec bNbBitsToRDWR_K7
            ldaa bNbBitsToRDWR_K7
            cmpa #$A0 ; ''

bcl3ReadByteFromK7:
            bne bclReadByteFromK7
            staa CBTPHA_K7                  ; flag indiquant la phase de lecture du port K7 (quelle transition HI-LO or LO-HI)
            rts

next4ReadByteFromK7:
            bsr K7_waitTransitionHigh_0     ; FCT : Attend une transition haute vers basse
                                            ; IN  : /
                                            ; OUT : B=0
                                            ;       bLenBit_K7=0
            bhi bcl1ReadByteFromK7

next5ReadByteFromK7:
            bsr K7_waitTransitionLow_0      ; FCT : Attend une transition basse
                                            ;       2 point d'entres
                                            ; IN  : /
                                            ; OUT : B=0
                                            ;       bLenBit_K7=0
            bcs bcl2ReadByteFromK7
            inc bNbBitsToRDWR_K7
            ldaa bNbBitsToRDWR_K7
            suba #$60
            bra bcl3ReadByteFromK7
; End of function K7_skipSYNCHRO


; =============== S U B R O U T I N E =======================================

; FCT : Attend une transition haute vers basse
; IN  : /
; OUT : B=0
;       bLenBit_K7=0

K7_waitTransitionHigh_0:
            clr CPERTM_K7                   ; longueur (quivalent  un temps) d'un bit lu en provenance du port K7
            bsr K7_waitTransitionHigh       ; FCT : Attend une transition haute sur le port K7
                                            ; IN  : /
                                            ; OUT : B<>0
            bra K7_waitTransitionLow_next
; End of function K7_waitTransitionHigh_0


; =============== S U B R O U T I N E =======================================

; FCT : Attend une transition basse
;       2 point d'entres
; IN  : /
; OUT : B=0
;       bLenBit_K7=0

K7_waitTransitionLow_0:
            clr CPERTM_K7               ; longueur (quivalent  un temps) d'un bit lu en provenance du port K7
            bsr K7_waitTransitionLow    ; FCT : Attend une transition basse sur le port K7
                                        ; IN  : /
                                        ; OUT : B=0

K7_waitTransitionLow_next:
            ldab CPERTM_K7              ; longueur (quivalent  un temps) d'un bit lu en provenance du port K7
            cmpb CMP0_K7                ; $1A par dfaut ;  Limite haute pour un signal  1200 hz
            bhi K7_waitTransitionLow_end; Est-ce suprieur  la constante CMP0_K7 ? Oui alors saut
            cmpb CMP1_K7                ; $0B par dfaut ;  limite haute pour une frquence   2400 Hz
            rts

K7_waitTransitionLow_end:
            clr bNbBitsToRDWR_K7
            rts
; End of function K7_waitTransitionLow_0


; =============== S U B R O U T I N E =======================================

; FCT : Obtient le deuxime paramtre de la fonction SOUND
;        partir du flot d'interprtation contenant ,XX
; IN  : le flot d'interprtation
; OUT : B=rsultat de l'interprtration du deuxime paramtre

getNextParam_RomSOUND:
            jsr CHKCOM
; End of function getNextParam_RomSOUND


; =============== S U B R O U T I N E =======================================

; FCT : Conversion de l'expression du flux d'interprtation en octet
; ALG : /
; STX : /
; ST  : ACTIF
; IN  : le flot d'interprtation
; OUT : B=rsultat de l'expression
;
getParam_RomSOUND:
            jsr GETBYT                  ; FCT : EVALUATE EXPRESSION AT TXTPTR, AND
                                        ;       CONVERT IT TO SINGLE BYTE IN B-REG
                                        ; ERR : FC : fonction incorrecte
                                        ; IN  : le flot d'interprtation
                                        ; OUT : B=la partie haute de la conversion (ACC1+3,ACC1+4)
            tstb
            bne endRomSOUND
            jmp printErrorMSG_0x08_FC_FctIncorrect
; End of function getParam_RomSOUND


; =============== S U B R O U T I N E =======================================

; FCT : Gnre un son de hauteur n1 pendant une priode n2
;       avec n1=[0..255] et n2=[0..255] : unit 7.5/100e de seconde
;       rend inutilisable le clavier car utilise la broche de
;       dtection d'une touche du clavier pour gnrer
;       le signal carr
; STX : SOUND 10,55
; OP  : $9E
; ST  : ACTIF
; IN  : le flot d'interprtation
; OUT : romSOUND

romSOUND:
            bsr getParam_RomSOUND           ; FCT : Conversion de l'expression du flux d'interprtation en octet
                                            ; ALG : /
                                            ; STX : /
                                            ; ST  : ACTIF
                                            ; IN  : le flot d'interprtation
                                            ; OUT : B=rsultat de l'expression
                                ;
            pshb
            bsr getNextParam_RomSOUND       ; FCT : Obtient le deuxime paramtre de la  fonction SOUND
                                            ;        partir du flot d'interprtation contenant ,XX
                                            ; IN  : le flot d'interprtation
                                            ; OUT : B=rsultat de l'interprtration du deuxime paramtre
            pula

initRomSound:

            psha
            pshb
            clra

bcl1RomSOUND:
            ldx CPTHOR                      ; Compteur d'horloge
            ldab CPTHOR_STATUS
            stx CPTHOR_CMP                  ; Comparateur pour le compteur d'horloge

bcl2RomSOUND:
            eora #$80
            staa IO_COL_KBD                 ; pour une range active du clavier, indique par un 0 la touche du clavier active
                                            ; est utilis aussi pour le son !
            tsx
            ldab 1,x

bcl3RomSOUND:
            inx
            inx
            incb
            bne bcl3RomSOUND
            ldab CPTHOR_STATUS
            andb #$40 ; '@'
            beq bcl2RomSOUND
            tsx
            dec 0,x
            bne bcl1RomSOUND
            clra
            staa IO_COL_KBD                 ; pour une range active du clavier, indique par un 0 la touche du clavier active
                                            ; est utilis aussi pour le son !
            pulx

endRomSOUND:
            rts
; End of function romSOUND

; ---------------------------------------------------------------------------
aCHAMBERLIN:        dc.b "nilrebmahC"
;----------------
; Cela ne sert rien, non ?
            dc.w OS_POLCA                   ; FCT : polling keyboard
                                            ; IN  : /
                                            ; OUT : A=code ascii de la touche
                                            ;       X,B not modified
            dc.w OS_printCHAR               ; FCT : OUTCA : mission d'un caractre soit sur imprimante soit sur l'cran
                                            ; IN  : A=caractre  imprimer
                                            ;       DEVNU mise  jour
                                            ; OUT : B, X unmodified
            dc.w K7_skipSYNCHRO             ; FCT : Permet d'ignorer la squence de synchronisation d'un programme K7
                                            ;       Celle-ci est constitue de :
                                            ;        1 - 128 octets gaux  $55=01010101b
                                            ;        2 - espace blanc de 0,5s
                                            ;        3 - 128 octets gaux  $55=01010101b
                                            ; IN  : /
                                            ; OUT : A,B,X modified
            dc.w K7LEC                      ; FCT : lit un programme sur K7
                                            ; ALG : 1 - synchronisation avec le caractre $3C
                                            ;       2 - Lit le type de bloc
                                            ;       3 - Lit la longueur du bloc
                                            ;       4 - itre sur la longueur de bloc pour rcuprer les donnes si ncessaire
                                            ;       5 - Lit un octet de vrification = somme des donnes + type  de bloc + longueur du bloc
                                            ; ST  : ACTIF
                                            ; IN  : A:longueur du bloc  lire
                                            ;       B=0 crit les donnes lues en mmoire <>0 ne les crit pas
                                            ;       X=pointeur sur la zone de stockage des donnes (si la demande est faite par B)
                                            ; OUT : A=$03:Erreur code bloc inattendu
                                            ;       A=$02:Erreur problme mmoire
                                            ;       A=$01:Erreur suite  la comparaison avec l'octet de vrification
                                            ;       A=$00:pas d'erreur
                                            ;       X=pointeur sur le dernier octet stock (si demande via B)
            dc.w K7_writeBlock              ; FCT : envoie un bloc de donnes de n'importe quel type sur le port K7
                                            ;       BLOC :
                                            ;         octet $55
                                            ;         octet $3C : synchronisation
                                            ;         octet type de bloc : $00 pour le nom de fichier
                                            ;         octet longueur de donnes : $0F pour le nom de fichier
                                            ;         les donnes
                                            ;         octet de vrification : CHECKSUM
                                            ;         octet de fin $55
                                            ; IN  : pTMP_K7  jour
                                            ; OUT : A,B,X modified
            dc.w initRomSound
            dc.w K7_writeHeaderSynchro      ; FCT : Envoi sur le port K7 $0080 fois le caractre de synchro $55
                                            ; ST  : ACTIF
                                            ; IN  : /
                                            ; OUT : X,B modified
            dc.w convWordToACC1             ; FCT : Convert Word to Float
                                            ; IN  : D=number to convert
                                            ; OUT : ACC1=float(D)
            dc.w convACC1toWord             ; FCT : Conversion d'un float (ACC1) en un mot
                                            ;       D=INT(ACC1)
                                            ; ERR : Fonction incorrect
                                            ; IN  : ACC1 set
                                            ; OUT : D=rsultat de la conversion float->WORD
            dc.w ACC1
;----------------
             dc.w vectSCI                   ; SerialCommunicationInterrupt
             dc.w vectTOF                   ; TimerOverflowInterrupt
             dc.w vectOCF                   ; OutputCompareInterruptFlag
             dc.w vectICF                   ; InputCaptureInterruptFlag
             dc.w doIRQ1
             dc.w doSWI
             dc.w doNMI
vectorRESET: dc.w doRESET                   ; FCT : Point d'entre pour la rinitialisation
                                            ; ST  : ACTIF
                                            ; IN  : /
                                            ; OUT : /
            end
